/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.pq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.database.index.pq.PQLookupTable;
import org.vitrivr.cottontail.database.index.pq.PQSignature;
import org.vitrivr.cottontail.database.index.pq.codebook.DoublePrecisionPQCodebook;
import org.vitrivr.cottontail.database.index.pq.codebook.PQCodebook;
import org.vitrivr.cottontail.database.index.pq.codebook.SinglePrecisionPQCodebook;
import org.vitrivr.cottontail.math.knn.metrics.DistanceKernel;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.types.VectorValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ*\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0016\u001a\u00020\u0017\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0012\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001a\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u001c\u001a\u00020\u001dR!\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/database/index/pq/PQ;", "", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "codebooks", "", "Lorg/vitrivr/cottontail/database/index/pq/codebook/PQCodebook;", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "(Lorg/vitrivr/cottontail/model/basics/Type;Ljava/util/List;)V", "getCodebooks", "()Ljava/util/List;", "dimensionsPerSubspace", "", "getDimensionsPerSubspace", "()I", "numberOfSubspaces", "getNumberOfSubspaces", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type;", "getLookupTable", "Lorg/vitrivr/cottontail/database/index/pq/PQLookupTable;", "v", "kernel", "Lorg/vitrivr/cottontail/math/knn/metrics/DistanceKernel;", "getLookupTable-ngM6xw4", "(Lorg/vitrivr/cottontail/model/values/types/VectorValue;Lorg/vitrivr/cottontail/math/knn/metrics/DistanceKernel;)[[D", "getSignature", "Lorg/vitrivr/cottontail/database/index/pq/PQSignature;", "array", "", "Companion", "Serializer", "cottontaildb"})
public final class PQ {
    @NotNull
    private final Type<?> type;
    @NotNull
    private final List<PQCodebook<VectorValue<?>>> codebooks;
    private static final Logger LOGGER;
    private static final int MAX_ITERATIONS = 250;
    @NotNull
    public static final Companion Companion;

    public final int getNumberOfSubspaces() {
        return this.codebooks.size();
    }

    public final int getDimensionsPerSubspace() {
        return this.type.getLogicalSize() / this.codebooks.size();
    }

    @NotNull
    public final PQSignature getSignature(@NotNull VectorValue<?> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return this.getSignature(v, new int[this.getNumberOfSubspaces()]);
    }

    @NotNull
    public final PQSignature getSignature(@NotNull VectorValue<?> v, @NotNull int[] array) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        boolean bl = array.length == this.getNumberOfSubspaces();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "IntArray of signature must have the same size as the number of subspaces for this PQ (expected: " + this.getNumberOfSubspaces() + ", actual: " + array.length + ").";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Arrays.parallelSetAll(array, new IntUnaryOperator(this, v){
            final /* synthetic */ PQ this$0;
            final /* synthetic */ VectorValue $v;

            public final int applyAsInt(int k) {
                return this.this$0.getCodebooks().get(k).quantizeSubspaceForVector(this.$v, k * this.this$0.getDimensionsPerSubspace());
            }
            {
                this.this$0 = pQ;
                this.$v = vectorValue;
            }
        });
        return new PQSignature(array);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final double[][] getLookupTable-ngM6xw4(@NotNull VectorValue<?> v, @NotNull DistanceKernel kernel) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)kernel, (String)"kernel");
        int n = this.getNumberOfSubspaces();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            void k;
            int n2 = i;
            int n3 = i;
            double[][] dArrayArray2 = dArrayArray;
            boolean bl = false;
            PQCodebook<VectorValue<?>> codebook = this.codebooks.get((int)k);
            int n4 = codebook.getNumberOfCentroids();
            double[] dArray = new double[n4];
            int n5 = 0;
            while (n5 < n4) {
                void it;
                double d;
                int n6 = n5;
                int n7 = n5++;
                double[] dArray2 = dArray;
                boolean bl2 = false;
                dArray2[n7] = d = kernel.invoke-JjrrKLw(v.subvector((int)(k * this.getDimensionsPerSubspace()), this.getDimensionsPerSubspace()), codebook.get((int)it));
            }
            double[] dArray3 = dArray;
            dArrayArray2[n3] = dArray3;
        }
        return PQLookupTable.constructor-impl(dArrayArray);
    }

    @NotNull
    public final Type<?> getType() {
        return this.type;
    }

    @NotNull
    public final List<PQCodebook<VectorValue<?>>> getCodebooks() {
        return this.codebooks;
    }

    public PQ(@NotNull Type<?> type, @NotNull List<? extends PQCodebook<VectorValue<?>>> codebooks) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(codebooks, (String)"codebooks");
        this.type = type;
        this.codebooks = codebooks;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(PQ.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(PQ::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/PQ$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/index/pq/PQ;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
    public static final class Serializer
    implements org.mapdb.Serializer<PQ> {
        @NotNull
        public static final Serializer INSTANCE;

        public void serialize(@NotNull DataOutput2 out, @NotNull PQ value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.writeUTF(value.getType().getName());
            out.packInt(value.getType().getLogicalSize());
            out.packInt(value.getCodebooks().size());
            Iterable $this$forEach$iv = value.getCodebooks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PQCodebook cast;
                PQCodebook it = (PQCodebook)element$iv;
                boolean bl = false;
                if (it == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.pq.codebook.PQCodebook<*>");
                }
                if (cast instanceof DoublePrecisionPQCodebook) {
                    DoublePrecisionPQCodebook.Serializer.INSTANCE.serialize(out, (DoublePrecisionPQCodebook)cast);
                    continue;
                }
                if (!(cast instanceof SinglePrecisionPQCodebook)) continue;
                SinglePrecisionPQCodebook.Serializer.INSTANCE.serialize(out, (SinglePrecisionPQCodebook)cast);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public PQ deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String string = input.readUTF();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readUTF()");
            Type<?> type = Type.Companion.forName(string, input.unpackInt());
            int size = input.unpackInt();
            ArrayList<PQCodebook> codebooks = new ArrayList<PQCodebook>(size);
            int n = 0;
            int n2 = size;
            while (n < n2) {
                void i;
                PQCodebook pQCodebook;
                Type<?> type2 = type;
                if (type2 instanceof Type.FloatVector) {
                    pQCodebook = SinglePrecisionPQCodebook.Serializer.INSTANCE.deserialize(input, available);
                } else if (type2 instanceof Type.DoubleVector) {
                    pQCodebook = DoublePrecisionPQCodebook.Serializer.INSTANCE.deserialize(input, available);
                } else if (type2 instanceof Type.Complex32Vector) {
                    pQCodebook = SinglePrecisionPQCodebook.Serializer.INSTANCE.deserialize(input, available);
                } else if (type2 instanceof Type.Complex64Vector) {
                    pQCodebook = DoublePrecisionPQCodebook.Serializer.INSTANCE.deserialize(input, available);
                } else {
                    throw (Throwable)new IllegalStateException("");
                }
                if (pQCodebook == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.pq.codebook.PQCodebook<org.vitrivr.cottontail.model.values.types.VectorValue<*>>");
                }
                codebooks.add(pQCodebook);
                ++i;
            }
            return new PQ(type, (List)codebooks);
        }

        private Serializer() {
        }

        static {
            Serializer serializer2;
            INSTANCE = serializer2 = new Serializer();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/PQ$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "MAX_ITERATIONS", "", "fromData", "Lorg/vitrivr/cottontail/database/index/pq/PQ;", "config", "Lorg/vitrivr/cottontail/database/index/pq/PQIndexConfig;", "column", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "data", "", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "cottontaildb"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PQ fromData(@NotNull PQIndexConfig config, @NotNull ColumnDef<?> column, @NotNull List<? extends VectorValue<?>> data) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            LOGGER.debug("Initializing PQ from initial data.");
            boolean bl = config.getNumSubspaces() > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Number of subspaces must be greater than zero for PQIndex.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = config.getNumCentroids() > 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Number of centroids must be greater than zero for PQIndex.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = column.getType().getLogicalSize() >= config.getNumSubspaces();
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Logical size of column must be greater or equal to number of subspaces.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = column.getType().getLogicalSize() % config.getNumSubspaces() == 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl7 = false;
                String string = "Logical size of column modulo number of subspaces must be zero.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int dimensionsPerSubspace = column.getType().getLogicalSize() / config.getNumSubspaces();
            LOGGER.debug("Creating subspace data");
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)config.getNumSubspaces());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                Iterable $this$map$iv2 = data;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void k;
                    void v;
                    VectorValue vectorValue = (VectorValue)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl9 = false;
                    VectorValue vectorValue2 = v.subvector((int)(k * dimensionsPerSubspace), dimensionsPerSubspace);
                    collection2.add(vectorValue2);
                }
                List list = (List)destination$iv$iv2;
                collection.add(list);
            }
            List subspaceData = (List)destination$iv$iv;
            LOGGER.debug("Learning centroids");
            boolean bl10 = false;
            List codebooks = new ArrayList();
            subspaceData.parallelStream().forEach((Consumer)new Consumer<List<? extends VectorValue<? extends Number>>>(column, config, codebooks){
                final /* synthetic */ ColumnDef $column;
                final /* synthetic */ PQIndexConfig $config;
                final /* synthetic */ List $codebooks;

                public final void accept(List<? extends VectorValue<? extends Number>> d) {
                    PQCodebook codebook;
                    PQCodebook pQCodebook;
                    Type<T> type = this.$column.getType();
                    if (type instanceof Type.Complex32Vector || type instanceof Type.FloatVector) {
                        List<? extends VectorValue<? extends Number>> list = d;
                        if (list == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<org.vitrivr.cottontail.model.values.FloatVectorValue>");
                        }
                        pQCodebook = SinglePrecisionPQCodebook.Companion.learnFromData(list, this.$config.getNumCentroids(), this.$config.getSeed(), 250);
                    } else if (type instanceof Type.Complex64Vector || type instanceof Type.DoubleVector) {
                        List<? extends VectorValue<? extends Number>> list = d;
                        if (list == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<org.vitrivr.cottontail.model.values.DoubleVectorValue>");
                        }
                        pQCodebook = DoublePrecisionPQCodebook.Companion.learnFromData(list, this.$config.getNumCentroids(), this.$config.getSeed(), 250);
                    } else {
                        throw (Throwable)new IllegalArgumentException("VectorValue of type " + this.$column.getType() + " is not supported for PQ.");
                    }
                    PQCodebook pQCodebook2 = codebook = pQCodebook;
                    if (pQCodebook2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.pq.codebook.PQCodebook<org.vitrivr.cottontail.model.values.types.VectorValue<*>>");
                    }
                    this.$codebooks.add(pQCodebook2);
                }
                {
                    this.$column = columnDef;
                    this.$config = pQIndexConfig;
                    this.$codebooks = list;
                }
            });
            LOGGER.debug("PQ initialization done.");
            return new PQ(column.getType(), codebooks);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

