/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.pq.codebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.database.index.pq.codebook.ClusterableWithIndex;
import org.vitrivr.cottontail.database.index.pq.codebook.PQCodebook;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.storage.serializers.DoubleVectorValueSerializerFactory;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001f B$\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\rH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0084\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0084\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0019\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/codebook/DoublePrecisionPQCodebook;", "Lorg/vitrivr/cottontail/database/index/pq/codebook/PQCodebook;", "Lorg/vitrivr/cottontail/model/values/DoubleVectorValue;", "centroids", "", "covMatrix", "(Ljava/util/List;Ljava/util/List;)V", "getCentroids", "()Ljava/util/List;", "getCovMatrix", "diffBuffer", "[D", "logicalSize", "", "getLogicalSize", "()I", "numberOfCentroids", "getNumberOfCentroids", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type;", "get", "ci", "get-c_ALH80", "(I)[D", "quantizeSubspaceForVector", "v", "start", "quantizeSubspaceForVector-IqIdJ9Q", "([DI)I", "Companion", "Serializer", "cottontaildb"})
public final class DoublePrecisionPQCodebook
implements PQCodebook<DoubleVectorValue> {
    private final double[] diffBuffer;
    @NotNull
    private final List<DoubleVectorValue> centroids;
    @NotNull
    private final List<DoubleVectorValue> covMatrix;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Type<DoubleVectorValue> getType() {
        return new Type.DoubleVector(this.getLogicalSize());
    }

    @Override
    public int getNumberOfCentroids() {
        return this.centroids.size();
    }

    @Override
    public int getLogicalSize() {
        return DoubleVectorValue.getLogicalSize-impl(this.centroids.get(0).unbox-impl());
    }

    @NotNull
    public double[] get-c_ALH80(int ci) {
        return this.centroids.get(ci).unbox-impl();
    }

    /*
     * WARNING - void declaration
     */
    public int quantizeSubspaceForVector-IqIdJ9Q(@NotNull double[] v, int start) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int mahIndex = 0;
        double mah = Double.POSITIVE_INFINITY;
        int i = 0;
        Iterator<DoubleVectorValue> iterator2 = this.centroids.iterator();
        block0: while (iterator2.hasNext()) {
            double[] c = iterator2.next().unbox-impl();
            double dist = 0.0;
            int n = 0;
            int n2 = this.diffBuffer.length;
            while (n < n2) {
                void it;
                this.diffBuffer[it] = c[it] - v[start + it];
                ++it;
            }
            int j = 0;
            Iterator<DoubleVectorValue> iterator3 = this.covMatrix.iterator();
            while (iterator3.hasNext()) {
                double[] m = iterator3.next().unbox-impl();
                int n3 = j++;
                dist = Math.fma(this.diffBuffer[n3], DoubleVectorValue.dot-He8yXgM(m, DoubleVectorValue.box-impl(this.diffBuffer)), dist);
                if (!(dist >= mah)) continue;
                ++i;
                continue block0;
            }
            if (dist < mah) {
                mah = dist;
                mahIndex = i;
            }
            ++i;
        }
        return mahIndex;
    }

    @NotNull
    protected final List<DoubleVectorValue> getCentroids() {
        return this.centroids;
    }

    @NotNull
    protected final List<DoubleVectorValue> getCovMatrix() {
        return this.covMatrix;
    }

    public DoublePrecisionPQCodebook(@NotNull List<DoubleVectorValue> centroids, @NotNull List<DoubleVectorValue> covMatrix) {
        Intrinsics.checkNotNullParameter(centroids, (String)"centroids");
        Intrinsics.checkNotNullParameter(covMatrix, (String)"covMatrix");
        this.centroids = centroids;
        this.covMatrix = covMatrix;
        this.diffBuffer = DoubleVectorValue.constructor-impl(new double[this.getLogicalSize()]);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/codebook/DoublePrecisionPQCodebook$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/index/pq/codebook/DoublePrecisionPQCodebook;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
    public static final class Serializer
    implements org.mapdb.Serializer<DoublePrecisionPQCodebook> {
        @NotNull
        public static final Serializer INSTANCE;

        public void serialize(@NotNull DataOutput2 out, @NotNull DoublePrecisionPQCodebook value) {
            double[] v;
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.packInt(value.getLogicalSize());
            MapDBSerializer<DoubleVectorValue> vectorSerializer = DoubleVectorValueSerializerFactory.INSTANCE.mapdb(value.getLogicalSize());
            out.packInt(value.getCentroids().size());
            Iterator<DoubleVectorValue> iterator2 = value.getCentroids().iterator();
            while (iterator2.hasNext()) {
                v = iterator2.next().unbox-impl();
                vectorSerializer.serialize(out, DoubleVectorValue.box-impl(v));
            }
            out.packInt(value.getCovMatrix().size());
            iterator2 = value.getCovMatrix().iterator();
            while (iterator2.hasNext()) {
                v = iterator2.next().unbox-impl();
                vectorSerializer.serialize(out, DoubleVectorValue.box-impl(v));
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public DoublePrecisionPQCodebook deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int logicalSize = input.unpackInt();
            MapDBSerializer<DoubleVectorValue> vectorSerializer = DoubleVectorValueSerializerFactory.INSTANCE.mapdb(logicalSize);
            int centroidsSize = input.unpackInt();
            ArrayList<Object> centroids = new ArrayList<Object>(centroidsSize);
            int n = 0;
            int n2 = centroidsSize;
            while (n < n2) {
                void i;
                centroids.add(vectorSerializer.deserialize(input, available));
                ++i;
            }
            int covMatrixSize = input.unpackInt();
            ArrayList<Object> covMatrix = new ArrayList<Object>(covMatrixSize);
            int n3 = 0;
            int n4 = covMatrixSize;
            while (n3 < n4) {
                void i;
                covMatrix.add(vectorSerializer.deserialize(input, available));
                ++i;
            }
            return new DoublePrecisionPQCodebook((List<DoubleVectorValue>)centroids, (List<DoubleVectorValue>)covMatrix);
        }

        private Serializer() {
        }

        static {
            Serializer serializer2;
            INSTANCE = serializer2 = new Serializer();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/codebook/DoublePrecisionPQCodebook$Companion;", "", "()V", "learnFromData", "Lorg/vitrivr/cottontail/database/index/pq/codebook/DoublePrecisionPQCodebook;", "subspaceData", "", "Lorg/vitrivr/cottontail/model/values/DoubleVectorValue;", "numCentroids", "", "seed", "", "maxIterations", "cottontaildb"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DoublePrecisionPQCodebook learnFromData(@NotNull List<DoubleVectorValue> subspaceData, int numCentroids, long seed, int maxIterations) {
            void $this$mapTo$iv$iv;
            RealMatrix covMatrix;
            int i;
            int n;
            Object object;
            Intrinsics.checkNotNullParameter(subspaceData, (String)"subspaceData");
            int n2 = subspaceData.size();
            double[][] dArrayArray = new double[n2][];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3;
                int n5 = n3++;
                object = dArrayArray;
                n = 0;
                double[] dArray = subspaceData.get(i).unbox-impl();
                object[n5] = dArray;
            }
            double[][] array = dArrayArray;
            RealMatrix realMatrix = covMatrix = new Covariance(array, false).getCovarianceMatrix();
            Intrinsics.checkNotNullExpressionValue((Object)realMatrix, (String)"covMatrix");
            List<CentroidCluster<ClusterableWithIndex>> centroidClusters2 = PQCodebook.Companion.clusterRealData(array, realMatrix, numCentroids, seed, maxIterations);
            ArrayList<DoubleVectorValue> centroids = new ArrayList<DoubleVectorValue>(numCentroids);
            n = numCentroids;
            for (i = 0; i < n; ++i) {
                Clusterable clusterable = centroidClusters2.get(i).getCenter();
                Intrinsics.checkNotNullExpressionValue((Object)clusterable, (String)"centroidClusters[i].center");
                double[] dArray = clusterable.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"centroidClusters[i].center.point");
                centroids.add(DoubleVectorValue.box-impl(DoubleVectorValue.constructor-impl(dArray)));
            }
            double[][] dArray = covMatrix.getData();
            Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"covMatrix.data");
            Object[] $this$map$iv = (Object[])dArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                double[] dArray2 = (double[])item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                void v4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                DoubleVectorValue doubleVectorValue = DoubleVectorValue.box-impl(DoubleVectorValue.constructor-impl((double[])v4));
                object.add(doubleVectorValue);
            }
            List dataCovMatrix = (List)destination$iv$iv;
            return new DoublePrecisionPQCodebook((List<DoubleVectorValue>)centroids, dataCovMatrix);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

