/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.locking;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.locking.Lock;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0014J\u0011\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J\u0015\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0019R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/database/locking/LockHolder;", "", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "(J)V", "locks", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lorg/vitrivr/cottontail/database/locking/Lock;", "getLocks", "()Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "numberOfLocks", "", "getNumberOfLocks", "()I", "getTxId", "()J", "addLock", "", "lock", "addLock$cottontaildb", "compareTo", "other", "", "removeLock", "removeLock$cottontaildb", "cottontaildb"})
public class LockHolder
implements Comparable<LockHolder> {
    @NotNull
    private final ObjectOpenHashSet<Lock> locks;
    private final long txId;

    @NotNull
    protected final ObjectOpenHashSet<Lock> getLocks() {
        return this.locks;
    }

    public final int getNumberOfLocks() {
        return this.locks.size();
    }

    @NotNull
    public final Set<Lock> getLocks() {
        Set<Lock> set = Collections.unmodifiableSet((Set)this.locks);
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.unmodifiableSet(this.locks)");
        return set;
    }

    public final void addLock$cottontaildb(@NotNull Lock lock2) {
        Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
        this.locks.add((Object)lock2);
    }

    public final void removeLock$cottontaildb(@NotNull Lock lock2) {
        Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
        this.locks.remove((Object)lock2);
    }

    @Override
    public int compareTo(@NotNull LockHolder other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (int)(this.txId - other.txId);
    }

    public final long getTxId() {
        return this.txId;
    }

    public LockHolder(long txId) {
        this.txId = txId;
        this.locks = new ObjectOpenHashSet();
    }
}

