/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.OperatorNode;
import org.vitrivr.cottontail.database.queries.binding.BindingContext;
import org.vitrivr.cottontail.database.queries.sort.SortOrder;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010)\u001a\u00020\t2\n\u0010*\u001a\u00060\u0006j\u0002`\u0007H\u0086\u0002J\n\u0010+\u001a\u00060\u0006j\u0002`\u0007J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\tJ\u000e\u0010/\u001a\u0002002\u0006\u0010\u0002\u001a\u00020\u0003R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000e\u001a\u001a\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020'0 \u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010#\u00a8\u00061"}, d2={"Lorg/vitrivr/cottontail/database/queries/QueryContext;", "", "txn", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "groupIdCounter", "", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "logical", "Lorg/vitrivr/cottontail/database/queries/OperatorNode$Logical;", "getLogical", "()Lorg/vitrivr/cottontail/database/queries/OperatorNode$Logical;", "nodes", "", "order", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "getOrder", "()[Lkotlin/Pair;", "output", "getOutput", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "<set-?>", "Lorg/vitrivr/cottontail/database/queries/OperatorNode$Physical;", "physical", "getPhysical", "()Lorg/vitrivr/cottontail/database/queries/OperatorNode$Physical;", "setPhysical$cottontaildb", "(Lorg/vitrivr/cottontail/database/queries/OperatorNode$Physical;)V", "records", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "Lorg/vitrivr/cottontail/model/basics/Record;", "getRecords", "()Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "getTxn", "()Lorg/vitrivr/cottontail/execution/TransactionContext;", "values", "Lorg/vitrivr/cottontail/model/values/types/Value;", "getValues", "get", "groupId", "nextGroupId", "register", "", "plan", "toOperatorTree", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "cottontaildb"})
public final class QueryContext {
    @NotNull
    private final BindingContext<Value> values;
    @NotNull
    private final BindingContext<Record> records;
    private final Map<Integer, OperatorNode.Logical> nodes;
    @Nullable
    private OperatorNode.Physical physical;
    private volatile int groupIdCounter;
    @NotNull
    private final TransactionContext txn;

    @NotNull
    public final BindingContext<Value> getValues() {
        return this.values;
    }

    @NotNull
    public final BindingContext<Record> getRecords() {
        return this.records;
    }

    @Nullable
    public final OperatorNode.Logical getLogical() {
        return this.nodes.get(0);
    }

    @Nullable
    public final OperatorNode.Physical getPhysical() {
        return this.physical;
    }

    public final void setPhysical$cottontaildb(@Nullable OperatorNode.Physical physical) {
        this.physical = physical;
    }

    @Nullable
    public final ColumnDef<?>[] getOutput() {
        OperatorNode.Logical logical = this.nodes.get(0);
        return logical != null ? logical.getColumns() : null;
    }

    @Nullable
    public final Pair<ColumnDef<?>, SortOrder>[] getOrder() {
        OperatorNode.Logical logical = this.nodes.get(0);
        return logical != null ? logical.getOrder() : null;
    }

    public final int nextGroupId() {
        int n = this.groupIdCounter;
        this.groupIdCounter = n + 1;
        return n;
    }

    public final void register(@NotNull OperatorNode.Logical plan) {
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        this.nodes.put(plan.getGroupId(), plan);
    }

    @NotNull
    public final OperatorNode.Logical get(int groupId) {
        OperatorNode.Logical logical = this.nodes.get(groupId);
        if (logical == null) {
            throw (Throwable)new QueryException.QueryPlannerException("Failed to access sub-query with groupId " + groupId);
        }
        return logical;
    }

    @NotNull
    public final Operator toOperatorTree(@NotNull TransactionContext txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        OperatorNode.Physical local = this.physical;
        boolean bl = local != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            IllegalStateException illegalStateException = new IllegalStateException("Cannot generate an operator tree without a valid, physical node expression tree.");
            throw (Throwable)new IllegalStateException(((Object)illegalStateException).toString());
        }
        return local.toOperator(txn, this);
    }

    @NotNull
    public final TransactionContext getTxn() {
        return this.txn;
    }

    public QueryContext(@NotNull TransactionContext txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        this.txn = txn;
        this.values = new BindingContext();
        this.records = new BindingContext();
        this.nodes = (Map)new Int2ObjectOpenHashMap();
    }
}

