/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.catalogue.CatalogueHeader;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.legacy.v1.catalogue.CatalogueV1Header;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/legacy/VersionProber;", "", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "isV1", "", "path", "Ljava/nio/file/Path;", "isV2", "probe", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "Companion", "cottontaildb"})
public final class VersionProber {
    private final Config config;
    @NotNull
    private static final DBOVersion EXPECTED;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final DBOVersion probe(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.isV2(path) ? DBOVersion.V2_0 : (this.isV1(path) ? DBOVersion.V1_0 : DBOVersion.UNDEFINED);
    }

    private final boolean isV1(Path path) {
        CatalogueV1Header header;
        block5: {
            CatalogueV1Header catalogueV1Header;
            CottontailStoreWAL cottontailStoreWAL;
            System.gc();
            try {
                MapDBConfig mapDBConfig = this.config.getMapdb();
                Path path2 = path.resolve("catalogue.db");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(CatalogueV1.FILE_CATALOGUE)");
                cottontailStoreWAL = mapDBConfig.store(path2);
            }
            catch (Throwable e) {
                return false;
            }
            CottontailStoreWAL store = cottontailStoreWAL;
            try {
                CottontailStoreWAL cottontailStoreWAL2 = store;
                catalogueV1Header = cottontailStoreWAL2 != null ? (CatalogueV1Header)cottontailStoreWAL2.get(1L, CatalogueV1Header.Serializer) : null;
            }
            catch (Throwable e) {
                CottontailStoreWAL cottontailStoreWAL3 = store;
                if (cottontailStoreWAL3 != null) {
                    cottontailStoreWAL3.close();
                }
                return false;
            }
            header = catalogueV1Header;
            CottontailStoreWAL cottontailStoreWAL4 = store;
            if (cottontailStoreWAL4 == null) break block5;
            cottontailStoreWAL4.close();
        }
        return header != null;
    }

    private final boolean isV2(Path path) {
        CatalogueHeader header;
        block5: {
            CatalogueHeader catalogueHeader;
            DB dB;
            System.gc();
            try {
                MapDBConfig mapDBConfig = this.config.getMapdb();
                Path path2 = path.resolve("catalogue.db");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(DefaultCatalogue.FILE_CATALOGUE)");
                dB = mapDBConfig.db(path2);
            }
            catch (Throwable e) {
                return false;
            }
            DB store = dB;
            try {
                DB dB2 = store;
                catalogueHeader = dB2 != null && (dB2 = dB2.atomicVar("cdb_catalogue_header", (Serializer)CatalogueHeader.Serializer)) != null && (dB2 = (Atomic.Var)dB2.open()) != null ? (CatalogueHeader)dB2.get() : null;
            }
            catch (Throwable e) {
                DB dB3 = store;
                if (dB3 != null) {
                    dB3.close();
                }
                return false;
            }
            header = catalogueHeader;
            DB dB4 = store;
            if (dB4 == null) break block5;
            dB4.close();
        }
        return header != null;
    }

    public VersionProber(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    static {
        Companion = new Companion(null);
        EXPECTED = DBOVersion.V2_0;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/VersionProber$Companion;", "", "()V", "EXPECTED", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getEXPECTED", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "cottontaildb"})
    public static final class Companion {
        @NotNull
        public final DBOVersion getEXPECTED() {
            return EXPECTED;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

