/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.queries.binding.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.database.queries.sort.SortOrder;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.operators.definition.CreateEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.CreateIndexOperator;
import org.vitrivr.cottontail.execution.operators.definition.CreateSchemaOperator;
import org.vitrivr.cottontail.execution.operators.definition.DropEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.DropIndexOperator;
import org.vitrivr.cottontail.execution.operators.definition.DropSchemaOperator;
import org.vitrivr.cottontail.execution.operators.definition.EntityDetailsOperator;
import org.vitrivr.cottontail.execution.operators.definition.ListEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.ListSchemaOperator;
import org.vitrivr.cottontail.execution.operators.definition.OptimizeEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.RebuildIndexOperator;
import org.vitrivr.cottontail.execution.operators.definition.TruncateEntityOperator;
import org.vitrivr.cottontail.execution.operators.sinks.SpoolerSinkOperator;
import org.vitrivr.cottontail.execution.operators.sort.HeapSortOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DDLGrpc;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TransactionException;
import org.vitrivr.cottontail.server.grpc.services.TransactionService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00182\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001a2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001c2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020 2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\"2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020$2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020&2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020(2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DDLService;", "Lorg/vitrivr/cottontail/grpc/DDLGrpc$DDLImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionService;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "createEntity", "", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateEntityMessage;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "createIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateIndexMessage;", "createSchema", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateSchemaMessage;", "dropEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropEntityMessage;", "dropIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropIndexMessage;", "dropSchema", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropSchemaMessage;", "entityDetails", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$EntityDetailsMessage;", "listEntities", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ListEntityMessage;", "listSchemas", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ListSchemaMessage;", "optimizeEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$OptimizeEntityMessage;", "rebuildIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$RebuildIndexMessage;", "truncateEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TruncateEntityMessage;", "Companion", "cottontaildb"})
@ExperimentalTime
public final class DDLService
extends DDLGrpc.DDLImplBase
implements TransactionService {
    @NotNull
    private final DefaultCatalogue catalogue;
    @NotNull
    private final TransactionManager manager;
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    public void listSchemas(@NotNull CottontailGrpc.ListSchemaMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new HeapSortOperator(new ListSchemaOperator(this.this$0.getCatalogue()), new Pair[]{new Pair(ListSchemaOperator.Companion.getCOLUMNS()[0], (Object)((Object)SortOrder.ASCENDING))}, 100), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                    }
                    catch (DatabaseException e) {
                        String message = this.this$0.formatMessage(tx, q, "Failed to fetch list of schemas because of a database error.");
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        String message = this.this$0.formatMessage(tx, q, "Failed to fetch list of schemas because of a deadlock with another transaction.");
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        String message = this.this$0.formatMessage(tx, q, "Failed to fetch list of schemas because of an unknown error.");
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void createSchema(@NotNull CottontailGrpc.CreateSchemaMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.CreateSchemaMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    CottontailGrpc.SchemaName schemaName = this.$request.getSchema();
                    Intrinsics.checkNotNullExpressionValue((Object)schemaName, (String)"request.schema");
                    Name.SchemaName schemaName2 = NameExtensionsKt.fqn(schemaName);
                    try {
                        DDLService.access$getLOGGER$cp().info("Creating schema '" + schemaName2 + "'...");
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new CreateSchemaOperator(this.this$0.getCatalogue(), schemaName2), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                        DDLService.access$getLOGGER$cp().info("Schema '" + schemaName2 + "' created successfully!");
                    }
                    catch (DatabaseException.SchemaAlreadyExistsException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create schema '");
                        CottontailGrpc.SchemaName schemaName3 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName3, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName3)).append("': Schema with identical name already exists.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create schema '");
                        CottontailGrpc.SchemaName schemaName4 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName4, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName4)).append("': Deadlock with another transaction.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create schema '");
                        CottontailGrpc.SchemaName schemaName5 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName5, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName5)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create schema '");
                        CottontailGrpc.SchemaName schemaName6 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName6, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName6)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = createSchemaMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void dropSchema(@NotNull CottontailGrpc.DropSchemaMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.DropSchemaMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    CottontailGrpc.SchemaName schemaName = this.$request.getSchema();
                    Intrinsics.checkNotNullExpressionValue((Object)schemaName, (String)"request.schema");
                    Name.SchemaName schemaName2 = NameExtensionsKt.fqn(schemaName);
                    try {
                        DDLService.access$getLOGGER$cp().info("Dropping schema '" + schemaName2 + "'...");
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new DropSchemaOperator(this.this$0.getCatalogue(), schemaName2), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                        DDLService.access$getLOGGER$cp().info("Schema '" + schemaName2 + "' dropped successfully!");
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop schema '");
                        CottontailGrpc.SchemaName schemaName3 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName3, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName3)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop schema'");
                        CottontailGrpc.SchemaName schemaName4 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName4, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName4)).append("': Deadlock with another transaction.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop schema '");
                        CottontailGrpc.SchemaName schemaName5 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName5, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName5)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop schema '");
                        CottontailGrpc.SchemaName schemaName6 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName6, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName6)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = dropSchemaMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void entityDetails(@NotNull CottontailGrpc.EntityDetailsMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.EntityDetailsMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    CottontailGrpc.EntityName entityName = this.$request.getEntity();
                    Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                    Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                    String string = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
                    String queryId = string;
                    try {
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new EntityDetailsOperator(this.this$0.getCatalogue(), entityName2), queryId, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                    }
                    catch (TransactionException.TransactionNotFoundException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to fetch entity information for '");
                        CottontailGrpc.EntityName entityName3 = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName3, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName3)).append("': Transaction ").append(e.getTxId()).append(" could not be resumed.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to fetch entity information for '");
                        CottontailGrpc.EntityName entityName4 = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName4, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName4)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.EntityDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to fetch entity information for '");
                        CottontailGrpc.EntityName entityName5 = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName5, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName5)).append("': Entity does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to fetch entity information for '");
                        CottontailGrpc.EntityName entityName6 = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName6, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName6)).append("': Deadlock with another transaction.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to fetch entity information '");
                        CottontailGrpc.EntityName entityName7 = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName7, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName7)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to fetch entity information '");
                        CottontailGrpc.EntityName entityName8 = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName8, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName8)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = entityDetailsMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void createEntity(@NotNull CottontailGrpc.CreateEntityMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.CreateEntityMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    CottontailGrpc.EntityDefinition entityDefinition = this.$request.getDefinition();
                    Intrinsics.checkNotNullExpressionValue((Object)entityDefinition, (String)"request.definition");
                    CottontailGrpc.EntityName entityName = entityDefinition.getEntity();
                    Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.definition.entity");
                    Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                    try {
                        void $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv;
                        DDLService.access$getLOGGER$cp().info("Creating entity '" + entityName2 + "'...");
                        CottontailGrpc.EntityDefinition entityDefinition2 = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)entityDefinition2, (String)"request.definition");
                        List list = entityDefinition2.getColumnsList();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.definition.columnsList");
                        Iterable $this$map$iv = list;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            CottontailGrpc.ColumnDefinition columnDefinition = (CottontailGrpc.ColumnDefinition)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            void v4 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                            Type<?> type = Type.Companion.forName(v4.getType().name(), it.getLength());
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            Name.ColumnName name = entityName2.column(string);
                            Pair pair = TuplesKt.to(new ColumnDef<T>(name, type, it.getNullable(), false, 8, null), (Object)((Object)ColumnEngine.valueOf(it.getEngine().toString())));
                            collection.add(pair);
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
                        if (pairArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        Pair[] columns = pairArray;
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new CreateEntityOperator(this.this$0.getCatalogue(), entityName2, columns), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                        DDLService.access$getLOGGER$cp().info("Schema '" + entityName2 + "' created successfully!");
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create entity '");
                        CottontailGrpc.EntityDefinition entityDefinition3 = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)entityDefinition3, (String)"request.definition");
                        CottontailGrpc.EntityName entityName3 = entityDefinition3.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName3, (String)"request.definition.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName3)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.EntityAlreadyExistsException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create entity '");
                        CottontailGrpc.EntityDefinition entityDefinition4 = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)entityDefinition4, (String)"request.definition");
                        CottontailGrpc.EntityName entityName4 = entityDefinition4.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName4, (String)"request.definition.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName4)).append("': Entity with identical name already exists.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create entity '");
                        CottontailGrpc.EntityDefinition entityDefinition5 = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)entityDefinition5, (String)"request.definition");
                        CottontailGrpc.EntityName entityName5 = entityDefinition5.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName5, (String)"request.definition.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName5)).append("': Deadlock with another transaction.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create entity '");
                        CottontailGrpc.EntityDefinition entityDefinition6 = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)entityDefinition6, (String)"request.definition");
                        CottontailGrpc.EntityName entityName6 = entityDefinition6.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName6, (String)"request.definition.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName6)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create entity '");
                        CottontailGrpc.EntityDefinition entityDefinition7 = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)entityDefinition7, (String)"request.definition");
                        CottontailGrpc.EntityName entityName7 = entityDefinition7.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName7, (String)"request.definition.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName7)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = createEntityMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void dropEntity(@NotNull CottontailGrpc.DropEntityMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.DropEntityMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                        DDLService.access$getLOGGER$cp().info("Dropping entity '" + entityName2 + "'...");
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new DropEntityOperator(this.this$0.getCatalogue(), entityName2), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                        DDLService.access$getLOGGER$cp().info("Entity '" + entityName2 + "' dropped successfully!");
                    }
                    catch (TransactionException.TransactionNotFoundException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to ddrop entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Transaction ").append(e.getTxId()).append(" could not be resumed.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.EntityDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Entity does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Deadlock with another transaction.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = dropEntityMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void truncateEntity(@NotNull CottontailGrpc.TruncateEntityMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.TruncateEntityMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                        DDLService.access$getLOGGER$cp().info("Truncating entity '" + entityName2 + "'...", (Object)entityName2);
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new TruncateEntityOperator(this.this$0.getCatalogue(), entityName2), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                        DDLService.access$getLOGGER$cp().info("Entity '" + entityName2 + "' truncated successfully!");
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to truncate entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.EntityDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to truncate entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Entity does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to truncate entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Deadlock with another transaction.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to truncate entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to truncate entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = truncateEntityMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void optimizeEntity(@NotNull CottontailGrpc.OptimizeEntityMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.OptimizeEntityMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                        DDLService.access$getLOGGER$cp().info("Optimizing entity '" + entityName2 + "'...");
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new OptimizeEntityOperator(this.this$0.getCatalogue(), entityName2), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                        DDLService.access$getLOGGER$cp().info("Entity '" + entityName2 + "' optimized successfully!");
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to optimize entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.EntityDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to optimize entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Entity does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to optimize entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("': Deadlock with another transaction.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to truncate entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to truncate entity '");
                        CottontailGrpc.EntityName entityName = this.$request.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(entityName)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = optimizeEntityMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void listEntities(@NotNull CottontailGrpc.ListEntityMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.ListEntityMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Name.SchemaName schemaName;
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    if (this.$request.hasSchema()) {
                        CottontailGrpc.SchemaName schemaName2 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName2, (String)"request.schema");
                        schemaName = NameExtensionsKt.fqn(schemaName2);
                    } else {
                        schemaName = null;
                    }
                    Name.SchemaName schemaName3 = schemaName;
                    try {
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new HeapSortOperator(new ListEntityOperator(this.this$0.getCatalogue(), schemaName3), new Pair[]{new Pair(ListSchemaOperator.Companion.getCOLUMNS()[0], (Object)((Object)SortOrder.ASCENDING))}, 100), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                    }
                    catch (TransactionException.TransactionNotFoundException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to list entities for schema '");
                        CottontailGrpc.SchemaName schemaName4 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName4, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName4)).append("': Transaction ").append(e.getTxId()).append(" could not be resumed.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to list entities for schema '");
                        CottontailGrpc.SchemaName schemaName5 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName5, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName5)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to list entities for schema '");
                        CottontailGrpc.SchemaName schemaName6 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName6, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName6)).append("': Deadlock with another transaction.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to list entities for schema '");
                        CottontailGrpc.SchemaName schemaName7 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName7, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName7)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to list entities for schema '");
                        CottontailGrpc.SchemaName schemaName8 = this.$request.getSchema();
                        Intrinsics.checkNotNullExpressionValue((Object)schemaName8, (String)"request.schema");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(schemaName8)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = listEntityMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void createIndex(@NotNull CottontailGrpc.CreateIndexMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.CreateIndexMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        void $this$mapTo$iv$iv;
                        CottontailGrpc.IndexDefinition indexDefinition = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition, (String)"request.definition");
                        CottontailGrpc.IndexName indexName = indexDefinition.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.definition.name");
                        Name.IndexName indexName2 = NameExtensionsKt.fqn(indexName);
                        DDLService.access$getLOGGER$cp().info("Creating index '" + indexName2 + "'...");
                        CottontailGrpc.IndexDefinition indexDefinition2 = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition2, (String)"request.definition");
                        List list = indexDefinition2.getColumnsList();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.definition.columnsList");
                        Iterable $this$map$iv = list;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            CottontailGrpc.ColumnName columnName = (CottontailGrpc.ColumnName)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Name.EntityName entityName = indexName2.entity();
                            void v5 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
                            String string = v5.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            Name.ColumnName columnName2 = entityName.column(string);
                            collection.add(columnName2);
                        }
                        List columns = (List)destination$iv$iv;
                        CottontailGrpc.IndexDefinition indexDefinition3 = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition3, (String)"request.definition");
                        IndexType indexType = IndexType.valueOf(indexDefinition3.getType().toString());
                        CottontailGrpc.IndexDefinition indexDefinition4 = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition4, (String)"request.definition");
                        Map params = indexDefinition4.getParamsMap();
                        DefaultCatalogue defaultCatalogue = this.this$0.getCatalogue();
                        Map map2 = params;
                        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"params");
                        SpoolerSinkOperator createOp = new SpoolerSinkOperator(new CreateIndexOperator(defaultCatalogue, indexName2, indexType, columns, map2, this.$request.getRebuild()), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(createOp);
                        this.$responseObserver.onCompleted();
                        DDLService.access$getLOGGER$cp().info("Index '" + indexName2 + "' created successfully!", (Object)this.$request);
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create index '");
                        CottontailGrpc.IndexDefinition indexDefinition = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition, (String)"request.definition");
                        CottontailGrpc.IndexName indexName = indexDefinition.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.definition.name");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.EntityDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create index '");
                        CottontailGrpc.IndexDefinition indexDefinition = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition, (String)"request.definition");
                        CottontailGrpc.IndexName indexName = indexDefinition.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.definition.name");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Entity does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.ColumnDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create index '");
                        CottontailGrpc.IndexDefinition indexDefinition = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition, (String)"request.definition");
                        CottontailGrpc.IndexName indexName = indexDefinition.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.definition.name");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Column does not exist.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.IndexAlreadyExistsException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create index '");
                        CottontailGrpc.IndexDefinition indexDefinition = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition, (String)"request.definition");
                        CottontailGrpc.IndexName indexName = indexDefinition.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.definition.name");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Index with identical name does already exist.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create index '");
                        CottontailGrpc.IndexDefinition indexDefinition = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition, (String)"request.definition");
                        CottontailGrpc.IndexName indexName = indexDefinition.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.definition.name");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to create index '");
                        CottontailGrpc.IndexDefinition indexDefinition = this.$request.getDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)indexDefinition, (String)"request.definition");
                        CottontailGrpc.IndexName indexName = indexDefinition.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.definition.name");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = createIndexMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void dropIndex(@NotNull CottontailGrpc.DropIndexMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.DropIndexMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        Name.IndexName indexName2 = NameExtensionsKt.fqn(indexName);
                        DDLService.access$getLOGGER$cp().info("Dropping index '" + indexName2 + "'...");
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new DropIndexOperator(this.this$0.getCatalogue(), indexName2), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                        DDLService.access$getLOGGER$cp().info("Index '" + indexName2 + "' dropped successfully!");
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.EntityDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Entity does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.IndexDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Index does not exist.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to drop index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = dropIndexMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void rebuildIndex(@NotNull CottontailGrpc.RebuildIndexMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DDLService this$0;
                final /* synthetic */ CottontailGrpc.RebuildIndexMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        Name.IndexName indexName2 = NameExtensionsKt.fqn(indexName);
                        DDLService.access$getLOGGER$cp().info("Rebuilding index '" + indexName2 + "'...");
                        SpoolerSinkOperator op = new SpoolerSinkOperator(new RebuildIndexOperator(this.this$0.getCatalogue(), indexName2), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        tx.execute(op);
                        this.$responseObserver.onCompleted();
                        DDLService.access$getLOGGER$cp().info("Index '" + indexName2 + "' rebuilt successfully!");
                    }
                    catch (DatabaseException.SchemaDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to rebuild index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Schema does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.EntityDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to rebuild index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Entity does not exist.").toString());
                        DDLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException.IndexDoesNotExistException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to rebuild index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("': Index does not exist.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
                    }
                    catch (DatabaseException e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to rebuild index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("' because of a database error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to rebuild index '");
                        CottontailGrpc.IndexName indexName = this.$request.getIndex();
                        Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                        String message = this.this$0.formatMessage(tx, q, stringBuilder.append(NameExtensionsKt.fqn(indexName)).append("' because of an unknown error.").toString());
                        DDLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).withCause(e).asException());
                    }
                }
                {
                    this.this$0 = dDLService;
                    this.$request = rebuildIndexMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    @NotNull
    public final DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    public DDLService(@NotNull DefaultCatalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.catalogue = catalogue;
        this.manager = manager;
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(DDLService.class);
    }

    @Override
    public void withTransactionContext(@NotNull CottontailGrpc.TransactionId txId, @NotNull Function2<? super TransactionManager.Transaction, ? super String, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        TransactionService.DefaultImpls.withTransactionContext(this, txId, action);
    }

    @Override
    @NotNull
    public String formatMessage(@NotNull TransactionManager.Transaction tx, @NotNull String queryId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return TransactionService.DefaultImpls.formatMessage(this, tx, queryId, message);
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DDLService$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

