/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.execution.operators.sinks.SpoolerSinkOperator;
import org.vitrivr.cottontail.execution.operators.system.ListLocksOperator;
import org.vitrivr.cottontail.execution.operators.system.ListTransactionsOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.TXNGrpc;
import org.vitrivr.cottontail.model.exceptions.TransactionException;
import org.vitrivr.cottontail.server.grpc.services.TransactionService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016J\u001e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/TXNService;", "Lorg/vitrivr/cottontail/grpc/TXNGrpc$TXNImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionService;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "begin", "", "request", "Lcom/google/protobuf/Empty;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TransactionId;", "commit", "listLocks", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "listTransactions", "rollback", "Companion", "cottontaildb"})
public final class TXNService
extends TXNGrpc.TXNImplBase
implements TransactionService {
    @NotNull
    private final TransactionManager manager;
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    public void begin(@NotNull Empty request, @NotNull StreamObserver<CottontailGrpc.TransactionId> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        TransactionManager.Transaction txn = this.getManager().new TransactionManager.Transaction(TransactionType.USER);
        CottontailGrpc.TransactionId txId = CottontailGrpc.TransactionId.newBuilder().setValue(txn.getTxId()).build();
        responseObserver.onNext((Object)txId);
        responseObserver.onCompleted();
    }

    public void commit(@NotNull CottontailGrpc.TransactionId request, @NotNull StreamObserver<Empty> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            this.withTransactionContext(request, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(responseObserver){
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                    tx.commit();
                    this.$responseObserver.onNext((Object)Empty.getDefaultInstance());
                    this.$responseObserver.onCompleted();
                }
                {
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            String message = "Execution failed because transaction " + request.getValue() + " could not be resumed.";
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void rollback(@NotNull CottontailGrpc.TransactionId request, @NotNull StreamObserver<Empty> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            this.withTransactionContext(request, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(responseObserver){
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                    tx.rollback();
                    this.$responseObserver.onNext((Object)Empty.getDefaultInstance());
                    this.$responseObserver.onCompleted();
                }
                {
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            String message = "Execution failed because transaction " + request.getValue() + " could not be resumed.";
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void listTransactions(@NotNull Empty request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        TransactionService.DefaultImpls.withTransactionContext$default(this, null, (Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, responseObserver){
            final /* synthetic */ TXNService this$0;
            final /* synthetic */ StreamObserver $responseObserver;

            public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                SpoolerSinkOperator operator = new SpoolerSinkOperator(new ListTransactionsOperator(this.this$0.getManager()), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                tx.execute(operator);
                this.$responseObserver.onCompleted();
            }
            {
                this.this$0 = tXNService;
                this.$responseObserver = streamObserver;
                super(2);
            }
        }, 1, null);
    }

    public void listLocks(@NotNull Empty request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        TransactionService.DefaultImpls.withTransactionContext$default(this, null, (Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, responseObserver){
            final /* synthetic */ TXNService this$0;
            final /* synthetic */ StreamObserver $responseObserver;

            public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                SpoolerSinkOperator operator = new SpoolerSinkOperator(new ListLocksOperator(this.this$0.getManager().getLockManager()), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                tx.execute(operator);
                this.$responseObserver.onCompleted();
            }
            {
                this.this$0 = tXNService;
                this.$responseObserver = streamObserver;
                super(2);
            }
        }, 1, null);
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    public TXNService(@NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(TXNService.class);
    }

    @Override
    public void withTransactionContext(@NotNull CottontailGrpc.TransactionId txId, @NotNull Function2<? super TransactionManager.Transaction, ? super String, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        TransactionService.DefaultImpls.withTransactionContext(this, txId, action);
    }

    @Override
    @NotNull
    public String formatMessage(@NotNull TransactionManager.Transaction tx, @NotNull String queryId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return TransactionService.DefaultImpls.formatMessage(this, tx, queryId, message);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/TXNService$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

