/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.data;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.utilities.data.Format$WhenMappings;
import org.vitrivr.cottontail.utilities.data.exporter.DataExporter;
import org.vitrivr.cottontail.utilities.data.exporter.JsonDataExporter;
import org.vitrivr.cottontail.utilities.data.exporter.ProtoDataExporter;
import org.vitrivr.cottontail.utilities.data.importer.DataImporter;
import org.vitrivr.cottontail.utilities.data.importer.JsonDataImporter;
import org.vitrivr.cottontail.utilities.data.importer.ProtoDataImporter;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ)\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/utilities/data/Format;", "", "suffix", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSuffix", "()Ljava/lang/String;", "newExporter", "Lorg/vitrivr/cottontail/utilities/data/exporter/DataExporter;", "file", "Ljava/nio/file/Path;", "newImporter", "Lorg/vitrivr/cottontail/utilities/data/importer/DataImporter;", "schema", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "(Ljava/nio/file/Path;[Lorg/vitrivr/cottontail/database/column/ColumnDef;)Lorg/vitrivr/cottontail/utilities/data/importer/DataImporter;", "PROTO", "JSON", "CSV", "cottontaildb"})
public final class Format
extends Enum<Format> {
    public static final /* enum */ Format PROTO;
    public static final /* enum */ Format JSON;
    public static final /* enum */ Format CSV;
    private static final /* synthetic */ Format[] $VALUES;
    @NotNull
    private final String suffix;

    static {
        Format[] formatArray = new Format[3];
        Format[] formatArray2 = formatArray;
        formatArray[0] = PROTO = new Format("proto");
        formatArray[1] = JSON = new Format("json");
        formatArray[2] = CSV = new Format("csv");
        $VALUES = formatArray;
    }

    @NotNull
    public final DataImporter newImporter(@NotNull Path file, @Nullable ColumnDef<?>[] schema) {
        DataImporter dataImporter;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        switch (Format$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                dataImporter = new ProtoDataImporter(file);
                break;
            }
            case 2: {
                if (schema == null) {
                    throw (Throwable)new IllegalArgumentException("Schema is required to create an instance of JsonDataImporter.");
                }
                dataImporter = new JsonDataImporter(file, schema);
                break;
            }
            case 3: {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dataImporter;
    }

    public static /* synthetic */ DataImporter newImporter$default(Format format, Path path, ColumnDef[] columnDefArray, int n, Object object) {
        if ((n & 2) != 0) {
            columnDefArray = null;
        }
        return format.newImporter(path, columnDefArray);
    }

    @NotNull
    public final DataExporter newExporter(@NotNull Path file) {
        DataExporter dataExporter;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        switch (Format$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: {
                dataExporter = new ProtoDataExporter(file);
                break;
            }
            case 2: {
                dataExporter = new JsonDataExporter(file, null, 2, null);
                break;
            }
            case 3: {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dataExporter;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    private Format(String suffix) {
        this.suffix = suffix;
    }

    public static Format[] values() {
        return (Format[])$VALUES.clone();
    }

    public static Format valueOf(String string) {
        return Enum.valueOf(Format.class, string);
    }
}

