/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli.entity;

import com.github.ajalt.clikt.output.TermUi;
import com.jakewharton.picnic.-DslKt;
import com.jakewharton.picnic.RowDsl;
import com.jakewharton.picnic.Table;
import com.jakewharton.picnic.TableDsl;
import com.jakewharton.picnic.TableSectionDsl;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.cli.entity.AbstractEntityCommand;
import org.vitrivr.cottontail.cli.entity.CreateEntityCommand;
import org.vitrivr.cottontail.cli.entity.CreateEntityCommand$WhenMappings;
import org.vitrivr.cottontail.database.queries.binding.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DDLGrpc;
import org.vitrivr.cottontail.utilities.output.TabulationUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/cli/entity/CreateEntityCommand;", "Lorg/vitrivr/cottontail/cli/entity/AbstractEntityCommand;", "ddlStub", "Lorg/vitrivr/cottontail/grpc/DDLGrpc$DDLBlockingStub;", "(Lorg/vitrivr/cottontail/grpc/DDLGrpc$DDLBlockingStub;)V", "checkValid", "", "exec", "", "promptForColumn", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ColumnDefinition;", "cottontaildb"})
@ExperimentalTime
public final class CreateEntityCommand
extends AbstractEntityCommand {
    private final DDLGrpc.DDLBlockingStub ddlStub;

    @Override
    public void exec() {
        this.checkValid();
        CottontailGrpc.EntityDefinition.Builder colDef = CottontailGrpc.EntityDefinition.newBuilder().setEntity(NameExtensionsKt.proto(this.getEntityName()));
        do {
            StringBuilder stringBuilder = new StringBuilder().append("Please specify column to add at position ");
            CottontailGrpc.EntityDefinition.Builder builder = colDef;
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"colDef");
            String string = stringBuilder.append(builder.getColumnsCount() + 1).append('.').toString();
            boolean bl = false;
            System.out.println((Object)string);
            CottontailGrpc.ColumnDefinition ret = this.promptForColumn();
            if (ret == null) continue;
            colDef.addColumns(ret);
        } while (colDef.getColumnsCount() <= 0 || !Intrinsics.areEqual((Object)TermUi.confirm$default((TermUi)TermUi.INSTANCE, (String)("Do you want to add another column (size = " + colDef.getColumnsCount() + ")?"), (boolean)false, (boolean)false, null, (boolean)false, null, (int)62, null), (Object)false));
        Table tbl2 = -DslKt.table((Function1)((Function1)new Function1<TableDsl, Unit>(this, colDef){
            final /* synthetic */ CreateEntityCommand this$0;
            final /* synthetic */ CottontailGrpc.EntityDefinition.Builder $colDef;

            public final void invoke(@NotNull TableDsl $this$table) {
                Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$receiver");
                $this$table.cellStyle((Function1)exec.tbl.1.INSTANCE);
                $this$table.header((Function1)new Function1<TableSectionDsl, Unit>(this){
                    final /* synthetic */ exec.tbl.1 this$0;

                    public final void invoke(@NotNull TableSectionDsl $this$header) {
                        Intrinsics.checkNotNullParameter((Object)$this$header, (String)"$receiver");
                        $this$header.row((Function1)new Function1<RowDsl, Unit>(this){
                            final /* synthetic */ exec.tbl.2 this$0;

                            public final void invoke(@NotNull RowDsl $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                                $this$row.cell((Object)this.this$0.this$0.this$0.getEntityName(), (Function1)exec.tbl.1.INSTANCE);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        $this$header.row((Function1)exec.tbl.2.INSTANCE);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                $this$table.body((Function1)new Function1<TableSectionDsl, Unit>(this){
                    final /* synthetic */ exec.tbl.1 this$0;

                    public final void invoke(@NotNull TableSectionDsl $this$body) {
                        Intrinsics.checkNotNullParameter((Object)$this$body, (String)"$receiver");
                        CottontailGrpc.EntityDefinition.Builder builder = this.this$0.$colDef;
                        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"colDef");
                        List list = builder.getColumnsList();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"colDef.columnsList");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            CottontailGrpc.ColumnDefinition def = (CottontailGrpc.ColumnDefinition)element$iv;
                            boolean bl = false;
                            $this$body.row((Function1)new Function1<RowDsl, Unit>(def){
                                final /* synthetic */ CottontailGrpc.ColumnDefinition $def;

                                public final void invoke(@NotNull RowDsl $this$row) {
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                                    Object[] objectArray = new Object[4];
                                    CottontailGrpc.ColumnDefinition columnDefinition = this.$def;
                                    Intrinsics.checkNotNullExpressionValue((Object)columnDefinition, (String)"def");
                                    objectArray[0] = columnDefinition.getName();
                                    CottontailGrpc.ColumnDefinition columnDefinition2 = this.$def;
                                    Intrinsics.checkNotNullExpressionValue((Object)columnDefinition2, (String)"def");
                                    objectArray[1] = columnDefinition2.getType();
                                    CottontailGrpc.ColumnDefinition columnDefinition3 = this.$def;
                                    Intrinsics.checkNotNullExpressionValue((Object)columnDefinition3, (String)"def");
                                    objectArray[2] = columnDefinition3.getLength();
                                    CottontailGrpc.ColumnDefinition columnDefinition4 = this.$def;
                                    Intrinsics.checkNotNullExpressionValue((Object)columnDefinition4, (String)"def");
                                    objectArray[3] = columnDefinition4.getNullable();
                                    RowDsl.cells$default((RowDsl)$this$row, (Object[])objectArray, null, (int)2, null);
                                }
                                {
                                    this.$def = columnDefinition;
                                    super(1);
                                }
                            });
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = createEntityCommand;
                this.$colDef = builder;
                super(1);
            }
        }));
        if (Intrinsics.areEqual((Object)TermUi.confirm$default((TermUi)TermUi.INSTANCE, (String)("Please confirm that you want to create the entity:\n" + tbl2), (boolean)true, (boolean)false, null, (boolean)false, null, (int)60, null), (Object)true)) {
            boolean $i$f$measureTimedValue = false;
            boolean bl = false;
            TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            boolean bl2 = false;
            TimeMark mark$iv$iv = $this$measureTimedValue$iv$iv.markNow();
            boolean bl3 = false;
            CottontailGrpc.QueryResponseMessage queryResponseMessage = this.ddlStub.createEntity(CottontailGrpc.CreateEntityMessage.newBuilder().setDefinition(colDef).build());
            Intrinsics.checkNotNullExpressionValue((Object)queryResponseMessage, (String)"this.ddlStub.createEntit\u2026finition(colDef).build())");
            Table result$iv$iv = TabulationUtilities.INSTANCE.tabulate(queryResponseMessage);
            TimedValue time = new TimedValue((Object)result$iv$iv, mark$iv$iv.elapsedNow-UwyO8pc(), null);
            Object object = "Entity " + this.getEntityName() + " created successfully (took " + Duration.toString-impl((long)time.getDuration-UwyO8pc()) + ").";
            boolean bl4 = false;
            System.out.println(object);
            object = time.getValue();
            bl4 = false;
            System.out.print(object);
        } else {
            String string = "Create entity " + this.getEntityName() + " aborted!";
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    private final boolean checkValid() {
        try {
            Iterator ret = this.ddlStub.listEntities(CottontailGrpc.ListEntityMessage.newBuilder().setSchema(NameExtensionsKt.proto(this.getEntityName().schema())).build());
            while (ret.hasNext()) {
            }
            return true;
        }
        catch (StatusRuntimeException e) {
            if (Intrinsics.areEqual((Object)e.getStatus(), (Object)Status.NOT_FOUND)) {
                String string = "Error: Schema " + this.getEntityName().schema() + " not found.";
                boolean bl = false;
                System.out.println((Object)string);
            }
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final CottontailGrpc.ColumnDefinition promptForColumn() {
        v0 = def = CottontailGrpc.ColumnDefinition.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"def");
        v0.setName(TermUi.prompt$default((TermUi)TermUi.INSTANCE, (String)"Column name (must consist of letters and numbers)", null, (boolean)false, (boolean)false, null, null, (boolean)false, (int)126, null));
        def.setType((CottontailGrpc.Type)TermUi.prompt$default((TermUi)TermUi.INSTANCE, (String)("Column type (" + ArraysKt.joinToString$default((Object[])CottontailGrpc.Type.values(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')'), null, (boolean)false, (boolean)false, null, null, (boolean)false, null, (Function1)promptForColumn.1.INSTANCE, (int)254, null));
        v1 = def.getType();
        if (v1 == null) ** GOTO lbl-1000
        switch (CreateEntityCommand$WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                v2 = (Integer)TermUi.prompt$default((TermUi)TermUi.INSTANCE, (String)"\rColumn lengths (i.e. number of entries for vectors)", null, (boolean)false, (boolean)false, null, null, (boolean)false, null, (Function1)promptForColumn.2.INSTANCE, (int)254, null);
                if (v2 != null) {
                    v3 = v2;
                    break;
                }
                v3 = 1;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v3 = -1;
            }
        }
        def.setLength(v3);
        v4 = TermUi.confirm$default((TermUi)TermUi.INSTANCE, (String)"Should column be nullable?", (boolean)false, (boolean)false, null, (boolean)false, null, (int)60, null);
        def.setNullable(v4 != null ? v4 : false);
        tbl = -DslKt.table((Function1)((Function1)new Function1<TableDsl, Unit>(def){
            final /* synthetic */ CottontailGrpc.ColumnDefinition.Builder $def;

            public final void invoke(@NotNull TableDsl $this$table) {
                Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$receiver");
                $this$table.cellStyle((Function1)promptForColumn.tbl.1.INSTANCE);
                $this$table.header((Function1)promptForColumn.tbl.2.INSTANCE);
                $this$table.body((Function1)new Function1<TableSectionDsl, Unit>(this){
                    final /* synthetic */ promptForColumn.tbl.1 this$0;

                    public final void invoke(@NotNull TableSectionDsl $this$body) {
                        Intrinsics.checkNotNullParameter((Object)$this$body, (String)"$receiver");
                        $this$body.row((Function1)new Function1<RowDsl, Unit>(this){
                            final /* synthetic */ promptForColumn.tbl.3 this$0;

                            public final void invoke(@NotNull RowDsl $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                                Object[] objectArray = new Object[4];
                                CottontailGrpc.ColumnDefinition.Builder builder = this.this$0.this$0.$def;
                                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"def");
                                objectArray[0] = builder.getName();
                                CottontailGrpc.ColumnDefinition.Builder builder2 = this.this$0.this$0.$def;
                                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"def");
                                objectArray[1] = builder2.getType();
                                CottontailGrpc.ColumnDefinition.Builder builder3 = this.this$0.this$0.$def;
                                Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"def");
                                objectArray[2] = builder3.getLength();
                                CottontailGrpc.ColumnDefinition.Builder builder4 = this.this$0.this$0.$def;
                                Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"def");
                                objectArray[3] = builder4.getNullable();
                                RowDsl.cells$default((RowDsl)$this$row, (Object[])objectArray, null, (int)2, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.$def = builder;
                super(1);
            }
        }));
        return Intrinsics.areEqual((Object)TermUi.confirm$default((TermUi)TermUi.INSTANCE, (String)("Please confirm column:\n" + tbl), (boolean)false, (boolean)false, null, (boolean)false, null, (int)62, null), (Object)true) != false ? def.build() : null;
    }

    public CreateEntityCommand(@NotNull DDLGrpc.DDLBlockingStub ddlStub) {
        Intrinsics.checkNotNullParameter((Object)ddlStub, (String)"ddlStub");
        super("create", "Creates a new entity in the database. Usage: entity create <schema>.<entity>");
        this.ddlStub = ddlStub;
    }
}

