/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli.query;

import com.github.ajalt.clikt.completion.CompletionCandidates;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.parameters.options.OptionCallTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.options.ValueWithDefault;
import com.jakewharton.picnic.Table;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.cli.AbstractCottontailCommand;
import org.vitrivr.cottontail.cli.query.AbstractQueryCommand$$special$;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DQLGrpc;
import org.vitrivr.cottontail.utilities.data.Format;
import org.vitrivr.cottontail.utilities.data.exporter.DataExporter;
import org.vitrivr.cottontail.utilities.output.TabulationUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/vitrivr/cottontail/cli/query/AbstractQueryCommand;", "Lorg/vitrivr/cottontail/cli/AbstractCottontailCommand;", "stub", "Lorg/vitrivr/cottontail/grpc/DQLGrpc$DQLBlockingStub;", "name", "", "help", "(Lorg/vitrivr/cottontail/grpc/DQLGrpc$DQLBlockingStub;Ljava/lang/String;Ljava/lang/String;)V", "explain", "", "getExplain", "()Z", "explain$delegate", "Lkotlin/properties/ReadOnlyProperty;", "format", "Lorg/vitrivr/cottontail/utilities/data/Format;", "getFormat", "()Lorg/vitrivr/cottontail/utilities/data/Format;", "format$delegate", "out", "Ljava/nio/file/Path;", "getOut", "()Ljava/nio/file/Path;", "out$delegate", "toFile", "getToFile", "executeAndExport", "", "query", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage;", "executeAndTabulate", "cottontaildb"})
@ExperimentalTime
public abstract class AbstractQueryCommand
extends AbstractCottontailCommand {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty explain$delegate;
    private final ReadOnlyProperty out$delegate;
    private final ReadOnlyProperty format$delegate;
    private final DQLGrpc.DQLBlockingStub stub;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(AbstractQueryCommand.class, "explain", "getExplain()Z", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(AbstractQueryCommand.class, "out", "getOut()Ljava/nio/file/Path;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(AbstractQueryCommand.class, "format", "getFormat()Lorg/vitrivr/cottontail/utilities/data/Format;", 0))};
    }

    private final boolean getExplain() {
        return (Boolean)this.explain$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final Path getOut() {
        return (Path)this.out$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final Format getFormat() {
        return (Format)((Object)this.format$delegate.getValue((Object)this, $$delegatedProperties[2]));
    }

    protected final boolean getToFile() {
        return this.getOut() != null;
    }

    protected final void executeAndTabulate(@NotNull CottontailGrpc.QueryMessage query2) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        try {
            boolean bl;
            Object object;
            Table table;
            boolean $i$f$measureTimedValue = false;
            boolean bl2 = false;
            TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            boolean bl3 = false;
            TimeMark mark$iv$iv = $this$measureTimedValue$iv$iv.markNow();
            boolean bl4 = false;
            if (this.getExplain()) {
                Iterator iterator2 = this.stub.explain(query2);
                Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"this.stub.explain(query)");
                table = TabulationUtilities.INSTANCE.tabulate(iterator2);
            } else {
                Iterator iterator3 = this.stub.query(query2);
                Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"this.stub.query(query)");
                table = TabulationUtilities.INSTANCE.tabulate(iterator3);
            }
            Table result$iv$iv = table;
            TimedValue results = new TimedValue((Object)result$iv$iv, mark$iv$iv.elapsedNow-UwyO8pc(), null);
            if (this.getExplain()) {
                object = "Explaining query (took: " + Duration.toString-impl((long)results.getDuration-UwyO8pc()) + "):";
                bl = false;
                System.out.println(object);
            } else {
                object = "Executing query (took: " + Duration.toString-impl((long)results.getDuration-UwyO8pc()) + "):";
                bl = false;
                System.out.println(object);
            }
            object = results.getValue();
            bl = false;
            System.out.print(object);
        }
        catch (Throwable e) {
            String string = "An error occurred while executing query: " + e.getMessage() + '.';
            boolean bl = false;
            System.out.print((Object)string);
        }
    }

    protected final void executeAndExport(@NotNull CottontailGrpc.QueryMessage query2) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        try {
            boolean $i$f$measureTime = false;
            boolean bl = false;
            TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            boolean bl2 = false;
            TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
            boolean bl3 = false;
            if (this.getOut() != null) {
                Iterator results;
                DataExporter dataExporter;
                DataExporter dataExporter2;
                Format format = this.getFormat();
                if (format != null) {
                    Path path = this.getOut();
                    Intrinsics.checkNotNull((Object)path);
                    dataExporter2 = format.newExporter(path);
                } else {
                    dataExporter2 = dataExporter = null;
                }
                if (dataExporter == null) {
                    String string = "Valid output format needs to be specified for export!";
                    boolean bl4 = false;
                    System.out.println((Object)string);
                    return;
                }
                Iterator iterator2 = results = this.getExplain() ? this.stub.explain(query2) : this.stub.query(query2);
                Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"results");
                Iterator iterator3 = iterator2;
                boolean bl5 = false;
                Iterator iterator4 = iterator3;
                while (iterator4.hasNext()) {
                    CottontailGrpc.QueryResponseMessage r;
                    CottontailGrpc.QueryResponseMessage queryResponseMessage = r = (CottontailGrpc.QueryResponseMessage)iterator4.next();
                    Intrinsics.checkNotNullExpressionValue((Object)queryResponseMessage, (String)"r");
                    dataExporter.offer(queryResponseMessage);
                }
                dataExporter.close();
            }
            long duration = mark$iv$iv.elapsedNow-UwyO8pc();
            String string = "Executing and exporting query took " + Duration.toString-impl((long)duration) + '.';
            boolean bl6 = false;
            System.out.println((Object)string);
        }
        catch (Throwable e) {
            String string = "A " + e.getClass().getSimpleName() + " occurred while executing and exporting query: " + e.getMessage() + '.';
            boolean bl = false;
            System.out.print((Object)string);
        }
    }

    public AbstractQueryCommand(@NotNull DQLGrpc.DQLBlockingStub stub, @NotNull String name, @NotNull String help) {
        Function1 metavar$iv$iv;
        OptionWithValues $this$convert$iv$iv;
        OptionWithValues $this$convert_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        super(name, help);
        this.stub = stub;
        OptionWithValues optionWithValues = OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-e", "--explain"}, (String)"If set, query will only be executed and not set.", null, (boolean)false, null, null, null, null, (int)252, null);
        Function1 metavar$iv = $special$$inlined$convert$1.INSTANCE;
        CompletionCandidates completionCandidates$iv = (CompletionCandidates)$this$convert_u24default$iv.getCompletionCandidatesWithDefault().getDefault();
        void var9_7 = $this$convert_u24default$iv;
        Function1 function1 = metavar$iv;
        CompletionCandidates completionCandidates$iv$iv = completionCandidates$iv;
        boolean $i$f$convert = false;
        Function2 proc$iv$iv = (Function2)new Function2<OptionCallTransformContext, String, Boolean>($this$convert$iv$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull OptionCallTransformContext $this$null, @NotNull String it) {
                Boolean bl;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string = (String)this.$this_convert.getTransformValue().invoke((Object)$this$null, (Object)it);
                    OptionCallTransformContext $this$convert = $this$null;
                    boolean bl2 = false;
                    void var6_9 = it2;
                    boolean bl3 = false;
                    bl = Boolean.parseBoolean((String)var6_9);
                }
                catch (UsageError err) {
                    err.setParamName($this$null.getName());
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    $this$null.fail(string == null ? "" : string);
                    throw new KotlinNothingValueException();
                }
                return bl;
            }
        };
        this.explain$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValues.copy$default((OptionWithValues)$this$convert$iv$iv, (Function2)proc$iv$iv, (Function2)OptionWithValuesKt.defaultEachProcessor(), (Function2)OptionWithValuesKt.defaultAllProcessor(), (Function2)OptionWithValuesKt.defaultValidator(), null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getMetavarWithDefault(), null, (Object)metavar$iv$iv, (int)1, null), (int)0, null, (boolean)false, null, null, null, null, null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getCompletionCandidatesWithDefault(), null, (Object)completionCandidates$iv$iv, (int)1, null), (int)16336, null), (Object)false, null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
        $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-o", "--out"}, (String)"If set, query will be exported into files instead of CLI.", null, (boolean)false, null, null, null, null, (int)252, null);
        metavar$iv = $special$$inlined$convert$3.INSTANCE;
        completionCandidates$iv = (CompletionCandidates)$this$convert_u24default$iv.getCompletionCandidatesWithDefault().getDefault();
        $this$convert$iv$iv = $this$convert_u24default$iv;
        metavar$iv$iv = metavar$iv;
        completionCandidates$iv$iv = completionCandidates$iv;
        $i$f$convert = false;
        proc$iv$iv = (Function2)new Function2<OptionCallTransformContext, String, Path>($this$convert$iv$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Path invoke(@NotNull OptionCallTransformContext $this$null, @NotNull String it) {
                Path path;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string = (String)this.$this_convert.getTransformValue().invoke((Object)$this$null, (Object)it);
                    OptionCallTransformContext $this$convert = $this$null;
                    boolean bl = false;
                    path = Paths.get((String)it2, new String[0]);
                }
                catch (UsageError err) {
                    err.setParamName($this$null.getName());
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    $this$null.fail(string == null ? "" : string);
                    throw new KotlinNothingValueException();
                }
                return path;
            }
        };
        this.out$delegate = OptionWithValues.copy$default((OptionWithValues)$this$convert$iv$iv, (Function2)proc$iv$iv, (Function2)OptionWithValuesKt.defaultEachProcessor(), (Function2)OptionWithValuesKt.defaultAllProcessor(), (Function2)OptionWithValuesKt.defaultValidator(), null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getMetavarWithDefault(), null, (Object)metavar$iv$iv, (int)1, null), (int)0, null, (boolean)false, null, null, null, null, null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getCompletionCandidatesWithDefault(), null, (Object)completionCandidates$iv$iv, (int)1, null), (int)16336, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
        $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-f", "--format"}, (String)"Only for option --out; export format. Defaults to PROTO", null, (boolean)false, null, null, null, null, (int)252, null);
        metavar$iv = $special$$inlined$convert$5.INSTANCE;
        completionCandidates$iv = (CompletionCandidates)$this$convert_u24default$iv.getCompletionCandidatesWithDefault().getDefault();
        $this$convert$iv$iv = $this$convert_u24default$iv;
        metavar$iv$iv = metavar$iv;
        completionCandidates$iv$iv = completionCandidates$iv;
        $i$f$convert = false;
        proc$iv$iv = (Function2)new Function2<OptionCallTransformContext, String, Format>($this$convert$iv$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Format invoke(@NotNull OptionCallTransformContext $this$null, @NotNull String it) {
                Format format;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string = (String)this.$this_convert.getTransformValue().invoke((Object)$this$null, (Object)it);
                    OptionCallTransformContext $this$convert = $this$null;
                    boolean bl = false;
                    format = Format.valueOf((String)it2);
                }
                catch (UsageError err) {
                    err.setParamName($this$null.getName());
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    $this$null.fail(string == null ? "" : string);
                    throw new KotlinNothingValueException();
                }
                return format;
            }
        };
        this.format$delegate = OptionWithValues.copy$default((OptionWithValues)$this$convert$iv$iv, (Function2)proc$iv$iv, (Function2)OptionWithValuesKt.defaultEachProcessor(), (Function2)OptionWithValuesKt.defaultAllProcessor(), (Function2)OptionWithValuesKt.defaultValidator(), null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getMetavarWithDefault(), null, (Object)metavar$iv$iv, (int)1, null), (int)0, null, (boolean)false, null, null, null, null, null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getCompletionCandidatesWithDefault(), null, (Object)completionCandidates$iv$iv, (int)1, null), (int)16336, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
    }
}

