/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.catalogue;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.catalogue.CatalogueHeader;
import org.vitrivr.cottontail.database.catalogue.CatalogueTx;
import org.vitrivr.cottontail.database.catalogue.CatalogueTxSnapshot;
import org.vitrivr.cottontail.database.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxAction;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.schema.DefaultSchema;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.utilities.io.TxFileUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u000201B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010*\u001a\u00020+H\u0016J\u0014\u0010,\u001a\u00060-R\u00020\u00002\u0006\u0010.\u001a\u00020/H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00062"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueHeader;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$RootName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$RootName;", "parent", "Lorg/vitrivr/cottontail/database/general/DBO;", "getParent", "()Lorg/vitrivr/cottontail/database/general/DBO;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "Lorg/vitrivr/cottontail/database/schema/Schema;", "size", "", "getSize", "()I", "store", "Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class DefaultCatalogue
implements Catalogue {
    @NotNull
    private final Path path;
    @Nullable
    private final DBO parent;
    private final StampedLock closeLock;
    private final DB store;
    private final Atomic.Var<CatalogueHeader> headerField;
    private final Map<Name.SchemaName, Schema> registry;
    @NotNull
    private final Config config;
    @NotNull
    public static final String CATALOGUE_HEADER_FIELD = "cdb_catalogue_header";
    @NotNull
    public static final String FILE_CATALOGUE = "catalogue.db";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Name.RootName getName() {
        return Name.RootName.INSTANCE;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    @Nullable
    public DBO getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int n;
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            n = 0;
            n = ((CatalogueHeader)this.headerField.get()).getSchemas().size();
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return n;
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-DefaultCatalogue$close$22 = false;
            this.store.close();
            Map<Name.SchemaName, Schema> $this$forEach$iv = this.registry;
            boolean $i$f$forEach = false;
            Map<Name.SchemaName, Schema> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<Name.SchemaName, Schema>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Name.SchemaName, Schema> element$iv;
                Map.Entry<Name.SchemaName, Schema> $dstr$_u24__u24$v = element$iv = iterator2.next();
                boolean bl2 = false;
                Map.Entry<Name.SchemaName, Schema> entry = $dstr$_u24__u24$v;
                boolean bl3 = false;
                Schema v = entry.getValue();
                v.close();
            }
            Unit $i$a$-write-DefaultCatalogue$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public DefaultCatalogue(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.path = this.getConfig().getRoot();
        this.closeLock = new StampedLock();
        MapDBConfig mapDBConfig = this.getConfig().getMapdb();
        Path path = this.getPath().resolve(FILE_CATALOGUE);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.path.resolve(FILE_CATALOGUE)");
        this.store = mapDBConfig.db(path);
        this.headerField = (Atomic.Var)this.store.atomicVar(CATALOGUE_HEADER_FIELD, (Serializer)CatalogueHeader.Serializer).createOrOpen();
        Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.synchronized\u2026ject2ObjectOpenHashMap())");
        this.registry = map2;
        if (this.headerField.get() == null) {
            this.headerField.set((Object)new CatalogueHeader(null, 0L, 0L, null, 15, null));
            this.store.commit();
        }
        for (CatalogueHeader.SchemaRef schemaRef : ((CatalogueHeader)this.headerField.get()).getSchemas()) {
            if (schemaRef.getPath() != null && Files.exists(schemaRef.getPath(), new LinkOption[0])) {
                this.registry.put(new Name.SchemaName(schemaRef.getName()), new DefaultSchema(this.getPath(), this));
                continue;
            }
            Path path2 = this.getPath().resolve("schema_" + schemaRef.getName());
            if (!Files.exists(path2, new LinkOption[0])) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Broken catalogue entry for schema '" + schemaRef.getName() + "'. Path " + path2 + " does not exist!");
            }
            Name.SchemaName schemaName = new Name.SchemaName(schemaRef.getName());
            Path path3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            this.registry.put(schemaName, new DefaultSchema(path3, this));
        }
    }

    public static final /* synthetic */ Atomic.Var access$getHeaderField$p(DefaultCatalogue $this) {
        return $this.headerField;
    }

    public static final /* synthetic */ DB access$getStore$p(DefaultCatalogue $this) {
        return $this.store;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001c\u001dB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "getDbo", "()Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "snapshot", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueTxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/catalogue/CatalogueTxSnapshot;", "snapshot$delegate", "Lkotlin/Lazy;", "cleanup", "", "createSchema", "Lorg/vitrivr/cottontail/database/schema/Schema;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "dropSchema", "listSchemas", "", "schemaForName", "CreateSchemaTxAction", "DropSchemaTxAction", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements CatalogueTx {
        private final long closeStamp;
        @NotNull
        private final Lazy snapshot$delegate;

        @Override
        @NotNull
        public DefaultCatalogue getDbo() {
            return DefaultCatalogue.this;
        }

        @Override
        @NotNull
        public CatalogueTxSnapshot getSnapshot() {
            Lazy lazy = this.snapshot$delegate;
            Tx tx = this;
            Object var3_3 = null;
            boolean bl = false;
            return (CatalogueTxSnapshot)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Schema> listSchemas() {
            List list;
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                list = CollectionsKt.toList((Iterable)this.getSnapshot().getSchemas().values());
            }
            finally {
                readLock.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Schema schemaForName(@NotNull Name.SchemaName name) {
            Schema schema;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                Schema schema2 = this.getSnapshot().getSchemas().get(name);
                if (schema2 == null) {
                    throw (Throwable)new DatabaseException.SchemaDoesNotExistException(name);
                }
                schema = schema2;
            }
            finally {
                readLock.unlock();
            }
            return schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Schema createSchema(@NotNull Name.SchemaName name) {
            int n;
            int n2;
            int n3;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n5 = 0;
            n5 = 0;
            int n6 = n4;
            while (n5 < n6) {
                n3 = n5++;
                n2 = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                n = 0;
                boolean bl4 = false;
                Map<Name.SchemaName, Schema> map2 = this.getSnapshot().getSchemas();
                Name.SchemaName schemaName = name;
                boolean bl5 = false;
                Map<Name.SchemaName, Schema> map3 = map2;
                boolean bl6 = false;
                if (map3.containsKey(schemaName)) {
                    throw (Throwable)new DatabaseException.SchemaAlreadyExistsException(name);
                }
                try {
                    Path data = DefaultSchema.Companion.initialize(name, DefaultCatalogue.this.getPath(), DefaultCatalogue.this.getConfig());
                    DefaultSchema schema = new DefaultSchema(data, DefaultCatalogue.this);
                    this.getSnapshot().record(new CreateSchemaTxAction(schema));
                    this.getSnapshot().getSchemas().put(name, schema);
                    Schema schema2 = schema;
                    return schema2;
                }
                catch (DatabaseException e) {
                    this.setStatus(TxStatus.ERROR);
                    throw (Throwable)e;
                }
            }
            finally {
                n6 = 0;
                n3 = 0;
                n3 = 0;
                n2 = n4;
                while (n3 < n2) {
                    n = n3++;
                    boolean bl7 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropSchema(@NotNull Name.SchemaName name) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                Schema schema = this.getSnapshot().getSchemas().get(name);
                if (schema == null) {
                    throw (Throwable)new DatabaseException.SchemaDoesNotExistException(name);
                }
                Schema schema2 = schema;
                this.getContext().requestLock(schema2, LockMode.EXCLUSIVE);
                this.getSnapshot().record(new DropSchemaTxAction(name));
                this.getSnapshot().getSchemas().remove(name);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        protected void cleanup() {
            DefaultCatalogue.this.closeLock.unlockRead(this.closeStamp);
        }

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = DefaultCatalogue.this.closeLock.readLock();
            this.snapshot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<snapshot.1>(this){
                final /* synthetic */ Tx this$0;

                @NotNull
                public final snapshot.1 invoke() {
                    return new CatalogueTxSnapshot(this){
                        @NotNull
                        private final Object2ObjectOpenHashMap<Name.SchemaName, Schema> schemas;
                        @NotNull
                        private final LinkedList<TxAction> actions;
                        final /* synthetic */ snapshot.2 this$0;

                        @NotNull
                        public Object2ObjectOpenHashMap<Name.SchemaName, Schema> getSchemas() {
                            return this.schemas;
                        }

                        @NotNull
                        public LinkedList<TxAction> getActions() {
                            return this.actions;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void commit() {
                            try {
                                Collection<CatalogueHeader.SchemaRef> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                TxAction it;
                                Iterable $this$forEach$iv = this.getActions();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (TxAction)element$iv;
                                    boolean bl = false;
                                    it.commit();
                                }
                                CatalogueHeader oldHeader = (CatalogueHeader)DefaultCatalogue.access$getHeaderField$p(this.this$0.this$0.DefaultCatalogue.this).get();
                                long l = System.currentTimeMillis();
                                ObjectCollection objectCollection = (ObjectCollection)this.getSchemas().values();
                                Intrinsics.checkNotNullExpressionValue((Object)objectCollection, (String)"this.schemas.values");
                                Iterable iterable = (Iterable)objectCollection;
                                long l2 = l;
                                long l3 = 0L;
                                String string = null;
                                CatalogueHeader catalogueHeader = oldHeader;
                                boolean $i$f$map = false;
                                it = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it2;
                                    Schema schema = (Schema)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    CatalogueHeader.SchemaRef schemaRef = new CatalogueHeader.SchemaRef(it2.getName().getSimple(), null);
                                    collection.add(schemaRef);
                                }
                                collection = (List)destination$iv$iv;
                                CatalogueHeader newHeader = CatalogueHeader.copy$default(catalogueHeader, string, l3, l2, (List)collection, 3, null);
                                DefaultCatalogue.access$getHeaderField$p(this.this$0.this$0.DefaultCatalogue.this).compareAndSet((Object)oldHeader, (Object)newHeader);
                                DefaultCatalogue.access$getStore$p(this.this$0.this$0.DefaultCatalogue.this).commit();
                            }
                            catch (Throwable e) {
                                Tx.access$setStatus$p(this.this$0.this$0, TxStatus.ERROR);
                                DefaultCatalogue.access$getStore$p(this.this$0.this$0.DefaultCatalogue.this).rollback();
                                throw (Throwable)new DatabaseException("Failed to commit catalogue due to a storage exception: " + e.getMessage(), null, 2, null);
                            }
                        }

                        public void rollback() {
                            Iterable $this$forEach$iv = this.getActions();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                TxAction it = (TxAction)element$iv;
                                boolean bl = false;
                                it.rollback();
                            }
                            DefaultCatalogue.access$getStore$p(this.this$0.this$0.DefaultCatalogue.this).rollback();
                        }

                        public boolean record(@NotNull TxAction action) {
                            boolean bl;
                            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                            TxAction txAction = action;
                            if (txAction instanceof CreateSchemaTxAction || txAction instanceof DropSchemaTxAction) {
                                ((LinkedList)this.getActions()).add(action);
                                bl = true;
                            } else {
                                bl = false;
                            }
                            return bl;
                        }
                        {
                            this.this$0 = this$0;
                            this.schemas = new Object2ObjectOpenHashMap(DefaultCatalogue.access$getRegistry$p(this$0.this$0.DefaultCatalogue.this));
                            this.actions = new LinkedList<E>();
                        }
                    };
                }
                {
                    this.this$0 = tx;
                    super(0);
                }
            }));
            if (DefaultCatalogue.this.getClosed()) {
                DefaultCatalogue.this.closeLock.unlockRead(this.closeStamp);
                throw (Throwable)new TxException.TxDBOClosedException(this.getContext().getTxId(), DefaultCatalogue.this);
            }
        }

        public static final /* synthetic */ TxStatus access$getStatus$p(Tx $this) {
            return $this.getStatus();
        }

        public static final /* synthetic */ void access$setStatus$p(Tx $this, TxStatus txStatus) {
            $this.setStatus(txStatus);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Tx$CreateSchemaTxAction;", "Lorg/vitrivr/cottontail/database/general/TxAction;", "schema", "Lorg/vitrivr/cottontail/database/schema/Schema;", "(Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Tx;Lorg/vitrivr/cottontail/database/schema/Schema;)V", "commit", "", "rollback", "cottontaildb"})
        public final class CreateSchemaTxAction
        implements TxAction {
            private final Schema schema;

            @Override
            public void commit() {
                this.schema.close();
                Path move = Files.move(this.schema.getPath(), TxFileUtilities.INSTANCE.plainPath(this.schema.getPath()), StandardCopyOption.ATOMIC_MOVE);
                Map map2 = DefaultCatalogue.this.registry;
                Name.SchemaName schemaName = this.schema.getName();
                Path path = move;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"move");
                map2.put(schemaName, new DefaultSchema(path, this.schema.getParent()));
            }

            @Override
            public void rollback() {
                this.schema.close();
                TxFileUtilities.INSTANCE.delete(this.schema.getPath());
            }

            public CreateSchemaTxAction(Schema schema) {
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                this.schema = schema;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Tx$DropSchemaTxAction;", "Lorg/vitrivr/cottontail/database/general/TxAction;", "schema", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "(Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Tx;Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;)V", "commit", "", "rollback", "cottontaildb"})
        public final class DropSchemaTxAction
        implements TxAction {
            private final Name.SchemaName schema;

            @Override
            public void commit() {
                Schema schema = (Schema)DefaultCatalogue.this.registry.remove(this.schema);
                if (schema == null) {
                    throw (Throwable)new IllegalStateException("Failed to drop schema " + this.schema + " because it is unknown to catalogue. This is a programmer's error!");
                }
                Schema schema2 = schema;
                schema2.close();
                if (Files.exists(schema2.getPath(), new LinkOption[0])) {
                    TxFileUtilities.INSTANCE.delete(schema2.getPath());
                }
            }

            @Override
            public void rollback() {
            }

            public DropSchemaTxAction(Name.SchemaName schema) {
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                this.schema = schema;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Companion;", "", "()V", "CATALOGUE_HEADER_FIELD", "", "FILE_CATALOGUE", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

