/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.hash;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxAction;
import org.vitrivr.cottontail.database.general.TxSnapshot;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.ComparisonOperator;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.StringValue;
import org.vitrivr.cottontail.model.values.pattern.LikePatternValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006)"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/NonUniqueHashIndex;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;)V", "map", "Lorg/mapdb/BTreeMap;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "", "kotlin.jvm.PlatformType", "produces", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "serializer", "Lorg/mapdb/serializer/GroupSerializer;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class NonUniqueHashIndex
extends AbstractIndex {
    @NotNull
    private final IndexType type;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private final ColumnDef<?>[] produces;
    private final GroupSerializer<Value> serializer;
    private final BTreeMap<Value, long[]> map;
    @NotNull
    public static final String NUQ_INDEX_MAP = "cdb_nuq_tree_map";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate.Atomic.Literal)) {
            return false;
        }
        if (((BooleanPredicate.Atomic.Literal)predicate).getNot()) {
            return false;
        }
        if (Intrinsics.areEqual(((BooleanPredicate.Atomic.Literal)predicate).getLeft(), this.getColumns()[0]) ^ true) {
            return false;
        }
        ComparisonOperator comparisonOperator = ((BooleanPredicate.Atomic.Literal)predicate).getOperator();
        return comparisonOperator instanceof ComparisonOperator.Binary.Equal || comparisonOperator instanceof ComparisonOperator.In ? true : (comparisonOperator instanceof ComparisonOperator.Binary.Like ? ((ComparisonOperator.Binary.Like)((BooleanPredicate.Atomic.Literal)predicate).getOperator()).getRight().getValue() instanceof LikePatternValue.StartsWith : false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Cost cost;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate.Atomic.Literal) || Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) ^ true || ((BooleanPredicate.Atomic.Literal)predicate).getNot()) {
            cost = Cost.Companion.getINVALID();
        } else if (((BooleanPredicate.Atomic.Literal)predicate).getOperator() instanceof ComparisonOperator.Binary.Equal) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = predicate.getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS();
            float f2 = 1.0E-4f;
            boolean $i$f$map = false;
            void var4_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColumnDef columnDef = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getType().getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            float f3 = CollectionsKt.sumOfInt((Iterable)collection);
            float f4 = f;
            float f5 = f2;
            cost = new Cost(f5, f4, f3);
        } else if (((BooleanPredicate.Atomic.Literal)predicate).getOperator() instanceof ComparisonOperator.Binary.Like) {
            Collection<Integer> collection;
            Iterable $this$map$iv = predicate.getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS();
            float f6 = 1.0E-4f;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ColumnDef it = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getType().getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            float f7 = CollectionsKt.sumOfInt((Iterable)collection);
            float f8 = f;
            float f9 = f6;
            cost = new Cost(f9, f8, f7);
        } else if (((BooleanPredicate.Atomic.Literal)predicate).getOperator() instanceof ComparisonOperator.In) {
            Collection<Integer> collection;
            Iterable $this$map$iv = predicate.getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS() * (float)((ComparisonOperator.In)((BooleanPredicate.Atomic.Literal)predicate).getOperator()).getRight().size();
            float f10 = 1.0E-4f * (float)((ComparisonOperator.In)((BooleanPredicate.Atomic.Literal)predicate).getOperator()).getRight().size();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ColumnDef it = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getType().getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            float f11 = CollectionsKt.sumOfInt((Iterable)collection);
            float f12 = f;
            float f13 = f10;
            cost = new Cost(f13, f12, f11);
        } else {
            cost = Cost.Companion.getINVALID();
        }
        return cost;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - void declaration
     */
    public NonUniqueHashIndex(@NotNull Path path, @NotNull DefaultEntity parent) {
        GroupSerializer groupSerializer;
        void it;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        this.type = IndexType.HASH;
        this.supportsIncrementalUpdate = true;
        this.produces = this.getColumns();
        MapDBSerializer<?> mapDBSerializer = this.getColumns()[0].getType().serializerFactory().mapdb(this.getColumns()[0].getType().getLogicalSize());
        boolean bl = false;
        boolean bl2 = false;
        MapDBSerializer<?> mapDBSerializer2 = mapDBSerializer;
        NonUniqueHashIndex nonUniqueHashIndex = this;
        boolean bl3 = false;
        boolean bl4 = it instanceof GroupSerializer;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "NonUniqueHashIndex only supports value types with group serializers.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        void v0 = it;
        if (v0 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.mapdb.serializer.GroupSerializer<org.vitrivr.cottontail.model.values.types.Value>");
        }
        nonUniqueHashIndex.serializer = groupSerializer = (GroupSerializer)v0;
        DB dB = this.getStore();
        GroupSerializer groupSerializer2 = Serializer.LONG_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer2, (String)"Serializer.LONG_ARRAY");
        this.map = dB.treeMap(NUQ_INDEX_MAP, this.serializer, groupSerializer2).createOrOpen();
        this.getStore().commit();
    }

    public static final /* synthetic */ DB access$getStore$p(NonUniqueHashIndex $this) {
        return $this.getStore();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\n\u0010\u0012\u001a\u00060\nj\u0002`\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016J\u001c\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\n\u0010\u0012\u001a\u00060\nj\u0002`\u0013H\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0016R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/NonUniqueHashIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/hash/NonUniqueHashIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "mappingsCache", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "Ljava/util/LinkedList;", "", "snapshot", "Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "addMapping", "", "key", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "clear", "count", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "removeMapping", "update", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        @NotNull
        private final TxSnapshot snapshot;
        private final Object2ObjectOpenHashMap<Value, LinkedList<Long>> mappingsCache;

        @Override
        @NotNull
        public TxSnapshot getSnapshot() {
            return this.snapshot;
        }

        private final void addMapping(Value key, long tupleId) {
            this.mappingsCache.compute((Object)key, (BiFunction)new BiFunction<Value, LinkedList<Long>, LinkedList<Long>>(tupleId){
                final /* synthetic */ long $tupleId;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final LinkedList<Long> apply(Value $noName_0, @Nullable LinkedList<Long> v) {
                    void var3_3;
                    LinkedList<Long> linkedList = v;
                    if (linkedList == null) {
                        linkedList = new LinkedList<Long>();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"v ?: LinkedList<TupleId>()");
                    LinkedList<Long> l = linkedList;
                    l.add(this.$tupleId);
                    return var3_3;
                }
                {
                    this.$tupleId = l;
                }
            });
        }

        private final void removeMapping(Value key, long tupleId) {
            NonUniqueHashIndex.this.map.compute((Object)key, (BiFunction)new BiFunction<Value, long[], long[]>(tupleId){
                final /* synthetic */ long $tupleId;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final long[] apply(Value $noName_0, @Nullable long[] v) {
                    long[] lArray;
                    block4: {
                        block3: {
                            void $this$filterTo$iv$iv;
                            lArray = v;
                            if (v == null) break block3;
                            long[] $this$filter$iv = lArray;
                            boolean $i$f$filter = false;
                            long[] lArray2 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            void var8_8 = $this$filterTo$iv$iv;
                            int n = ((void)var8_8).length;
                            for (int i = 0; i < n; ++i) {
                                void element$iv$iv;
                                void it = element$iv$iv = var8_8[i];
                                boolean bl = false;
                                if (!(it != this.$tupleId)) continue;
                                destination$iv$iv.add((long)element$iv$iv);
                            }
                            lArray = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
                            if (lArray != null) break block4;
                        }
                        lArray = v;
                    }
                    return lArray;
                }
                {
                    this.$tupleId = l;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long count() {
            long l;
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                l = NonUniqueHashIndex.this.map.size();
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebuild() {
            int n;
            int n2;
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
                if (tx == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
                }
                EntityTx entityTx = (EntityTx)tx;
                NonUniqueHashIndex.this.map.clear();
                Iterator<Record> $this$forEach$iv = entityTx.scan(this.getDbo().getColumns());
                boolean $i$f$forEach = false;
                Iterator<Record> iterator2 = $this$forEach$iv;
                boolean bl6 = false;
                Iterator<Record> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Value value;
                    Record element$iv;
                    Record record = element$iv = iterator3.next();
                    boolean bl7 = false;
                    if (record.get(this.getDbo().getColumns()[0]) == null) {
                        throw (Throwable)new TxException.TxValidationException(this.getContext().getTxId(), "A value cannot be null for instances of NonUniqueHashIndex " + NonUniqueHashIndex.this.getName() + " but given value is (value = null, tupleId = " + record.getTupleId() + ").");
                    }
                    this.addMapping(value, record.getTupleId());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl8 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NotNull DataChangeEvent event) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Value old;
                boolean bl4 = false;
                boolean bl5 = false;
                DataChangeEvent dataChangeEvent = event;
                if (dataChangeEvent instanceof DataChangeEvent.InsertDataChangeEvent) {
                    Value value = ((DataChangeEvent.InsertDataChangeEvent)event).getInserts().get(this.getDbo().getColumns()[0]);
                    if (value != null) {
                        this.addMapping(value, event.getTupleId());
                    }
                } else if (dataChangeEvent instanceof DataChangeEvent.UpdateDataChangeEvent) {
                    Value value;
                    Pair<Value, Value> pair = ((DataChangeEvent.UpdateDataChangeEvent)event).getUpdates().get(this.getDbo().getColumns()[0]);
                    Value value2 = old = pair != null ? (Value)pair.getFirst() : null;
                    if (old != null) {
                        this.removeMapping(old, event.getTupleId());
                    }
                    Pair<Value, Value> pair2 = ((DataChangeEvent.UpdateDataChangeEvent)event).getUpdates().get(this.getDbo().getColumns()[0]);
                    Value value3 = value = pair2 != null ? (Value)pair2.getSecond() : null;
                    if (value != null) {
                        this.addMapping(value, event.getTupleId());
                    }
                } else if (dataChangeEvent instanceof DataChangeEvent.DeleteDataChangeEvent && (old = ((DataChangeEvent.DeleteDataChangeEvent)event).getDeleted().get(this.getDbo().getColumns()[0])) != null) {
                    this.removeMapping(old, event.getTupleId());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            int n;
            int n2;
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                NonUniqueHashIndex.this.getDirtyField().compareAndSet(false, true);
                NonUniqueHashIndex.this.map.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(this, predicate){
                private final BooleanPredicate.Atomic predicate;
                private final LinkedList<Pair<Long, Value>> elements;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                public boolean hasNext() {
                    Collection collection = this.elements;
                    boolean bl = false;
                    return !collection.isEmpty();
                }

                @NotNull
                public Record next() {
                    Pair<Long, Value> next = this.elements.poll();
                    return new StandaloneRecord(((Number)next.getFirst()).longValue(), this.this$0.getDbo().getColumns(), new Value[]{(Value)next.getSecond()});
                }
                {
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    this.elements = new LinkedList<E>();
                    boolean bl = $captured_local_variable$1 instanceof BooleanPredicate.Atomic.Literal;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "NonUniqueHashIndex.filter() does only support Atomic.Literal boolean predicates.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    bl = !((BooleanPredicate.Atomic.Literal)$captured_local_variable$1).getNot();
                    bl2 = false;
                    bl3 = false;
                    if (!bl) {
                        boolean bl5 = false;
                        String string = "NonUniqueHashIndex.filter() does not support negated statements (i.e. NOT EQUALS or NOT IN).";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    this.predicate = (BooleanPredicate.Atomic)$captured_local_variable$1;
                    AbstractTx this_$iv = this$0;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
                    boolean bl6 = false;
                    boolean bl7 = false;
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    readLock.lock();
                    try {
                        Unit unit;
                        Object v;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        ComparisonOperator comparisonOperator = this.predicate.getOperator();
                        if (comparisonOperator instanceof ComparisonOperator.In) {
                            Iterable $this$forEach$iv = ((ComparisonOperator.In)this.predicate.getOperator()).getRight();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                v = (Binding)element$iv;
                                boolean bl10 = false;
                                Value value = (Value)((Binding)v).getValue();
                                long[] subset = (long[])NonUniqueHashIndex.access$getMap$p(this.this$0.NonUniqueHashIndex.this).get((Object)value);
                                if (subset == null) continue;
                                long[] $this$forEach$iv2 = subset;
                                boolean $i$f$forEach2 = false;
                                long[] lArray = $this$forEach$iv2;
                                int n = lArray.length;
                                for (int i = 0; i < n; ++i) {
                                    long element$iv2;
                                    long it = element$iv2 = lArray[i];
                                    boolean bl11 = false;
                                    this.elements.add((Pair<Long, Value>)new Pair((Object)it, (Object)value));
                                }
                            }
                            unit = Unit.INSTANCE;
                        } else if (comparisonOperator instanceof ComparisonOperator.Binary.Equal) {
                            long[] subset;
                            Value value = ((ComparisonOperator.Binary.Equal)this.predicate.getOperator()).getRight().getValue();
                            if (subset != null) {
                                long[] $this$forEach$iv = subset = (long[])NonUniqueHashIndex.access$getMap$p(this.this$0.NonUniqueHashIndex.this).get((Object)value);
                                boolean $i$f$forEach = false;
                                v = $this$forEach$iv;
                                int bl10 = ((Object)v).length;
                                for (int i = 0; i < bl10; ++i) {
                                    Object element$iv;
                                    Object it = element$iv = v[i];
                                    boolean bl12 = false;
                                    this.elements.add((Pair<Long, Value>)new Pair((Object)((long)it), (Object)value));
                                }
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                        } else {
                            if (!(comparisonOperator instanceof ComparisonOperator.Binary.Like)) throw (Throwable)new IllegalArgumentException("NonUniqueHashIndex.filter() does only support EQUAL, IN and LIKE operators.");
                            Value operand = ((ComparisonOperator.Binary.Like)this.predicate.getOperator()).getRight().getValue();
                            if (!(operand instanceof LikePatternValue.StartsWith)) throw (Throwable)new IllegalArgumentException("NonUniqueHashIndex.filter() does only support LIKE operators with prefix matching (i.e. LIKE XYZ%).");
                            ConcurrentNavigableMap prefix = NonUniqueHashIndex.access$getMap$p(this.this$0.NonUniqueHashIndex.this).prefixSubMap((Object)StringValue.box-impl(StringValue.constructor-impl(((Object)((LikePatternValue.StartsWith)operand).getStartsWith()).toString())));
                            v = prefix;
                            boolean bl10 = false;
                            Iterator<Map.Entry<K, V>> iterator2 = v.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                long[] v2;
                                Object object;
                                Object object2 = object = iterator2.next();
                                boolean bl13 = false;
                                v = (Value)object2.getKey();
                                object2 = object;
                                bl13 = false;
                                for (long l : v2 = (long[])object2.getValue()) {
                                    void k;
                                    this.elements.add((Pair<Long, Value>)new Pair((Object)l, (Object)k));
                                }
                            }
                            unit = Unit.INSTANCE;
                        }
                        Unit unit2 = unit;
                        return;
                    }
                    finally {
                        readLock.unlock();
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw (Throwable)new UnsupportedOperationException("The NonUniqueHashIndex does not support ranged filtering!");
        }

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.snapshot = new TxSnapshot(this){
                @NotNull
                private final List<TxAction> actions;
                final /* synthetic */ Tx this$0;

                @NotNull
                public List<TxAction> getActions() {
                    return this.actions;
                }

                public void commit() {
                    Map map2 = (Map)Tx.access$getMappingsCache$p(this.this$0);
                    boolean bl = false;
                    for (Map.Entry<K, V> c : map2.entrySet()) {
                        NonUniqueHashIndex.access$getMap$p(this.this$0.NonUniqueHashIndex.this).compute(c.getKey(), (BiFunction)new BiFunction<Value, long[], long[]>(c){
                            final /* synthetic */ Map.Entry $c;

                            @Nullable
                            public final long[] apply(Value $noName_0, @Nullable long[] v) {
                                long[] lArray;
                                if (v == null) {
                                    V v2 = this.$c.getValue();
                                    Intrinsics.checkNotNullExpressionValue(v2, (String)"c.value");
                                    lArray = CollectionsKt.toLongArray((Collection)((Collection)v2));
                                } else {
                                    V v3 = this.$c.getValue();
                                    Intrinsics.checkNotNullExpressionValue(v3, (String)"c.value");
                                    lArray = ArraysKt.plus((long[])v, (long[])CollectionsKt.toLongArray((Collection)((Collection)v3)));
                                }
                                return lArray;
                            }
                            {
                                this.$c = entry;
                            }
                        });
                    }
                    NonUniqueHashIndex.access$getStore$p(this.this$0.NonUniqueHashIndex.this).commit();
                }

                public void rollback() {
                    Tx.access$getMappingsCache$p(this.this$0).clear();
                    NonUniqueHashIndex.access$getStore$p(this.this$0.NonUniqueHashIndex.this).rollback();
                }

                public boolean record(@NotNull TxAction action) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    return false;
                }
                {
                    this.this$0 = this$0;
                    this.actions = CollectionsKt.emptyList();
                }
            };
            this.mappingsCache = new Object2ObjectOpenHashMap();
        }

        public static final /* synthetic */ Object access$withReadLock(Tx $this, Function0 block) {
            return $this.withReadLock(block);
        }

        public static final /* synthetic */ Object2ObjectOpenHashMap access$getMappingsCache$p(Tx $this) {
            return $this.mappingsCache;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/NonUniqueHashIndex$Companion;", "", "()V", "NUQ_INDEX_MAP", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

