/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.planning.nodes.physical.sources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.queries.OperatorNode;
import org.vitrivr.cottontail.database.queries.QueryContext;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.NullaryPhysicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.sources.RangedEntityScanPhysicalOperatorNode;
import org.vitrivr.cottontail.database.statistics.entity.RecordStatistics;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.operators.sources.EntityScanOperator;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u0001:\u0001;B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\b\u0010+\u001a\u00020\u0000H\u0016J\u0013\u0010,\u001a\u00020\r2\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\b\u0010/\u001a\u00020\u0003H\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u001eH\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001cR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006<"}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/sources/RangedEntityScanPhysicalOperatorNode;", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/NullaryPhysicalOperatorNode;", "groupId", "", "entity", "Lorg/vitrivr/cottontail/database/entity/EntityTx;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "partitionIndex", "partitions", "(ILorg/vitrivr/cottontail/database/entity/EntityTx;[Lorg/vitrivr/cottontail/database/column/ColumnDef;II)V", "canBePartitioned", "", "getCanBePartitioned", "()Z", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "getCost", "()Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "getEntity", "()Lorg/vitrivr/cottontail/database/entity/EntityTx;", "executable", "getExecutable", "getGroupId", "()I", "name", "", "getName", "()Ljava/lang/String;", "outputSize", "", "getOutputSize", "()J", "getPartitionIndex", "getPartitions", "statistics", "Lorg/vitrivr/cottontail/database/statistics/entity/RecordStatistics;", "getStatistics", "()Lorg/vitrivr/cottontail/database/statistics/entity/RecordStatistics;", "copy", "equals", "other", "", "hashCode", "partition", "", "Lorg/vitrivr/cottontail/database/queries/OperatorNode$Physical;", "p", "toOperator", "Lorg/vitrivr/cottontail/execution/operators/sources/EntityScanOperator;", "tx", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "ctx", "Lorg/vitrivr/cottontail/database/queries/QueryContext;", "toString", "Companion", "cottontaildb"})
public final class RangedEntityScanPhysicalOperatorNode
extends NullaryPhysicalOperatorNode {
    private final long outputSize;
    @NotNull
    private final RecordStatistics statistics;
    private final boolean executable;
    private final boolean canBePartitioned;
    @NotNull
    private final Cost cost;
    private final int groupId;
    @NotNull
    private final EntityTx entity;
    @NotNull
    private final ColumnDef<?>[] columns;
    private final int partitionIndex;
    private final int partitions;
    private static final String NODE_NAME = "ScanEntity";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        return NODE_NAME;
    }

    @Override
    public long getOutputSize() {
        return this.outputSize;
    }

    @Override
    @NotNull
    public RecordStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public boolean getExecutable() {
        return this.executable;
    }

    @Override
    public boolean getCanBePartitioned() {
        return this.canBePartitioned;
    }

    @Override
    @NotNull
    public Cost getCost() {
        return this.cost;
    }

    @Override
    @NotNull
    public RangedEntityScanPhysicalOperatorNode copy() {
        return new RangedEntityScanPhysicalOperatorNode(this.getGroupId(), this.entity, this.getColumns(), this.partitionIndex, this.partitions);
    }

    @Override
    @NotNull
    public List<OperatorNode.Physical> partition(int p) {
        throw (Throwable)new UnsupportedOperationException("RangedEntityScanPhysicalOperatorNode cannot be further partitioned.");
    }

    @Override
    @NotNull
    public EntityScanOperator toOperator(@NotNull TransactionContext tx, @NotNull QueryContext ctx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return new EntityScanOperator(this.getGroupId(), this.entity, this.getColumns(), this.partitionIndex, this.partitions);
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + '[' + ArraysKt.joinToString$default((Object[])this.getColumns(), (CharSequence)",", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null) + ',' + this.partitionIndex + '/' + this.partitions + ']';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RangedEntityScanPhysicalOperatorNode)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.entity, (Object)((RangedEntityScanPhysicalOperatorNode)other).entity) ^ true) {
            return false;
        }
        Object[] objectArray = this.getColumns();
        Object[] objectArray2 = ((RangedEntityScanPhysicalOperatorNode)other).getColumns();
        boolean bl = false;
        if (!Arrays.equals(objectArray, objectArray2)) {
            return false;
        }
        if (this.partitionIndex != ((RangedEntityScanPhysicalOperatorNode)other).partitionIndex) {
            return false;
        }
        return this.partitions == ((RangedEntityScanPhysicalOperatorNode)other).partitions;
    }

    public int hashCode() {
        int result = this.entity.hashCode();
        Object[] objectArray = this.getColumns();
        boolean bl = false;
        result = 31 * result + Arrays.hashCode(objectArray);
        result = 31 * result + Integer.hashCode(this.partitionIndex);
        result = 31 * result + Integer.hashCode(this.partitions);
        return result;
    }

    @Override
    public int getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final EntityTx getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public final int getPartitionIndex() {
        return this.partitionIndex;
    }

    public final int getPartitions() {
        return this.partitions;
    }

    /*
     * WARNING - void declaration
     */
    public RangedEntityScanPhysicalOperatorNode(int groupId, @NotNull EntityTx entity, @NotNull ColumnDef<?>[] columns, int partitionIndex, int partitions) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.groupId = groupId;
        this.entity = entity;
        this.columns = columns;
        this.partitionIndex = partitionIndex;
        this.partitions = partitions;
        this.outputSize = Math.floorDiv(this.entity.count(), (long)this.partitions);
        this.statistics = this.entity.getSnapshot().getStatistics();
        this.executable = true;
        ColumnDef<?>[] columnDefArray = this.getColumns();
        Cost cost = new Cost(1.0E-4f, Cost.Companion.getCOST_MEMORY_ACCESS(), 0.0f, 4, null).times(this.getOutputSize());
        RangedEntityScanPhysicalOperatorNode rangedEntityScanPhysicalOperatorNode = this;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var11_19 = $this$mapTo$iv$iv;
        int n = ((void)var11_19).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var15_23 = item$iv$iv = var11_19[i];
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n2 = this.getStatistics().get((ColumnDef<?>)it).getAvgWidth();
            collection.add(n2);
        }
        collection = (List)destination$iv$iv;
        rangedEntityScanPhysicalOperatorNode.cost = cost.times(CollectionsKt.sumOfInt((Iterable)collection));
        boolean bl = this.partitions >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "A range entity scan requires at least one partition in order to be valid.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.partitionIndex < this.partitions;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "The partition index must be smaller than the overall number of partitions.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/sources/RangedEntityScanPhysicalOperatorNode$Companion;", "", "()V", "NODE_NAME", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

