/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import io.grpc.Status;
import io.grpc.StatusException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.queries.binding.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.database.queries.sort.SortOrder;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.execution.operators.definition.CreateEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.CreateIndexOperator;
import org.vitrivr.cottontail.execution.operators.definition.CreateSchemaOperator;
import org.vitrivr.cottontail.execution.operators.definition.DropEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.DropIndexOperator;
import org.vitrivr.cottontail.execution.operators.definition.DropSchemaOperator;
import org.vitrivr.cottontail.execution.operators.definition.EntityDetailsOperator;
import org.vitrivr.cottontail.execution.operators.definition.ListEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.ListSchemaOperator;
import org.vitrivr.cottontail.execution.operators.definition.OptimizeEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.RebuildIndexOperator;
import org.vitrivr.cottontail.execution.operators.definition.TruncateEntityOperator;
import org.vitrivr.cottontail.execution.operators.sort.HeapSortOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DDLGrpcKt;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.server.grpc.services.DDLService;
import org.vitrivr.cottontail.server.grpc.services.gRPCTransactionService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0019\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0019\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020!H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$2\u0006\u0010\u000e\u001a\u00020%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0$2\u0006\u0010\u000e\u001a\u00020'H\u0016J\u0019\u0010(\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020,H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0019\u0010.\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020/H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DDLService;", "Lorg/vitrivr/cottontail/grpc/DDLGrpcKt$DDLCoroutineImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/gRPCTransactionService;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "createEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateIndexMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateIndexMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSchema", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateSchemaMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateSchemaMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropIndexMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropIndexMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropSchema", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropSchemaMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropSchemaMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "entityDetails", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$EntityDetailsMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$EntityDetailsMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listEntities", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ListEntityMessage;", "listSchemas", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ListSchemaMessage;", "optimizeEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$OptimizeEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$OptimizeEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rebuildIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$RebuildIndexMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$RebuildIndexMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "truncateEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TruncateEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TruncateEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cottontaildb"})
@ExperimentalTime
public final class DDLService
extends DDLGrpcKt.DDLCoroutineImplBase
implements gRPCTransactionService {
    @NotNull
    private final DefaultCatalogue catalogue;
    @NotNull
    private final TransactionManager manager;

    @Nullable
    public Object createSchema(@NotNull CottontailGrpc.CreateSchemaMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "CREATE SCHEMA", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.CreateSchemaMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.SchemaName schemaName = this.$request.getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schemaName, (String)"request.schema");
                Name.SchemaName schemaName2 = NameExtensionsKt.fqn(schemaName);
                CreateSchemaOperator op = new CreateSchemaOperator(this.this$0.getCatalogue(), schemaName2);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, schemaName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ createSchema.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.SchemaName $schemaName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaAlreadyExistsException) {
                                    StatusException statusException = Status.ALREADY_EXISTS.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "CREATE SCHEMA failed (" + this.$schemaName + "): Schema with identical name already exists.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.ALREADY_EXISTS.wi\u2026 exists.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$schemaName = schemaName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = createSchemaMessage;
                super(2);
            }
        })), $completion);
    }

    @Nullable
    public Object dropSchema(@NotNull CottontailGrpc.DropSchemaMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "DROP SCHEMA", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.DropSchemaMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.SchemaName schemaName = this.$request.getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schemaName, (String)"request.schema");
                Name.SchemaName schemaName2 = NameExtensionsKt.fqn(schemaName);
                DropSchemaOperator op = new DropSchemaOperator(this.this$0.getCatalogue(), schemaName2);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, schemaName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ dropSchema.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.SchemaName $schemaName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "DROP SCHEMA failed (" + this.$schemaName + "): Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$schemaName = schemaName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = dropSchemaMessage;
                super(2);
            }
        })), $completion);
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listSchemas(@NotNull CottontailGrpc.ListSchemaMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return this.withTransactionContext(transactionId, "LIST SCHEMA", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this){
            final /* synthetic */ DDLService this$0;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                HeapSortOperator op = new HeapSortOperator(new ListSchemaOperator(this.this$0.getCatalogue()), new Pair[]{new Pair(ListSchemaOperator.Companion.getCOLUMNS()[0], (Object)((Object)SortOrder.ASCENDING))}, 100);
                return this.this$0.executeAndMaterialize(tx, op, q, 0);
            }
            {
                this.this$0 = dDLService;
                super(2);
            }
        }));
    }

    @Nullable
    public Object createEntity(@NotNull CottontailGrpc.CreateEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "CREATE ENTITY", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.CreateEntityMessage $request;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.EntityDefinition entityDefinition = this.$request.getDefinition();
                Intrinsics.checkNotNullExpressionValue((Object)entityDefinition, (String)"request.definition");
                CottontailGrpc.EntityName entityName = entityDefinition.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.definition.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                CottontailGrpc.EntityDefinition entityDefinition2 = this.$request.getDefinition();
                Intrinsics.checkNotNullExpressionValue((Object)entityDefinition2, (String)"request.definition");
                List list = entityDefinition2.getColumnsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.definition.columnsList");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CottontailGrpc.ColumnDefinition columnDefinition = (CottontailGrpc.ColumnDefinition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                    Type<?> type = Type.Companion.forName(v4.getType().name(), it.getLength());
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    Name.ColumnName name = entityName2.column(string);
                    Pair pair = TuplesKt.to(new ColumnDef<T>(name, type, it.getNullable(), false, 8, null), (Object)((Object)ColumnEngine.valueOf(it.getEngine().toString())));
                    collection.add(pair);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
                if (pairArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Pair[] columns = pairArray;
                CreateEntityOperator op = new CreateEntityOperator(this.this$0.getCatalogue(), entityName2, columns);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, entityName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ createEntity.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.EntityName $entityName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "CREATE ENTITY failed (" + this.$entityName + "): Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.EntityAlreadyExistsException) {
                                    StatusException statusException = Status.ALREADY_EXISTS.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "CREATE ENTITY failed (" + this.$entityName + "): Entity with identical name already exists.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.ALREADY_EXISTS.wi\u2026 exists.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$entityName = entityName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = createEntityMessage;
                super(2);
            }
        })), $completion);
    }

    @Nullable
    public Object dropEntity(@NotNull CottontailGrpc.DropEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "DROP ENTITY", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.DropEntityMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                DropEntityOperator op = new DropEntityOperator(this.this$0.getCatalogue(), entityName2);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, entityName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ dropEntity.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.EntityName $entityName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "DROP ENTITY failed (" + this.$entityName + "): Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.EntityDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "DROP ENTITY failed (" + this.$entityName + "): Entity does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$entityName = entityName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = dropEntityMessage;
                super(2);
            }
        })), $completion);
    }

    @Nullable
    public Object truncateEntity(@NotNull CottontailGrpc.TruncateEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "TRUNCATE ENTITY", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.TruncateEntityMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                TruncateEntityOperator op = new TruncateEntityOperator(this.this$0.getCatalogue(), entityName2);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, entityName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ truncateEntity.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.EntityName $entityName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "TRUNCATE ENTITY failed (" + this.$entityName + "): Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.EntityDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "TRUNCATE ENTITY failed (" + this.$entityName + "): Entity does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$entityName = entityName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = truncateEntityMessage;
                super(2);
            }
        })), $completion);
    }

    @Nullable
    public Object optimizeEntity(@NotNull CottontailGrpc.OptimizeEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "OPTIMIZE ENTITY", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.OptimizeEntityMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                OptimizeEntityOperator op = new OptimizeEntityOperator(this.this$0.getCatalogue(), entityName2);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, entityName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ optimizeEntity.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.EntityName $entityName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "OPTIMIZE ENTITY failed (" + this.$entityName + "): Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.EntityDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "OPTIMIZE ENTITY failed (" + this.$entityName + "): Entity does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$entityName = entityName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = optimizeEntityMessage;
                super(2);
            }
        })), $completion);
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listEntities(@NotNull CottontailGrpc.ListEntityMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return this.withTransactionContext(transactionId, "LIST ENTITIES", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.ListEntityMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Name.SchemaName schemaName;
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                if (this.$request.hasSchema()) {
                    CottontailGrpc.SchemaName schemaName2 = this.$request.getSchema();
                    Intrinsics.checkNotNullExpressionValue((Object)schemaName2, (String)"request.schema");
                    schemaName = NameExtensionsKt.fqn(schemaName2);
                } else {
                    schemaName = null;
                }
                Name.SchemaName schemaName3 = schemaName;
                HeapSortOperator op = new HeapSortOperator(new ListEntityOperator(this.this$0.getCatalogue(), schemaName3), new Pair[]{new Pair(ListSchemaOperator.Companion.getCOLUMNS()[0], (Object)((Object)SortOrder.ASCENDING))}, 100);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, schemaName3, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ listEntities.1 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.SchemaName $schemaName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "LIST ENTITIES failed (" + this.$schemaName + "}': Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$schemaName = schemaName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = listEntityMessage;
                super(2);
            }
        }));
    }

    @Nullable
    public Object entityDetails(@NotNull CottontailGrpc.EntityDetailsMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "SHOW ENTITY", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.EntityDetailsMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                EntityDetailsOperator op = new EntityDetailsOperator(this.this$0.getCatalogue(), entityName2);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, entityName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ entityDetails.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.EntityName $entityName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "SHOW ENTITY failed (" + this.$entityName + "): Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.EntityDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "SHOW ENTITY failed (" + this.$entityName + "): Entity does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$entityName = entityName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = entityDetailsMessage;
                super(2);
            }
        })), $completion);
    }

    @Nullable
    public Object createIndex(@NotNull CottontailGrpc.CreateIndexMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "CREATE INDEX", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.CreateIndexMessage $request;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.IndexDefinition indexDefinition = this.$request.getDefinition();
                Intrinsics.checkNotNullExpressionValue((Object)indexDefinition, (String)"request.definition");
                CottontailGrpc.IndexName indexName = indexDefinition.getName();
                Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.definition.name");
                Name.IndexName indexName2 = NameExtensionsKt.fqn(indexName);
                CottontailGrpc.IndexDefinition indexDefinition2 = this.$request.getDefinition();
                Intrinsics.checkNotNullExpressionValue((Object)indexDefinition2, (String)"request.definition");
                List list = indexDefinition2.getColumnsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.definition.columnsList");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CottontailGrpc.ColumnName columnName = (CottontailGrpc.ColumnName)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Name.EntityName entityName = indexName2.entity();
                    void v5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
                    String string = v5.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    Name.ColumnName columnName2 = entityName.column(string);
                    collection.add(columnName2);
                }
                List columns = (List)destination$iv$iv;
                CottontailGrpc.IndexDefinition indexDefinition3 = this.$request.getDefinition();
                Intrinsics.checkNotNullExpressionValue((Object)indexDefinition3, (String)"request.definition");
                IndexType indexType = IndexType.valueOf(indexDefinition3.getType().toString());
                CottontailGrpc.IndexDefinition indexDefinition4 = this.$request.getDefinition();
                Intrinsics.checkNotNullExpressionValue((Object)indexDefinition4, (String)"request.definition");
                Map params = indexDefinition4.getParamsMap();
                DefaultCatalogue defaultCatalogue = this.this$0.getCatalogue();
                Map map2 = params;
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"params");
                CreateIndexOperator op = new CreateIndexOperator(defaultCatalogue, indexName2, indexType, columns, map2, this.$request.getRebuild());
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, indexName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ createIndex.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.IndexName $indexName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "CREATE INDEX failed (" + this.$indexName + "): Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.EntityDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "CREATE INDEX failed (" + this.$indexName + "): Entity does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.ColumnDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "CREATE INDEX failed (" + this.$indexName + "): Column does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.IndexAlreadyExistsException) {
                                    StatusException statusException = Status.ALREADY_EXISTS.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "CREATE INDEX failed (" + this.$indexName + "): Index with identical name does already exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.ALREADY_EXISTS.wi\u2026y exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$indexName = indexName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = createIndexMessage;
                super(2);
            }
        })), $completion);
    }

    @Nullable
    public Object dropIndex(@NotNull CottontailGrpc.DropIndexMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "DROP INDEX", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.DropIndexMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.IndexName indexName = this.$request.getIndex();
                Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                Name.IndexName indexName2 = NameExtensionsKt.fqn(indexName);
                DropIndexOperator op = new DropIndexOperator(this.this$0.getCatalogue(), indexName2);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, indexName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ dropIndex.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.IndexName $indexName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "DROP INDEX failed (" + this.$indexName + "): Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.EntityDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "DROP INDEX failed (" + this.$indexName + "): Entity does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.IndexDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "DROP INDEX failed (" + this.$indexName + "): Index does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$indexName = indexName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = dropIndexMessage;
                super(2);
            }
        })), $completion);
    }

    @Nullable
    public Object rebuildIndex(@NotNull CottontailGrpc.RebuildIndexMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return FlowKt.single(this.withTransactionContext(transactionId, "REBUILD INDEX", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DDLService this$0;
            final /* synthetic */ CottontailGrpc.RebuildIndexMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                CottontailGrpc.IndexName indexName = this.$request.getIndex();
                Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                Name.IndexName indexName2 = NameExtensionsKt.fqn(indexName);
                RebuildIndexOperator op = new RebuildIndexOperator(this.this$0.getCatalogue(), indexName2);
                return FlowKt.catch(this.this$0.executeAndMaterialize(tx, op, q, 0), (Function3)((Function3)new Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object>(this, tx, q, indexName2, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ rebuildIndex.2 this$0;
                    final /* synthetic */ TransactionManager.Transaction $tx;
                    final /* synthetic */ String $q;
                    final /* synthetic */ Name.IndexName $indexName;

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable;
                                Throwable e;
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable2 = e = (Throwable)this.L$0;
                                if (throwable2 instanceof DatabaseException.SchemaDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "REBUILD INDEX failed (" + this.$indexName + "): Schema does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.EntityDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "REBUILD INDEX failed (" + this.$indexName + "): Entity does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else if (throwable2 instanceof DatabaseException.IndexDoesNotExistException) {
                                    StatusException statusException = Status.NOT_FOUND.withDescription(this.this$0.this$0.formatMessage(this.$tx, this.$q, "REBUILD INDEX failed (" + this.$indexName + "): Index does not exist.")).asException();
                                    Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.NOT_FOUND.withDes\u2026t exist.\")).asException()");
                                    throwable = (Throwable)statusException;
                                } else {
                                    void var2_3;
                                    throwable = var2_3;
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tx = transaction;
                        this.$q = string;
                        this.$indexName = indexName;
                        super(3, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull FlowCollector<? super CottontailGrpc.QueryResponseMessage> $this$create, @NotNull Throwable e, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                        Function3<FlowCollector<? super CottontailGrpc.QueryResponseMessage>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function3.L$0 = e;
                        return function3;
                    }

                    public final Object invoke(Object object, Object object2, Object object3) {
                        return (this.create((FlowCollector<? super CottontailGrpc.QueryResponseMessage>)((FlowCollector)object), (Throwable)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            {
                this.this$0 = dDLService;
                this.$request = rebuildIndexMessage;
                super(2);
            }
        })), $completion);
    }

    @NotNull
    public final DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    public DDLService(@NotNull DefaultCatalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(null, 1, null);
        this.catalogue = catalogue;
        this.manager = manager;
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> withTransactionContext(@NotNull CottontailGrpc.TransactionId txId, @NotNull String description, @NotNull Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>> action) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return gRPCTransactionService.DefaultImpls.withTransactionContext(this, txId, description, action);
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> executeAndMaterialize(@NotNull TransactionManager.Transaction tx, @NotNull Operator operator, @NotNull String queryId, int queryIndex) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        return gRPCTransactionService.DefaultImpls.executeAndMaterialize(this, tx, operator, queryId, queryIndex);
    }

    @Override
    @NotNull
    public CottontailGrpc.QueryResponseMessage.Tuple toTuple(@NotNull Record $this$toTuple) {
        Intrinsics.checkNotNullParameter((Object)$this$toTuple, (String)"$this$toTuple");
        return gRPCTransactionService.DefaultImpls.toTuple(this, $this$toTuple);
    }

    @Override
    @NotNull
    public String formatMessage(@NotNull TransactionManager.Transaction tx, @NotNull String queryId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return gRPCTransactionService.DefaultImpls.formatMessage(this, tx, queryId, message);
    }
}

