/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.queries.OperatorNode;
import org.vitrivr.cottontail.database.queries.QueryContext;
import org.vitrivr.cottontail.database.queries.binding.GrpcQueryBinder;
import org.vitrivr.cottontail.database.queries.planning.CottontailQueryPlanner;
import org.vitrivr.cottontail.database.queries.planning.rules.RewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.DeferFetchOnFetchRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.DeferFetchOnScanRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.LeftConjunctionOnSubselectRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.LeftConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.RightConjunctionOnSubselectRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.RightConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.BooleanIndexScanRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.KnnIndexScanRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.merge.LimitingSortMergeRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.pushdown.CountPushdownRule;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.execution.operators.system.ExplainQueryOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DQLGrpcKt;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.server.grpc.services.gRPCTransactionService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DQLService;", "Lorg/vitrivr/cottontail/grpc/DQLGrpcKt$DQLCoroutineImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/gRPCTransactionService;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/database/catalogue/Catalogue;Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "binder", "Lorg/vitrivr/cottontail/database/queries/binding/GrpcQueryBinder;", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "planner", "Lorg/vitrivr/cottontail/database/queries/planning/CottontailQueryPlanner;", "explain", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage;", "ping", "Lcom/google/protobuf/Empty;", "(Lcom/google/protobuf/Empty;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "query", "cottontaildb"})
@ExperimentalTime
public final class DQLService
extends DQLGrpcKt.DQLCoroutineImplBase
implements gRPCTransactionService {
    private final GrpcQueryBinder binder;
    private final CottontailQueryPlanner planner;
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final TransactionManager manager;

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> query(@NotNull CottontailGrpc.QueryMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return this.withTransactionContext(transactionId, "EXECUTE QUERY", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DQLService this$0;
            final /* synthetic */ CottontailGrpc.QueryMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                QueryContext ctx = new QueryContext(tx);
                GrpcQueryBinder grpcQueryBinder = DQLService.access$getBinder$p(this.this$0);
                CottontailGrpc.Query query2 = this.$request.getQuery();
                Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"request.query");
                grpcQueryBinder.bind(query2, ctx);
                CottontailQueryPlanner.planAndSelect$default(DQLService.access$getPlanner$p(this.this$0), ctx, false, false, 6, null);
                return this.this$0.executeAndMaterialize(tx, ctx.toOperatorTree(tx), q, 0);
            }
            {
                this.this$0 = dQLService;
                this.$request = queryMessage;
                super(2);
            }
        }));
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> explain(@NotNull CottontailGrpc.QueryMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        return this.withTransactionContext(transactionId, "EXPLAIN QUERY", (Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>>)((Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this, request){
            final /* synthetic */ DQLService this$0;
            final /* synthetic */ CottontailGrpc.QueryMessage $request;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                QueryContext ctx = new QueryContext(tx);
                GrpcQueryBinder grpcQueryBinder = DQLService.access$getBinder$p(this.this$0);
                CottontailGrpc.Query query2 = this.$request.getQuery();
                Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"request.query");
                grpcQueryBinder.bind(query2, ctx);
                Collection<OperatorNode.Physical> candidates = DQLService.access$getPlanner$p(this.this$0).plan(ctx);
                return this.this$0.executeAndMaterialize(tx, new ExplainQueryOperator(candidates), q, 0);
            }
            {
                this.this$0 = dQLService;
                this.$request = queryMessage;
                super(2);
            }
        }));
    }

    @Nullable
    public Object ping(@NotNull Empty request, @NotNull Continuation<? super Empty> $completion) {
        Empty empty = Empty.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)empty, (String)"Empty.getDefaultInstance()");
        return empty;
    }

    @NotNull
    public final Catalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    public DQLService(@NotNull Catalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(null, 1, null);
        this.catalogue = catalogue;
        this.manager = manager;
        this.binder = new GrpcQueryBinder(this.catalogue);
        this.planner = new CottontailQueryPlanner(CollectionsKt.listOf((Object[])new RewriteRule[]{LeftConjunctionRewriteRule.INSTANCE, RightConjunctionRewriteRule.INSTANCE, LeftConjunctionOnSubselectRewriteRule.INSTANCE, RightConjunctionOnSubselectRewriteRule.INSTANCE, DeferFetchOnScanRewriteRule.INSTANCE, DeferFetchOnFetchRewriteRule.INSTANCE}), CollectionsKt.listOf((Object[])new RewriteRule[]{BooleanIndexScanRule.INSTANCE, KnnIndexScanRule.INSTANCE, CountPushdownRule.INSTANCE, LimitingSortMergeRule.INSTANCE}), this.catalogue.getConfig().getCache().getPlanCacheSize());
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> withTransactionContext(@NotNull CottontailGrpc.TransactionId txId, @NotNull String description, @NotNull Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>> action) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return gRPCTransactionService.DefaultImpls.withTransactionContext(this, txId, description, action);
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> executeAndMaterialize(@NotNull TransactionManager.Transaction tx, @NotNull Operator operator, @NotNull String queryId, int queryIndex) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        return gRPCTransactionService.DefaultImpls.executeAndMaterialize(this, tx, operator, queryId, queryIndex);
    }

    @Override
    @NotNull
    public CottontailGrpc.QueryResponseMessage.Tuple toTuple(@NotNull Record $this$toTuple) {
        Intrinsics.checkNotNullParameter((Object)$this$toTuple, (String)"$this$toTuple");
        return gRPCTransactionService.DefaultImpls.toTuple(this, $this$toTuple);
    }

    @Override
    @NotNull
    public String formatMessage(@NotNull TransactionManager.Transaction tx, @NotNull String queryId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return gRPCTransactionService.DefaultImpls.formatMessage(this, tx, queryId, message);
    }

    public static final /* synthetic */ GrpcQueryBinder access$getBinder$p(DQLService $this) {
        return $this.binder;
    }

    public static final /* synthetic */ CottontailQueryPlanner access$getPlanner$p(DQLService $this) {
        return $this.planner;
    }
}

