/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.entity;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.Placeholder;
import org.vitrivr.cottontail.database.general.PlaceholderType;
import org.vitrivr.cottontail.database.schema.DefaultSchema;
import org.vitrivr.cottontail.database.statistics.entity.EntityStatistics;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00063"}, d2={"Lorg/vitrivr/cottontail/database/entity/PlaceholderEntity;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "Lorg/vitrivr/cottontail/database/general/Placeholder;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/schema/DefaultSchema;", "type", "Lorg/vitrivr/cottontail/database/general/PlaceholderType;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/schema/DefaultSchema;Lorg/vitrivr/cottontail/database/general/PlaceholderType;)V", "closed", "", "getClosed", "()Z", "maxTupleId", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "getMaxTupleId", "()J", "name", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "numberOfColumns", "", "getNumberOfColumns", "()I", "numberOfRows", "getNumberOfRows", "getParent", "()Lorg/vitrivr/cottontail/database/schema/DefaultSchema;", "getPath", "()Ljava/nio/file/Path;", "statistics", "Lorg/vitrivr/cottontail/database/statistics/entity/EntityStatistics;", "getStatistics", "()Lorg/vitrivr/cottontail/database/statistics/entity/EntityStatistics;", "getType", "()Lorg/vitrivr/cottontail/database/general/PlaceholderType;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "initialize", "Lorg/vitrivr/cottontail/database/general/DBO;", "newTx", "Lorg/vitrivr/cottontail/database/entity/EntityTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "cottontaildb"})
public final class PlaceholderEntity
implements Entity,
Placeholder {
    @NotNull
    private final Name.EntityName name;
    @NotNull
    private final EntityStatistics statistics;
    private final int numberOfColumns;
    private final long numberOfRows;
    private final long maxTupleId;
    private final boolean closed;
    @NotNull
    private final Path path;
    @NotNull
    private final DefaultSchema parent;
    @NotNull
    private final PlaceholderType type;

    @Override
    @NotNull
    public Name.EntityName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public EntityStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    @Override
    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public long getMaxTupleId() {
        return this.maxTupleId;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return this.getParent().getVersion();
    }

    @Override
    @NotNull
    public EntityTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        throw (Throwable)new UnsupportedOperationException("Broken entity " + this.getName() + " cannot be used to start a new transaction.");
    }

    @Override
    @NotNull
    public DBO initialize() {
        return new DefaultEntity(this.getPath(), this.getParent());
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public DefaultSchema getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public PlaceholderType getType() {
        return this.type;
    }

    public PlaceholderEntity(@NotNull Path path, @NotNull DefaultSchema parent, @NotNull PlaceholderType type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.path = path;
        this.parent = parent;
        this.type = type;
        this.name = this.getParent().getName().entity(StringsKt.replace$default((String)((Object)this.getPath().getFileName()).toString(), (String)"entity_", (String)"", (boolean)false, (int)4, null));
        this.statistics = new EntityStatistics(0L, 0L, 3, null);
        this.maxTupleId = -1L;
        this.closed = true;
    }

    @Override
    @Nullable
    public DBO tryInitialize() {
        return Placeholder.DefaultImpls.tryInitialize(this);
    }
}

