/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.pq;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SplittableRandom;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.IndexTreeList;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.pq.PQ;
import org.vitrivr.cottontail.database.index.pq.PQIndex;
import org.vitrivr.cottontail.database.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.database.index.pq.PQIndexEntry;
import org.vitrivr.cottontail.database.index.pq.PQLookupTable;
import org.vitrivr.cottontail.database.index.pq.PQSignature;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.knn.KnnPredicate;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.math.knn.basics.DistanceKernel;
import org.vitrivr.cottontail.math.knn.selection.ComparablePair;
import org.vitrivr.cottontail.math.knn.selection.MinHeapSelection;
import org.vitrivr.cottontail.math.knn.selection.MinSingleSelection;
import org.vitrivr.cottontail.math.knn.selection.Selection;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;
import org.vitrivr.cottontail.utilities.math.KnnUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0002*+B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006,"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/PQIndex;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/database/index/pq/PQIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/database/index/pq/PQIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/database/index/pq/PQIndexConfig;", "pqStore", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/index/pq/PQ;", "produces", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "signaturesStore", "Lorg/mapdb/IndexTreeList;", "Lorg/vitrivr/cottontail/database/index/pq/PQIndexEntry;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class PQIndex
extends AbstractIndex {
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final IndexType type;
    @NotNull
    private final PQIndexConfig config;
    private final Atomic.Var<PQ> pqStore;
    private final IndexTreeList<PQIndexEntry> signaturesStore;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    private static final String PQ_INDEX_FIELD = "cdb_pq_real";
    private static final String PQ_INDEX_SIGNATURES_FIELD = "cdb_pq_signatures";
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public PQIndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof KnnPredicate && Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Cost cost;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (predicate instanceof KnnPredicate && Intrinsics.areEqual(((KnnPredicate)predicate).getColumn(), this.getColumns()[0])) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ColumnDef<?>[] columnDefArray = this.getProduces();
            int n = ((KnnPredicate)predicate).getK();
            float f = (float)this.signaturesStore.size() * ((float)4 * Cost.Companion.getCOST_MEMORY_ACCESS() + Cost.Companion.getCOST_FLOP()) + (float)((KnnPredicate)predicate).getK() * predicate.getAtomicCpuCost();
            float f2 = (float)(this.signaturesStore.size() * this.getConfig().getNumSubspaces()) * 1.0E-4f + (float)(((KnnPredicate)predicate).getK() * ((KnnPredicate)predicate).getColumn().getType().getLogicalSize()) * 1.0E-4f;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var7_10 = $this$mapTo$iv$iv;
            int n2 = ((void)var7_10).length;
            for (int i = 0; i < n2; ++i) {
                void it;
                void item$iv$iv;
                void var11_14 = item$iv$iv = var7_10[i];
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n3 = it.getType().getPhysicalSize();
                collection.add(n3);
            }
            collection = (List)destination$iv$iv;
            float f3 = n * CollectionsKt.sumOfInt((Iterable)collection);
            float f4 = f;
            float f5 = f2;
            cost = new Cost(f5, f4, f3);
        } else {
            cost = Cost.Companion.getINVALID();
        }
        return cost;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    public PQIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable PQIndexConfig config) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        this.produces = new ColumnDef[]{KnnUtilities.INSTANCE.distanceColumnDef(this.getParent().getName())};
        this.type = IndexType.PQ;
        this.pqStore = (Atomic.Var)this.getStore().atomicVar(PQ_INDEX_FIELD, (Serializer)PQ.Serializer.INSTANCE).createOrOpen();
        this.signaturesStore = (IndexTreeList)this.getStore().indexTreeList(PQ_INDEX_SIGNATURES_FIELD, (Serializer)PQIndexEntry.Serializer).createOrOpen();
        boolean bl = this.getColumns().length == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "PQIndex only supports indexing a single column.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar("cdb_index_config", (Serializer)PQIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            this.config = config != null ? (config.getNumSubspaces() == -1 || config.getNumSubspaces() % this.getColumns()[0].getType().getLogicalSize() != 0 ? PQIndexConfig.copy$default(config, Companion.defaultNumberOfSubspaces(this.getColumns()[0].getType().getLogicalSize()), 0, 0, 0L, 14, null) : config) : new PQIndexConfig(10, 500, 5000, System.currentTimeMillis());
            configOnDisk.set((Object)this.getConfig());
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (PQIndexConfig)object;
        }
        this.getStore().commit();
        bl2 = this.getConfig().getNumCentroids() > 0;
        bl3 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl62 = false;
            String string = "PQIndex supports a maximum number of " + this.getConfig().getNumCentroids() + " centroids.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl2 = this.getConfig().getNumCentroids() <= Short.MAX_VALUE;
        bl3 = false;
        bl5 = false;
        bl5 = false;
        boolean bl62 = false;
        if (!bl2) {
            boolean bl7 = false;
            String bl62 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(bl62.toString());
        }
        bl2 = this.getConfig().getNumSubspaces() > 0;
        bl3 = false;
        bl5 = false;
        if (!bl2) {
            boolean bl8 = false;
            String string = "PQIndex requires at least one centroid.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl2 = this.getColumns()[0].getType().getLogicalSize() >= this.getConfig().getNumSubspaces();
        bl3 = false;
        bl5 = false;
        if (!bl2) {
            boolean bl9 = false;
            String string = "Logical size of the column must be greater or equal than the number of subspaces.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.supportsPartitioning = true;
    }

    public /* synthetic */ PQIndex(Path path, DefaultEntity defaultEntity, PQIndexConfig pQIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pQIndexConfig = null;
        }
        this(path, defaultEntity, pQIndexConfig);
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(PQIndex.class);
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/PQIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/pq/PQIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "acquireLearningData", "", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "txn", "Lorg/vitrivr/cottontail/database/entity/EntityTx;", "clear", "", "count", "", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long count() {
            long l;
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                l = PQIndex.this.signaturesStore.size();
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebuild() {
            int n;
            int n2;
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                Companion.getLOGGER().debug("Rebuilding PQ index {}", (Object)PQIndex.this.getName());
                org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
                if (tx == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
                }
                EntityTx txn = (EntityTx)tx;
                List<VectorValue<?>> data = this.acquireLearningData(txn);
                PQ pq = PQ.Companion.fromData(PQIndex.this.getConfig(), PQIndex.this.getColumns()[0], data);
                Object2ObjectOpenHashMap signatureMap = new Object2ObjectOpenHashMap((int)txn.count());
                Iterator<Record> $this$forEach$iv = txn.scan(this.getDbo().getColumns());
                boolean $i$f$forEach = false;
                Iterator<Record> iterator2 = $this$forEach$iv;
                boolean bl6 = false;
                Iterator<Record> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Record element$iv;
                    Record rec = element$iv = iterator3.next();
                    boolean bl7 = false;
                    Value value = rec.get(PQIndex.this.getColumns()[0]);
                    if (!(value instanceof VectorValue)) continue;
                    PQSignature sig = pq.getSignature((VectorValue)value);
                    signatureMap.compute((Object)sig, (BiFunction)new BiFunction<PQSignature, LinkedList<Long>, LinkedList<Long>>(rec){
                        final /* synthetic */ Record $rec;

                        /*
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final LinkedList<Long> apply(PQSignature $noName_0, @Nullable LinkedList<Long> v) {
                            void var3_3;
                            LinkedList<Long> linkedList = v;
                            if (linkedList == null) {
                                linkedList = new LinkedList<Long>();
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"v ?: LinkedList<TupleId>()");
                            LinkedList<Long> ret = linkedList;
                            ret.add(this.$rec.getTupleId());
                            return var3_3;
                        }
                        {
                            this.$rec = record;
                        }
                    });
                }
                PQIndex.this.pqStore.set((Object)pq);
                PQIndex.this.signaturesStore.clear();
                for (Map.Entry entry : (ObjectSet)signatureMap.entrySet()) {
                    IndexTreeList indexTreeList = PQIndex.this.signaturesStore;
                    Object k = entry.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                    PQSignature pQSignature = (PQSignature)k;
                    Object v = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
                    indexTreeList.add((Object)new PQIndexEntry(pQSignature, CollectionsKt.toLongArray((Collection)((Collection)v))));
                }
                PQIndex.this.getDirtyField().compareAndSet(true, false);
                Companion.getLOGGER().debug("Rebuilding PQIndex {} complete.", (Object)PQIndex.this.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl8 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NotNull DataChangeEvent event) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                PQIndex.this.getDirtyField().compareAndSet(false, true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            int n;
            int n2;
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                PQIndex.this.getDirtyField().compareAndSet(false, true);
                PQIndex.this.signaturesStore.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return this.filterRange(predicate, 0, 1);
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(this, predicate, partitions, partitionIndex){
                private final KnnPredicate predicate;
                private final VectorValue<?> query;
                private final PQ pq;
                private final double[][] lookupTable;
                private final Lazy resultsQueue$delegate;
                private final IntRange range;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ int $partitions;
                final /* synthetic */ int $partitionIndex;

                private final ArrayDeque<StandaloneRecord> getResultsQueue() {
                    Lazy lazy = this.resultsQueue$delegate;
                    filterRange.1 var2_2 = this;
                    Object var3_3 = null;
                    boolean bl = false;
                    return (ArrayDeque)lazy.getValue();
                }

                public boolean hasNext() {
                    Collection collection = (Collection)this.getResultsQueue();
                    boolean bl = false;
                    return !collection.isEmpty();
                }

                @NotNull
                public Record next() {
                    return (Record)this.getResultsQueue().removeFirst();
                }

                /*
                 * WARNING - void declaration
                 */
                private final ArrayDeque<StandaloneRecord> prepareResults() {
                    MinHeapSelection<Comparable> preKnn;
                    EntityTx txn;
                    block10: {
                        int n;
                        org.vitrivr.cottontail.database.general.Tx tx = this.this$0.getContext().getTx(this.this$0.PQIndex.this.getParent());
                        if (tx == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
                        }
                        txn = (EntityTx)tx;
                        int preKnnSize = (int)((double)this.predicate.getK() * 1.15);
                        preKnn = new MinHeapSelection<Comparable>(preKnnSize);
                        IntRange intRange = this.range;
                        int n2 = intRange.getFirst();
                        if (n2 > (n = intRange.getLast())) break block10;
                        while (true) {
                            void i;
                            block12: {
                                double approximation;
                                PQIndexEntry entry;
                                block11: {
                                    PQIndexEntry pQIndexEntry = entry = (PQIndexEntry)PQIndex.access$getSignaturesStore$p(this.this$0.PQIndex.this).get((int)i);
                                    Intrinsics.checkNotNull((Object)pQIndexEntry);
                                    approximation = PQLookupTable.approximateDistance-impl(this.lookupTable, pQIndexEntry.getSignature());
                                    if (preKnn.getSize() < this.predicate.getK()) break block11;
                                    T t = preKnn.peek();
                                    Intrinsics.checkNotNull(t);
                                    if (!(((Number)((ComparablePair)t).getSecond()).doubleValue() > approximation)) break block12;
                                }
                                preKnn.offer(new ComparablePair<long[], Comparable>(entry.getTupleIds(), Double.valueOf(approximation)));
                            }
                            if (i == n) break;
                            ++i;
                        }
                    }
                    Selection knn = this.predicate.getK() == 1 ? (Selection)new MinSingleSelection<T>() : (Selection)new MinHeapSelection<T>(this.predicate.getK());
                    DistanceKernel<?> distanceKernel = this.predicate.getDistance().kernelForQuery(this.query);
                    if (distanceKernel == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.math.knn.basics.DistanceKernel<org.vitrivr.cottontail.model.values.types.VectorValue<*>>");
                    }
                    DistanceKernel<?> kernel = distanceKernel;
                    int entry = 0;
                    int approximation = preKnn.getSize();
                    while (entry < approximation) {
                        void j;
                        long[] tupleIds;
                        for (long tupleId : tupleIds = (long[])((ComparablePair)preKnn.get((int)j)).getFirst()) {
                            Value exact = txn.read(tupleId, this.this$0.PQIndex.this.getColumns()).get(this.this$0.PQIndex.this.getColumns()[0]);
                            if (!(exact instanceof VectorValue)) continue;
                            double distance = kernel.invoke-He8yXgM((VectorValue)exact);
                            if (knn.getSize() >= this.predicate.getK()) {
                                T t = knn.peek();
                                Intrinsics.checkNotNull(t);
                                if (DoubleValue.compareTo-impl(((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), DoubleValue.box-impl(distance)) <= 0) continue;
                            }
                            knn.offer((Comparable)new ComparablePair<Long, DoubleValue>(tupleId, DoubleValue.box-impl(distance)));
                        }
                        ++j;
                    }
                    ArrayDeque queue = new ArrayDeque(this.predicate.getK());
                    approximation = 0;
                    int n = knn.getSize();
                    while (approximation < n) {
                        void i;
                        queue.add((Object)new StandaloneRecord(((Number)((ComparablePair)knn.get((int)i)).getFirst()).longValue(), this.this$0.PQIndex.this.getProduces(), new Value[]{(Value)((ComparablePair)knn.get((int)i)).getSecond()}));
                        ++i;
                    }
                    return queue;
                }
                {
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    this.$partitions = $captured_local_variable$2;
                    this.$partitionIndex = $captured_local_variable$3;
                    if (!($captured_local_variable$1 instanceof KnnPredicate)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.PQIndex.this.getName() + "' (PQ Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (KnnPredicate)$captured_local_variable$1;
                    this.pq = (PQ)PQIndex.access$getPqStore$p(this$0.PQIndex.this).get();
                    this.resultsQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayDeque<StandaloneRecord>>(this){
                        final /* synthetic */ filterRange.1 this$0;

                        @NotNull
                        public final ArrayDeque<StandaloneRecord> invoke() {
                            return filterRange.1.access$prepareResults(this.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    AbstractTx this_$iv = this$0;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
                    int n = 0;
                    boolean bl = false;
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    readLock.lock();
                    try {
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    Value value = this.predicate.getQuery().getValue();
                    $i$f$withReadLock = value instanceof VectorValue;
                    int n2 = 0;
                    n = 0;
                    if (!$i$f$withReadLock) {
                        boolean bl4 = false;
                        String string = "Bound value for query vector has wrong type (found = " + value.getType() + ").";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    this.query = (VectorValue)value;
                    this.lookupTable = this.pq.getLookupTable-ngM6xw4(this.query, this.predicate.getDistance());
                    int pSize = Math.floorDiv(PQIndex.access$getSignaturesStore$p(this$0.PQIndex.this).size(), $captured_local_variable$2) + 1;
                    n2 = pSize * ($captured_local_variable$3 + 1);
                    n = PQIndex.access$getSignaturesStore$p(this$0.PQIndex.this).size();
                    boolean bl5 = false;
                    this.range = RangesKt.until((int)(pSize * $captured_local_variable$3), (int)Math.min(n2, n));
                }

                public static final /* synthetic */ ArrayDeque access$prepareResults(filterRange.1 $this) {
                    return $this.prepareResults();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        private final List<VectorValue<?>> acquireLearningData(EntityTx txn) {
            LinkedList<Value> learningData = new LinkedList<Value>();
            SplittableRandom rng = new SplittableRandom(PQIndex.this.getConfig().getSeed());
            double learningDataFraction = (double)PQIndex.this.getConfig().getSampleSize() / (double)txn.count();
            Iterator<Record> $this$forEach$iv = txn.scan(this.getDbo().getColumns());
            boolean $i$f$forEach = false;
            Iterator<Record> iterator2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Record> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Value value;
                Record element$iv;
                Record it = element$iv = iterator3.next();
                boolean bl2 = false;
                if (!(rng.nextDouble() <= learningDataFraction) || !((value = it.get(PQIndex.this.getColumns()[0])) instanceof VectorValue)) continue;
                learningData.add(value);
            }
            return learningData;
        }

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
        }

        public static final /* synthetic */ Object access$withReadLock(Tx $this, Function0 block) {
            return $this.withReadLock(block);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/PQIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "PQ_INDEX_FIELD", "", "PQ_INDEX_SIGNATURES_FIELD", "defaultNumberOfSubspaces", "", "d", "cottontaildb"})
    public static final class Companion {
        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public final int defaultNumberOfSubspaces(int d) {
            int start;
            for (int subspaces = start = d == 1 ? 1 : (d == 2 ? 2 : (d <= 8 ? 4 : (d <= 64 ? 4 : (d <= 256 ? 8 : (d <= 1024 ? 16 : (d <= 4096 ? 32 : 64)))))); subspaces < d && subspaces < 127; ++subspaces) {
                if (d % subspaces != 0) continue;
                return subspaces;
            }
            return start;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

