/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.locking;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.locking.Lock$WhenMappings;
import org.vitrivr.cottontail.database.locking.LockHolder;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.locking.WaitForGraph;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002J\u0016\u0010\u001e\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002J\u0006\u0010\u001f\u001a\u00020\u001cJ\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130!J\u0014\u0010\"\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013J\u0014\u0010#\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/database/locking/Lock;", "T", "", "waitForGraph", "Lorg/vitrivr/cottontail/database/locking/WaitForGraph;", "obj", "(Lorg/vitrivr/cottontail/database/locking/WaitForGraph;Ljava/lang/Object;)V", "isExclusivelyLocked", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isSharedLocked", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getObj", "()Ljava/lang/Object;", "Ljava/lang/Object;", "owners", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lorg/vitrivr/cottontail/database/locking/LockHolder;", "sharedLockCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "waiters", "Ljava/util/concurrent/locks/Condition;", "acquire", "", "txn", "lockMode", "Lorg/vitrivr/cottontail/database/locking/LockMode;", "acquireExclusiveLock", "acquireSharedLock", "getMode", "getOwners", "", "release", "upgrade", "cottontaildb"})
public final class Lock<T> {
    private final ObjectOpenHashSet<LockHolder<T>> owners;
    private final ReentrantReadWriteLock lock;
    private final Condition waiters;
    private final AtomicInteger sharedLockCount;
    private final AtomicBoolean isExclusivelyLocked;
    private final WaitForGraph waitForGraph;
    private final T obj;

    private final boolean isSharedLocked() {
        return this.sharedLockCount.get() > 0;
    }

    public final void acquire(@NotNull LockHolder<T> txn, @NotNull LockMode lockMode) {
        Intrinsics.checkNotNullParameter(txn, (String)"txn");
        Intrinsics.checkNotNullParameter((Object)((Object)lockMode), (String)"lockMode");
        switch (Lock$WhenMappings.$EnumSwitchMapping$0[lockMode.ordinal()]) {
            case 1: {
                this.acquireSharedLock(txn);
                break;
            }
            case 2: {
                this.acquireExclusiveLock(txn);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Lock mode of type UNLOCKED cannot be acquired!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(@NotNull LockHolder<T> txn) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(txn, (String)"txn");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            if (this.owners.remove(txn)) {
                this.waitForGraph.remove(txn);
                this.sharedLockCount.decrementAndGet();
                this.isExclusivelyLocked.compareAndExchange(true, false);
                this.waiters.signalAll();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void upgrade(@NotNull LockHolder<T> txn) {
        boolean bl;
        int n;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter(txn, (String)"txn");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl2 = false;
        boolean bl3 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl4 = false;
        int n5 = 0;
        n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n3 = n5++;
            n2 = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            n = 0;
            bl = this.owners.contains(txn);
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl) {
                boolean bl7 = false;
                String string = "Transaction " + txn.getTxId() + " failed upgrade lock " + this + ": Transaction does not own lock.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (this.isExclusivelyLocked.get()) {
                return;
            }
            while (this.isExclusivelyLocked.get() || this.sharedLockCount.get() > 1) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = (Iterable)this.owners;
                boolean $i$f$filter = false;
                Iterable bl7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LockHolder it = (LockHolder)element$iv$iv;
                    boolean bl8 = false;
                    if (!(Intrinsics.areEqual((Object)it, txn) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                Collection collection = list;
                Set ownersWithSelfRemoved = (Set)new ObjectOpenHashSet(collection);
                this.waitForGraph.add(txn, ownersWithSelfRemoved);
                this.waitForGraph.detectDeadlock(txn);
                this.waiters.await();
            }
            boolean bl9 = this.sharedLockCount.compareAndSet(1, 0);
            boolean bl10 = false;
            bl6 = false;
            if (!bl9) {
                boolean bl11 = false;
                String string = "Transaction " + txn.getTxId() + " failed to upgrade lock " + this + ": expected one shared lock (own).";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl9 = this.isExclusivelyLocked.compareAndSet(false, true);
            bl10 = false;
            bl6 = false;
            if (!bl9) {
                boolean bl12 = false;
                String string = "Transaction " + txn.getTxId() + " failed to upgrade lock " + this + ": non-exclusive lock.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n6 = 0;
            n3 = 0;
            n3 = 0;
            n2 = n4;
            while (n3 < n2) {
                n = n3++;
                bl = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @NotNull
    public final Set<LockHolder<T>> getOwners() {
        Set<LockHolder<T>> set = Collections.unmodifiableSet((Set)this.owners);
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.unmodifiableSet(this.owners)");
        return set;
    }

    @NotNull
    public final LockMode getMode() {
        return this.isExclusivelyLocked.get() ? LockMode.EXCLUSIVE : (this.isSharedLocked() ? LockMode.SHARED : LockMode.NO_LOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean acquireSharedLock(LockHolder<T> txn) {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            while (this.isExclusivelyLocked.get() || this.lock.hasWaiters(this.waiters)) {
                this.waitForGraph.add(txn, (Set)this.owners);
                this.waitForGraph.detectDeadlock(txn);
                this.waiters.await();
            }
            this.sharedLockCount.incrementAndGet();
            n4 = this.owners.add(txn) ? 1 : 0;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return n4 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean acquireExclusiveLock(LockHolder<T> txn) {
        boolean bl;
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl2 = false;
        boolean bl3 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl4 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl5 = false;
            while (this.isExclusivelyLocked.get() || this.isSharedLocked()) {
                this.waitForGraph.add(txn, (Set)this.owners);
                this.waitForGraph.detectDeadlock(txn);
                this.waiters.await();
            }
            bl = this.isExclusivelyLocked.compareAndSet(false, true);
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl) {
                boolean bl8 = false;
                String string = "Transaction " + txn.getTxId() + " failed to acquire lock " + this + ": Lock is being held exclusively.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            n4 = this.owners.add(txn) ? 1 : 0;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                bl = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return n4 != 0;
    }

    public final T getObj() {
        return this.obj;
    }

    public Lock(@NotNull WaitForGraph waitForGraph, T obj) {
        Intrinsics.checkNotNullParameter((Object)waitForGraph, (String)"waitForGraph");
        this.waitForGraph = waitForGraph;
        this.obj = obj;
        this.owners = new ObjectOpenHashSet();
        this.lock = new ReentrantReadWriteLock(true);
        Condition condition = this.lock.writeLock().newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"this.lock.writeLock().newCondition()");
        this.waiters = condition;
        this.sharedLockCount = new AtomicInteger(0);
        this.isExclusivelyLocked = new AtomicBoolean(false);
    }
}

