/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.planning;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.queries.OperatorNode;
import org.vitrivr.cottontail.database.queries.QueryContext;
import org.vitrivr.cottontail.database.queries.planning.CottontailPlanCache;
import org.vitrivr.cottontail.database.queries.planning.MemoizingOperatorList;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.BinaryLogicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.NAryLogicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.NullaryLogicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.UnaryLogicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.BinaryPhysicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.NAryPhysicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.NullaryPhysicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.UnaryPhysicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.rules.RewriteRule;
import org.vitrivr.cottontail.model.exceptions.QueryException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u000b\u001a\u00020\f2\f\b\u0002\u0010\r\u001a\u00060\u0007j\u0002`\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u0010H\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\u0006\u0010\u001a\u001a\u00020\u0017J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00172\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u001eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/CottontailQueryPlanner;", "", "logicalRules", "", "Lorg/vitrivr/cottontail/database/queries/planning/rules/RewriteRule;", "physicalRules", "planCacheSize", "", "(Ljava/util/Collection;Ljava/util/Collection;I)V", "planCache", "Lorg/vitrivr/cottontail/database/queries/planning/CottontailPlanCache;", "compose", "Lorg/vitrivr/cottontail/database/queries/OperatorNode$Physical;", "startGroupId", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "decomposition", "", "decompose", "Lorg/vitrivr/cottontail/database/queries/OperatorNode$Logical;", "operator", "optimizeLogical", "", "ctx", "Lorg/vitrivr/cottontail/database/queries/QueryContext;", "optimizePhysical", "plan", "context", "planAndSelect", "", "bypassCache", "", "cache", "cottontaildb"})
public final class CottontailQueryPlanner {
    private final CottontailPlanCache planCache;
    private final Collection<RewriteRule> logicalRules;
    private final Collection<RewriteRule> physicalRules;

    /*
     * WARNING - void declaration
     */
    public final void planAndSelect(@NotNull QueryContext context2, boolean bypassCache, boolean cache) {
        Object v0;
        void $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        OperatorNode.Logical logical = context2.getLogical();
        boolean bl = logical != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot plan for a QueryContext that doesn't have a valid logical query representation.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long digest = logical.digest();
        if (!bypassCache) {
            context2.setPhysical$cottontaildb(this.planCache.get(digest));
            if (context2.getPhysical() != null) {
                return;
            }
        }
        Collection<OperatorNode.Physical> candidates = this.plan(context2);
        Iterable bl4 = candidates;
        QueryContext queryContext = context2;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                OperatorNode.Physical it = (OperatorNode.Physical)minElem$iv;
                boolean bl5 = false;
                Comparable minValue$iv = it.getTotalCost();
                do {
                    Object e$iv = iterator$iv.next();
                    OperatorNode.Physical it2 = (OperatorNode.Physical)e$iv;
                    $i$a$-minByOrNull-CottontailQueryPlanner$planAndSelect$2 = false;
                    Comparable v$iv = it2.getTotalCost();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Object var17_22 = v0;
        OperatorNode.Physical physical = var17_22;
        if (physical == null) {
            throw (Throwable)new QueryException.QueryPlannerException("Failed to generate a physical execution plan for expression: " + logical + '.');
        }
        queryContext.setPhysical$cottontaildb(physical);
        if (!cache) {
            OperatorNode.Physical physical2 = context2.getPhysical();
            Intrinsics.checkNotNull((Object)physical2);
            this.planCache.set(digest, physical2);
        }
    }

    public static /* synthetic */ void planAndSelect$default(CottontailQueryPlanner cottontailQueryPlanner, QueryContext queryContext, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        cottontailQueryPlanner.planAndSelect(queryContext, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<OperatorNode.Physical> plan(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        OperatorNode.Logical logical = context2.getLogical();
        boolean bl = logical != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            QueryException.QueryPlannerException queryPlannerException = new QueryException.QueryPlannerException("Cannot perform query planning for a QueryContext that doesn't have a logical query plan.");
            throw (Throwable)new IllegalArgumentException(((Object)queryPlannerException).toString());
        }
        Map<Integer, OperatorNode.Logical> decomposition = this.decompose(logical);
        Int2ObjectLinkedOpenHashMap candidates = new Int2ObjectLinkedOpenHashMap();
        Map<Integer, OperatorNode.Logical> map2 = decomposition;
        boolean bl5 = false;
        for (Map.Entry<Integer, OperatorNode.Logical> d : map2.entrySet()) {
            OperatorNode.Physical candidate;
            Object v0;
            void $this$flatMapTo$iv$iv;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.optimizeLogical(d.getValue(), context2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                OperatorNode.Logical logical2 = (OperatorNode.Logical)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                OperatorNode.Physical physical = it.implement();
                collection.add(physical);
            }
            List stage1 = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = stage1;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            item$iv$iv2 = $this$flatMapTo$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                Object element$iv$iv = item$iv$iv2.next();
                OperatorNode.Physical it = (OperatorNode.Physical)element$iv$iv;
                boolean bl7 = false;
                Iterable list$iv$iv = this.optimizePhysical(it, context2);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List stage2 = (List)destination$iv$iv2;
            Iterable $this$minByOrNull$iv = stage2;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    OperatorNode.Physical it = (OperatorNode.Physical)minElem$iv;
                    boolean bl8 = false;
                    Comparable minValue$iv = it.getTotalCost();
                    do {
                        Object e$iv = iterator$iv.next();
                        OperatorNode.Physical it2 = (OperatorNode.Physical)e$iv;
                        $i$a$-minByOrNull-CottontailQueryPlanner$plan$candidate$1 = false;
                        Comparable v$iv = it2.getTotalCost();
                        if (minValue$iv.compareTo(v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            if ((OperatorNode.Physical)v0 == null) {
                throw (Throwable)new QueryException.QueryPlannerException("Failed to generate a physical execution plan for expression: " + logical + '.');
            }
            ((Map)candidates).put(d.getKey(), candidate);
        }
        return CollectionsKt.listOf((Object)this.compose(0, (Map)candidates));
    }

    private final Map<Integer, OperatorNode.Logical> decompose(OperatorNode.Logical operator) {
        Int2ObjectLinkedOpenHashMap decomposition = new Int2ObjectLinkedOpenHashMap();
        ((Map)decomposition).put(operator.getGroupId(), operator.copyWithGroupInputs());
        OperatorNode.Logical next = operator;
        OperatorNode.Logical prev = null;
        while (next != null) {
            prev = next;
            OperatorNode.Logical logical = next;
            if (logical instanceof NullaryLogicalOperatorNode) {
                return (Map)decomposition;
            }
            if (logical instanceof UnaryLogicalOperatorNode) {
                next = ((UnaryLogicalOperatorNode)next).getInput();
                continue;
            }
            if (logical instanceof BinaryLogicalOperatorNode) {
                if (((BinaryLogicalOperatorNode)next).getRight() != null) {
                    OperatorNode.Logical logical2 = ((BinaryLogicalOperatorNode)next).getRight();
                    Intrinsics.checkNotNull((Object)logical2);
                    decomposition.putAll(this.decompose(logical2));
                }
                next = ((BinaryLogicalOperatorNode)next).getLeft();
                continue;
            }
            if (!(logical instanceof NAryLogicalOperatorNode)) continue;
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)((NAryLogicalOperatorNode)next).getInputs(), (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OperatorNode.Logical it = (OperatorNode.Logical)element$iv;
                boolean bl = false;
                decomposition.putAll(this.decompose(it));
            }
            next = (OperatorNode.Logical)CollectionsKt.first(((NAryLogicalOperatorNode)next).getInputs());
        }
        throw (Throwable)new IllegalStateException("Tree decomposition failed. Encountered null node while scanning tree (node = " + prev + "). This is a programmer's error!");
    }

    private final OperatorNode.Physical compose(int startGroupId, Map<Integer, ? extends OperatorNode.Physical> decomposition) {
        OperatorNode.Physical main;
        OperatorNode.Physical physical = decomposition.get(startGroupId);
        if (physical == null) {
            throw (Throwable)new IllegalStateException("Tree composition failed. No entry for desired groupId " + startGroupId + '.');
        }
        OperatorNode.Physical next = main = physical;
        OperatorNode.Physical prev = null;
        while (next != null) {
            prev = next;
            OperatorNode.Physical physical2 = next;
            if (physical2 instanceof NullaryPhysicalOperatorNode) {
                return main;
            }
            if (physical2 instanceof UnaryPhysicalOperatorNode) {
                next = ((UnaryPhysicalOperatorNode)next).getInput();
                continue;
            }
            if (physical2 instanceof BinaryPhysicalOperatorNode) {
                ((BinaryPhysicalOperatorNode)next).setRight(this.compose(startGroupId + 1, decomposition));
                next = ((BinaryPhysicalOperatorNode)next).getLeft();
                continue;
            }
            if (!(physical2 instanceof NAryPhysicalOperatorNode)) continue;
            int n = next.getInputArity() - 1;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                OperatorNode.Physical physical3 = next;
                if (physical3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.queries.planning.nodes.physical.NAryPhysicalOperatorNode");
                }
                ((NAryPhysicalOperatorNode)physical3).addInput(this.compose(startGroupId + it + 1, decomposition));
            }
            next = (OperatorNode.Physical)CollectionsKt.first(((NAryPhysicalOperatorNode)next).getInputs());
        }
        throw (Throwable)new IllegalStateException("Tree composition failed. Encountered null node while scanning tree (node = " + prev + "). This is a programmer's error!");
    }

    static /* synthetic */ OperatorNode.Physical compose$default(CottontailQueryPlanner cottontailQueryPlanner, int n, Map map2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return cottontailQueryPlanner.compose(n, map2);
    }

    private final List<OperatorNode.Logical> optimizeLogical(OperatorNode.Logical operator, QueryContext ctx) {
        MemoizingOperatorList candidates = new MemoizingOperatorList((OperatorNode[])new OperatorNode.Logical[]{operator});
        MemoizingOperatorList explore = new MemoizingOperatorList((OperatorNode[])new OperatorNode.Logical[]{operator});
        OperatorNode.Logical pointer = (OperatorNode.Logical)explore.dequeue();
        while (pointer != null) {
            for (RewriteRule rule : this.logicalRules) {
                OperatorNode result = rule.apply(pointer, ctx);
                if (!(result instanceof OperatorNode.Logical)) continue;
                MemoizingOperatorList.enqueue$default(explore, result, false, 2, null);
                MemoizingOperatorList.enqueue$default(candidates, result, false, 2, null);
            }
            OperatorNode.Logical logical = pointer;
            if (logical instanceof NAryLogicalOperatorNode) {
                OperatorNode.Logical logical2 = (OperatorNode.Logical)CollectionsKt.firstOrNull(((NAryLogicalOperatorNode)pointer).getInputs());
                if (logical2 == null) {
                    throw (Throwable)new IllegalStateException("Encountered null node in logical operator node tree (node = " + pointer + "). This is a programmer's error!");
                }
                MemoizingOperatorList.enqueue$default(explore, logical2, false, 2, null);
            } else if (logical instanceof BinaryLogicalOperatorNode) {
                OperatorNode.Logical logical3 = ((BinaryLogicalOperatorNode)pointer).getLeft();
                if (logical3 == null) {
                    throw (Throwable)new IllegalStateException("Encountered null node in logical operator node tree (node = " + pointer + "). This is a programmer's error!");
                }
                MemoizingOperatorList.enqueue$default(explore, logical3, false, 2, null);
            } else if (logical instanceof UnaryLogicalOperatorNode) {
                OperatorNode.Logical logical4 = ((UnaryLogicalOperatorNode)pointer).getInput();
                if (logical4 == null) {
                    throw (Throwable)new IllegalStateException("EEncountered null node in logical operator node tree (node = " + pointer + "). This is a programmer's error!");
                }
                MemoizingOperatorList.enqueue$default(explore, logical4, false, 2, null);
            } else if (logical instanceof OperatorNode.Physical) {
                throw (Throwable)new IllegalStateException("Encountered physical operator node in logical operator node tree. This is a programmer's error!");
            }
            pointer = (OperatorNode.Logical)explore.dequeue();
        }
        return candidates.toList();
    }

    private final List<OperatorNode.Physical> optimizePhysical(OperatorNode.Physical operator, QueryContext ctx) {
        MemoizingOperatorList candidates = new MemoizingOperatorList((OperatorNode[])new OperatorNode.Physical[]{operator.getRoot()});
        MemoizingOperatorList explore = new MemoizingOperatorList((OperatorNode[])new OperatorNode.Physical[]{operator.getRoot()});
        OperatorNode.Physical pointer = (OperatorNode.Physical)explore.dequeue();
        while (pointer != null) {
            for (RewriteRule rule : this.physicalRules) {
                OperatorNode result = rule.apply(pointer, ctx);
                if (!(result instanceof OperatorNode.Physical)) continue;
                MemoizingOperatorList.enqueue$default(explore, result, false, 2, null);
                MemoizingOperatorList.enqueue$default(candidates, result, false, 2, null);
            }
            OperatorNode.Physical physical = pointer;
            if (physical instanceof NAryPhysicalOperatorNode) {
                OperatorNode.Physical physical2 = (OperatorNode.Physical)CollectionsKt.firstOrNull(((NAryPhysicalOperatorNode)pointer).getInputs());
                if (physical2 == null) {
                    throw (Throwable)new IllegalStateException("Encountered null node in physical operator node tree (node = " + pointer + "). This is a programmer's error!");
                }
                MemoizingOperatorList.enqueue$default(explore, physical2, false, 2, null);
            } else if (physical instanceof BinaryPhysicalOperatorNode) {
                OperatorNode.Physical physical3 = ((BinaryPhysicalOperatorNode)pointer).getLeft();
                if (physical3 == null) {
                    throw (Throwable)new IllegalStateException("Encountered null node in physical operator node tree (node = " + pointer + "). This is a programmer's error!");
                }
                MemoizingOperatorList.enqueue$default(explore, physical3, false, 2, null);
            } else if (physical instanceof UnaryPhysicalOperatorNode) {
                OperatorNode.Physical physical4 = ((UnaryPhysicalOperatorNode)pointer).getInput();
                if (physical4 == null) {
                    throw (Throwable)new IllegalStateException("Encountered null node in physical operator node tree (node = " + pointer + "). This is a programmer's error!");
                }
                MemoizingOperatorList.enqueue$default(explore, physical4, false, 2, null);
            } else if (physical instanceof OperatorNode.Logical) {
                throw (Throwable)new IllegalStateException("Encountered logical operator node in physical operator node tree. This is a programmer's error!");
            }
            pointer = (OperatorNode.Physical)explore.dequeue();
        }
        return candidates.toList();
    }

    public CottontailQueryPlanner(@NotNull Collection<? extends RewriteRule> logicalRules, @NotNull Collection<? extends RewriteRule> physicalRules, int planCacheSize) {
        Intrinsics.checkNotNullParameter(logicalRules, (String)"logicalRules");
        Intrinsics.checkNotNullParameter(physicalRules, (String)"physicalRules");
        this.logicalRules = logicalRules;
        this.physicalRules = physicalRules;
        this.planCache = new CottontailPlanCache(planCacheSize);
    }

    public /* synthetic */ CottontailQueryPlanner(Collection collection, Collection collection2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        this(collection, collection2, n);
    }
}

