/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.statistics.columns;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.database.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.FloatValue;
import org.vitrivr.cottontail.model.values.types.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0000H\u0016J\u001d\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\tR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/database/statistics/columns/FloatValueStatistics;", "Lorg/vitrivr/cottontail/database/statistics/columns/ValueStatistics;", "Lorg/vitrivr/cottontail/model/values/FloatValue;", "()V", "max", "", "getMax", "()F", "setMax", "(F)V", "mean", "getMean", "min", "getMin", "setMin", "sum", "getSum", "setSum", "copy", "delete", "", "deleted", "delete-Cx6tYAc", "insert", "inserted", "insert-Cx6tYAc", "reset", "Serializer", "cottontaildb"})
public final class FloatValueStatistics
extends ValueStatistics<FloatValue> {
    private float min = Float.MAX_VALUE;
    private float max = Float.MIN_VALUE;
    private float sum;
    @NotNull
    public static final Serializer Serializer = new Serializer(null);

    public final float getMin() {
        return this.min;
    }

    public final void setMin(float f) {
        this.min = f;
    }

    public final float getMax() {
        return this.max;
    }

    public final void setMax(float f) {
        this.max = f;
    }

    public final float getSum() {
        return this.sum;
    }

    public final void setSum(float f) {
        this.sum = f;
    }

    public final float getMean() {
        return this.sum / (float)this.getNumberOfNonNullEntries();
    }

    public void insert-Cx6tYAc(@Nullable FloatValue inserted) {
        super.insert((Value)inserted);
        if (inserted != null) {
            this.min = Float.min(inserted.unbox-impl(), this.min);
            this.max = Float.max(inserted.unbox-impl(), this.max);
            this.sum += inserted.unbox-impl();
        }
    }

    public void delete-Cx6tYAc(@Nullable FloatValue deleted) {
        super.delete((Value)deleted);
        if (deleted != null) {
            this.sum -= deleted.unbox-impl();
            if (this.min == deleted.unbox-impl() || this.max == deleted.unbox-impl()) {
                this.setFresh(false);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.min = Float.MAX_VALUE;
        this.max = Float.MIN_VALUE;
        this.sum = 0.0f;
    }

    @NotNull
    public FloatValueStatistics copy() {
        FloatValueStatistics copy = new FloatValueStatistics();
        copy.setFresh(this.getFresh());
        copy.setNumberOfNullEntries(this.getNumberOfNullEntries());
        copy.setNumberOfNonNullEntries(this.getNumberOfNonNullEntries());
        copy.min = this.min;
        copy.max = this.max;
        copy.sum = this.sum;
        return copy;
    }

    public FloatValueStatistics() {
        super(Type.Float.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/statistics/columns/FloatValueStatistics$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/statistics/columns/FloatValueStatistics;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
    public static final class Serializer
    implements org.mapdb.Serializer<FloatValueStatistics> {
        public void serialize(@NotNull DataOutput2 out, @NotNull FloatValueStatistics value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.writeFloat(value.getMin());
            out.writeFloat(value.getMax());
            out.writeFloat(value.getSum());
        }

        @NotNull
        public FloatValueStatistics deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            FloatValueStatistics stat = new FloatValueStatistics();
            stat.setMin(input.readFloat());
            stat.setMax(input.readFloat());
            stat.setSum(input.readFloat());
            return stat;
        }

        private Serializer() {
        }

        public /* synthetic */ Serializer(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

