/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.math.knn.kernels.binary.plain;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.math.knn.basics.DistanceKernel;
import org.vitrivr.cottontail.math.knn.kernels.KernelNotFoundException;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.model.values.IntVectorValue;
import org.vitrivr.cottontail.model.values.LongVectorValue;
import org.vitrivr.cottontail.model.values.types.RealVectorValue;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u0013*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0005\u0013\u0014\u0015\u0016\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0004R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0004\u0018\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel;", "T", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "Lorg/vitrivr/cottontail/math/knn/basics/DistanceKernel;", "query", "(Lorg/vitrivr/cottontail/model/values/types/VectorValue;)V", "cost", "", "getCost", "()F", "getQuery", "()Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "haversine", "", "aLat", "aLon", "bLat", "bLon", "Companion", "DoubleVector", "FloatVector", "IntVector", "LongVector", "Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel$DoubleVector;", "Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel$FloatVector;", "Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel$LongVector;", "Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel$IntVector;", "cottontaildb"})
public abstract class HaversineKernel<T extends VectorValue<?>>
implements DistanceKernel<T> {
    @NotNull
    private final T query;
    public static final double RADIUS_EARTH = 6371000.0;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public float getCost() {
        return (float)this.getD() * 2.0f * Cost.Companion.getCOST_MEMORY_ACCESS() + 27.0f * Cost.Companion.getCOST_FLOP() + 20.0f * Cost.Companion.getCOST_MEMORY_ACCESS();
    }

    protected final double haversine(double aLat, double aLon, double bLat, double bLon) {
        double phi1 = StrictMath.toRadians(aLat);
        double phi2 = StrictMath.toRadians(bLat);
        double deltaPhi = StrictMath.toRadians(bLat - aLat);
        double deltaLambda = StrictMath.toRadians(bLon - aLon);
        double d = deltaPhi / 2.0;
        boolean bl = false;
        double d2 = Math.sin(d);
        d = deltaPhi / 2.0;
        bl = false;
        boolean bl2 = false;
        bl2 = false;
        double d3 = deltaLambda / 2.0;
        bl = false;
        double d4 = Math.cos(phi1) * Math.cos(phi2) * Math.sin(d3);
        d3 = deltaLambda / 2.0;
        bl = false;
        double c = d2 * Math.sin(d) + d4 * Math.sin(d3);
        bl = false;
        double d5 = Math.sqrt(c);
        double d6 = 1.0 - c;
        boolean bl3 = false;
        d6 = Math.sqrt(d6);
        bl3 = false;
        double d7 = 2.0 * Math.atan2(d5, d6);
        return 6371000.0 * d7;
    }

    @Override
    @NotNull
    public final T getQuery() {
        return this.query;
    }

    private HaversineKernel(T query2) {
        this.query = query2;
        boolean bl = this.query.getLogicalSize() == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Haversine distance can only be calculated for 2D vectors.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public int getD() {
        return DistanceKernel.DefaultImpls.getD(this);
    }

    public /* synthetic */ HaversineKernel(VectorValue query2, DefaultConstructorMarker $constructor_marker) {
        this(query2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel$DoubleVector;", "Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel;", "Lorg/vitrivr/cottontail/model/values/DoubleVectorValue;", "query", "([DLkotlin/jvm/internal/DefaultConstructorMarker;)V", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "vector", "invoke-xzCZ-GI", "([D)D", "cottontaildb"})
    public static final class DoubleVector
    extends HaversineKernel<DoubleVectorValue> {
        public double invoke-xzCZ-GI(@NotNull double[] vector) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            return DoubleValue.constructor-impl(this.haversine(((DoubleVectorValue)this.getQuery()).unbox-impl()[0], ((DoubleVectorValue)this.getQuery()).unbox-impl()[1], vector[0], vector[1]));
        }

        private DoubleVector(double[] query2) {
            super(DoubleVectorValue.box-impl(query2), null);
        }

        public /* synthetic */ DoubleVector(double[] query2, DefaultConstructorMarker $constructor_marker) {
            this(query2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel$FloatVector;", "Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel;", "Lorg/vitrivr/cottontail/model/values/FloatVectorValue;", "query", "([FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "vector", "invoke-fPbL_uc", "([F)D", "cottontaildb"})
    public static final class FloatVector
    extends HaversineKernel<FloatVectorValue> {
        public double invoke-fPbL_uc(@NotNull float[] vector) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            return DoubleValue.constructor-impl(this.haversine(((FloatVectorValue)this.getQuery()).unbox-impl()[0], ((FloatVectorValue)this.getQuery()).unbox-impl()[1], vector[0], vector[1]));
        }

        private FloatVector(float[] query2) {
            super(FloatVectorValue.box-impl(query2), null);
        }

        public /* synthetic */ FloatVector(float[] query2, DefaultConstructorMarker $constructor_marker) {
            this(query2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel$LongVector;", "Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel;", "Lorg/vitrivr/cottontail/model/values/LongVectorValue;", "d", "([JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "vector", "invoke--RL9i6w", "([J)D", "cottontaildb"})
    public static final class LongVector
    extends HaversineKernel<LongVectorValue> {
        public double invoke--RL9i6w(@NotNull long[] vector) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            return DoubleValue.constructor-impl(this.haversine(((LongVectorValue)this.getQuery()).unbox-impl()[0], ((LongVectorValue)this.getQuery()).unbox-impl()[1], vector[0], vector[1]));
        }

        private LongVector(long[] d) {
            super(LongVectorValue.box-impl(d), null);
        }

        public /* synthetic */ LongVector(long[] d, DefaultConstructorMarker $constructor_marker) {
            this(d);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel$IntVector;", "Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel;", "Lorg/vitrivr/cottontail/model/values/IntVectorValue;", "query", "([ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "vector", "invoke-1PbIZQU", "([I)D", "cottontaildb"})
    public static final class IntVector
    extends HaversineKernel<IntVectorValue> {
        public double invoke-1PbIZQU(@NotNull int[] vector) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            return DoubleValue.constructor-impl(this.haversine(((IntVectorValue)this.getQuery()).unbox-impl()[0], ((IntVectorValue)this.getQuery()).unbox-impl()[1], vector[0], vector[1]));
        }

        private IntVector(int[] query2) {
            super(IntVectorValue.box-impl(query2), null);
        }

        public /* synthetic */ IntVector(int[] query2, DefaultConstructorMarker $constructor_marker) {
            this(query2);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel$Companion;", "", "()V", "RADIUS_EARTH", "", "cost", "", "d", "", "kernel", "Lorg/vitrivr/cottontail/math/knn/kernels/binary/plain/HaversineKernel;", "Lorg/vitrivr/cottontail/model/values/types/RealVectorValue;", "query", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "cottontaildb"})
    public static final class Companion {
        @NotNull
        public final HaversineKernel<? extends RealVectorValue<?>> kernel(@NotNull VectorValue<?> query2) {
            HaversineKernel haversineKernel;
            Intrinsics.checkNotNullParameter(query2, (String)"query");
            VectorValue<?> vectorValue = query2;
            if (vectorValue instanceof DoubleVectorValue) {
                haversineKernel = new DoubleVector(((DoubleVectorValue)query2).unbox-impl(), null);
            } else if (vectorValue instanceof FloatVectorValue) {
                haversineKernel = new FloatVector(((FloatVectorValue)query2).unbox-impl(), null);
            } else if (vectorValue instanceof IntVectorValue) {
                haversineKernel = new IntVector(((IntVectorValue)query2).unbox-impl(), null);
            } else if (vectorValue instanceof LongVectorValue) {
                haversineKernel = new LongVector(((LongVectorValue)query2).unbox-impl(), null);
            } else {
                String string = HaversineKernel.class.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HaversineKernel::class.java.simpleName");
                throw (Throwable)new KernelNotFoundException(string, query2);
            }
            return haversineKernel;
        }

        public final float cost(int d) {
            return (float)d * (Cost.Companion.getCOST_FLOP() + Cost.Companion.getCOST_MEMORY_ACCESS());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

