/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.data.importer;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.utilities.data.Format;
import org.vitrivr.cottontail.utilities.data.importer.DataImporter;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\tH\u0096\u0002J\t\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/vitrivr/cottontail/utilities/data/importer/JsonDataImporter;", "Lorg/vitrivr/cottontail/utilities/data/importer/DataImporter;", "path", "Ljava/nio/file/Path;", "schema", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "(Ljava/nio/file/Path;[Lorg/vitrivr/cottontail/database/column/ColumnDef;)V", "<set-?>", "", "closed", "getClosed", "()Z", "format", "Lorg/vitrivr/cottontail/utilities/data/Format;", "getFormat", "()Lorg/vitrivr/cottontail/utilities/data/Format;", "getPath", "()Ljava/nio/file/Path;", "reader", "Lcom/google/gson/stream/JsonReader;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "close", "", "hasNext", "next", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$InsertMessage$Builder;", "readBooleanVector", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Literal$Builder;", "size", "", "readComplex32Value", "readComplex32Vector", "readComplex64Value", "readComplex64Vector", "readDoubleVector", "readFloatVector", "readIntVector", "readLongVector", "cottontaildb"})
public final class JsonDataImporter
implements DataImporter {
    private final JsonReader reader;
    @NotNull
    private final Format format;
    private boolean closed;
    @NotNull
    private final Path path;
    private final ColumnDef<?>[] schema;

    @Override
    @NotNull
    public Format getFormat() {
        return this.format;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public CottontailGrpc.InsertMessage.Builder next() {
        this.reader.beginObject();
        CottontailGrpc.InsertMessage.Builder message = CottontailGrpc.InsertMessage.newBuilder();
        for (ColumnDef<?> column : this.schema) {
            CottontailGrpc.Literal.Builder builder;
            String name = this.reader.nextName();
            if (!Intrinsics.areEqual((Object)column.getName().getSimple(), (Object)name) && !Intrinsics.areEqual((Object)column.getName().toString(), (Object)name)) continue;
            CottontailGrpc.InsertMessage.InsertElement.Builder element = CottontailGrpc.InsertMessage.InsertElement.newBuilder();
            Type<?> type = column.getType();
            if (type instanceof Type.Boolean) {
                builder = CottontailGrpc.Literal.newBuilder().setBooleanData(this.reader.nextBoolean());
            } else if (type instanceof Type.Byte || type instanceof Type.Short || type instanceof Type.Int) {
                builder = CottontailGrpc.Literal.newBuilder().setIntData(this.reader.nextInt());
            } else if (type instanceof Type.Long) {
                builder = CottontailGrpc.Literal.newBuilder().setLongData(this.reader.nextLong());
            } else if (type instanceof Type.Float) {
                builder = CottontailGrpc.Literal.newBuilder().setFloatData((float)this.reader.nextDouble());
            } else if (type instanceof Type.Double) {
                builder = CottontailGrpc.Literal.newBuilder().setDoubleData(this.reader.nextDouble());
            } else if (type instanceof Type.Date) {
                builder = CottontailGrpc.Literal.newBuilder().setStringData(this.reader.nextString());
            } else if (type instanceof Type.String) {
                builder = CottontailGrpc.Literal.newBuilder().setDateData(CottontailGrpc.Date.newBuilder().setUtcTimestamp(this.reader.nextLong()));
            } else if (type instanceof Type.Complex32) {
                builder = this.readComplex32Value();
            } else if (type instanceof Type.Complex64) {
                builder = this.readComplex64Value();
            } else if (type instanceof Type.IntVector) {
                builder = this.readIntVector(column.getType().getLogicalSize());
            } else if (type instanceof Type.LongVector) {
                builder = this.readLongVector(column.getType().getLogicalSize());
            } else if (type instanceof Type.FloatVector) {
                builder = this.readFloatVector(column.getType().getLogicalSize());
            } else if (type instanceof Type.DoubleVector) {
                builder = this.readDoubleVector(column.getType().getLogicalSize());
            } else if (type instanceof Type.BooleanVector) {
                builder = this.readBooleanVector(column.getType().getLogicalSize());
            } else if (type instanceof Type.Complex32Vector) {
                builder = this.readComplex32Vector(column.getType().getLogicalSize());
            } else if (type instanceof Type.Complex64Vector) {
                builder = this.readComplex64Vector(column.getType().getLogicalSize());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            CottontailGrpc.Literal.Builder value = builder;
            element.setColumn(CottontailGrpc.ColumnName.newBuilder().setName(column.getName().getSimple()));
            element.setValue(value);
            message.addElements(element);
        }
        this.reader.endObject();
        CottontailGrpc.InsertMessage.Builder builder = message;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"message");
        return builder;
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext() && this.reader.peek() == JsonToken.BEGIN_OBJECT;
    }

    private final CottontailGrpc.Literal.Builder readComplex32Value() {
        CottontailGrpc.Complex32.Builder value = CottontailGrpc.Complex32.newBuilder();
        this.reader.beginObject();
        this.reader.nextName();
        CottontailGrpc.Complex32.Builder builder = value;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"value");
        builder.setReal((float)this.reader.nextDouble());
        this.reader.nextName();
        value.setImaginary((float)this.reader.nextDouble());
        this.reader.endObject();
        CottontailGrpc.Literal.Builder builder2 = CottontailGrpc.Literal.newBuilder().setComplex32Data(value);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"CottontailGrpc.Literal.n\u2026).setComplex32Data(value)");
        return builder2;
    }

    private final CottontailGrpc.Literal.Builder readComplex64Value() {
        CottontailGrpc.Complex64.Builder value = CottontailGrpc.Complex64.newBuilder();
        this.reader.beginObject();
        this.reader.nextName();
        CottontailGrpc.Complex64.Builder builder = value;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"value");
        builder.setReal(this.reader.nextDouble());
        this.reader.nextName();
        value.setImaginary(this.reader.nextDouble());
        this.reader.endObject();
        CottontailGrpc.Literal.Builder builder2 = CottontailGrpc.Literal.newBuilder().setComplex64Data(value);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"CottontailGrpc.Literal.n\u2026).setComplex64Data(value)");
        return builder2;
    }

    /*
     * WARNING - void declaration
     */
    private final CottontailGrpc.Literal.Builder readBooleanVector(int size) {
        CottontailGrpc.BoolVector.Builder vector = CottontailGrpc.BoolVector.newBuilder();
        this.reader.beginArray();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            vector.addVector(this.reader.nextBoolean());
            ++i;
        }
        this.reader.endArray();
        CottontailGrpc.Literal.Builder builder = CottontailGrpc.Literal.newBuilder().setVectorData(CottontailGrpc.Vector.newBuilder().setBoolVector(vector));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"CottontailGrpc.Literal.n\u2026().setBoolVector(vector))");
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private final CottontailGrpc.Literal.Builder readIntVector(int size) {
        CottontailGrpc.IntVector.Builder vector = CottontailGrpc.IntVector.newBuilder();
        this.reader.beginArray();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            vector.addVector(this.reader.nextInt());
            ++i;
        }
        this.reader.endArray();
        CottontailGrpc.Literal.Builder builder = CottontailGrpc.Literal.newBuilder().setVectorData(CottontailGrpc.Vector.newBuilder().setIntVector(vector));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"CottontailGrpc.Literal.n\u2026r().setIntVector(vector))");
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private final CottontailGrpc.Literal.Builder readLongVector(int size) {
        CottontailGrpc.LongVector.Builder vector = CottontailGrpc.LongVector.newBuilder();
        this.reader.beginArray();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            vector.addVector(this.reader.nextLong());
            ++i;
        }
        this.reader.endArray();
        CottontailGrpc.Literal.Builder builder = CottontailGrpc.Literal.newBuilder().setVectorData(CottontailGrpc.Vector.newBuilder().setLongVector(vector));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"CottontailGrpc.Literal.n\u2026().setLongVector(vector))");
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private final CottontailGrpc.Literal.Builder readFloatVector(int size) {
        CottontailGrpc.FloatVector.Builder vector = CottontailGrpc.FloatVector.newBuilder();
        this.reader.beginArray();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            vector.addVector((float)this.reader.nextDouble());
            ++i;
        }
        this.reader.endArray();
        CottontailGrpc.Literal.Builder builder = CottontailGrpc.Literal.newBuilder().setVectorData(CottontailGrpc.Vector.newBuilder().setFloatVector(vector));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"CottontailGrpc.Literal.n\u2026).setFloatVector(vector))");
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private final CottontailGrpc.Literal.Builder readDoubleVector(int size) {
        CottontailGrpc.DoubleVector.Builder vector = CottontailGrpc.DoubleVector.newBuilder();
        this.reader.beginArray();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            vector.addVector(this.reader.nextDouble());
            ++i;
        }
        this.reader.endArray();
        CottontailGrpc.Literal.Builder builder = CottontailGrpc.Literal.newBuilder().setVectorData(CottontailGrpc.Vector.newBuilder().setDoubleVector(vector));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"CottontailGrpc.Literal.n\u2026.setDoubleVector(vector))");
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private final CottontailGrpc.Literal.Builder readComplex32Vector(int size) {
        CottontailGrpc.Complex32Vector.Builder vector = CottontailGrpc.Complex32Vector.newBuilder();
        this.reader.beginArray();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            vector.addVector(this.readComplex32Value().getComplex32Data());
            ++i;
        }
        this.reader.endArray();
        CottontailGrpc.Literal.Builder builder = CottontailGrpc.Literal.newBuilder().setVectorData(CottontailGrpc.Vector.newBuilder().setComplex32Vector(vector));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"CottontailGrpc.Literal.n\u2026tComplex32Vector(vector))");
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private final CottontailGrpc.Literal.Builder readComplex64Vector(int size) {
        CottontailGrpc.Complex64Vector.Builder vector = CottontailGrpc.Complex64Vector.newBuilder();
        this.reader.beginArray();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            vector.addVector(this.readComplex64Value().getComplex64Data());
            ++i;
        }
        this.reader.endArray();
        CottontailGrpc.Literal.Builder builder = CottontailGrpc.Literal.newBuilder().setVectorData(CottontailGrpc.Vector.newBuilder().setComplex64Vector(vector));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"CottontailGrpc.Literal.n\u2026tComplex64Vector(vector))");
        return builder;
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            this.reader.close();
            this.closed = true;
        }
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    public JsonDataImporter(@NotNull Path path, @NotNull ColumnDef<?>[] schema) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        this.path = path;
        this.schema = schema;
        this.reader = new JsonReader((Reader)Files.newBufferedReader(this.getPath()));
        this.reader.beginArray();
        this.format = Format.JSON;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

