/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.column.mapdb;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.column.ColumnTx;
import org.vitrivr.cottontail.database.column.ColumnTxSnapshot;
import org.vitrivr.cottontail.database.column.mapdb.ColumnHeader;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u000267B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00100\u001a\u000201H\u0016J\u001a\u00102\u001a\f03R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u000205H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00068"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn;", "T", "Lorg/vitrivr/cottontail/model/values/types/Value;", "Lorg/vitrivr/cottontail/database/column/Column;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/Entity;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "columnDef", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumnDef$annotations", "()V", "getColumnDef", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "engine", "Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "getEngine", "()Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "header", "Lorg/vitrivr/cottontail/database/column/mapdb/ColumnHeader;", "getHeader", "()Lorg/vitrivr/cottontail/database/column/mapdb/ColumnHeader;", "maxTupleId", "", "getMaxTupleId", "()J", "name", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class MapDBColumn<T extends Value>
implements Column<T> {
    private CottontailStoreWAL store;
    @NotNull
    private final ColumnDef<T> columnDef;
    private volatile boolean closed;
    private final StampedLock closeLock;
    @NotNull
    private final Path path;
    @NotNull
    private final Entity parent;
    private static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final ColumnHeader getHeader() {
        ColumnHeader columnHeader = (ColumnHeader)this.store.get(1L, ColumnHeader.Serializer);
        if (columnHeader == null) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open header of column '" + this.getName() + "'!'");
        }
        return columnHeader;
    }

    public static /* synthetic */ void getColumnDef$annotations() {
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.getColumnDef().getName();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    @NotNull
    public ColumnEngine getEngine() {
        return ColumnEngine.MAPDB;
    }

    @Override
    public long getMaxTupleId() {
        return this.store.getMaxRecid();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            try {
                long stamp = this.closeLock.tryWriteLock(1000L, TimeUnit.MILLISECONDS);
                try {
                    this.store.close();
                    this.closed = true;
                }
                catch (Throwable e) {
                    this.closeLock.unlockWrite(stamp);
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw (Throwable)new IllegalStateException("Could not close column " + this.getName() + ". Failed to acquire exclusive lock which indicates, that transaction wasn't closed properly.");
            }
        }
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public MapDBColumn(@NotNull Path path, @NotNull Entity parent) {
        CottontailStoreWAL cottontailStoreWAL;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        MapDBColumn mapDBColumn = this;
        try {
            MapDBColumn mapDBColumn2 = mapDBColumn;
            cottontailStoreWAL = this.getParent().getParent().getParent().getConfig().getMapdb().store(this.getPath());
        }
        catch (DBException dBException) {
            void e;
            MapDBColumn mapDBColumn3 = mapDBColumn;
            throw (Throwable)new DatabaseException("Failed to open column at '" + this.getPath() + "': " + e.getMessage() + '\'');
        }
        mapDBColumn2.store = cottontailStoreWAL;
        ColumnDef<?> columnDef = this.getHeader().getColumnDef();
        if (columnDef == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnDef<T>");
        }
        this.columnDef = columnDef;
        this.closeLock = new StampedLock();
    }

    @Override
    @NotNull
    public Type<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    public static final /* synthetic */ void access$setStore$p(MapDBColumn $this, CottontailStoreWAL cottontailStoreWAL) {
        $this.store = cottontailStoreWAL;
    }

    public static final /* synthetic */ boolean access$getClosed$p(MapDBColumn $this) {
        return $this.getClosed();
    }

    public static final /* synthetic */ void access$setClosed$p(MapDBColumn $this, boolean bl) {
        $this.closed = bl;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J-\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u000bj\u0002`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00018\u00002\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000bH\u0016J\u001b\u0010\u001c\u001a\u0004\u0018\u00018\u00002\n\u0010\u0016\u001a\u00060\u000bj\u0002`\u0017H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001dJ\f\u0010\"\u001a\u00060#R\u00020$H\u0016J\u0014\u0010\"\u001a\u00060#R\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J%\u0010'\u001a\u0004\u0018\u00018\u00002\n\u0010\u0016\u001a\u00060\u000bj\u0002`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010(R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "dbo", "Lorg/vitrivr/cottontail/database/column/Column;", "getDbo", "()Lorg/vitrivr/cottontail/database/column/Column;", "globalStamp", "", "serializer", "Lorg/vitrivr/cottontail/storage/serializers/mapdb/MapDBSerializer;", "snapshot", "Lorg/vitrivr/cottontail/database/column/ColumnTxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/column/ColumnTxSnapshot;", "cleanup", "", "compareAndUpdate", "", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "value", "expected", "(JLorg/vitrivr/cottontail/model/values/types/Value;Lorg/vitrivr/cottontail/model/values/types/Value;)Z", "count", "delete", "(J)Lorg/vitrivr/cottontail/model/values/types/Value;", "insert", "record", "(Lorg/vitrivr/cottontail/model/values/types/Value;)J", "read", "scan", "Lorg/mapdb/CottontailStoreWAL$RecordIdIterator;", "Lorg/mapdb/CottontailStoreWAL;", "range", "Lkotlin/ranges/LongRange;", "update", "(JLorg/vitrivr/cottontail/model/values/types/Value;)Lorg/vitrivr/cottontail/model/values/types/Value;", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements ColumnTx<T> {
        private final MapDBSerializer<T> serializer;
        private final long globalStamp;
        @NotNull
        private final ColumnTxSnapshot snapshot;

        @Override
        @NotNull
        public Column<T> getDbo() {
            return MapDBColumn.this;
        }

        @Override
        @NotNull
        public ColumnTxSnapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        @Nullable
        public T read(long tupleId) {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return (Value)MapDBColumn.this.store.get(tupleId, this.serializer);
        }

        @Override
        public long count() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return MapDBColumn.this.getHeader().getCount() + this.getSnapshot().getDelta();
        }

        @NotNull
        public CottontailStoreWAL.RecordIdIterator scan() {
            long l = 1L;
            return this.scan(new LongRange(l, MapDBColumn.this.getMaxTupleId()));
        }

        @NotNull
        public CottontailStoreWAL.RecordIdIterator scan(@NotNull LongRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return new CottontailStoreWAL.RecordIdIterator(MapDBColumn.this.store, range);
        }

        @Override
        public long insert(@Nullable T record) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                long l;
                if (record == null && this.getColumnDef().getNullable()) {
                    l = MapDBColumn.this.store.preallocate();
                } else if (record != null) {
                    l = MapDBColumn.this.store.put(record, this.serializer);
                } else {
                    throw (Throwable)new IllegalArgumentException("Column " + this.getColumnDef() + " does not allow for NULL values.");
                }
                long tupleId = l;
                ColumnTxSnapshot columnTxSnapshot = this.getSnapshot();
                columnTxSnapshot.setDelta(columnTxSnapshot.getDelta() + 1L);
                return tupleId;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                long l = this.getContext().getTxId();
                String string = e.getMessage();
                if (string == null) {
                    string = "Unknown";
                }
                throw (Throwable)new TxException.TxStorageException(l, string);
            }
        }

        @Override
        @Nullable
        public T update(long tupleId, @Nullable T value) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                Value ret = (Value)MapDBColumn.this.store.get(tupleId, this.serializer);
                MapDBColumn.this.store.update(tupleId, value, this.serializer);
                return ret;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                long l = this.getContext().getTxId();
                String string = e.getMessage();
                if (string == null) {
                    string = "Unknown exception during data storage";
                }
                throw (Throwable)new TxException.TxStorageException(l, string);
            }
        }

        @Override
        public boolean compareAndUpdate(long tupleId, @Nullable T value, @Nullable T expected) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                boolean ret = MapDBColumn.this.store.compareAndSwap(tupleId, expected, value, this.serializer);
                return ret;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                long l = this.getContext().getTxId();
                String string = e.getMessage();
                if (string == null) {
                    string = "Unknown";
                }
                throw (Throwable)new TxException.TxStorageException(l, string);
            }
        }

        @Override
        @Nullable
        public T delete(long tupleId) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                Value ret = (Value)MapDBColumn.this.store.get(tupleId, this.serializer);
                MapDBColumn.this.store.delete(tupleId, this.serializer);
                ColumnTxSnapshot columnTxSnapshot = this.getSnapshot();
                columnTxSnapshot.setDelta(columnTxSnapshot.getDelta() - 1L);
                MapDBColumn.this.store.update(1L, MapDBColumn.this.getHeader(), ColumnHeader.Serializer);
                return ret;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                long l = this.getContext().getTxId();
                String string = e.getMessage();
                if (string == null) {
                    string = "Unknown";
                }
                throw (Throwable)new TxException.TxStorageException(l, string);
            }
        }

        @Override
        protected void cleanup() {
            MapDBColumn.this.closeLock.unlockRead(this.globalStamp);
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            if (MapDBColumn.this.getClosed()) {
                throw (Throwable)new TxException.TxDBOClosedException(this.getContext().getTxId());
            }
            this.serializer = MapDBColumn.this.getType().serializerFactory().mapdb(MapDBColumn.this.getType().getLogicalSize());
            this.globalStamp = MapDBColumn.this.closeLock.readLock();
            this.snapshot = new ColumnTxSnapshot(this){
                private volatile long delta;
                final /* synthetic */ Tx this$0;

                public long getDelta() {
                    return this.delta;
                }

                public void setDelta(long l) {
                    this.delta = l;
                }

                public void commit() {
                    long l = MapDBColumn.access$getHeader$p(this.this$0.MapDBColumn.this).getCount() + this.getDelta();
                    long l2 = 0L;
                    long l3 = System.currentTimeMillis();
                    ColumnHeader header = ColumnHeader.copy$default(MapDBColumn.access$getHeader$p(this.this$0.MapDBColumn.this), null, l, l2, l3, 5, null);
                    MapDBColumn.access$getStore$p(this.this$0.MapDBColumn.this).update(1L, header, ColumnHeader.Serializer);
                    MapDBColumn.access$getStore$p(this.this$0.MapDBColumn.this).commit();
                }

                public void rollback() {
                    MapDBColumn.access$getStore$p(this.this$0.MapDBColumn.this).rollback();
                }
                {
                    this.this$0 = this$0;
                }
            };
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnTx.DefaultImpls.getColumnDef(this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Companion;", "", "()V", "HEADER_RECORD_ID", "", "initialize", "", "path", "Ljava/nio/file/Path;", "column", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "config", "Lorg/vitrivr/cottontail/config/MapDBConfig;", "cottontaildb"})
    public static final class Companion {
        public final void initialize(@NotNull Path path, @NotNull ColumnDef<?> column, @NotNull MapDBConfig config) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (Files.exists(path, new LinkOption[0])) {
                throw (Throwable)new DatabaseException.InvalidFileException("Could not initialize column " + column.getName() + ". A file already exists under " + path + '.');
            }
            CottontailStoreWAL store = config.store(path);
            store.put(new ColumnHeader(column, 0L, 0L, 0L, 14, null), ColumnHeader.Serializer);
            store.commit();
            store.close();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

