/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.column.ColumnTx;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.entity.EntityHeader;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.entity.EntityTxSnapshot;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.schema.DefaultSchema;
import org.vitrivr.cottontail.database.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.database.statistics.entity.EntityStatistics;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.utilities.io.FileUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0002<=B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00106\u001a\u000207H\u0016J\u0014\u00108\u001a\u000609R\u00020\u00002\u0006\u0010:\u001a\u00020;H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001cR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020,0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006>"}, d2={"Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/schema/DefaultSchema;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/schema/DefaultSchema;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "columns", "", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "Lorg/vitrivr/cottontail/database/column/Column;", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/entity/EntityHeader;", "indexes", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "Lorg/vitrivr/cottontail/database/index/Index;", "maxTupleId", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "getMaxTupleId", "()J", "name", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "numberOfColumns", "", "getNumberOfColumns", "()I", "numberOfRows", "getNumberOfRows", "getParent", "()Lorg/vitrivr/cottontail/database/schema/DefaultSchema;", "getPath", "()Ljava/nio/file/Path;", "statistics", "Lorg/vitrivr/cottontail/database/statistics/entity/EntityStatistics;", "getStatistics", "()Lorg/vitrivr/cottontail/database/statistics/entity/EntityStatistics;", "statisticsField", "store", "Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity$Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class DefaultEntity
implements Entity {
    private final DB store;
    private final Atomic.Var<EntityHeader> headerField;
    private final Atomic.Var<EntityStatistics> statisticsField;
    @NotNull
    private final Name.EntityName name;
    private final StampedLock closeLock;
    private final Map<Name.ColumnName, Column<?>> columns;
    private final Map<Name.IndexName, Index> indexes;
    private volatile boolean closed;
    @NotNull
    private final Path path;
    @NotNull
    private final DefaultSchema parent;
    @NotNull
    public static final String CATALOGUE_FILE = "index.db";
    @NotNull
    public static final String ENTITY_HEADER_FIELD = "cdb_entity_header";
    @NotNull
    public static final String ENTITY_STATISTICS_FIELD = "cdb_entity_statistics";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Name.EntityName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns.size();
    }

    @Override
    @NotNull
    public EntityStatistics getStatistics() {
        Object object = this.statisticsField.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.statisticsField.get()");
        return (EntityStatistics)object;
    }

    @Override
    public long getNumberOfRows() {
        return this.getStatistics().getCount();
    }

    @Override
    public long getMaxTupleId() {
        return this.getStatistics().getMaximumTupleId();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            try {
                long stamp = this.closeLock.tryWriteLock(1000L, TimeUnit.MILLISECONDS);
                try {
                    Iterable $this$forEach$iv = this.columns.values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Column it = (Column)element$iv;
                        boolean bl = false;
                        it.close();
                    }
                    this.store.close();
                    this.closed = true;
                }
                catch (Throwable e) {
                    this.closeLock.unlockWrite(stamp);
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw (Throwable)new IllegalStateException("Could not close entity " + this.getName() + ". Failed to acquire exclusive lock which indicates, that transaction wasn't closed properly.");
            }
        }
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public DefaultSchema getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultEntity(@NotNull Path path, @NotNull DefaultSchema parent) {
        void $this$mapTo$iv$iv;
        DB dB;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        Object object = this;
        try {
            DefaultEntity defaultEntity = object;
            MapDBConfig mapDBConfig = this.getParent().getParent().getConfig().getMapdb();
            Path path2 = this.getPath().resolve(CATALOGUE_FILE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.path.resolve(CATALOGUE_FILE)");
            dB = mapDBConfig.db(path2);
        }
        catch (DBException dBException) {
            void e;
            DefaultEntity defaultEntity = object;
            throw (Throwable)new DatabaseException("Failed to open entity at " + this.getPath() + ": " + e.getMessage() + "'.");
        }
        defaultEntity.store = dB;
        this.headerField = (Atomic.Var)this.store.atomicVar(ENTITY_HEADER_FIELD, (Serializer)EntityHeader.Serializer).createOrOpen();
        this.statisticsField = (Atomic.Var)this.store.atomicVar(ENTITY_STATISTICS_FIELD, (Serializer)EntityStatistics.Serializer).createOrOpen();
        this.name = this.getParent().getName().entity(((EntityHeader)this.headerField.get()).getName());
        this.closeLock = new StampedLock();
        this.columns = (Map)new Object2ObjectLinkedOpenHashMap();
        this.indexes = (Map)new Object2ObjectOpenHashMap();
        EntityHeader header = (EntityHeader)this.headerField.get();
        Iterable $this$map$iv = header.getColumns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EntityHeader.ColumnRef columnRef = (EntityHeader.ColumnRef)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Name.ColumnName columnName = this.getName().column(it.getName());
            Path path3 = this.getPath().resolve(it.getName() + ".col");
            ColumnEngine columnEngine = it.getType();
            Path path4 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path");
            this.columns.put(columnName, columnEngine.open(path4, this));
            Unit unit = Unit.INSTANCE;
            object.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Iterable $this$forEach$iv = header.getIndexes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityHeader.IndexRef it = (EntityHeader.IndexRef)element$iv;
            boolean bl = false;
            Name.IndexName indexName = this.getName().index(it.getName());
            Path path5 = this.getPath().resolve(it.getName() + ".idx");
            IndexType indexType = it.getType();
            Path path6 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"path");
            this.indexes.put(indexName, indexType.open(path6, this));
        }
    }

    public static final /* synthetic */ Atomic.Var access$getStatisticsField$p(DefaultEntity $this) {
        return $this.statisticsField;
    }

    public static final /* synthetic */ DB access$getStore$p(DefaultEntity $this) {
        return $this.store;
    }

    public static final /* synthetic */ Map access$getIndexes$p(DefaultEntity $this) {
        return $this.indexes;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DefaultEntity $this) {
        return $this.getClosed();
    }

    public static final /* synthetic */ void access$setClosed$p(DefaultEntity $this, boolean bl) {
        $this.closed = bl;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0014\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016JC\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0\"H\u0016\u00a2\u0006\u0002\u0010$J\u0014\u0010%\u001a\u00020\u00132\n\u0010&\u001a\u00060\u0007j\u0002`'H\u0016J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u001d\u0010*\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`'2\u0006\u0010+\u001a\u00020,H\u0016\u00a2\u0006\u0002\u0010-J\u0012\u0010.\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150/H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u001a0/H\u0016J\f\u00101\u001a\u00060\u0007j\u0002`'H\u0016J\b\u00102\u001a\u00020\u0013H\u0016J+\u00103\u001a\u00020,2\n\u0010&\u001a\u00060\u0007j\u0002`'2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fH\u0016\u00a2\u0006\u0002\u00104J%\u00105\u001a\b\u0012\u0004\u0012\u00020,062\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fH\u0016\u00a2\u0006\u0002\u00107J-\u00105\u001a\b\u0012\u0004\u0012\u00020,062\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001f2\u0006\u00108\u001a\u000209H\u0016\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006<"}, d2={"Lorg/vitrivr/cottontail/database/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/entity/EntityTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "getDbo", "()Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "snapshot", "Lorg/vitrivr/cottontail/database/entity/EntityTxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/entity/EntityTxSnapshot;", "snapshot$delegate", "Lkotlin/Lazy;", "cleanup", "", "columnForName", "Lorg/vitrivr/cottontail/database/column/Column;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "count", "createIndex", "Lorg/vitrivr/cottontail/database/index/Index;", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "params", "", "", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/index/IndexType;[Lorg/vitrivr/cottontail/database/column/ColumnDef;Ljava/util/Map;)Lorg/vitrivr/cottontail/database/index/Index;", "delete", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "dropIndex", "indexForName", "insert", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "(Lorg/vitrivr/cottontail/model/basics/Record;)Ljava/lang/Long;", "listColumns", "", "listIndexes", "maxTupleId", "optimize", "read", "(J[Lorg/vitrivr/cottontail/database/column/ColumnDef;)Lorg/vitrivr/cottontail/model/basics/Record;", "scan", "", "([Lorg/vitrivr/cottontail/database/column/ColumnDef;)Ljava/util/Iterator;", "range", "Lkotlin/ranges/LongRange;", "([Lorg/vitrivr/cottontail/database/column/ColumnDef;Lkotlin/ranges/LongRange;)Ljava/util/Iterator;", "update", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements EntityTx {
        private final long closeStamp;
        @NotNull
        private final Lazy snapshot$delegate;

        @Override
        @NotNull
        public DefaultEntity getDbo() {
            return DefaultEntity.this;
        }

        @Override
        @NotNull
        public EntityTxSnapshot getSnapshot() {
            Lazy lazy = this.snapshot$delegate;
            Tx tx = this;
            Object var3_3 = null;
            boolean bl = false;
            return (EntityTxSnapshot)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Record read(long tupleId, @NotNull ColumnDef<?>[] columns) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Object $this$map$iv = columns;
            boolean $i$f$map = false;
            ColumnDef<?>[] columnDefArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((ColumnDef<?>[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var10_8 = $this$mapTo$iv$iv;
            int n = ((void)var10_8).length;
            for (int i = 0; i < n; ++i) {
                Column column;
                void it;
                void item$iv$iv;
                void var14_12 = item$iv$iv = var10_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if ((Column)DefaultEntity.this.columns.get(it.getName()) == null) {
                    throw (Throwable)new IllegalArgumentException("Column " + it + " does not exist on entity " + DefaultEntity.this.getName() + '.');
                }
                org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(column);
                if (tx == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<*>");
                }
                Object t = ((ColumnTx)tx).read(tupleId);
                collection.add(t);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
            if (valueArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Value[] values = valueArray;
            return new StandaloneRecord(tupleId, columns, values);
        }

        @Override
        public long count() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return this.getSnapshot().getStatistics().getCount();
        }

        @Override
        public long maxTupleId() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return this.getSnapshot().getStatistics().getMaximumTupleId();
        }

        @Override
        @NotNull
        public List<Column<?>> listColumns() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return CollectionsKt.toList((Iterable)DefaultEntity.this.columns.values());
        }

        @Override
        @NotNull
        public Column<?> columnForName(@NotNull Name.ColumnName name) {
            Column column;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            if (!name.getWildcard()) {
                column = (Column)DefaultEntity.this.columns.get(name);
                if (column == null) {
                    throw (Throwable)new DatabaseException.ColumnDoesNotExistException(name);
                }
            } else {
                Name.ColumnName fqn = DefaultEntity.this.getName().column(name.getSimple());
                column = (Column)DefaultEntity.this.columns.get(fqn);
                if (column == null) {
                    throw (Throwable)new DatabaseException.ColumnDoesNotExistException(fqn);
                }
            }
            return column;
        }

        @Override
        @NotNull
        public List<Index> listIndexes() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return CollectionsKt.toList((Iterable)this.getSnapshot().getIndexes().values());
        }

        @Override
        @NotNull
        public Index indexForName(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            Index index = this.getSnapshot().getIndexes().get(name);
            if (index == null) {
                throw (Throwable)new DatabaseException.IndexDoesNotExistException(name);
            }
            return index;
        }

        @Override
        @NotNull
        public Index createIndex(@NotNull Name.IndexName name, @NotNull IndexType type, @NotNull ColumnDef<?>[] columns, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            if (this.getSnapshot().getIndexes().containsKey(name)) {
                throw (Throwable)new DatabaseException.IndexAlreadyExistsException(name);
            }
            try {
                Path data;
                Path path = data = DefaultEntity.this.getPath().resolve(name.getSimple() + ".idx");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"data");
                AbstractIndex newIndex = type.create(path, this.getDbo(), name, columns, params);
                this.getSnapshot().getCreated().put(name, newIndex);
                this.getSnapshot().getIndexes().put(name, newIndex);
                this.getSnapshot().getDropped().remove(name);
                return newIndex;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Failed to create index '" + name + "' due to a storage exception: " + e.getMessage());
            }
            catch (IOException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Failed to create index '" + name + "' due to an IO exception: " + e.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void dropIndex(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            Index index = this.getSnapshot().getIndexes().remove(name);
            if (index == null) {
                throw (Throwable)new DatabaseException.IndexDoesNotExistException(name);
            }
            Index index2 = index;
            if (this.getContext().lockOn(index2) != LockMode.EXCLUSIVE) {
                this.getContext().requestLock(index2, LockMode.EXCLUSIVE);
            }
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                EntityHeader oldHeader = (EntityHeader)DefaultEntity.this.headerField.get();
                Iterable iterable = oldHeader.getIndexes();
                List list = null;
                long l = 0L;
                long l2 = 0L;
                String string = null;
                EntityHeader entityHeader = oldHeader;
                Atomic.Var var = DefaultEntity.this.headerField;
                boolean $i$f$filter = false;
                void var17_17 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    EntityHeader.IndexRef it = (EntityHeader.IndexRef)element$iv$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)index2.getName().getSimple()) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                var.set((Object)EntityHeader.copy$default(entityHeader, string, l2, l, list, list2, 15, null));
                this.getSnapshot().getIndexes().remove(name);
                this.getSnapshot().getCreated().remove(name);
                this.getSnapshot().getDropped().put(name, index2);
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Failed to drop index '" + name + "' due to a storage exception: " + e.getMessage());
            }
            catch (IOException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Failed to drop index '" + name + "' due to an IO exception: " + e.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void optimize() {
            void $this$filterTo$iv$iv;
            void $this$toTypedArray$iv;
            Object item$iv$iv3;
            void $this$mapTo$iv$iv;
            Object object;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Index it;
            void $this$filterTo$iv$iv2;
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            Iterable $this$filter$iv = this.listIndexes();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (Index)element$iv$iv;
                boolean bl2 = false;
                if (!it.getSupportsIncrementalUpdate()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (Index)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl3 = false;
                org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                if (tx == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                }
                IndexTx tx2 = (IndexTx)tx;
                tx2.clear();
                object = tx2;
                collection.add(object);
            }
            List incremental = (List)destination$iv$iv;
            Iterable $this$map$iv2 = this.listColumns();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                void it2;
                Column bl3 = (Column)item$iv$iv3;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                object = it2.getColumnDef();
                collection.add(object);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
            if (columnDefArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ColumnDef[] columns = columnDefArray;
            Object2ObjectOpenHashMap map2 = new Object2ObjectOpenHashMap(columns.length);
            long l = 0L;
            LongRange range = new LongRange(l, this.maxTupleId());
            this.getSnapshot().getStatistics().reset();
            Iterator<Record> $this$forEach$iv = this.scan(columns, range);
            boolean $i$f$forEach = false;
            Object $i$f$mapTo22 = $this$forEach$iv;
            boolean item$iv$iv2 = false;
            item$iv$iv3 = $i$f$mapTo22;
            while (item$iv$iv3.hasNext()) {
                Object element$iv = item$iv$iv3.next();
                Record r = (Record)element$iv;
                boolean bl5 = false;
                r.forEach((Function2)new Function2<ColumnDef<?>, Value, Unit>(map2, incremental, this){
                    final /* synthetic */ Object2ObjectOpenHashMap $map$inlined;
                    final /* synthetic */ List $incremental$inlined;
                    final /* synthetic */ Tx this$0;
                    {
                        this.$map$inlined = object2ObjectOpenHashMap;
                        this.$incremental$inlined = list;
                        this.this$0 = tx;
                        super(2);
                    }

                    public final void invoke(@NotNull ColumnDef<?> columnDef, @Nullable Value value) {
                        Intrinsics.checkNotNullParameter(columnDef, (String)"columnDef");
                        ((Map)this.$map$inlined).put(columnDef, value);
                    }
                });
                DataChangeEvent.InsertDataChangeEvent event = new DataChangeEvent.InsertDataChangeEvent((Entity)DefaultEntity.this, r.getTupleId(), (Map)map2);
                this.getSnapshot().getStatistics().consume(event);
                Iterable $this$forEach$iv2 = incremental;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    IndexTx it3 = (IndexTx)element$iv2;
                    boolean bl6 = false;
                    it3.update(event);
                }
            }
            Iterable $this$filter$iv2 = this.listIndexes();
            boolean $i$f$filter2 = false;
            $i$f$mapTo22 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Index it4 = (Index)element$iv$iv;
                boolean bl7 = false;
                if (!(!it4.getSupportsIncrementalUpdate())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv3;
            $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Index it5 = (Index)element$iv;
                boolean bl8 = false;
                org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it5);
                if (tx == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                }
                ((IndexTx)tx).rebuild();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> scan(@NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            long l = 1L;
            return this.scan(columns, new LongRange(l, this.maxTupleId()));
        }

        @Override
        @NotNull
        public Iterator<Record> scan(@NotNull ColumnDef<?>[] columns, @NotNull LongRange range) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return new Iterator<Record>(this, (ColumnDef[])columns, range){
                private final List<ColumnTx<?>> txs;
                private final Iterator<Long> wrapped;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ ColumnDef[] $columns$inlined;
                final /* synthetic */ LongRange $range$inlined;
                {
                    Collection<ColumnTx> collection;
                    void $this$mapTo$iv$iv;
                    this.this$0 = tx;
                    this.$columns$inlined = object;
                    this.$range$inlined = longRange;
                    ColumnDef[] $this$map$iv = this.$columns$inlined;
                    object = this;
                    boolean $i$f$map = false;
                    ColumnDef[] columnDefArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    void var7_8 = $this$mapTo$iv$iv;
                    int n = ((void)var7_8).length;
                    for (int i = 0; i < n; ++i) {
                        Column column;
                        void it;
                        void item$iv$iv;
                        void var11_12 = item$iv$iv = var7_8[i];
                        collection = destination$iv$iv;
                        boolean bl = false;
                        if ((Column)DefaultEntity.access$getColumns$p(this.this$0.DefaultEntity.this).get(it.getName()) == null) {
                            throw (Throwable)new IllegalArgumentException("Column " + it + " does not exist on entity " + this.this$0.DefaultEntity.this.getName() + '.');
                        }
                        org.vitrivr.cottontail.database.general.Tx tx2 = this.this$0.getContext().getTx(column);
                        if (tx2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<*>");
                        }
                        ColumnTx columnTx = (ColumnTx)tx2;
                        collection.add(columnTx);
                    }
                    collection = (List)destination$iv$iv;
                    object.txs = collection;
                    this.wrapped = ((ColumnTx)CollectionsKt.first(this.txs)).scan(this.$range$inlined);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public Record next() {
                    void $this$mapTo$iv$iv;
                    long tupleId = ((Number)this.wrapped.next()).longValue();
                    Iterable $this$map$iv = this.txs;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ColumnTx columnTx = (ColumnTx)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        T t = it.read(tupleId);
                        collection.add(t);
                    }
                    Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
                    if (valueArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Value[] values = valueArray;
                    return new StandaloneRecord(tupleId, this.$columns$inlined, values);
                }

                public boolean hasNext() {
                    return this.wrapped.hasNext();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @Nullable
        public Long insert(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                Long lastTupleId = null;
                Object2ObjectArrayMap inserts = new Object2ObjectArrayMap(DefaultEntity.this.columns.size());
                Iterable $this$forEach$iv = DefaultEntity.this.columns.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Column it = (Column)element$iv;
                    boolean bl2 = false;
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<org.vitrivr.cottontail.model.values.types.Value>");
                    }
                    ColumnTx tx2 = (ColumnTx)tx;
                    Value value = record.get(it.getColumnDef());
                    long tupleId = tx2.insert(value);
                    Long l = lastTupleId;
                    if ((l == null || l != tupleId) && lastTupleId != null) {
                        throw (Throwable)new DatabaseException.DataCorruptionException("Entity '" + DefaultEntity.this.getName() + "' is corrupt. Insert did not yield same record ID for all columns involved!");
                    }
                    lastTupleId = tupleId;
                    ((Map)inserts).put(it.getColumnDef(), value);
                }
                if (lastTupleId != null) {
                    Entity entity = DefaultEntity.this;
                    Long l = lastTupleId;
                    Intrinsics.checkNotNull((Object)l);
                    DataChangeEvent.InsertDataChangeEvent event = new DataChangeEvent.InsertDataChangeEvent(entity, (long)l, (Map)inserts);
                    Iterable $this$forEach$iv2 = this.getSnapshot().getIndexes().values();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        Index it = (Index)element$iv;
                        boolean bl3 = false;
                        org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                        if (tx == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                        }
                        ((IndexTx)tx).update(event);
                    }
                    this.getSnapshot().getStatistics().consume(event);
                    this.getContext().signalEvent(event);
                }
                return lastTupleId;
            }
            catch (DatabaseException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)e;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Inserting record failed due to an error in the underlying storage: " + e.getMessage() + '.');
            }
        }

        @Override
        public void update(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                Object2ObjectArrayMap updates = new Object2ObjectArrayMap(record.getColumns().length);
                ColumnDef<?>[] $this$forEach$iv = record.getColumns();
                boolean $i$f$forEach = false;
                ColumnDef<?>[] columnDefArray = $this$forEach$iv;
                int n = columnDefArray.length;
                for (int i = 0; i < n; ++i) {
                    Column column;
                    ColumnDef<?> element$iv;
                    ColumnDef<?> def = element$iv = columnDefArray[i];
                    boolean bl2 = false;
                    if ((Column)DefaultEntity.this.columns.get(def.getName()) == null) {
                        throw (Throwable)new IllegalArgumentException("Column " + def + " does not exist on entity " + DefaultEntity.this.getName() + '.');
                    }
                    Value value = record.get(def);
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(column);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<org.vitrivr.cottontail.model.values.types.Value>");
                    }
                    ColumnTx columnTx = (ColumnTx)tx;
                    ((Map)updates).put(def, new Pair((Object)columnTx.update(record.getTupleId(), value), (Object)value));
                }
                DataChangeEvent.UpdateDataChangeEvent event = new DataChangeEvent.UpdateDataChangeEvent((Entity)DefaultEntity.this, record.getTupleId(), (Map)updates);
                Iterable $this$forEach$iv2 = this.getSnapshot().getIndexes().values();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Index it = (Index)element$iv;
                    boolean bl3 = false;
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                    }
                    ((IndexTx)tx).update(event);
                }
                this.getSnapshot().getStatistics().consume(event);
                this.getContext().signalEvent(event);
            }
            catch (DatabaseException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)e;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Updating record " + record.getTupleId() + " failed due to an error in the underlying storage: " + e.getMessage() + '.');
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void delete(long tupleId) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                void $this$mapTo$iv$iv;
                Object2ObjectArrayMap deleted = new Object2ObjectArrayMap(DefaultEntity.this.columns.size());
                Iterable $this$map$iv = DefaultEntity.this.columns.values();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Column column = (Column)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx((DBO)it);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<*>");
                    }
                    ((Map)deleted).put(it.getColumnDef(), ((ColumnTx)tx).delete(tupleId));
                    Unit unit = Unit.INSTANCE;
                    collection.add(unit);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                DataChangeEvent.DeleteDataChangeEvent event = new DataChangeEvent.DeleteDataChangeEvent((Entity)DefaultEntity.this, tupleId, (Map)deleted);
                Iterable $this$forEach$iv = this.getSnapshot().getIndexes().values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Index it = (Index)element$iv;
                    boolean bl3 = false;
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                    }
                    ((IndexTx)tx).update(event);
                }
                this.getSnapshot().getStatistics().consume(event);
                this.getContext().signalEvent(event);
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Deleting record " + tupleId + " failed due to an error in the underlying storage: " + e.getMessage() + '.');
            }
        }

        @Override
        protected void cleanup() {
            DefaultEntity.this.closeLock.unlockRead(this.closeStamp);
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.closeStamp = DefaultEntity.this.closeLock.readLock();
            this.snapshot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<snapshot.1>(this){
                final /* synthetic */ Tx this$0;

                @NotNull
                public final snapshot.1 invoke() {
                    return new EntityTxSnapshot(this){
                        @NotNull
                        private final EntityStatistics statistics;
                        @NotNull
                        private final Object2ObjectOpenHashMap<Name.IndexName, Index> indexes;
                        @NotNull
                        private final Object2ObjectOpenHashMap<Name.IndexName, Index> created;
                        @NotNull
                        private final Object2ObjectOpenHashMap<Name.IndexName, Index> dropped;
                        final /* synthetic */ snapshot.2 this$0;

                        @NotNull
                        public EntityStatistics getStatistics() {
                            return this.statistics;
                        }

                        @NotNull
                        public Object2ObjectOpenHashMap<Name.IndexName, Index> getIndexes() {
                            return this.indexes;
                        }

                        @NotNull
                        public Object2ObjectOpenHashMap<Name.IndexName, Index> getCreated() {
                            return this.created;
                        }

                        @NotNull
                        public Object2ObjectOpenHashMap<Name.IndexName, Index> getDropped() {
                            return this.dropped;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void commit() {
                            Map.Entry<K, V> element$iv;
                            Iterator<Map.Entry<K, V>> iterator2;
                            Object object;
                            try {
                                Collection<EntityHeader.IndexRef> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                EntityHeader oldHeader = (EntityHeader)DefaultEntity.access$getHeaderField$p(this.this$0.this$0.DefaultEntity.this).get();
                                long l = System.currentTimeMillis();
                                ObjectCollection objectCollection = (ObjectCollection)this.getIndexes().values();
                                Intrinsics.checkNotNullExpressionValue((Object)objectCollection, (String)"this.indexes.values");
                                object = (Iterable)objectCollection;
                                List list = null;
                                long l2 = l;
                                long l3 = 0L;
                                String string = null;
                                EntityHeader entityHeader = oldHeader;
                                boolean $i$f$map = false;
                                iterator2 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    Index index = (Index)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    EntityHeader.IndexRef indexRef = new EntityHeader.IndexRef(it.getName().getSimple(), it.getType());
                                    collection.add(indexRef);
                                }
                                collection = (List)destination$iv$iv;
                                EntityHeader newHeader = EntityHeader.copy$default(entityHeader, string, l3, l2, list, (List)collection, 11, null);
                                DefaultEntity.access$getHeaderField$p(this.this$0.this$0.DefaultEntity.this).compareAndSet((Object)oldHeader, (Object)newHeader);
                                DefaultEntity.access$getStatisticsField$p(this.this$0.this$0.DefaultEntity.this).set((Object)this.getStatistics());
                                DefaultEntity.access$getStore$p(this.this$0.this$0.DefaultEntity.this).commit();
                            }
                            catch (DBException e) {
                                Tx.access$setStatus$p(this.this$0.this$0, TxStatus.ERROR);
                                throw (Throwable)new DatabaseException("Failed to create index '" + this.this$0.this$0.DefaultEntity.this.getName() + "' due to a storage exception: " + e.getMessage());
                            }
                            Map $this$forEach$iv = (Map)this.getCreated();
                            boolean $i$f$forEach = false;
                            object = $this$forEach$iv;
                            boolean bl = false;
                            iterator2 = object.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<K, V> it = element$iv = iterator2.next();
                                boolean bl2 = false;
                                Map map2 = DefaultEntity.access$getIndexes$p(this.this$0.this$0.DefaultEntity.this);
                                K k = it.getKey();
                                Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                                V v = it.getValue();
                                Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                                map2.put(k, v);
                            }
                            $this$forEach$iv = (Map)this.getDropped();
                            $i$f$forEach = false;
                            object = $this$forEach$iv;
                            bl = false;
                            iterator2 = object.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Index index;
                                Map.Entry<K, V> it = element$iv = iterator2.next();
                                boolean bl3 = false;
                                Index index2 = index = (Index)DefaultEntity.access$getIndexes$p(this.this$0.this$0.DefaultEntity.this).remove(it.getKey());
                                if (index2 != null) {
                                    index2.close();
                                }
                                FileUtilities.INSTANCE.deleteRecursively(((Index)it.getValue()).getPath());
                            }
                        }

                        public void rollback() {
                            Map $this$forEach$iv = (Map)this.getCreated();
                            boolean $i$f$forEach = false;
                            Map map2 = $this$forEach$iv;
                            boolean bl = false;
                            Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> $dstr$_u24__u24$v = element$iv = iterator2.next();
                                boolean bl2 = false;
                                Map.Entry<K, V> entry = $dstr$_u24__u24$v;
                                boolean bl3 = false;
                                Index v = (Index)entry.getValue();
                                v.close();
                                FileUtilities.INSTANCE.deleteRecursively(v.getPath());
                            }
                            DefaultEntity.access$getStore$p(this.this$0.this$0.DefaultEntity.this).rollback();
                        }
                        {
                            this.this$0 = this$0;
                            Object object = DefaultEntity.access$getStatisticsField$p(this$0.this$0.DefaultEntity.this).get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this@DefaultEntity.statisticsField.get()");
                            this.statistics = (EntityStatistics)object;
                            this.indexes = new Object2ObjectOpenHashMap(DefaultEntity.access$getIndexes$p(this$0.this$0.DefaultEntity.this));
                            this.created = new Object2ObjectOpenHashMap();
                            this.dropped = new Object2ObjectOpenHashMap();
                        }
                    };
                }
                {
                    this.this$0 = tx;
                    super(0);
                }
            }));
            if (DefaultEntity.this.getClosed()) {
                throw (Throwable)new TxException.TxDBOClosedException(this.getContext().getTxId());
            }
        }

        public static final /* synthetic */ TxStatus access$getStatus$p(Tx $this) {
            return $this.getStatus();
        }

        public static final /* synthetic */ void access$setStatus$p(Tx $this, TxStatus txStatus) {
            $this.setStatus(txStatus);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u001c\u0010\u000e\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/database/entity/DefaultEntity$Companion;", "", "()V", "CATALOGUE_FILE", "", "ENTITY_HEADER_FIELD", "ENTITY_STATISTICS_FIELD", "initialize", "Ljava/nio/file/Path;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "path", "config", "Lorg/vitrivr/cottontail/config/Config;", "columns", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "cottontaildb"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Path initialize(@NotNull Name.EntityName name, @NotNull Path path, @NotNull Config config, @NotNull List<? extends Pair<? extends ColumnDef<?>, ? extends ColumnEngine>> columns) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Path dataPath = path.resolve("entity_" + name.getSimple());
            if (Files.exists(dataPath, new LinkOption[0])) {
                throw (Throwable)new DatabaseException.InvalidFileException("Failed to create entity '" + name + "'. Data directory '" + dataPath + "' seems to be occupied.");
            }
            Files.createDirectories(dataPath, new FileAttribute[0]);
            try {
                Collection<EntityHeader.ColumnRef> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = columns;
                long l = 0L;
                long l2 = 0L;
                String string = name.getSimple();
                boolean $i$f$map = false;
                void var9_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Path colPath = dataPath.resolve(((ColumnDef)it.getFirst()).getName().getSimple() + ".col");
                    ColumnEngine columnEngine = (ColumnEngine)((Object)it.getSecond());
                    Path path2 = colPath;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"colPath");
                    columnEngine.create(path2, (ColumnDef)it.getFirst(), config);
                    EntityHeader.ColumnRef columnRef = new EntityHeader.ColumnRef(((ColumnDef)it.getFirst()).getName().getSimple(), (ColumnEngine)((Object)it.getSecond()));
                    collection.add(columnRef);
                }
                collection = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 22;
                List list = null;
                Collection<EntityHeader.ColumnRef> collection2 = collection;
                long l3 = l;
                long l4 = l2;
                String string2 = string;
                EntityHeader entityHeader = new EntityHeader(string2, l4, l3, (List)collection2, list, n, defaultConstructorMarker);
                EntityStatistics entityStatistics = new EntityStatistics(0L, 0L, 3, null);
                Iterable $this$forEach$iv = columns;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    ValueStatistics<Value> valueStatistics = ((ColumnDef)it.getFirst()).getType().statistics();
                    if (valueStatistics == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.statistics.columns.ValueStatistics<org.vitrivr.cottontail.model.values.types.Value>");
                    }
                    entityStatistics.set((ColumnDef)it.getFirst(), valueStatistics);
                }
                MapDBConfig mapDBConfig = config.getMapdb();
                Path path3 = dataPath.resolve(DefaultEntity.CATALOGUE_FILE);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"dataPath.resolve(CATALOGUE_FILE)");
                Closeable closeable = (Closeable)mapDBConfig.db(path3);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    DB it = (DB)closeable;
                    boolean bl3 = false;
                    ((Atomic.Var)it.atomicVar(DefaultEntity.ENTITY_HEADER_FIELD, (Serializer)EntityHeader.Serializer).create()).set((Object)entityHeader);
                    ((Atomic.Var)it.atomicVar(DefaultEntity.ENTITY_STATISTICS_FIELD, (Serializer)EntityStatistics.Serializer).create()).set((Object)entityStatistics);
                    it.commit();
                    it.close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (DBException e) {
                Path path4 = dataPath;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"dataPath");
                FileUtilities.INSTANCE.deleteRecursively(path4);
                throw (Throwable)new DatabaseException("Failed to create entity '" + name + "' due to error in the underlying data store: {" + e.getMessage());
            }
            catch (IOException e) {
                Path path5 = dataPath;
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"dataPath");
                FileUtilities.INSTANCE.deleteRecursively(path5);
                throw (Throwable)new DatabaseException("Failed to create entity '" + name + "' due to an IO exception: {" + e.getMessage());
            }
            catch (Throwable e) {
                Path path6 = dataPath;
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"dataPath");
                FileUtilities.INSTANCE.deleteRecursively(path6);
                throw (Throwable)new DatabaseException("Failed to create entity '" + name + "' due to an unexpected error: {" + e.getMessage());
            }
            Path path7 = dataPath;
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"dataPath");
            return path7;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

