/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.catalogue;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.catalogue.CatalogueHeader;
import org.vitrivr.cottontail.database.catalogue.CatalogueTx;
import org.vitrivr.cottontail.database.catalogue.CatalogueTxSnapshot;
import org.vitrivr.cottontail.database.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.schema.DefaultSchema;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.utilities.io.FileUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u000212B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010+\u001a\u00020,H\u0016J\u0014\u0010-\u001a\u00060.R\u00020\u00002\u0006\u0010/\u001a\u000200H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00063"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueHeader;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$RootName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$RootName;", "parent", "Lorg/vitrivr/cottontail/database/general/DBO;", "getParent", "()Lorg/vitrivr/cottontail/database/general/DBO;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "Lorg/vitrivr/cottontail/database/schema/Schema;", "size", "", "getSize", "()I", "store", "Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class DefaultCatalogue
implements Catalogue {
    @NotNull
    private final Path path;
    @Nullable
    private final DBO parent;
    private final StampedLock closeLock;
    private final DB store;
    private final Atomic.Var<CatalogueHeader> headerField;
    private final Map<Name.SchemaName, Schema> registry;
    private volatile boolean closed;
    @NotNull
    private final Config config;
    @NotNull
    public static final String CATALOGUE_HEADER_FIELD = "cdb_catalogue_header";
    @NotNull
    public static final String FILE_CATALOGUE = "catalogue.db";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Name.RootName getName() {
        return Name.RootName.INSTANCE;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    @Nullable
    public DBO getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int n;
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            n = 0;
            n = ((CatalogueHeader)this.headerField.get()).getSchemas().size();
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return n;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    @Override
    public void close() {
        try {
            long stamp = this.closeLock.tryWriteLock(1000L, TimeUnit.MILLISECONDS);
            try {
                Map<Name.SchemaName, Schema> $this$forEach$iv = this.registry;
                boolean $i$f$forEach = false;
                Map<Name.SchemaName, Schema> map2 = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<Name.SchemaName, Schema>> iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<Name.SchemaName, Schema> element$iv;
                    Map.Entry<Name.SchemaName, Schema> $dstr$_u24__u24$v = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Map.Entry<Name.SchemaName, Schema> entry = $dstr$_u24__u24$v;
                    boolean bl3 = false;
                    Schema v = entry.getValue();
                    v.close();
                }
                this.store.close();
                this.closed = true;
            }
            catch (Throwable e) {
                this.closeLock.unlockWrite(stamp);
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw (Throwable)new IllegalStateException("Could not close schema " + this.getName() + ". Failed to acquire exclusive lock which indicates, that transaction wasn't closed properly.");
        }
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public DefaultCatalogue(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.path = this.getConfig().getRoot();
        this.closeLock = new StampedLock();
        MapDBConfig mapDBConfig = this.getConfig().getMapdb();
        Path path = this.getPath().resolve(FILE_CATALOGUE);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.path.resolve(FILE_CATALOGUE)");
        this.store = mapDBConfig.db(path);
        this.headerField = (Atomic.Var)this.store.atomicVar(CATALOGUE_HEADER_FIELD, (Serializer)CatalogueHeader.Serializer).createOrOpen();
        Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.synchronized\u2026ject2ObjectOpenHashMap())");
        this.registry = map2;
        if (this.headerField.get() == null) {
            this.headerField.set((Object)new CatalogueHeader(null, 0L, 0L, null, 15, null));
            this.store.commit();
        }
        for (CatalogueHeader.SchemaRef schemaRef : ((CatalogueHeader)this.headerField.get()).getSchemas()) {
            if (schemaRef.getPath() != null && Files.exists(schemaRef.getPath(), new LinkOption[0])) {
                this.registry.put(new Name.SchemaName(schemaRef.getName()), new DefaultSchema(this.getPath(), this));
                continue;
            }
            Path path2 = this.getPath().resolve("schema_" + schemaRef.getName());
            if (!Files.exists(path2, new LinkOption[0])) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Broken catalogue entry for schema '" + schemaRef.getName() + "'. Path " + path2 + " does not exist!");
            }
            Name.SchemaName schemaName = new Name.SchemaName(schemaRef.getName());
            Path path3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            this.registry.put(schemaName, new DefaultSchema(path3, this));
        }
    }

    public static final /* synthetic */ Atomic.Var access$getHeaderField$p(DefaultCatalogue $this) {
        return $this.headerField;
    }

    public static final /* synthetic */ DB access$getStore$p(DefaultCatalogue $this) {
        return $this.store;
    }

    public static final /* synthetic */ Map access$getRegistry$p(DefaultCatalogue $this) {
        return $this.registry;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "getDbo", "()Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "snapshot", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueTxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/catalogue/CatalogueTxSnapshot;", "snapshot$delegate", "Lkotlin/Lazy;", "cleanup", "", "createSchema", "Lorg/vitrivr/cottontail/database/schema/Schema;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "dropSchema", "listSchemas", "", "schemaForName", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements CatalogueTx {
        private final long closeStamp;
        @NotNull
        private final Lazy snapshot$delegate;

        @Override
        @NotNull
        public DefaultCatalogue getDbo() {
            return DefaultCatalogue.this;
        }

        @Override
        @NotNull
        public CatalogueTxSnapshot getSnapshot() {
            Lazy lazy = this.snapshot$delegate;
            Tx tx = this;
            Object var3_3 = null;
            boolean bl = false;
            return (CatalogueTxSnapshot)lazy.getValue();
        }

        @Override
        @NotNull
        public List<Schema> listSchemas() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return CollectionsKt.toList((Iterable)this.getSnapshot().getSchemas().values());
        }

        @Override
        @NotNull
        public Schema schemaForName(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            Schema schema = this.getSnapshot().getSchemas().get(name);
            if (schema == null) {
                throw (Throwable)new DatabaseException.SchemaDoesNotExistException(name);
            }
            return schema;
        }

        @Override
        @NotNull
        public Schema createSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            Map<Name.SchemaName, Schema> map2 = this.getSnapshot().getSchemas();
            Name.SchemaName schemaName = name;
            boolean bl2 = false;
            Map<Name.SchemaName, Schema> map3 = map2;
            boolean bl3 = false;
            if (map3.containsKey(schemaName)) {
                throw (Throwable)new DatabaseException.SchemaAlreadyExistsException(name);
            }
            try {
                Path data = DefaultSchema.Companion.initialize(name, DefaultCatalogue.this.getPath(), DefaultCatalogue.this.getConfig());
                DefaultSchema schema = new DefaultSchema(data, DefaultCatalogue.this);
                this.getSnapshot().getCreated().put(name, schema);
                this.getSnapshot().getSchemas().put(name, schema);
                this.getSnapshot().getDropped().remove(name);
                return schema;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Failed to create schema '" + name + "' due to a storage exception: " + e.getMessage());
            }
            catch (IOException e) {
                throw (Throwable)new DatabaseException("Failed to create schema '" + name + "' due to an IO exception: " + e.getMessage());
            }
        }

        @Override
        public void dropSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            Schema schema = this.getSnapshot().getSchemas().get(name);
            if (schema == null) {
                throw (Throwable)new DatabaseException.SchemaDoesNotExistException(name);
            }
            Schema schema2 = schema;
            if (this.getContext().lockOn(schema2) != LockMode.EXCLUSIVE) {
                this.getContext().requestLock(schema2, LockMode.EXCLUSIVE);
            }
            this.getSnapshot().getDropped().put(name, schema2);
            this.getSnapshot().getCreated().remove(name);
            this.getSnapshot().getSchemas().remove(name);
        }

        @Override
        protected void cleanup() {
            DefaultCatalogue.this.closeLock.unlockRead(this.closeStamp);
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.closeStamp = DefaultCatalogue.this.closeLock.readLock();
            this.snapshot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<snapshot.1>(this){
                final /* synthetic */ Tx this$0;

                @NotNull
                public final snapshot.1 invoke() {
                    return new CatalogueTxSnapshot(this){
                        @NotNull
                        private final Object2ObjectOpenHashMap<Name.SchemaName, Schema> schemas;
                        @NotNull
                        private final Object2ObjectOpenHashMap<Name.SchemaName, Schema> created;
                        @NotNull
                        private final Object2ObjectOpenHashMap<Name.SchemaName, Schema> dropped;
                        final /* synthetic */ snapshot.2 this$0;

                        @NotNull
                        public Object2ObjectOpenHashMap<Name.SchemaName, Schema> getSchemas() {
                            return this.schemas;
                        }

                        @NotNull
                        public Object2ObjectOpenHashMap<Name.SchemaName, Schema> getCreated() {
                            return this.created;
                        }

                        @NotNull
                        public Object2ObjectOpenHashMap<Name.SchemaName, Schema> getDropped() {
                            return this.dropped;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void commit() {
                            Map.Entry<K, V> element$iv;
                            Iterator<Map.Entry<K, V>> iterator2;
                            Object object;
                            try {
                                Collection<CatalogueHeader.SchemaRef> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                CatalogueHeader oldHeader = (CatalogueHeader)DefaultCatalogue.access$getHeaderField$p(this.this$0.this$0.DefaultCatalogue.this).get();
                                long l = System.currentTimeMillis();
                                ObjectCollection objectCollection = (ObjectCollection)this.getSchemas().values();
                                Intrinsics.checkNotNullExpressionValue((Object)objectCollection, (String)"this.schemas.values");
                                object = (Iterable)objectCollection;
                                long l2 = l;
                                long l3 = 0L;
                                String string = null;
                                CatalogueHeader catalogueHeader = oldHeader;
                                boolean $i$f$map = false;
                                iterator2 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    Schema schema = (Schema)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    CatalogueHeader.SchemaRef schemaRef = new CatalogueHeader.SchemaRef(it.getName().getSimple(), null);
                                    collection.add(schemaRef);
                                }
                                collection = (List)destination$iv$iv;
                                CatalogueHeader newHeader = CatalogueHeader.copy$default(catalogueHeader, string, l3, l2, (List)collection, 3, null);
                                DefaultCatalogue.access$getHeaderField$p(this.this$0.this$0.DefaultCatalogue.this).compareAndSet((Object)oldHeader, (Object)newHeader);
                                DefaultCatalogue.access$getStore$p(this.this$0.this$0.DefaultCatalogue.this).commit();
                            }
                            catch (DBException e) {
                                Tx.access$setStatus$p(this.this$0.this$0, TxStatus.ERROR);
                                DefaultCatalogue.access$getStore$p(this.this$0.this$0.DefaultCatalogue.this).rollback();
                                throw (Throwable)new DatabaseException("Failed to commit catalogue due to a storage exception: " + e.getMessage());
                            }
                            Map $this$forEach$iv = (Map)this.getCreated();
                            boolean $i$f$forEach = false;
                            object = $this$forEach$iv;
                            boolean bl = false;
                            iterator2 = object.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<K, V> it = element$iv = iterator2.next();
                                boolean bl2 = false;
                                Map map2 = DefaultCatalogue.access$getRegistry$p(this.this$0.this$0.DefaultCatalogue.this);
                                K k = it.getKey();
                                Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                                V v = it.getValue();
                                Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                                map2.put(k, v);
                            }
                            $this$forEach$iv = (Map)this.getDropped();
                            $i$f$forEach = false;
                            object = $this$forEach$iv;
                            bl = false;
                            iterator2 = object.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Schema entity;
                                Map.Entry<K, V> it = element$iv = iterator2.next();
                                boolean bl3 = false;
                                if ((Schema)DefaultCatalogue.access$getRegistry$p(this.this$0.this$0.DefaultCatalogue.this).remove(it.getKey()) == null) {
                                    throw (Throwable)new IllegalStateException("");
                                }
                                entity.close();
                                FileUtilities.INSTANCE.deleteRecursively(((Schema)it.getValue()).getPath());
                            }
                        }

                        public void rollback() {
                            Map $this$forEach$iv = (Map)this.getCreated();
                            boolean $i$f$forEach = false;
                            Map map2 = $this$forEach$iv;
                            boolean bl = false;
                            Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> $dstr$_u24__u24$v = element$iv = iterator2.next();
                                boolean bl2 = false;
                                Map.Entry<K, V> entry = $dstr$_u24__u24$v;
                                boolean bl3 = false;
                                Schema v = (Schema)entry.getValue();
                                v.close();
                                FileUtilities.INSTANCE.deleteRecursively(v.getPath());
                            }
                        }
                        {
                            this.this$0 = this$0;
                            this.schemas = new Object2ObjectOpenHashMap(DefaultCatalogue.access$getRegistry$p(this$0.this$0.DefaultCatalogue.this));
                            this.created = new Object2ObjectOpenHashMap();
                            this.dropped = new Object2ObjectOpenHashMap();
                        }
                    };
                }
                {
                    this.this$0 = tx;
                    super(0);
                }
            }));
        }

        public static final /* synthetic */ TxStatus access$getStatus$p(Tx $this) {
            return $this.getStatus();
        }

        public static final /* synthetic */ void access$setStatus$p(Tx $this, TxStatus txStatus) {
            $this.setStatus(txStatus);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue$Companion;", "", "()V", "CATALOGUE_HEADER_FIELD", "", "FILE_CATALOGUE", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

