/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxSnapshot;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexConfig;
import org.vitrivr.cottontail.database.index.IndexHeader;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.NoIndexConfig;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.sort.SortOrder;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 =2\u00020\u0001:\u0002=>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010;\u001a\u00020<H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R,\u0010)\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020+0*0\u0013X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010.\u001a\u0004\b,\u0010-R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u000204X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u000208X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:\u00a8\u0006?"}, d2={"Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "Lorg/vitrivr/cottontail/database/index/Index;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/Entity;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "getCloseLock", "()Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "setClosed", "(Z)V", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "config", "Lorg/vitrivr/cottontail/database/index/IndexConfig;", "getConfig", "()Lorg/vitrivr/cottontail/database/index/IndexConfig;", "dirty", "getDirty", "dirtyField", "Lorg/mapdb/Atomic$Boolean;", "getDirtyField", "()Lorg/mapdb/Atomic$Boolean;", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/index/IndexHeader;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "order", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "getOrder", "()[Lkotlin/Pair;", "[Lkotlin/Pair;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/DB;", "getStore", "()Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "Companion", "Tx", "cottontaildb"})
public abstract class AbstractIndex
implements Index {
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final DB store;
    private final Atomic.Var<IndexHeader> headerField;
    @NotNull
    private final Atomic.Boolean dirtyField;
    @NotNull
    private final Name.IndexName name;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final Pair<ColumnDef<?>, SortOrder>[] order;
    @NotNull
    private final DBOVersion version;
    @NotNull
    private final IndexConfig config;
    private volatile boolean closed;
    @NotNull
    private final Path path;
    @NotNull
    private final Entity parent;
    @NotNull
    public static final String INDEX_HEADER_FIELD = "cdb_index_header";
    @NotNull
    public static final String INDEX_CONFIG_FIELD = "cdb_index_config";
    @NotNull
    public static final String INDEX_DIRTY_FIELD = "cdb_index_dirty";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final StampedLock getCloseLock() {
        return this.closeLock;
    }

    @NotNull
    protected final DB getStore() {
        return this.store;
    }

    @NotNull
    protected final Atomic.Boolean getDirtyField() {
        return this.dirtyField;
    }

    @Override
    @NotNull
    public Name.IndexName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @Override
    @NotNull
    public Pair<ColumnDef<?>, SortOrder>[] getOrder() {
        return this.order;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public IndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean getDirty() {
        return this.dirtyField.get();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    protected void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            try {
                long stamp = this.closeLock.tryWriteLock(1000L, TimeUnit.MILLISECONDS);
                try {
                    this.store.close();
                    this.setClosed(true);
                }
                catch (Throwable e) {
                    this.closeLock.unlockWrite(stamp);
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw (Throwable)new IllegalStateException("Could not close index " + this.getName() + ". Failed to acquire exclusive lock which indicates, that some Tx wasn't closed properly.");
            }
        }
    }

    @Override
    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public final Entity getParent() {
        return this.parent;
    }

    public AbstractIndex(@NotNull Path path, @NotNull Entity parent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        this.closeLock = new StampedLock();
        this.store = this.parent.getParent().getParent().getConfig().getMapdb().db(this.path);
        this.headerField = (Atomic.Var)this.store.atomicVar(INDEX_HEADER_FIELD, (Serializer)IndexHeader.Serializer).createOrOpen();
        this.dirtyField = (Atomic.Boolean)this.store.atomicBoolean(INDEX_DIRTY_FIELD).createOrOpen();
        this.name = this.parent.getName().index(((IndexHeader)this.headerField.get()).getName());
        this.columns = ((IndexHeader)this.headerField.get()).getColumns();
        this.order = new Pair[0];
        this.version = DBOVersion.V2_0;
        this.config = NoIndexConfig.INSTANCE;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00170\u00160\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\fR\u001b\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006,"}, d2={"Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/AbstractIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "dbo", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "getDbo", "()Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "name", "Lorg/vitrivr/cottontail/model/basics/Name;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name;", "order", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "getOrder", "()[Lkotlin/Pair;", "produces", "getProduces", "snapshot", "Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "snapshot$delegate", "Lkotlin/Lazy;", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cleanup", "", "cottontaildb"})
    protected abstract class Tx
    extends AbstractTx
    implements IndexTx {
        private final long closeStamp;
        @NotNull
        private final Lazy snapshot$delegate;

        @Override
        @NotNull
        public AbstractIndex getDbo() {
            return AbstractIndex.this;
        }

        @Override
        @NotNull
        public Name getName() {
            return AbstractIndex.this.getName();
        }

        @Override
        @NotNull
        public ColumnDef<?>[] getColumns() {
            return AbstractIndex.this.getColumns();
        }

        @Override
        @NotNull
        public ColumnDef<?>[] getProduces() {
            return AbstractIndex.this.getProduces();
        }

        @Override
        @NotNull
        public Pair<ColumnDef<?>, SortOrder>[] getOrder() {
            return AbstractIndex.this.getOrder();
        }

        @Override
        @NotNull
        public IndexType getType() {
            return AbstractIndex.this.getType();
        }

        @Override
        @NotNull
        public TxSnapshot getSnapshot() {
            Lazy lazy = this.snapshot$delegate;
            Tx tx = this;
            Object var3_3 = null;
            boolean bl = false;
            return (TxSnapshot)lazy.getValue();
        }

        @Override
        public boolean canProcess(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return AbstractIndex.this.canProcess(predicate);
        }

        @Override
        protected void cleanup() {
            AbstractIndex.this.getCloseLock().unlock(this.closeStamp);
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.closeStamp = AbstractIndex.this.getCloseLock().readLock();
            this.snapshot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<snapshot.1>(this){
                final /* synthetic */ Tx this$0;

                @NotNull
                public final snapshot.1 invoke() {
                    return new TxSnapshot(this){
                        final /* synthetic */ snapshot.2 this$0;

                        public void commit() {
                            this.this$0.this$0.AbstractIndex.this.getStore().commit();
                        }

                        public void rollback() {
                            this.this$0.this$0.AbstractIndex.this.getStore().rollback();
                        }
                        {
                            this.this$0 = this$0;
                        }
                    };
                }
                {
                    this.this$0 = tx;
                    super(0);
                }
            }));
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/database/index/AbstractIndex$Companion;", "", "()V", "INDEX_CONFIG_FIELD", "", "INDEX_DIRTY_FIELD", "INDEX_HEADER_FIELD", "initialize", "", "path", "Ljava/nio/file/Path;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/index/IndexType;[Lorg/vitrivr/cottontail/database/column/ColumnDef;Lorg/vitrivr/cottontail/config/Config;)V", "cottontaildb"})
    public static final class Companion {
        public final void initialize(@NotNull Path path, @NotNull Name.IndexName name, @NotNull IndexType type, @NotNull ColumnDef<?>[] columns, @NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (Files.exists(path, new LinkOption[0])) {
                throw (Throwable)new DatabaseException.InvalidFileException("Could not initialize index. A file already exists under " + path + '.');
            }
            DB db = config.getMapdb().db(path);
            Atomic.Var header = (Atomic.Var)db.atomicVar(AbstractIndex.INDEX_HEADER_FIELD, (Serializer)IndexHeader.Serializer).create();
            header.set((Object)new IndexHeader(name.getSimple(), type, columns, 0L, 0L, 24, null));
            db.commit();
            db.close();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

