/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.hash;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.ComparisonOperator;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0002%&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nj\u0002`\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;)V", "map", "Lorg/mapdb/HTreeMap;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "produces", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class UniqueHashIndex
extends AbstractIndex {
    @NotNull
    private final IndexType type;
    @NotNull
    private final ColumnDef<?>[] produces;
    private final HTreeMap<Value, Long> map;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    public static final String UQ_INDEX_MAP = "cdb_uq_map";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof BooleanPredicate.Atomic.Literal && !((BooleanPredicate.Atomic.Literal)predicate).getNot() && Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) && (((BooleanPredicate.Atomic.Literal)predicate).getOperator() instanceof ComparisonOperator.In || ((BooleanPredicate.Atomic.Literal)predicate).getOperator() instanceof ComparisonOperator.Binary.Equal);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Cost cost;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate.Atomic.Literal) || Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) ^ true || ((BooleanPredicate.Atomic.Literal)predicate).getNot()) {
            cost = Cost.Companion.getINVALID();
        } else if (((BooleanPredicate.Atomic.Literal)predicate).getOperator() instanceof ComparisonOperator.Binary.Equal) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = predicate.getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS();
            float f2 = 1.0E-4f;
            boolean $i$f$map = false;
            void var4_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColumnDef columnDef = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getType().getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            float f3 = CollectionsKt.sumOfInt((Iterable)collection);
            float f4 = f;
            float f5 = f2;
            cost = new Cost(f5, f4, f3);
        } else if (((BooleanPredicate.Atomic.Literal)predicate).getOperator() instanceof ComparisonOperator.In) {
            Collection<Integer> collection;
            Iterable $this$map$iv = predicate.getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS() * (float)((ComparisonOperator.In)((BooleanPredicate.Atomic.Literal)predicate).getOperator()).getRight().size();
            float f6 = 1.0E-4f * (float)((ComparisonOperator.In)((BooleanPredicate.Atomic.Literal)predicate).getOperator()).getRight().size();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ColumnDef it = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getType().getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            float f7 = CollectionsKt.sumOfInt((Iterable)collection);
            float f8 = f;
            float f9 = f6;
            cost = new Cost(f9, f8, f7);
        } else {
            cost = Cost.Companion.getINVALID();
        }
        return cost;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    public UniqueHashIndex(@NotNull Path path, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        this.type = IndexType.HASH_UQ;
        this.produces = this.getColumns();
        DB dB = this.getStore();
        Serializer serializer2 = this.getColumns()[0].getType().serializerFactory().mapdb(this.getColumns()[0].getType().getLogicalSize());
        GroupSerializer groupSerializer = Serializer.LONG_DELTA;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.LONG_DELTA");
        HTreeMap hTreeMap = dB.hashMap(UQ_INDEX_MAP, serializer2, (Serializer)groupSerializer).createOrOpen();
        if (hTreeMap == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.mapdb.HTreeMap<org.vitrivr.cottontail.model.values.types.Value, org.vitrivr.cottontail.model.basics.TupleId /* = kotlin.Long */>");
        }
        this.map = hTreeMap;
        this.supportsIncrementalUpdate = true;
        this.getStore().commit();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "addMapping", "", "key", "Lorg/vitrivr/cottontail/model/values/types/Value;", "tupleId", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "clear", "", "count", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "removeMapping", "update", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        private final boolean addMapping(Value key, long tupleId) {
            return UniqueHashIndex.this.map.putIfAbsentBoolean((Object)key, (Object)tupleId);
        }

        private final boolean removeMapping(Value key) {
            return UniqueHashIndex.this.map.remove((Object)key) != null;
        }

        @Override
        public long count() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            Map map2 = (Map)UniqueHashIndex.this.map;
            boolean bl2 = false;
            return map2.size();
        }

        @Override
        public void rebuild() {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
            if (tx == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
            }
            EntityTx entityTx = (EntityTx)tx;
            UniqueHashIndex.this.map.clear();
            Iterator<Record> $this$forEach$iv = entityTx.scan(UniqueHashIndex.this.getColumns());
            boolean $i$f$forEach = false;
            Iterator<Record> iterator2 = $this$forEach$iv;
            boolean bl2 = false;
            Iterator<Record> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Value value;
                Record element$iv;
                Record record = element$iv = iterator3.next();
                boolean bl3 = false;
                if (record.get(this.getColumns()[0]) == null) {
                    throw (Throwable)new TxException.TxValidationException(this.getContext().getTxId(), "Value cannot be null for UniqueHashIndex " + UniqueHashIndex.this.getName() + " given value is (value = null, tupleId = " + record.getTupleId() + ").");
                }
                if (this.addMapping(value, record.getTupleId())) continue;
                throw (Throwable)new TxException.TxValidationException(this.getContext().getTxId(), "Value must be unique for UniqueHashIndex " + UniqueHashIndex.this.getName() + " but is not (value = " + value + ", tupleId = " + record.getTupleId() + ").");
            }
        }

        @Override
        public void update(@NotNull DataChangeEvent event) {
            Value old;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            DataChangeEvent dataChangeEvent = event;
            if (dataChangeEvent instanceof DataChangeEvent.InsertDataChangeEvent) {
                Value value = ((DataChangeEvent.InsertDataChangeEvent)event).getInserts().get(this.getColumns()[0]);
                if (value != null) {
                    this.addMapping(value, event.getTupleId());
                }
            } else if (dataChangeEvent instanceof DataChangeEvent.UpdateDataChangeEvent) {
                Value value;
                Value old2;
                Pair<Value, Value> pair = ((DataChangeEvent.UpdateDataChangeEvent)event).getUpdates().get(this.getColumns()[0]);
                Value value2 = old2 = pair != null ? (Value)pair.getFirst() : null;
                if (old2 != null) {
                    this.removeMapping(old2);
                }
                Pair<Value, Value> pair2 = ((DataChangeEvent.UpdateDataChangeEvent)event).getUpdates().get(this.getColumns()[0]);
                Value value3 = value = pair2 != null ? (Value)pair2.getSecond() : null;
                if (value != null) {
                    this.addMapping(value, event.getTupleId());
                }
            } else if (dataChangeEvent instanceof DataChangeEvent.DeleteDataChangeEvent && (old = ((DataChangeEvent.DeleteDataChangeEvent)event).getDeleted().get(this.getColumns()[0])) != null) {
                this.removeMapping(old);
            }
        }

        @Override
        public void clear() {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            UniqueHashIndex.this.getDirtyField().compareAndSet(false, true);
            UniqueHashIndex.this.map.clear();
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(this, predicate){
                private final BooleanPredicate.Atomic.Literal predicate;
                private final LinkedList<Value> elements;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                public boolean hasNext() {
                    while (true) {
                        Object object = this.elements;
                        boolean bl = false;
                        if (!(!object.isEmpty())) break;
                        object = (Map)UniqueHashIndex.access$getMap$p(this.this$0.UniqueHashIndex.this);
                        Value value = this.elements.peek();
                        boolean bl2 = false;
                        Object object2 = object;
                        boolean bl3 = false;
                        if (object2.containsKey(value)) {
                            return true;
                        }
                        this.elements.remove();
                    }
                    return false;
                }

                @NotNull
                public Record next() {
                    Value value = this.elements.poll();
                    Object object = UniqueHashIndex.access$getMap$p(this.this$0.UniqueHashIndex.this).get((Object)value);
                    Intrinsics.checkNotNull((Object)object);
                    long tid = ((Number)object).longValue();
                    return new StandaloneRecord(tid, this.this$0.UniqueHashIndex.this.getProduces(), new Value[]{value});
                }
                {
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    this.elements = new LinkedList<E>();
                    boolean bl = $captured_local_variable$1 instanceof BooleanPredicate.Atomic.Literal;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "UniqueHashIndex.filter() does only support Atomic.Literal boolean predicates.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    bl = !((BooleanPredicate.Atomic.Literal)$captured_local_variable$1).getNot();
                    bl2 = false;
                    bl3 = false;
                    if (!bl) {
                        boolean bl5 = false;
                        String string = "UniqueHashIndex.filter() does not support negated statements (i.e. NOT EQUALS or NOT IN).";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    AbstractTx this_$iv = this$0;
                    boolean $i$f$withReadLock2 = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                        this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    }
                    boolean bl6 = false;
                    this.predicate = (BooleanPredicate.Atomic.Literal)$captured_local_variable$1;
                    ComparisonOperator comparisonOperator = ((BooleanPredicate.Atomic.Literal)$captured_local_variable$1).getOperator();
                    if (comparisonOperator instanceof ComparisonOperator.In) {
                        Collection<Value> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable $i$f$withReadLock2 = ((ComparisonOperator.In)((BooleanPredicate.Atomic.Literal)$captured_local_variable$1).getOperator()).getRight();
                        LinkedList<Value> linkedList = this.elements;
                        boolean $i$f$map = false;
                        void bl5 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Binding binding = (Binding)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl7 = false;
                            Value value = (Value)it.getValue();
                            collection.add(value);
                        }
                        collection = (List)destination$iv$iv;
                        linkedList.addAll(collection);
                    } else if (comparisonOperator instanceof ComparisonOperator.Binary.Equal) {
                        this.elements.add(((ComparisonOperator.Binary.Equal)((BooleanPredicate.Atomic.Literal)$captured_local_variable$1).getOperator()).getRight().getValue());
                    } else {
                        throw (Throwable)new IllegalArgumentException("UniqueHashIndex.filter() does only support EQUAL and IN operators.");
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw (Throwable)new UnsupportedOperationException("The UniqueHashIndex does not support ranged filtering!");
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(UniqueHashIndex.this, context);
        }

        public static final /* synthetic */ Object access$withReadLock(Tx $this, Function0 block) {
            return $this.withReadLock(block);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex$Companion;", "", "()V", "UQ_INDEX_MAP", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

