/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.va;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.IndexTreeList;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.va.VAFIndex;
import org.vitrivr.cottontail.database.index.va.VAFIndexConfig;
import org.vitrivr.cottontail.database.index.va.bounds.Bounds;
import org.vitrivr.cottontail.database.index.va.bounds.L1Bounds;
import org.vitrivr.cottontail.database.index.va.bounds.L2Bounds;
import org.vitrivr.cottontail.database.index.va.bounds.L2SBounds;
import org.vitrivr.cottontail.database.index.va.bounds.LpBounds;
import org.vitrivr.cottontail.database.index.va.signature.Marks;
import org.vitrivr.cottontail.database.index.va.signature.MarksGenerator;
import org.vitrivr.cottontail.database.index.va.signature.VAFSignature;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.knn.KnnPredicate;
import org.vitrivr.cottontail.database.statistics.columns.DoubleVectorValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.FloatVectorValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.IntVectorValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.LongVectorValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.math.knn.metrics.DistanceKernel;
import org.vitrivr.cottontail.math.knn.metrics.EuclidianDistance;
import org.vitrivr.cottontail.math.knn.metrics.ManhattanDistance;
import org.vitrivr.cottontail.math.knn.metrics.MinkowskiDistance;
import org.vitrivr.cottontail.math.knn.metrics.SquaredEuclidianDistance;
import org.vitrivr.cottontail.math.knn.selection.ComparablePair;
import org.vitrivr.cottontail.math.knn.selection.MinHeapSelection;
import org.vitrivr.cottontail.math.knn.selection.MinSingleSelection;
import org.vitrivr.cottontail.math.knn.selection.Selection;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.types.RealVectorValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;
import org.vitrivr.cottontail.utilities.math.KnnUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0002*+B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lorg/vitrivr/cottontail/database/index/va/VAFIndex;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/database/index/va/VAFIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/database/index/va/VAFIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/database/index/va/VAFIndexConfig;", "marksStore", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/index/va/signature/Marks;", "produces", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "signatures", "Lorg/mapdb/IndexTreeList;", "Lorg/vitrivr/cottontail/database/index/va/signature/VAFSignature;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class VAFIndex
extends AbstractIndex {
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final IndexType type;
    @NotNull
    private final VAFIndexConfig config;
    private final Atomic.Var<Marks> marksStore;
    private final IndexTreeList<VAFSignature> signatures;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    private static final String VAF_INDEX_SIGNATURES_FIELD = "vaf_signatures";
    private static final String VAF_INDEX_MARKS_FIELD = "vaf_marks";
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public VAFIndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Cost cost;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (predicate instanceof KnnPredicate && Intrinsics.areEqual(((KnnPredicate)predicate).getColumn(), this.getColumns()[0]) && (((KnnPredicate)predicate).getDistance() instanceof MinkowskiDistance || ((KnnPredicate)predicate).getDistance() instanceof SquaredEuclidianDistance)) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ColumnDef<?>[] columnDefArray = this.getProduces();
            float f = ((KnnPredicate)predicate).getK();
            float f2 = (float)(this.signatures.size() * Marks.getD-impl(((Marks)this.marksStore.get()).unbox-impl())) * ((float)2 * Cost.Companion.getCOST_MEMORY_ACCESS() + Cost.Companion.getCOST_FLOP()) + 0.1f * (float)this.signatures.size() * predicate.getAtomicCpuCost();
            float f3 = (float)(this.signatures.size() * Marks.getD-impl(((Marks)this.marksStore.get()).unbox-impl())) * 1.0E-4f + 0.1f * ((float)(this.signatures.size() * this.getColumns()[0].getType().getPhysicalSize()) * 1.0E-4f);
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var7_10 = $this$mapTo$iv$iv;
            int n = ((void)var7_10).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_14 = item$iv$iv = var7_10[i];
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n2 = it.getType().getPhysicalSize();
                collection.add(n2);
            }
            collection = (List)destination$iv$iv;
            float f4 = f * (float)CollectionsKt.sumOfInt((Iterable)collection);
            float f5 = f2;
            float f6 = f3;
            cost = new Cost(f6, f5, f4);
        } else {
            cost = Cost.Companion.getINVALID();
        }
        return cost;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof KnnPredicate && Intrinsics.areEqual(((KnnPredicate)predicate).getColumn(), this.getColumns()[0]);
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    public VAFIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable VAFIndexConfig config) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        this.produces = new ColumnDef[]{KnnUtilities.INSTANCE.distanceColumnDef(this.getParent().getName())};
        this.type = IndexType.VAF;
        this.marksStore = (Atomic.Var)this.getStore().atomicVar(VAF_INDEX_MARKS_FIELD, (Serializer)Marks.Serializer).createOrOpen();
        this.signatures = (IndexTreeList)this.getStore().indexTreeList(VAF_INDEX_SIGNATURES_FIELD, (Serializer)VAFSignature.Serializer).createOrOpen();
        boolean bl = this.getColumns().length == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Companion + " only supports indexing a single column.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar("cdb_index_config", (Serializer)VAFIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            this.config = config != null ? config : new VAFIndexConfig(50);
            configOnDisk.set((Object)this.getConfig());
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (VAFIndexConfig)object;
        }
        this.getStore().commit();
        this.supportsPartitioning = true;
    }

    public /* synthetic */ VAFIndex(Path path, DefaultEntity defaultEntity, VAFIndexConfig vAFIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            vAFIndexConfig = null;
        }
        this(path, defaultEntity, vAFIndexConfig);
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(VAFIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(VAFIndex::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/database/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/va/VAFIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "clear", "", "count", "", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        @Override
        public long count() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return VAFIndex.this.signatures.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            int[] nArray;
            Value value;
            Record r;
            int n;
            boolean bl;
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl2 = false;
            Companion.getLOGGER().debug("Rebuilding VAF index {}", (Object)VAFIndex.this.getName());
            org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(VAFIndex.this.getParent());
            if (tx == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
            }
            EntityTx txn = (EntityTx)tx;
            ValueStatistics<?> stat = this.getDbo().getParent().getStatistics().get(VAFIndex.this.getColumns()[0]);
            double[] min = new double[VAFIndex.this.getColumns()[0].getType().getLogicalSize()];
            double[] max = new double[VAFIndex.this.getColumns()[0].getType().getLogicalSize()];
            ValueStatistics<?> valueStatistics = stat;
            if (valueStatistics instanceof FloatVectorValueStatistics) {
                int n2 = min.length;
                bl = false;
                int n3 = 0;
                n3 = 0;
                n = n2;
                while (n3 < n) {
                    int it = n3++;
                    boolean bl3 = false;
                    min[it] = ((FloatVectorValueStatistics)stat).getMin-3wzOJwo()[it];
                    max[it] = ((FloatVectorValueStatistics)stat).getMax-3wzOJwo()[it];
                }
            } else if (valueStatistics instanceof DoubleVectorValueStatistics) {
                int n4 = min.length;
                bl = false;
                int n5 = 0;
                n5 = 0;
                n = n4;
                while (n5 < n) {
                    int it = n5++;
                    boolean bl4 = false;
                    min[it] = ((DoubleVectorValueStatistics)stat).getMin-Jz4_OW8()[it];
                    max[it] = ((DoubleVectorValueStatistics)stat).getMax-Jz4_OW8()[it];
                }
            } else if (valueStatistics instanceof IntVectorValueStatistics) {
                int n6 = min.length;
                bl = false;
                int n7 = 0;
                n7 = 0;
                n = n6;
                while (n7 < n) {
                    int it = n7++;
                    boolean bl5 = false;
                    min[it] = ((IntVectorValueStatistics)stat).getMin-bSjjh_E()[it];
                    max[it] = ((IntVectorValueStatistics)stat).getMax-bSjjh_E()[it];
                }
            } else if (valueStatistics instanceof LongVectorValueStatistics) {
                int n8 = min.length;
                bl = false;
                int n9 = 0;
                n9 = 0;
                n = n8;
                while (n9 < n) {
                    int it = n9++;
                    boolean bl6 = false;
                    min[it] = ((LongVectorValueStatistics)stat).getMin-8fdD9LQ()[it];
                    max[it] = ((LongVectorValueStatistics)stat).getMax-8fdD9LQ()[it];
                }
            } else {
                Iterator<Record> $this$forEach$iv = txn.scan(VAFIndex.this.getColumns());
                boolean $i$f$forEach = false;
                Iterator<Record> iterator2 = $this$forEach$iv;
                n = 0;
                Iterator<Record> it = iterator2;
                while (it.hasNext()) {
                    Record element$iv;
                    r = element$iv = it.next();
                    boolean bl7 = false;
                    Value value2 = r.get(VAFIndex.this.getColumns()[0]);
                    if (value2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.types.VectorValue<*>");
                    }
                    value = (VectorValue)value2;
                    int n10 = 0;
                    int n11 = value.getLogicalSize();
                    while (n10 < n11) {
                        void i;
                        double d = min[i];
                        double d2 = value.get((int)i).asDouble-Z2rTJmk();
                        boolean bl8 = false;
                        min[i] = Math.min(d, d2);
                        d = max[i];
                        d2 = value.get((int)i).asDouble-Z2rTJmk();
                        bl8 = false;
                        max[i] = Math.max(d, d2);
                        ++i;
                    }
                }
            }
            int $this$forEach$iv = VAFIndex.this.getColumns()[0].getType().getLogicalSize();
            double[] dArray = max;
            double[] dArray2 = min;
            MarksGenerator marksGenerator = MarksGenerator.INSTANCE;
            int[] $i$f$forEach = new int[$this$forEach$iv];
            int n12 = 0;
            while (n12 < $this$forEach$iv) {
                int n13;
                n = n12;
                int n14 = n12++;
                nArray = $i$f$forEach;
                boolean bl9 = false;
                nArray[n14] = n13 = VAFIndex.this.getConfig().getMarksPerDimension();
            }
            nArray = $i$f$forEach;
            double[][] marks = marksGenerator.getEquidistantMarks-SYtBgYA(dArray2, dArray, nArray);
            VAFIndex.this.marksStore.set((Object)Marks.box-impl(marks));
            VAFIndex.this.signatures.clear();
            Iterator<Record> $this$forEach$iv2 = txn.scan(VAFIndex.this.getColumns());
            boolean $i$f$forEach2 = false;
            Iterator<Record> iterator3 = $this$forEach$iv2;
            n = 0;
            Iterator<Record> iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Record element$iv;
                r = element$iv = iterator4.next();
                boolean bl10 = false;
                value = r.get(VAFIndex.this.getColumns()[0]);
                if (!(value instanceof RealVectorValue)) continue;
                VAFIndex.this.signatures.add((Object)new VAFSignature(r.getTupleId(), Marks.getCells-impl(marks, (RealVectorValue)value)));
            }
            VAFIndex.this.getDirtyField().compareAndSet(true, false);
            Companion.getLOGGER().debug("Done rebuilding VAF index {}", (Object)VAFIndex.this.getName());
        }

        @Override
        public void update(@NotNull DataChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            VAFIndex.this.getDirtyField().compareAndSet(false, true);
        }

        @Override
        public void clear() {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            VAFIndex.this.getDirtyField().compareAndSet(false, true);
            VAFIndex.this.signatures.clear();
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return this.filterRange(predicate, 0, 1);
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(this, predicate, partitions, partitionIndex){
                private final KnnPredicate predicate;
                private final RealVectorValue<?> query;
                private final double[][] marks;
                private final Bounds bounds;
                private final Lazy resultsQueue$delegate;
                private final IntRange range;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ int $partitions;
                final /* synthetic */ int $partitionIndex;

                private final ArrayDeque<StandaloneRecord> getResultsQueue() {
                    Lazy lazy = this.resultsQueue$delegate;
                    filterRange.1 var2_2 = this;
                    Object var3_3 = null;
                    boolean bl = false;
                    return (ArrayDeque)lazy.getValue();
                }

                public boolean hasNext() {
                    Collection collection = (Collection)this.getResultsQueue();
                    boolean bl = false;
                    return !collection.isEmpty();
                }

                @NotNull
                public Record next() {
                    return (Record)this.getResultsQueue().removeFirst();
                }

                /*
                 * WARNING - void declaration
                 */
                private final ArrayDeque<StandaloneRecord> prepareResults() {
                    long read2;
                    Selection knn;
                    block7: {
                        int n;
                        org.vitrivr.cottontail.database.general.Tx tx = this.this$0.getContext().getTx(this.this$0.VAFIndex.this.getParent());
                        if (tx == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
                        }
                        EntityTx txn = (EntityTx)tx;
                        knn = this.predicate.getK() == 1 ? (Selection)new MinSingleSelection<T>() : (Selection)new MinHeapSelection<T>(this.predicate.getK());
                        read2 = 0L;
                        IntRange intRange = this.range;
                        int n2 = intRange.getFirst();
                        if (n2 > (n = intRange.getLast())) break block7;
                        while (true) {
                            void sigIndex;
                            block8: {
                                Value value;
                                VAFSignature signature;
                                block9: {
                                    if ((signature = (VAFSignature)VAFIndex.access$getSignatures$p(this.this$0.VAFIndex.this).get((int)sigIndex)) == null) break block8;
                                    if (knn.getSize() < this.predicate.getK()) break block9;
                                    T t = knn.peek();
                                    Intrinsics.checkNotNull(t);
                                    if (!this.bounds.isVASSACandidate(signature, ((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl())) break block8;
                                }
                                if ((value = txn.read(signature.getTupleId(), this.this$0.VAFIndex.this.getColumns()).get(this.this$0.VAFIndex.this.getColumns()[0])) instanceof VectorValue) {
                                    knn.offer((Comparable)new ComparablePair<Long, DoubleValue>(signature.getTupleId(), DoubleValue.box-impl(this.predicate.getDistance().invoke-JjrrKLw((VectorValue)value, (VectorValue)this.query))));
                                }
                                ++read2;
                            }
                            if (sigIndex == n) break;
                            ++sigIndex;
                        }
                    }
                    double skipped = (1.0 - (double)read2 / (double)VAFIndex.access$getSignatures$p(this.this$0.VAFIndex.this).size()) * (double)100;
                    VAFIndex.Companion.getLOGGER().debug("VA-file scan: Skipped over " + skipped + "% of entries.");
                    ArrayDeque queue = new ArrayDeque(this.predicate.getK());
                    int value = 0;
                    int n = knn.getSize();
                    while (value < n) {
                        void i;
                        queue.add((Object)new StandaloneRecord(((Number)((ComparablePair)knn.get((int)i)).getFirst()).longValue(), this.this$0.VAFIndex.this.getProduces(), new Value[]{(Value)((ComparablePair)knn.get((int)i)).getSecond()}));
                        ++i;
                    }
                    return queue;
                }
                {
                    Bounds bounds;
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    this.$partitions = $captured_local_variable$2;
                    this.$partitionIndex = $captured_local_variable$3;
                    if (!($captured_local_variable$1 instanceof KnnPredicate)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.VAFIndex.this.getName() + "' (VAF Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (KnnPredicate)$captured_local_variable$1;
                    Marks marks = (Marks)VAFIndex.access$getMarksStore$p(this$0.VAFIndex.this).get();
                    this.marks = (double[][])(marks != null ? marks.unbox-impl() : null);
                    this.resultsQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayDeque<StandaloneRecord>>(this){
                        final /* synthetic */ filterRange.1 this$0;

                        @NotNull
                        public final ArrayDeque<StandaloneRecord> invoke() {
                            return filterRange.1.access$prepareResults(this.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    AbstractTx this_$iv = this$0;
                    boolean $i$f$withReadLock22 = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                        this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    }
                    boolean bl = false;
                    Value value = this.predicate.getQuery().getValue();
                    $i$f$withReadLock22 = value instanceof RealVectorValue;
                    int n = 0;
                    int n2 = 0;
                    if (!$i$f$withReadLock22) {
                        boolean bl2 = false;
                        String string = "Bound value for query vector has wrong type (found = " + value.getType() + ").";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    this.query = (RealVectorValue)value;
                    DistanceKernel $i$f$withReadLock22 = this.predicate.getDistance();
                    if ($i$f$withReadLock22 instanceof ManhattanDistance) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.marks, (String)"this.marks");
                        bounds = new L1Bounds(this.query, this.marks, null);
                    } else if ($i$f$withReadLock22 instanceof EuclidianDistance) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.marks, (String)"this.marks");
                        bounds = new L2Bounds(this.query, this.marks, null);
                    } else if ($i$f$withReadLock22 instanceof SquaredEuclidianDistance) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.marks, (String)"this.marks");
                        bounds = new L2SBounds(this.query, this.marks, null);
                    } else if ($i$f$withReadLock22 instanceof MinkowskiDistance) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.marks, (String)"this.marks");
                        bounds = new LpBounds(this.query, this.marks, ((MinkowskiDistance)this.predicate.getDistance()).getP(), null);
                    } else {
                        throw (Throwable)new IllegalArgumentException("The " + this.predicate.getDistance() + " distance kernel is not supported by VAFIndex.");
                    }
                    this.bounds = bounds;
                    int pSize = Math.floorDiv(VAFIndex.access$getSignatures$p(this$0.VAFIndex.this).size(), $captured_local_variable$2) + 1;
                    n = pSize * ($captured_local_variable$3 + 1);
                    n2 = VAFIndex.access$getSignatures$p(this$0.VAFIndex.this).size();
                    boolean bl3 = false;
                    this.range = RangesKt.until((int)(pSize * $captured_local_variable$3), (int)Math.min(n, n2));
                }

                public static final /* synthetic */ ArrayDeque access$prepareResults(filterRange.1 $this) {
                    return $this.prepareResults();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(VAFIndex.this, context);
        }

        public static final /* synthetic */ Object access$withReadLock(Tx $this, Function0 block) {
            return $this.withReadLock(block);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/database/index/va/VAFIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "VAF_INDEX_MARKS_FIELD", "", "VAF_INDEX_SIGNATURES_FIELD", "cottontaildb"})
    public static final class Companion {
        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

