/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.execution;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.Tx;
import org.vitrivr.cottontail.database.locking.DeadlockException;
import org.vitrivr.cottontail.database.locking.LockHolder;
import org.vitrivr.cottontail.database.locking.LockManager;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.TransactionStatus;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.ExecutionException;
import org.vitrivr.cottontail.model.exceptions.TransactionException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\u001b\u001a\b\u0018\u00010\u0012R\u00020\u00002\n\u0010\u001c\u001a\u00060\u0019j\u0002`\u001dH\u0086\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RE\u0010\u0010\u001a6\u0012\u0014\u0012\u0012 \u0013*\b\u0018\u00010\u0012R\u00020\u00000\u0012R\u00020\u0000 \u0013*\u001a\u0012\u0014\u0012\u0012 \u0013*\b\u0018\u00010\u0012R\u00020\u00000\u0012R\u00020\u0000\u0018\u00010\u00140\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R^\u0010\u0017\u001aR\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00190\u0019\u0012\u0014\u0012\u0012 \u0013*\b\u0018\u00010\u0012R\u00020\u00000\u0012R\u00020\u0000 \u0013*(\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00190\u0019\u0012\u0014\u0012\u0012 \u0013*\b\u0018\u00010\u0012R\u00020\u00000\u0012R\u00020\u0000\u0018\u00010\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/execution/TransactionManager;", "", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "transactionTableSize", "", "transactionHistorySize", "(Ljava/util/concurrent/ThreadPoolExecutor;II)V", "dispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "lockManager", "Lorg/vitrivr/cottontail/database/locking/LockManager;", "getLockManager", "()Lorg/vitrivr/cottontail/database/locking/LockManager;", "tidCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "transactionHistory", "", "Lorg/vitrivr/cottontail/execution/TransactionManager$Transaction;", "kotlin.jvm.PlatformType", "", "getTransactionHistory", "()Ljava/util/List;", "transactions", "", "", "", "get", "txId", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "Companion", "Transaction", "cottontaildb"})
public final class TransactionManager {
    private final ExecutorCoroutineDispatcher dispatcher;
    private final Map<Long, Transaction> transactions;
    private final AtomicLong tidCounter;
    @NotNull
    private final LockManager lockManager;
    private final List<Transaction> transactionHistory;
    private final ThreadPoolExecutor executor;
    private final int transactionHistorySize;
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final LockManager getLockManager() {
        return this.lockManager;
    }

    public final List<Transaction> getTransactionHistory() {
        return this.transactionHistory;
    }

    @Nullable
    public final Transaction get(long txId) {
        return this.transactions.get(txId);
    }

    public TransactionManager(@NotNull ThreadPoolExecutor executor, int transactionTableSize, int transactionHistorySize) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this.transactionHistorySize = transactionHistorySize;
        this.dispatcher = ExecutorsKt.from((ExecutorService)this.executor);
        this.transactions = Collections.synchronizedMap((Map)new Long2ObjectOpenHashMap(transactionTableSize, 0.25f));
        this.tidCounter = new AtomicLong();
        this.lockManager = new LockManager();
        this.transactionHistory = Collections.synchronizedList(new LinkedList());
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(TransactionManager.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0013H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020\u0013H\u0016J\u0018\u0010*\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010+\u001a\u00020)H\u0016J\u0006\u0010,\u001a\u00020\"J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u0018@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lorg/vitrivr/cottontail/execution/TransactionManager$Transaction;", "Lorg/vitrivr/cottontail/database/locking/LockHolder;", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "type", "Lorg/vitrivr/cottontail/execution/TransactionType;", "(Lorg/vitrivr/cottontail/execution/TransactionManager;Lorg/vitrivr/cottontail/execution/TransactionType;)V", "created", "", "getCreated", "()J", "<set-?>", "ended", "getEnded", "()Ljava/lang/Long;", "Ljava/lang/Long;", "finalizationLock", "Ljava/util/concurrent/locks/StampedLock;", "lockedDBOs", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lorg/vitrivr/cottontail/database/general/DBO;", "numberOfTxs", "", "getNumberOfTxs", "()I", "Lorg/vitrivr/cottontail/execution/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/execution/TransactionStatus;", "txns", "", "Lorg/vitrivr/cottontail/database/general/Tx;", "getType", "()Lorg/vitrivr/cottontail/execution/TransactionType;", "commit", "", "execute", "operator", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator$SinkOperator;", "getTx", "dbo", "lockOn", "Lorg/vitrivr/cottontail/database/locking/LockMode;", "requestLock", "mode", "rollback", "signalEvent", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    public final class Transaction
    extends LockHolder
    implements TransactionContext {
        @NotNull
        private volatile TransactionStatus state;
        private final Map<DBO, Tx> txns;
        private final ObjectOpenHashSet<DBO> lockedDBOs;
        private final StampedLock finalizationLock;
        private final long created;
        @Nullable
        private Long ended;
        @NotNull
        private final TransactionType type;

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        public final int getNumberOfTxs() {
            return this.txns.size();
        }

        public final long getCreated() {
            return this.created;
        }

        @Nullable
        public final Long getEnded() {
            return this.ended;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Tx getTx(@NotNull DBO dbo) {
            Tx tx;
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            StampedLock $this$read$iv = this.finalizationLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-TransactionManager$Transaction$getTx$22 = false;
                Tx $i$a$-read-TransactionManager$Transaction$getTx$22 = this.txns.computeIfAbsent(dbo, new Function<DBO, Tx>(this, dbo){
                    final /* synthetic */ Transaction this$0;
                    final /* synthetic */ DBO $dbo$inlined;
                    {
                        this.this$0 = transaction;
                        this.$dbo$inlined = dBO;
                    }

                    @NotNull
                    public final Tx apply(@NotNull DBO it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$dbo$inlined.newTx(this.this$0);
                    }
                });
                tx = $i$a$-read-TransactionManager$Transaction$getTx$22;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
            Intrinsics.checkNotNullExpressionValue((Object)tx, (String)"this.finalizationLock.re\u2026o.newTx(this) }\n        }");
            return tx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestLock(@NotNull DBO dbo, @NotNull LockMode mode) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            StampedLock $this$read$iv = this.finalizationLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                TransactionManager.this.getLockManager().lock(this, dbo, mode);
                this.lockedDBOs.add((Object)dbo);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public LockMode lockOn(@NotNull DBO dbo) {
            LockMode $i$a$-read-TransactionManager$Transaction$lockOn$22;
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            StampedLock $this$read$iv = this.finalizationLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-TransactionManager$Transaction$lockOn$22 = false;
                $i$a$-read-TransactionManager$Transaction$lockOn$22 = TransactionManager.this.getLockManager().lockOn(this, dbo);
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
            return $i$a$-read-TransactionManager$Transaction$lockOn$22;
        }

        @Override
        public void signalEvent(@NotNull DataChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute(@NotNull Operator.SinkOperator operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            StampedLock $this$read$iv = this.finalizationLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-TransactionManager$Transaction$execute$22 = false;
                BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)TransactionManager.this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, this, operator){
                    int label;
                    final /* synthetic */ Transaction this$0;
                    final /* synthetic */ Operator.SinkOperator $operator$inlined;
                    {
                        this.this$0 = transaction;
                        this.$operator$inlined = sinkOperator;
                        super(2, continuation);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                Transaction.access$setState$p(this.this$0, TransactionStatus.RUNNING);
                                this.label = 1;
                                v0 = FlowKt.collect(this.$operator$inlined.toFlow(this.this$0), (Continuation)this);
                                ** if (v0 != var2_2) goto lbl13
lbl-1000:
                                // 1 sources

                                {
                                    var3_3 = var2_2;
                                    return var3_3;
                                }
lbl13:
                                // 1 sources

                                ** GOTO lbl19
                            }
                            case 1: {
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl19:
                                    // 2 sources

                                    Transaction.access$setState$p(this.this$0, TransactionStatus.READY);
                                }
                                catch (DeadlockException e) {
                                    throw (Throwable)new TransactionException.DeadlockException(this.this$0.getTxId(), e);
                                }
                                catch (ExecutionException.OperatorExecutionException e) {
                                    throw (Throwable)e;
                                }
                                catch (DatabaseException e) {
                                    throw (Throwable)e;
                                }
                                catch (Throwable e) {
                                    throw e;
                                }
                                finally {
                                    Transaction.access$setState$p(this.this$0, TransactionStatus.ERROR);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                Unit $i$a$-read-TransactionManager$Transaction$execute$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void commit() {
            StampedLock $this$write$iv = this.finalizationLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                boolean $i$a$-write-TransactionManager$Transaction$commit$22 = false;
                boolean bl = this.getState() == TransactionStatus.READY;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Cannot commit transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                this.state = TransactionStatus.FINALIZING;
                try {
                    $this$forEach$iv = this.txns.values();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Tx txn = (Tx)element$iv;
                        boolean bl5 = false;
                        txn.commit();
                        txn.close();
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("An error occurred while committing transaction " + this.getTxId() + ". This is probably serious!", e);
                }
                finally {
                    $this$forEach$iv = (Iterable)this.lockedDBOs;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DBO it = (DBO)element$iv;
                        boolean bl6 = false;
                        LockManager lockManager = TransactionManager.this.getLockManager();
                        LockHolder lockHolder = this;
                        DBO dBO = it;
                        Intrinsics.checkNotNullExpressionValue((Object)dBO, (String)"it");
                        lockManager.unlock(lockHolder, dBO);
                    }
                    this.txns.clear();
                    this.lockedDBOs.clear();
                    this.ended = System.currentTimeMillis();
                    this.state = TransactionStatus.COMMIT;
                    TransactionManager.this.transactions.remove(this.getTxId());
                }
                Unit $i$a$-write-TransactionManager$Transaction$commit$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void rollback() {
            StampedLock $this$write$iv = this.finalizationLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                boolean $i$a$-write-TransactionManager$Transaction$rollback$22 = false;
                boolean bl = this.getState() == TransactionStatus.READY || this.getState() == TransactionStatus.ERROR;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Cannot rollback transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                this.state = TransactionStatus.FINALIZING;
                try {
                    $this$forEach$iv = this.txns.values();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Tx txn = (Tx)element$iv;
                        boolean bl5 = false;
                        txn.rollback();
                        txn.close();
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("An error occurred while rolling back transaction " + this.getTxId() + ". This is probably serious!", e);
                }
                finally {
                    $this$forEach$iv = (Iterable)this.lockedDBOs;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DBO it = (DBO)element$iv;
                        boolean bl6 = false;
                        LockManager lockManager = TransactionManager.this.getLockManager();
                        LockHolder lockHolder = this;
                        DBO dBO = it;
                        Intrinsics.checkNotNullExpressionValue((Object)dBO, (String)"it");
                        lockManager.unlock(lockHolder, dBO);
                    }
                    this.txns.clear();
                    this.lockedDBOs.clear();
                    this.ended = System.currentTimeMillis();
                    this.state = TransactionStatus.ROLLBACK;
                    TransactionManager.this.transactions.remove(this.getTxId());
                }
                Unit $i$a$-write-TransactionManager$Transaction$rollback$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        public Transaction(TransactionType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(TransactionManager.this.tidCounter.getAndIncrement());
            this.type = type;
            this.state = TransactionStatus.READY;
            Object2ObjectMap object2ObjectMap = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap, (String)"Object2ObjectMaps.synchr\u2026bjectLinkedOpenHashMap())");
            this.txns = (Map)object2ObjectMap;
            this.lockedDBOs = new ObjectOpenHashSet();
            this.finalizationLock = new StampedLock();
            this.created = System.currentTimeMillis();
            Map map2 = TransactionManager.this.transactions;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"this@TransactionManager.transactions");
            map2.put(this.getTxId(), this);
            TransactionManager.this.getTransactionHistory().add(this);
            if (TransactionManager.this.getTransactionHistory().size() >= TransactionManager.this.transactionHistorySize) {
                TransactionManager.this.getTransactionHistory().remove(0);
            }
        }

        public static final /* synthetic */ TransactionStatus access$getState$p(Transaction $this) {
            return $this.getState();
        }

        public static final /* synthetic */ void access$setState$p(Transaction $this, TransactionStatus transactionStatus) {
            $this.state = transactionStatus;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/execution/TransactionManager$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

