/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.schema;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxSnapshot;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.database.schema.SchemaTx;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.legacy.v1.catalogue.CatalogueV1;
import org.vitrivr.cottontail.legacy.v1.entity.EntityV1;
import org.vitrivr.cottontail.legacy.v1.schema.SchemaV1;
import org.vitrivr.cottontail.legacy.v1.schema.SchemaV1Header;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006-"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "Lorg/vitrivr/cottontail/database/schema/Schema;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "parent", "Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;", "(Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "header", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1Header;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "getParent", "()Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;", "path", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class SchemaV1
implements Schema {
    private final Path path;
    private final CottontailStoreWAL store;
    private final StampedLock closeLock;
    private final Map<Name.EntityName, EntityV1> registry;
    private volatile boolean closed;
    @NotNull
    private final Name.SchemaName name;
    @NotNull
    private final CatalogueV1 parent;
    public static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final String FILE_CATALOGUE = "index.db";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public Path getPath() {
        return this.path;
    }

    private final SchemaV1Header getHeader() {
        SchemaV1Header schemaV1Header = (SchemaV1Header)this.store.get(1L, SchemaV1Header.Serializer);
        if (schemaV1Header == null) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open header of schema " + this.getName() + '!');
        }
        return schemaV1Header;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public SchemaTx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean $i$a$-read-SchemaV1$close$22 = false;
            if (!this.getClosed()) {
                this.registry.entrySet().removeIf(close.1.1.INSTANCE);
                this.store.close();
                this.closed = true;
            }
            Unit $i$a$-read-SchemaV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public Name.SchemaName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public CatalogueV1 getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public SchemaV1(@NotNull Name.SchemaName name, @NotNull CatalogueV1 parent) {
        void $this$mapTo$iv$iv;
        CottontailStoreWAL cottontailStoreWAL;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        this.path = this.getParent().getPath().resolve("schema_" + this.getName().getSimple());
        Object object = this;
        try {
            SchemaV1 schemaV1 = object;
            MapDBConfig mapDBConfig = this.getParent().getConfig().getMapdb();
            Path path = this.getPath().resolve(FILE_CATALOGUE);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.path.resolve(FILE_CATALOGUE)");
            cottontailStoreWAL = mapDBConfig.store(path);
        }
        catch (DBException dBException) {
            void e;
            SchemaV1 schemaV1 = object;
            throw (Throwable)new DatabaseException("Failed to open schema " + this.getName() + " at '" + this.getPath() + "': " + e.getMessage() + '\'');
        }
        schemaV1.store = cottontailStoreWAL;
        this.closeLock = new StampedLock();
        Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.synchronized\u2026ject2ObjectOpenHashMap())");
        this.registry = map2;
        long[] $this$map$iv = this.getHeader().getEntities();
        boolean $i$f$map = false;
        long[] lArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_10 = $this$mapTo$iv$iv;
        int n = ((void)var8_10).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_14 = item$iv$iv = var8_10[i];
            object = destination$iv$iv;
            boolean bl = false;
            Name.SchemaName schemaName = this.getName();
            GroupSerializer groupSerializer = Serializer.STRING;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.STRING");
            String string = (String)this.store.get((long)it, (Serializer)groupSerializer);
            if (string == null) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Failed to read schema " + this.getName() + " (" + this.getPath() + "): Could not find entity name of ID " + (long)it + '.');
            }
            Name.EntityName name2 = schemaName.entity(string);
            this.registry.put(name2, new EntityV1(name2, this));
            Unit unit = Unit.INSTANCE;
            object.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0014JI\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001522\u0010\u0016\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u0017\"\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/general/DBO;", "getDbo", "()Lorg/vitrivr/cottontail/database/general/DBO;", "snapshot", "Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "cleanup", "", "createEntity", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "columns", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "(Lorg/vitrivr/cottontail/model/basics/Name$EntityName;[Lkotlin/Pair;)Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "dropEntity", "entityForName", "Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;", "listEntities", "", "Lorg/vitrivr/cottontail/database/entity/Entity;", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements SchemaTx {
        private final long closeStamp;
        @NotNull
        private final TxSnapshot snapshot;

        @Override
        @NotNull
        public TxSnapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        @NotNull
        public DBO getDbo() {
            return SchemaV1.this;
        }

        @Override
        @NotNull
        public List<Entity> listEntities() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return CollectionsKt.toList((Iterable)SchemaV1.this.registry.values());
        }

        @Override
        @NotNull
        public EntityV1 entityForName(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            EntityV1 entityV1 = (EntityV1)SchemaV1.this.registry.get(name);
            if (entityV1 == null) {
                throw (Throwable)new DatabaseException.EntityDoesNotExistException(name);
            }
            return entityV1;
        }

        @Override
        @NotNull
        public DefaultEntity createEntity(@NotNull Name.EntityName name, Pair<? extends ColumnDef<?>, ? extends ColumnEngine> ... columns) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        protected void cleanup() {
            SchemaV1.this.closeLock.unlockRead(this.closeStamp);
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.closeStamp = SchemaV1.this.closeLock.readLock();
            this.snapshot = new TxSnapshot(){

                @NotNull
                public Void commit() {
                    throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }

                @NotNull
                public Void rollback() {
                    throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }
            };
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

