/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.column.mapdb;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.column.ColumnTx;
import org.vitrivr.cottontail.database.column.ColumnTxSnapshot;
import org.vitrivr.cottontail.database.column.mapdb.ColumnHeader;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxAction;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u000256B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010/\u001a\u000200H\u0016J\u001a\u00101\u001a\f02R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00103\u001a\u000204H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00067"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn;", "T", "Lorg/vitrivr/cottontail/model/values/types/Value;", "Lorg/vitrivr/cottontail/database/column/Column;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/Entity;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "columnDef", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumnDef$annotations", "()V", "getColumnDef", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "engine", "Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "getEngine", "()Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "header", "Lorg/vitrivr/cottontail/database/column/mapdb/ColumnHeader;", "getHeader", "()Lorg/vitrivr/cottontail/database/column/mapdb/ColumnHeader;", "maxTupleId", "", "getMaxTupleId", "()J", "name", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class MapDBColumn<T extends Value>
implements Column<T> {
    private CottontailStoreWAL store;
    @NotNull
    private final ColumnDef<T> columnDef;
    private final StampedLock closeLock;
    @NotNull
    private final Path path;
    @NotNull
    private final Entity parent;
    private static final long RECORD_ID_TUPLE_ID_SHIFT = 2L;
    private static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final ColumnHeader getHeader() {
        ColumnHeader columnHeader = (ColumnHeader)this.store.get(1L, ColumnHeader.Serializer);
        if (columnHeader == null) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open header of column '" + this.getName() + "'!'");
        }
        return columnHeader;
    }

    public static /* synthetic */ void getColumnDef$annotations() {
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.getColumnDef().getName();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    @NotNull
    public ColumnEngine getEngine() {
        return ColumnEngine.MAPDB;
    }

    @Override
    public long getMaxTupleId() {
        return this.store.getMaxRecid();
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            this.store.close();
        }
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public MapDBColumn(@NotNull Path path, @NotNull Entity parent) {
        CottontailStoreWAL cottontailStoreWAL;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        MapDBColumn mapDBColumn = this;
        try {
            MapDBColumn mapDBColumn2 = mapDBColumn;
            cottontailStoreWAL = this.getParent().getParent().getParent().getConfig().getMapdb().store(this.getPath());
        }
        catch (DBException dBException) {
            void e;
            MapDBColumn mapDBColumn3 = mapDBColumn;
            throw (Throwable)new DatabaseException("Failed to open column at '" + this.getPath() + "': " + e.getMessage() + '\'', null, 2, null);
        }
        mapDBColumn2.store = cottontailStoreWAL;
        ColumnDef<?> columnDef = this.getHeader().getColumnDef();
        if (columnDef == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnDef<T>");
        }
        this.columnDef = columnDef;
        this.closeLock = new StampedLock();
    }

    @Override
    @NotNull
    public Type<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    public static final /* synthetic */ void access$setStore$p(MapDBColumn $this, CottontailStoreWAL cottontailStoreWAL) {
        $this.store = cottontailStoreWAL;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J-\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0007j\u0002`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00018\u00002\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0007H\u0016J\u001b\u0010\u001c\u001a\u0004\u0018\u00018\u00002\n\u0010\u0016\u001a\u00060\u0007j\u0002`\u0017H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\"\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00170#H\u0016J\u001a\u0010\"\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00170#2\u0006\u0010$\u001a\u00020%H\u0016J%\u0010&\u001a\u0004\u0018\u00018\u00002\n\u0010\u0016\u001a\u00060\u0007j\u0002`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/column/Column;", "getDbo", "()Lorg/vitrivr/cottontail/database/column/Column;", "serializer", "Lorg/vitrivr/cottontail/storage/serializers/mapdb/MapDBSerializer;", "snapshot", "Lorg/vitrivr/cottontail/database/column/ColumnTxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/column/ColumnTxSnapshot;", "cleanup", "", "compareAndUpdate", "", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "value", "expected", "(JLorg/vitrivr/cottontail/model/values/types/Value;Lorg/vitrivr/cottontail/model/values/types/Value;)Z", "count", "delete", "(J)Lorg/vitrivr/cottontail/model/values/types/Value;", "insert", "record", "(Lorg/vitrivr/cottontail/model/values/types/Value;)J", "read", "scan", "", "range", "Lkotlin/ranges/LongRange;", "update", "(JLorg/vitrivr/cottontail/model/values/types/Value;)Lorg/vitrivr/cottontail/model/values/types/Value;", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements ColumnTx<T> {
        private final MapDBSerializer<T> serializer;
        private final long closeStamp;
        @NotNull
        private final ColumnTxSnapshot snapshot;

        @Override
        @NotNull
        public Column<T> getDbo() {
            return MapDBColumn.this;
        }

        @Override
        @NotNull
        public ColumnTxSnapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        @Nullable
        public T read(long tupleId) {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return (Value)MapDBColumn.this.store.get(tupleId + 2L, this.serializer);
        }

        @Override
        public long count() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return MapDBColumn.this.getHeader().getCount() + this.getSnapshot().getDelta();
        }

        @Override
        @NotNull
        public Iterator<Long> scan() {
            long l = 0L;
            return this.scan(new LongRange(l, MapDBColumn.this.getMaxTupleId()));
        }

        @Override
        @NotNull
        public Iterator<Long> scan(@NotNull LongRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return new Iterator<Long>(this, range){
                private final CottontailStoreWAL.RecordIdIterator wrapped;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ LongRange $range$inlined;
                {
                    this.this$0 = tx;
                    this.$range$inlined = longRange;
                    long l = this.$range$inlined.getFirst() + 2L;
                    this.wrapped = new CottontailStoreWAL.RecordIdIterator(MapDBColumn.access$getStore$p(this.this$0.MapDBColumn.this), new LongRange(l, this.$range$inlined.getLast() + 2L));
                }

                public boolean hasNext() {
                    return this.wrapped.hasNext();
                }

                @NotNull
                public Long next() {
                    return this.wrapped.next() - 2L;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        public long insert(@Nullable T record) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                long l;
                if (record == null && this.getColumnDef().getNullable()) {
                    l = MapDBColumn.this.store.preallocate() - 2L;
                } else if (record != null) {
                    l = MapDBColumn.this.store.put(record, this.serializer) - 2L;
                } else {
                    throw (Throwable)new IllegalArgumentException("Column " + this.getColumnDef() + " does not allow for NULL values.");
                }
                long tupleId = l;
                ColumnTxSnapshot columnTxSnapshot = this.getSnapshot();
                columnTxSnapshot.setDelta(columnTxSnapshot.getDelta() + 1L);
                return tupleId;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                long l = this.getContext().getTxId();
                String string = e.getMessage();
                if (string == null) {
                    string = "Unknown";
                }
                throw (Throwable)new TxException.TxStorageException(l, string);
            }
        }

        @Override
        @Nullable
        public T update(long tupleId, @Nullable T value) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                Value ret = (Value)MapDBColumn.this.store.get(tupleId + 2L, this.serializer);
                MapDBColumn.this.store.update(tupleId + 2L, value, this.serializer);
                return ret;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                long l = this.getContext().getTxId();
                String string = e.getMessage();
                if (string == null) {
                    string = "Unknown exception during data storage";
                }
                throw (Throwable)new TxException.TxStorageException(l, string);
            }
        }

        @Override
        public boolean compareAndUpdate(long tupleId, @Nullable T value, @Nullable T expected) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                boolean ret = MapDBColumn.this.store.compareAndSwap(tupleId + 2L, expected, value, this.serializer);
                return ret;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                long l = this.getContext().getTxId();
                String string = e.getMessage();
                if (string == null) {
                    string = "Unknown";
                }
                throw (Throwable)new TxException.TxStorageException(l, string);
            }
        }

        @Override
        @Nullable
        public T delete(long tupleId) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                Value ret = (Value)MapDBColumn.this.store.get(tupleId + 2L, this.serializer);
                MapDBColumn.this.store.delete(tupleId + 2L, this.serializer);
                ColumnTxSnapshot columnTxSnapshot = this.getSnapshot();
                columnTxSnapshot.setDelta(columnTxSnapshot.getDelta() - 1L);
                MapDBColumn.this.store.update(1L, MapDBColumn.this.getHeader(), ColumnHeader.Serializer);
                return ret;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                long l = this.getContext().getTxId();
                String string = e.getMessage();
                if (string == null) {
                    string = "Unknown";
                }
                throw (Throwable)new TxException.TxStorageException(l, string);
            }
        }

        @Override
        protected void cleanup() {
            MapDBColumn.this.closeLock.unlockRead(this.closeStamp);
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.serializer = MapDBColumn.this.getType().serializerFactory().mapdb(MapDBColumn.this.getType().getLogicalSize());
            this.closeStamp = MapDBColumn.this.closeLock.readLock();
            if (MapDBColumn.this.getClosed()) {
                MapDBColumn.this.closeLock.unlockRead(this.closeStamp);
                throw (Throwable)new TxException.TxDBOClosedException(this.getContext().getTxId(), MapDBColumn.this);
            }
            this.snapshot = new ColumnTxSnapshot(this){
                private volatile long delta;
                @NotNull
                private final List<TxAction> actions;
                final /* synthetic */ Tx this$0;

                public long getDelta() {
                    return this.delta;
                }

                public void setDelta(long l) {
                    this.delta = l;
                }

                @NotNull
                public List<TxAction> getActions() {
                    return this.actions;
                }

                public void commit() {
                    long l = MapDBColumn.access$getHeader$p(this.this$0.MapDBColumn.this).getCount() + this.getDelta();
                    long l2 = 0L;
                    long l3 = System.currentTimeMillis();
                    ColumnHeader header = ColumnHeader.copy$default(MapDBColumn.access$getHeader$p(this.this$0.MapDBColumn.this), null, l, l2, l3, 5, null);
                    MapDBColumn.access$getStore$p(this.this$0.MapDBColumn.this).update(1L, header, ColumnHeader.Serializer);
                    MapDBColumn.access$getStore$p(this.this$0.MapDBColumn.this).commit();
                }

                public void rollback() {
                    MapDBColumn.access$getStore$p(this.this$0.MapDBColumn.this).rollback();
                }

                public boolean record(@NotNull TxAction action) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    return false;
                }
                {
                    this.this$0 = this$0;
                    this.actions = CollectionsKt.emptyList();
                }
            };
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnTx.DefaultImpls.getColumnDef(this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Companion;", "", "()V", "HEADER_RECORD_ID", "", "RECORD_ID_TUPLE_ID_SHIFT", "initialize", "", "path", "Ljava/nio/file/Path;", "column", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "config", "Lorg/vitrivr/cottontail/config/MapDBConfig;", "cottontaildb"})
    public static final class Companion {
        public final void initialize(@NotNull Path path, @NotNull ColumnDef<?> column, @NotNull MapDBConfig config) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (Files.exists(path, new LinkOption[0])) {
                throw (Throwable)new DatabaseException.InvalidFileException("Could not initialize column " + column.getName() + ". A file already exists under " + path + '.');
            }
            CottontailStoreWAL store = config.store(path);
            store.put(new ColumnHeader(column, 0L, 0L, 0L, 14, null), ColumnHeader.Serializer);
            store.commit();
            store.close();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

