/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.predicates.bool;

import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.binding.BindingContext;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.BooleanPredicate$Compound$WhenMappings;
import org.vitrivr.cottontail.database.queries.predicates.bool.ComparisonOperator;
import org.vitrivr.cottontail.database.queries.predicates.bool.ConnectionOperator;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH&R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0005\u0014\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "()V", "atomics", "", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "getAtomics", "()Ljava/util/Set;", "bindValues", "ctx", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "matches", "", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "score", "", "Atomic", "Compound", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Compound;", "cottontaildb"})
public abstract class BooleanPredicate
implements Predicate {
    @NotNull
    public abstract Set<Atomic> getAtomics();

    public abstract boolean matches(@NotNull Record var1);

    public abstract double score(@NotNull Record var1);

    @Override
    @NotNull
    public abstract BooleanPredicate bindValues(@NotNull BindingContext<Value> var1);

    private BooleanPredicate() {
    }

    public /* synthetic */ BooleanPredicate(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB#\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0001\u0002\u001f \u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "left", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "operator", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator;", "not", "", "(Lorg/vitrivr/cottontail/database/column/ColumnDef;Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator;Z)V", "atomicCpuCost", "", "getAtomicCpuCost", "()F", "atomics", "", "getAtomics", "()Ljava/util/Set;", "getLeft", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getNot", "()Z", "getOperator", "()Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator;", "digest", "", "score", "", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "Literal", "Reference", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic$Literal;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic$Reference;", "cottontaildb"})
    public static abstract class Atomic
    extends BooleanPredicate {
        @NotNull
        private final ColumnDef<?> left;
        @NotNull
        private final ComparisonOperator operator;
        private final boolean not;

        @Override
        public float getAtomicCpuCost() {
            return this.operator.getAtomicCpuCost();
        }

        @Override
        @NotNull
        public Set<Atomic> getAtomics() {
            return SetsKt.setOf((Object)this);
        }

        @Override
        public double score(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            return this.matches(record) ? 1.0 : 0.0;
        }

        @Override
        public long digest() {
            return 33L * (long)this.hashCode();
        }

        @NotNull
        public final ColumnDef<?> getLeft() {
            return this.left;
        }

        @NotNull
        public final ComparisonOperator getOperator() {
            return this.operator;
        }

        public final boolean getNot() {
            return this.not;
        }

        private Atomic(ColumnDef<?> left, ComparisonOperator operator, boolean not) {
            super(null);
            this.left = left;
            this.operator = operator;
            this.not = not;
        }

        public /* synthetic */ Atomic(ColumnDef left, ComparisonOperator operator, boolean not, DefaultConstructorMarker $constructor_marker) {
            this(left, operator, not);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\b\u0002\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic$Literal;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "left", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "operator", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator;", "not", "", "dependsOn", "", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "(Lorg/vitrivr/cottontail/database/column/ColumnDef;Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator;ZI)V", "atomicCpuCost", "", "getAtomicCpuCost", "()F", "columns", "", "getColumns", "()Ljava/util/Set;", "getDependsOn", "()I", "bindValues", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "ctx", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "equals", "other", "", "hashCode", "matches", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "toString", "", "cottontaildb"})
        public static final class Literal
        extends Atomic {
            private final int dependsOn;

            @Override
            public float getAtomicCpuCost() {
                return this.getOperator().getAtomicCpuCost();
            }

            @Override
            @NotNull
            public Set<ColumnDef<?>> getColumns() {
                return SetsKt.setOf(this.getLeft());
            }

            @Override
            @NotNull
            public BooleanPredicate bindValues(@NotNull BindingContext<Value> ctx) {
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                this.getOperator().bindValues(ctx);
                return this;
            }

            @Override
            public boolean matches(@NotNull Record record) {
                Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                return this.getNot() ? !this.getOperator().match(record.get(this.getLeft())) : this.getOperator().match(record.get(this.getLeft()));
            }

            @NotNull
            public String toString() {
                StringBuilder builder = new StringBuilder();
                if (this.getNot()) {
                    builder.append("!(");
                }
                builder.append(this.getLeft().getName().toString());
                builder.append(" ");
                builder.append(this.getOperator().toString());
                if (this.getNot()) {
                    builder.append(")");
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                return string;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Literal)) {
                    return false;
                }
                if (Intrinsics.areEqual(this.getLeft(), ((Literal)other).getLeft()) ^ true) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)this.getOperator(), (Object)((Literal)other).getOperator()) ^ true) {
                    return false;
                }
                return this.getNot() == ((Literal)other).getNot();
            }

            public int hashCode() {
                int result = this.getLeft().hashCode();
                result = 31 * result + this.getOperator().hashCode();
                result = 31 * result + Boolean.hashCode(this.getNot());
                return result;
            }

            public final int getDependsOn() {
                return this.dependsOn;
            }

            public Literal(@NotNull ColumnDef<?> left, @NotNull ComparisonOperator operator, boolean not, int dependsOn) {
                Intrinsics.checkNotNullParameter(left, (String)"left");
                Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
                super(left, operator, not, null);
                this.dependsOn = dependsOn;
            }

            public /* synthetic */ Literal(ColumnDef columnDef, ComparisonOperator comparisonOperator, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 8) != 0) {
                    n = -1;
                }
                this(columnDef, comparisonOperator, bl, n);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0013\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic$Reference;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "left", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "right", "binaryOperator", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator$Binary;", "not", "", "(Lorg/vitrivr/cottontail/database/column/ColumnDef;Lorg/vitrivr/cottontail/database/column/ColumnDef;Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator$Binary;Z)V", "getBinaryOperator", "()Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator$Binary;", "columns", "", "getColumns", "()Ljava/util/Set;", "context", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "getRight", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "bindValues", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "ctx", "equals", "other", "", "hashCode", "", "matches", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "toString", "", "cottontaildb"})
        public static final class Reference
        extends Atomic {
            private final BindingContext<Value> context;
            @NotNull
            private final ColumnDef<?> right;
            @NotNull
            private final ComparisonOperator.Binary binaryOperator;

            @Override
            @NotNull
            public Set<ColumnDef<?>> getColumns() {
                return SetsKt.setOf((Object[])new ColumnDef[]{this.getLeft(), this.right});
            }

            @Override
            public boolean matches(@NotNull Record record) {
                Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                this.context.update(this.binaryOperator.getRight(), record.get(this.right));
                return this.getNot() ? !this.binaryOperator.match(record.get(this.getLeft())) : this.binaryOperator.match(record.get(this.getLeft()));
            }

            @Override
            @NotNull
            public BooleanPredicate bindValues(@NotNull BindingContext<Value> ctx) {
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                this.binaryOperator.bindValues(this.context);
                return this;
            }

            @NotNull
            public String toString() {
                StringBuilder builder = new StringBuilder();
                if (this.getNot()) {
                    builder.append("!(");
                }
                builder.append(this.getLeft().getName().toString());
                builder.append(" ");
                builder.append(this.getOperator());
                if (this.getNot()) {
                    builder.append(")");
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                return string;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Reference)) {
                    return false;
                }
                if (Intrinsics.areEqual(this.getLeft(), ((Reference)other).getLeft()) ^ true) {
                    return false;
                }
                if (Intrinsics.areEqual(this.right, ((Reference)other).right) ^ true) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)this.getOperator(), (Object)((Reference)other).getOperator()) ^ true) {
                    return false;
                }
                return this.getNot() == ((Reference)other).getNot();
            }

            public int hashCode() {
                int result = this.getLeft().hashCode();
                result = 31 * result + this.right.hashCode();
                result = 31 * result + this.getOperator().hashCode();
                result = 31 * result + Boolean.hashCode(this.getNot());
                return result;
            }

            @NotNull
            public final ColumnDef<?> getRight() {
                return this.right;
            }

            @NotNull
            public final ComparisonOperator.Binary getBinaryOperator() {
                return this.binaryOperator;
            }

            public Reference(@NotNull ColumnDef<?> left, @NotNull ColumnDef<?> right, @NotNull ComparisonOperator.Binary binaryOperator, boolean not) {
                Intrinsics.checkNotNullParameter(left, (String)"left");
                Intrinsics.checkNotNullParameter(right, (String)"right");
                Intrinsics.checkNotNullParameter((Object)binaryOperator, (String)"binaryOperator");
                super(left, binaryOperator, not, null);
                this.right = right;
                this.binaryOperator = binaryOperator;
                this.context = new BindingContext();
                this.context.register(this.binaryOperator.getRight(), null);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0018\u001a\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006+"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Compound;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "connector", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/ConnectionOperator;", "p1", "p2", "(Lorg/vitrivr/cottontail/database/queries/predicates/bool/ConnectionOperator;Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;)V", "atomicCpuCost", "", "getAtomicCpuCost", "()F", "atomics", "", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "getAtomics", "()Ljava/util/Set;", "columns", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "getConnector", "()Lorg/vitrivr/cottontail/database/queries/predicates/bool/ConnectionOperator;", "getP1", "()Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "getP2", "bindValues", "ctx", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "digest", "", "equals", "", "other", "", "hashCode", "", "matches", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "score", "", "toString", "", "cottontaildb"})
    public static final class Compound
    extends BooleanPredicate {
        @NotNull
        private final ConnectionOperator connector;
        @NotNull
        private final BooleanPredicate p1;
        @NotNull
        private final BooleanPredicate p2;

        @Override
        public float getAtomicCpuCost() {
            return this.p1.getAtomicCpuCost() + this.p2.getAtomicCpuCost();
        }

        @Override
        @NotNull
        public Set<Atomic> getAtomics() {
            return SetsKt.plus(this.p1.getAtomics(), (Iterable)this.p2.getAtomics());
        }

        @Override
        @NotNull
        public Set<ColumnDef<?>> getColumns() {
            return SetsKt.plus(this.p1.getColumns(), (Iterable)this.p2.getColumns());
        }

        @Override
        public boolean matches(@NotNull Record record) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            switch (BooleanPredicate$Compound$WhenMappings.$EnumSwitchMapping$0[this.connector.ordinal()]) {
                case 1: {
                    if (this.p1.matches(record) && this.p2.matches(record)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (this.p1.matches(record) || this.p2.matches(record)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl;
        }

        @Override
        public double score(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            return this.connector == ConnectionOperator.AND && this.p1.matches(record) && this.p2.matches(record) ? 1.0 : (this.connector == ConnectionOperator.OR ? (this.p1.score(record) + this.p2.score(record)) / 2.0 : 0.0);
        }

        @NotNull
        public String toString() {
            return "" + this.p1 + ' ' + (Object)((Object)this.connector) + ' ' + this.p2;
        }

        @Override
        @NotNull
        public BooleanPredicate bindValues(@NotNull BindingContext<Value> ctx) {
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            this.p1.bindValues(ctx);
            this.p2.bindValues(ctx);
            return this;
        }

        @Override
        public long digest() {
            return 33L * (long)this.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Compound)) {
                return false;
            }
            if (this.connector != ((Compound)other).connector) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.p1, (Object)((Compound)other).p1) ^ true) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.p2, (Object)((Compound)other).p2) ^ true);
        }

        public int hashCode() {
            int result = this.connector.hashCode();
            result = 31 * result + this.p1.hashCode();
            result = 31 * result + this.p2.hashCode();
            return result;
        }

        @NotNull
        public final ConnectionOperator getConnector() {
            return this.connector;
        }

        @NotNull
        public final BooleanPredicate getP1() {
            return this.p1;
        }

        @NotNull
        public final BooleanPredicate getP2() {
            return this.p2;
        }

        public Compound(@NotNull ConnectionOperator connector, @NotNull BooleanPredicate p1, @NotNull BooleanPredicate p2) {
            Intrinsics.checkNotNullParameter((Object)((Object)connector), (String)"connector");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            super(null);
            this.connector = connector;
            this.p1 = p1;
            this.p2 = p2;
        }
    }
}

