/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.catalogue.CatalogueTx;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.Tx;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.database.schema.SchemaTx;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.TransactionStatus;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.legacy.AbstractMigrationManager;
import org.vitrivr.cottontail.legacy.MigrationManager;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.utilities.io.TxFileUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0014J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u0015H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;", "Lorg/vitrivr/cottontail/legacy/MigrationManager;", "batchSize", "", "logFile", "Ljava/nio/file/Path;", "(ILjava/nio/file/Path;)V", "getBatchSize", "()I", "transactionIdCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "writer", "Ljava/io/BufferedWriter;", "close", "", "log", "message", "", "logStdout", "migrate", "config", "Lorg/vitrivr/cottontail/config/Config;", "migrateCatalogueAndSchema", "srcCatalogueTx", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueTx;", "dstCatalogueTx", "migrateEntity", "srcEntity", "Lorg/vitrivr/cottontail/database/entity/Entity;", "destSchemaTx", "Lorg/vitrivr/cottontail/database/schema/SchemaTx;", "openDestinationCatalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "openSourceCatalogue", "MigrationContext", "cottontaildb"})
@ExperimentalTime
public abstract class AbstractMigrationManager
implements MigrationManager {
    private final AtomicLong transactionIdCounter;
    private final BufferedWriter writer;
    private final int batchSize;

    @Nullable
    public abstract Catalogue openSourceCatalogue(@NotNull Config var1);

    @Nullable
    public abstract Catalogue openDestinationCatalogue(@NotNull Config var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean $i$f$measureTime = false;
        boolean bl = false;
        TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        boolean bl2 = false;
        TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
        boolean bl3 = false;
        this.log("Starting catalogue migration from V" + this.getFrom() + " for " + config.getRoot() + ".\n");
        Catalogue srcCatalogue = this.openSourceCatalogue(config);
        if (srcCatalogue == null) {
            this.log("Failed to open source catalogue.\n");
            return;
        }
        this.log("Source catalogue " + srcCatalogue.getConfig().getRoot() + " loaded successfully.\n");
        Path migratedDatabaseRoot = config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~migrated");
        if (!Files.exists(migratedDatabaseRoot, new LinkOption[0])) {
            Files.createDirectories(migratedDatabaseRoot, new FileAttribute[0]);
        }
        Path path = migratedDatabaseRoot;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"migratedDatabaseRoot");
        Catalogue dstCatalogue = this.openDestinationCatalogue(Config.copy$default(config, path, false, false, null, null, null, null, null, 254, null));
        if (dstCatalogue == null) {
            this.log("Failed to open destination catalogue.\n");
            srcCatalogue.close();
            return;
        }
        this.log("Destination catalogue " + dstCatalogue.getConfig().getRoot() + " loaded successfully.\n");
        MigrationContext context = new MigrationContext();
        try {
            Tx tx = context.getTx(srcCatalogue);
            if (tx == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.catalogue.CatalogueTx");
            }
            CatalogueTx srcCatalogueTx = (CatalogueTx)tx;
            Tx tx2 = context.getTx(dstCatalogue);
            if (tx2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.catalogue.CatalogueTx");
            }
            CatalogueTx dstCatalogueTx = (CatalogueTx)tx2;
            this.migrateCatalogueAndSchema(srcCatalogueTx, dstCatalogueTx);
            context.commit();
            Files.move(config.getRoot(), config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~old"), StandardCopyOption.ATOMIC_MOVE);
            Files.move(migratedDatabaseRoot, config.getRoot(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Throwable e) {
            this.log("Error during data migration: " + e.getMessage() + '\n');
            context.rollback();
            TxFileUtilities.INSTANCE.delete(dstCatalogue.getPath());
        }
        finally {
            srcCatalogue.close();
            dstCatalogue.close();
        }
        double duration = mark$iv$iv.elapsedNow-UwyO8pc();
        this.log("Data migration completed. Took " + Duration.toString-impl((double)duration) + ".\n");
    }

    /*
     * WARNING - void declaration
     */
    protected void migrateCatalogueAndSchema(@NotNull CatalogueTx srcCatalogueTx, @NotNull CatalogueTx dstCatalogueTx) {
        Intrinsics.checkNotNullParameter((Object)srcCatalogueTx, (String)"srcCatalogueTx");
        Intrinsics.checkNotNullParameter((Object)dstCatalogueTx, (String)"dstCatalogueTx");
        List<Schema> schemas = srcCatalogueTx.listSchemas();
        boolean bl = false;
        for (Schema srcSchema : (Iterable)schemas) {
            void s;
            this.log("+ Migrating schema " + srcSchema.getName() + " (" + (int)(s + true) + " / " + schemas.size() + "):\n");
            MigrationContext context = new MigrationContext();
            Schema destSchema = dstCatalogueTx.createSchema(srcSchema.getName());
            Tx tx = context.getTx(srcSchema);
            if (tx == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.schema.SchemaTx");
            }
            SchemaTx srcSchemaTx = (SchemaTx)tx;
            Tx tx2 = context.getTx(destSchema);
            if (tx2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.schema.SchemaTx");
            }
            SchemaTx destSchemaTx = (SchemaTx)tx2;
            List<Entity> entities = srcSchemaTx.listEntities();
            boolean bl2 = false;
            for (Entity srcEntity : (Iterable)entities) {
                void i;
                this.log("-- Migrating entity " + srcEntity.getName() + " (" + (int)(i + true) + " / " + entities.size() + "):\n");
                this.migrateEntity(srcEntity, destSchemaTx);
                ++i;
            }
            context.commit();
            ++s;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void migrateEntity(@NotNull Entity srcEntity, @NotNull SchemaTx destSchemaTx) {
        void $this$toTypedArray$iv;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$toTypedArray$iv2;
        Object object2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)srcEntity, (String)"srcEntity");
        Intrinsics.checkNotNullParameter((Object)destSchemaTx, (String)"destSchemaTx");
        MigrationContext creationContext = new MigrationContext();
        Tx tx = creationContext.getTx(srcEntity);
        if (tx == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
        }
        EntityTx srcEntityTx = (EntityTx)tx;
        Iterable $this$map$iv = srcEntityTx.listColumns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Column column = (Column)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object2 = TuplesKt.to(it.getColumnDef(), (Object)((Object)ColumnEngine.MAPDB));
            collection.add(object2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv2;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Pair[] columnDefs = pairArray;
        Entity destEntity = destSchemaTx.createEntity(srcEntity.getName(), Arrays.copyOf(columnDefs, columnDefs.length));
        Tx tx2 = creationContext.getTx(destEntity);
        if (tx2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
        }
        EntityTx destEntityTx = (EntityTx)tx2;
        for (Index index : srcEntityTx.listIndexes()) {
            this.log("---- Migrating index " + index.getName() + "...\n");
            destEntityTx.createIndex(index.getName(), index.getType(), index.getColumns(), index.getConfig().toMap());
        }
        long count = srcEntityTx.count();
        long maxTupleId = srcEntityTx.maxTupleId();
        Iterable $this$map$iv2 = srcEntityTx.listColumns();
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (Column)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object2 = it.getColumnDef();
            collection.add(object2);
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray2 = false;
        void thisCollection$iv22 = $this$toTypedArray$iv;
        ColumnDef[] columnDefArray = thisCollection$iv22.toArray(new ColumnDef[0]);
        if (columnDefArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ColumnDef[] columns = columnDefArray;
        creationContext.commit();
        if (count > 0L) {
            long i = 0L;
            int p = (int)Math.floorDiv(maxTupleId, this.batchSize);
            int thisCollection$iv22 = 0;
            int n = p;
            while (thisCollection$iv22 < n) {
                void j;
                MigrationContext context = new MigrationContext();
                Tx tx3 = context.getTx(srcEntity);
                if (tx3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
                }
                srcEntityTx = (EntityTx)tx3;
                Tx tx4 = context.getTx(destEntity);
                if (tx4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
                }
                destEntityTx = (EntityTx)tx4;
                Iterator<Record> $this$forEach$iv = srcEntityTx.scan(columns, (int)j, p);
                boolean $i$f$forEach = false;
                object = $this$forEach$iv;
                boolean bl = false;
                Object object3 = object;
                while (object3.hasNext()) {
                    Object element$iv = object3.next();
                    Record r = (Record)element$iv;
                    boolean bl2 = false;
                    this.logStdout("---- Migrating data for " + srcEntity.getName() + "... (" + ++i + " / " + count + ")\r");
                    destEntityTx.insert(r);
                }
                this.log("---- Migrating data for " + srcEntity.getName() + "; committing... (" + i + " / " + count + ")\r");
                context.commit();
                ++j;
            }
            this.log("---- Data migration for " + srcEntity.getName() + " completed (" + i + " / " + count + ").\n");
        } else {
            this.log("---- Data migration for " + srcEntity.getName() + " skipped (no data).\n");
        }
        destEntity.close();
    }

    protected final void logStdout(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = false;
        System.out.print((Object)message);
    }

    protected final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = false;
        System.out.print((Object)message);
        this.writer.append(message);
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public AbstractMigrationManager(int batchSize, @NotNull Path logFile) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        this.batchSize = batchSize;
        this.transactionIdCounter = new AtomicLong(0L);
        BufferedWriter bufferedWriter = Files.newBufferedWriter(logFile.resolve("cottontaildb_migration_" + System.currentTimeMillis() + ".log"), StandardOpenOption.CREATE, StandardOpenOption.CREATE);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"Files.newBufferedWriter(\u2026rdOpenOption.CREATE\n    )");
        this.writer = bufferedWriter;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J\u0006\u0010\u001f\u001a\u00020\u0018J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager$MigrationContext;", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;)V", "<set-?>", "Lorg/vitrivr/cottontail/execution/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/execution/TransactionStatus;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "getTxId", "()J", "txns", "", "Lorg/vitrivr/cottontail/database/general/DBO;", "Lorg/vitrivr/cottontail/database/general/Tx;", "getTxns", "()Ljava/util/Map;", "type", "Lorg/vitrivr/cottontail/execution/TransactionType;", "getType", "()Lorg/vitrivr/cottontail/execution/TransactionType;", "commit", "", "getTx", "dbo", "lockOn", "Lorg/vitrivr/cottontail/database/locking/LockMode;", "requestLock", "mode", "rollback", "signalEvent", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    public final class MigrationContext
    implements TransactionContext {
        private final long txId;
        @NotNull
        private final TransactionType type;
        @NotNull
        private volatile TransactionStatus state;
        @NotNull
        private final Map<DBO, Tx> txns;

        @Override
        public long getTxId() {
            return this.txId;
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        @NotNull
        protected final Map<DBO, Tx> getTxns() {
            return this.txns;
        }

        @Override
        @NotNull
        public Tx getTx(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Tx tx = this.txns.computeIfAbsent(dbo, new Function<DBO, Tx>(this, dbo){
                final /* synthetic */ MigrationContext this$0;
                final /* synthetic */ DBO $dbo;

                @NotNull
                public final Tx apply(@NotNull DBO it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$dbo.newTx(this.this$0);
                }
                {
                    this.this$0 = migrationContext;
                    this.$dbo = dBO;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)tx, (String)"this.txns.computeIfAbsen\u2026dbo.newTx(this)\n        }");
            return tx;
        }

        @Override
        public void requestLock(@NotNull DBO dbo, @NotNull LockMode mode) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        }

        @Override
        @NotNull
        public LockMode lockOn(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            return LockMode.EXCLUSIVE;
        }

        @Override
        public void signalEvent(@NotNull DataChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public final void commit() {
            boolean bl = this.getState() == TransactionStatus.READY;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot commit transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            this.txns.values().removeIf(commit.2.INSTANCE);
            this.state = TransactionStatus.COMMIT;
        }

        public final void rollback() {
            boolean bl = this.getState() == TransactionStatus.READY || this.getState() == TransactionStatus.ERROR;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot rollback transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            Iterable $this$forEach$iv = this.txns.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tx txn = (Tx)element$iv;
                boolean bl5 = false;
                txn.rollback();
            }
            this.txns.clear();
            this.state = TransactionStatus.ROLLBACK;
        }

        public MigrationContext() {
            this.txId = AbstractMigrationManager.this.transactionIdCounter.getAndIncrement();
            this.type = TransactionType.SYSTEM;
            this.state = TransactionStatus.READY;
            Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
            Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.synchronized\u2026ject2ObjectOpenHashMap())");
            this.txns = map2;
        }
    }
}

