/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.catalogue;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.catalogue.CatalogueTx;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxAction;
import org.vitrivr.cottontail.database.general.TxSnapshot;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.legacy.v1.catalogue.CatalogueV1Header;
import org.vitrivr.cottontail.legacy.v1.schema.SchemaV1;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u000223B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00064"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "header", "Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1Header;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$RootName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$RootName;", "parent", "Lorg/vitrivr/cottontail/database/general/DBO;", "getParent", "()Lorg/vitrivr/cottontail/database/general/DBO;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "size", "", "getSize", "()I", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class CatalogueV1
implements Catalogue {
    @NotNull
    private final Path path;
    @NotNull
    private final Name.RootName name;
    @Nullable
    private final DBO parent;
    private final StampedLock closeLock;
    private final CottontailStoreWAL store;
    private final Map<Name.SchemaName, SchemaV1> registry;
    private volatile boolean closed;
    @NotNull
    private final Config config;
    public static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final String FILE_CATALOGUE = "catalogue.db";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Name.RootName getName() {
        return this.name;
    }

    @Override
    @Nullable
    public DBO getParent() {
        return this.parent;
    }

    private final CatalogueV1Header getHeader() {
        CatalogueV1Header catalogueV1Header = (CatalogueV1Header)this.store.get(1L, CatalogueV1Header.Serializer);
        if (catalogueV1Header == null) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open Cottontail DB catalogue header!");
        }
        return catalogueV1Header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int n;
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            n = 0;
            n = this.getHeader().getSchemas().length;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return n;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public CatalogueTx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-CatalogueV1$close$22 = false;
            Map<Name.SchemaName, SchemaV1> $this$forEach$iv = this.registry;
            boolean $i$f$forEach = false;
            Map<Name.SchemaName, SchemaV1> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<Name.SchemaName, SchemaV1>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Name.SchemaName, SchemaV1> element$iv;
                Map.Entry<Name.SchemaName, SchemaV1> $dstr$_u24__u24$v = element$iv = iterator2.next();
                boolean bl2 = false;
                Map.Entry<Name.SchemaName, SchemaV1> entry = $dstr$_u24__u24$v;
                boolean bl3 = false;
                SchemaV1 v = entry.getValue();
                v.close();
            }
            this.store.close();
            this.closed = true;
            Unit $i$a$-write-CatalogueV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public CatalogueV1(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.path = this.getConfig().getRoot();
        this.name = Name.RootName.INSTANCE;
        this.closeLock = new StampedLock();
        MapDBConfig mapDBConfig = this.getConfig().getMapdb();
        Path path = this.getPath().resolve(FILE_CATALOGUE);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.path.resolve(FILE_CATALOGUE)");
        this.store = mapDBConfig.store(path);
        Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.synchronized\u2026ject2ObjectOpenHashMap())");
        this.registry = map2;
        CatalogueV1Header header = this.getHeader();
        for (long sid : header.getSchemas()) {
            CatalogueV1Header.CatalogueEntry schema;
            if ((CatalogueV1Header.CatalogueEntry)this.store.get(sid, CatalogueV1Header.CatalogueEntry.Serializer) == null) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open Cottontail DB catalogue entry!");
            }
            Path path2 = this.getPath().resolve("schema_" + schema.getName());
            if (!Files.exists(path2, new LinkOption[0])) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Broken catalogue entry for schema '" + schema.getName() + "'. Path " + path2 + " does not exist!");
            }
            SchemaV1 s = new SchemaV1(new Name.SchemaName(schema.getName()), this);
            this.registry.put(s.getName(), s);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getDbo", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "snapshot", "Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "cleanup", "", "createSchema", "Lorg/vitrivr/cottontail/database/schema/Schema;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "dropSchema", "listSchemas", "", "schemaForName", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements CatalogueTx {
        @NotNull
        private final TxSnapshot snapshot;
        private final long closeStamp;

        @Override
        @NotNull
        public Catalogue getDbo() {
            return CatalogueV1.this;
        }

        @Override
        @NotNull
        public TxSnapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        @NotNull
        public List<Schema> listSchemas() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return CollectionsKt.toList((Iterable)CatalogueV1.this.registry.values());
        }

        @Override
        @NotNull
        public SchemaV1 schemaForName(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            SchemaV1 schemaV1 = (SchemaV1)CatalogueV1.this.registry.get(name);
            if (schemaV1 == null) {
                throw (Throwable)new DatabaseException.SchemaDoesNotExistException(name);
            }
            return schemaV1;
        }

        @Override
        @NotNull
        public Schema createSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        protected void cleanup() {
            CatalogueV1.this.closeLock.unlockRead(this.closeStamp);
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.snapshot = new TxSnapshot(){
                @NotNull
                private final List<TxAction> actions;

                @NotNull
                public List<TxAction> getActions() {
                    return this.actions;
                }

                @NotNull
                public Void commit() {
                    throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }

                @NotNull
                public Void rollback() {
                    throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }

                public boolean record(@NotNull TxAction action) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }
                {
                    this.actions = CollectionsKt.emptyList();
                }
            };
            this.closeStamp = CatalogueV1.this.closeLock.readLock();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

