/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.exceptions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0005\u0005\u0006\u0007\b\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TxException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "message", "", "(Ljava/lang/String;)V", "TxClosedException", "TxDBOClosedException", "TxInErrorException", "TxStorageException", "TxValidationException", "cottontaildb"})
public class TxException
extends DatabaseException {
    public TxException(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message, null, 2, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TxException$TxDBOClosedException;", "Lorg/vitrivr/cottontail/model/exceptions/TxException;", "tid", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "dbo", "Lorg/vitrivr/cottontail/database/general/DBO;", "(JLorg/vitrivr/cottontail/database/general/DBO;)V", "cottontaildb"})
    public static final class TxDBOClosedException
    extends TxException {
        public TxDBOClosedException(long tid, @NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            super("Tx " + tid + " could not be created for DBO '" + dbo.getName() + "': Enclosing DBO has been closed.");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TxException$TxClosedException;", "Lorg/vitrivr/cottontail/model/exceptions/TxException;", "tid", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "(J)V", "cottontaildb"})
    public static final class TxClosedException
    extends TxException {
        public TxClosedException(long tid) {
            super("Tx " + tid + " has been closed and cannot be used anymore.");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TxException$TxInErrorException;", "Lorg/vitrivr/cottontail/model/exceptions/TxException;", "tid", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "(J)V", "cottontaildb"})
    public static final class TxInErrorException
    extends TxException {
        public TxInErrorException(long tid) {
            super("Tx " + tid + " is in error and cannot be used, until it is rolled back.");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TxException$TxValidationException;", "Lorg/vitrivr/cottontail/model/exceptions/TxException;", "tid", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "message", "", "(JLjava/lang/String;)V", "cottontaildb"})
    public static final class TxValidationException
    extends TxException {
        public TxValidationException(long tid, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super("Transaction " + tid + " reported validation error: " + message);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TxException$TxStorageException;", "Lorg/vitrivr/cottontail/model/exceptions/TxException;", "tid", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "message", "", "(JLjava/lang/String;)V", "cottontaildb"})
    public static final class TxStorageException
    extends TxException {
        public TxStorageException(long tid, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super("Transaction " + tid + " reported storage error: " + message);
        }
    }
}

