/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.recordset;

import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectBigArrayBigList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.BooleanPredicate;
import org.vitrivr.cottontail.model.basics.Filterable;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.basics.Scanable;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u00015B!\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0004\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0012J'\u0010\u0018\u001a\u00020\u00192\n\u0010\u001e\u001a\u00060\u0007j\u0002`\u001f2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0004\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010$\u001a\u00020\nJ\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120&2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010'\u001a\u0004\u0018\u00010\u0012J\u0015\u0010(\u001a\u00020\u00122\n\u0010\u001e\u001a\u00060\u0007j\u0002`\u001fH\u0086\u0002J\u0012\u0010)\u001a\u00020\n2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u0005J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120&J%\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120&2\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010.J5\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120&2\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u00101J\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001203J\u000e\u00104\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00066"}, d2={"Lorg/vitrivr/cottontail/model/recordset/Recordset;", "Lorg/vitrivr/cottontail/model/basics/Scanable;", "Lorg/vitrivr/cottontail/model/basics/Filterable;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "capacity", "", "([Lorg/vitrivr/cottontail/database/column/ColumnDef;J)V", "columnCount", "", "getColumnCount", "()I", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "list", "Lit/unimi/dsi/fastutil/objects/ObjectBigArrayBigList;", "Lorg/vitrivr/cottontail/model/basics/Record;", "lock", "Ljava/util/concurrent/locks/StampedLock;", "rowCount", "getRowCount", "()J", "addRow", "", "values", "Lorg/vitrivr/cottontail/model/values/types/Value;", "([Lorg/vitrivr/cottontail/model/values/types/Value;)Z", "record", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "(J[Lorg/vitrivr/cottontail/model/values/types/Value;)Z", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "column", "filter", "", "first", "get", "indexOf", "intersect", "other", "iterator", "scan", "([Lorg/vitrivr/cottontail/database/column/ColumnDef;)Ljava/util/Iterator;", "partitionIndex", "partitions", "([Lorg/vitrivr/cottontail/database/column/ColumnDef;II)Ljava/util/Iterator;", "toList", "", "union", "RecordsetRecord", "cottontaildb"})
public final class Recordset
implements Scanable,
Filterable {
    private final ObjectBigArrayBigList<Record> list;
    private final StampedLock lock;
    @NotNull
    private final ColumnDef<?>[] columns;

    public final int getColumnCount() {
        return this.columns.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getRowCount() {
        long l;
        long stamp = this.lock.tryOptimisticRead();
        long size = this.list.size64();
        if (this.lock.validate(stamp)) {
            l = size;
        } else {
            long l2;
            try {
                stamp = this.lock.readLock();
                l2 = size;
            }
            finally {
                this.lock.unlockRead(stamp);
            }
            l = l2;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addRow(long tupleId, @NotNull Value[] values) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        StampedLock $this$write$iv = this.lock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean bl2 = false;
            bl = this.list.add((Object)new RecordsetRecord(this, tupleId, values));
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
        return bl;
    }

    public final boolean addRow(@NotNull Value[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.addRow(this.list.size64(), values);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addRow(@NotNull Record record) {
        Collection<Value> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        ColumnDef<?>[] columnDefArray = record.getColumns();
        long l = record.getTupleId();
        Recordset recordset = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var7_9 = $this$mapTo$iv$iv;
        int n = ((void)var7_9).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_13 = item$iv$iv = var7_9[i];
            collection = destination$iv$iv;
            boolean bl = false;
            Value value = record.get((ColumnDef<?>)it);
            collection.add(value);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
        if (valueArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return recordset.addRow(l, valueArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Record get(long tupleId) {
        Record record;
        long stamp = this.lock.tryOptimisticRead();
        Record value = (Record)this.list.get(tupleId);
        if (this.lock.validate(stamp)) {
            Record record2 = value;
            record = record2;
            Intrinsics.checkNotNullExpressionValue((Object)record2, (String)"value");
        } else {
            Record record3;
            try {
                stamp = this.lock.readLock();
                record3 = (Record)this.list.get(tupleId);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
            Record record4 = record3;
            record = record4;
            Intrinsics.checkNotNullExpressionValue((Object)record4, (String)"try {\n                st\u2026Read(stamp)\n            }");
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Recordset union(@NotNull Recordset other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        StampedLock $this$read$iv = this.lock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            long it;
            long element$iv;
            boolean bl = false;
            Object object = other.columns;
            Object[] objectArray = this.columns;
            boolean bl2 = false;
            if (!ArraysKt.contentDeepEquals((Object[])object, (Object[])objectArray)) {
                throw (Throwable)new IllegalArgumentException("UNION of record sets not possible; columns of the two record sets are not the same!");
            }
            object = new Recordset(this.columns, 0L, 2, null);
            boolean bl3 = false;
            bl2 = false;
            Object object2 = object;
            boolean bl4 = false;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((long)0L, (long)this.list.size64());
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = ((LongIterator)iterator2).nextLong();
                boolean bl5 = false;
                Object object3 = this.list.get(it);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"this.list[it]");
                ((Recordset)object2).addRow((Record)object3);
            }
            $this$forEach$iv = (Iterable)RangesKt.until((long)0L, (long)this.list.size64());
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = ((LongIterator)iterator2).nextLong();
                boolean bl6 = false;
                Object object4 = this.list.get(it);
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"this.list[it]");
                ((Recordset)object2).addRow((Record)object4);
            }
            Object object5 = object;
            return object5;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Recordset intersect(@NotNull Recordset other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        StampedLock $this$read$iv = this.lock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            long it;
            long element$iv;
            boolean bl = false;
            Object object = other.columns;
            Object[] objectArray = this.columns;
            boolean bl2 = false;
            if (!ArraysKt.contentDeepEquals((Object[])object, (Object[])objectArray)) {
                throw (Throwable)new IllegalArgumentException("INTERSECT of record sets not possible; columns of the two record sets are not the same!");
            }
            object = new Recordset(this.columns, 0L, 2, null);
            boolean bl3 = false;
            bl2 = false;
            Object object2 = object;
            boolean bl4 = false;
            Long2LongOpenHashMap map2 = new Long2LongOpenHashMap();
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((long)0L, (long)this.list.size64());
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = ((LongIterator)iterator2).nextLong();
                boolean bl5 = false;
                ((Map)map2).put(((Record)this.list.get(it)).getTupleId(), it);
            }
            $this$forEach$iv = (Iterable)RangesKt.until((long)0L, (long)other.list.size64());
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = ((LongIterator)iterator2).nextLong();
                boolean bl6 = false;
                Record record = (Record)this.list.get(it);
                Map map3 = (Map)map2;
                Long l = record.getTupleId();
                boolean bl7 = false;
                Map map4 = map3;
                boolean bl8 = false;
                if (!map4.containsKey(l)) continue;
                Record record2 = record;
                Intrinsics.checkNotNullExpressionValue((Object)record2, (String)"record");
                ((Recordset)object2).addRow(record2);
            }
            Object object3 = object;
            return object3;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    @Nullable
    public final Record first() {
        return (Record)CollectionsKt.first((Iterable)((Iterable)this.list));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        ColumnDef it;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate)) return false;
        Iterable $this$all$iv = predicate.getColumns();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (ColumnDef)element$iv;
            boolean bl = false;
        } while (ArraysKt.contains((Object[])this.columns, (Object)it));
        return false;
    }

    @Override
    @NotNull
    public Iterator<Record> filter(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public final ColumnDef<?> column(int column) {
        return this.columns[column];
    }

    public final int indexOf(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.indexOf((Object[])this.columns, column);
    }

    @NotNull
    public final List<Record> toList() {
        return CollectionsKt.toList((Iterable)((Iterable)this.list));
    }

    @NotNull
    public final Iterator<Record> iterator() {
        return this.scan(this.columns);
    }

    @Override
    @NotNull
    public Iterator<Record> scan(@NotNull ColumnDef<?>[] columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        return this.scan(columns, 0, 1);
    }

    @Override
    @NotNull
    public Iterator<Record> scan(@NotNull ColumnDef<?>[] columns, int partitionIndex, int partitions) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        return new Iterator<Record>(this, partitions, partitionIndex){
            private final LongRange range;
            private volatile long pointer;
            final /* synthetic */ Recordset this$0;
            final /* synthetic */ int $partitions;
            final /* synthetic */ int $partitionIndex;

            public boolean hasNext() {
                return this.pointer < Recordset.access$getList$p(this.this$0).size64();
            }

            @NotNull
            public Record next() {
                Record record = (Record)Recordset.access$getList$p(this.this$0).get(this.pointer);
                ++this.pointer;
                Record record2 = record;
                Intrinsics.checkNotNullExpressionValue((Object)record2, (String)"record");
                return record2;
            }
            {
                this.this$0 = this$0;
                this.$partitions = $captured_local_variable$1;
                this.$partitionIndex = $captured_local_variable$2;
                long maximum = this$0.getRowCount();
                long partitionSize = Math.floorDiv(maximum, (long)$captured_local_variable$1) + 1L;
                long start = (long)$captured_local_variable$2 * partitionSize;
                long l = (long)($captured_local_variable$2 + 1) * partitionSize;
                boolean bl = false;
                long end = Math.min(l, maximum);
                this.range = RangesKt.until((long)start, (long)end);
                this.pointer = this.range.getFirst();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public Recordset(@NotNull ColumnDef<?>[] columns, long capacity) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columns = columns;
        this.list = new ObjectBigArrayBigList(capacity);
        this.lock = new StampedLock();
    }

    public /* synthetic */ Recordset(ColumnDef[] columnDefArray, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 250L;
        }
        this(columnDefArray, l);
    }

    public static final /* synthetic */ ObjectBigArrayBigList access$getList$p(Recordset $this) {
        return $this.list;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0001H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J(\u0010\u0018\u001a\u00020\u00192\u001e\u0010\u001a\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00190\u001bH\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00062\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002J\u0014\u0010\u001e\u001a\u00020\u00152\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u001f\u0010!\u001a\u00020\u00192\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010\"\u001a\u0004\u0018\u00010\u0006H\u0096\u0002J\u001a\u0010#\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060$H\u0016R\u001e\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR,\u0010\f\u001a \u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u000e*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lorg/vitrivr/cottontail/model/recordset/Recordset$RecordsetRecord;", "Lorg/vitrivr/cottontail/model/basics/Record;", "tupleId", "", "values", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "(Lorg/vitrivr/cottontail/model/recordset/Recordset;J[Lorg/vitrivr/cottontail/model/values/types/Value;)V", "columns", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "map", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "kotlin.jvm.PlatformType", "getTupleId", "()J", "setTupleId", "(J)V", "copy", "equals", "", "other", "", "forEach", "", "action", "Lkotlin/Function2;", "get", "column", "has", "hashCode", "", "set", "value", "toMap", "", "cottontaildb"})
    public final class RecordsetRecord
    implements Record {
        private final Object2ObjectOpenHashMap<ColumnDef<?>, Value> map;
        private long tupleId;
        final /* synthetic */ Recordset this$0;

        @Override
        @NotNull
        public ColumnDef<?>[] getColumns() {
            return this.this$0.getColumns();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Record copy() {
            Collection<Value> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ColumnDef<?>[] columnDefArray = this.getColumns();
            ColumnDef<?>[] columnDefArray2 = this.getColumns();
            long l = this.getTupleId();
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var6_8 = $this$mapTo$iv$iv;
            int n = ((void)var6_8).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_12 = item$iv$iv = var6_8[i];
                collection = destination$iv$iv;
                boolean bl = false;
                Value value = (Value)this.map.get((Object)it);
                collection.add(value);
            }
            collection = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
            if (valueArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Value[] valueArray2 = valueArray;
            ColumnDef<?>[] columnDefArray3 = columnDefArray2;
            long l2 = l;
            return new StandaloneRecord(l2, columnDefArray3, valueArray2);
        }

        @Override
        public void forEach(@NotNull Function2<? super ColumnDef<?>, ? super Value, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            for (ColumnDef<?> c : this.getColumns()) {
                action.invoke(c, this.map.get(c));
            }
        }

        @Override
        public boolean has(@NotNull ColumnDef<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            return this.map.containsKey(column);
        }

        @Override
        @NotNull
        public Map<ColumnDef<?>, Value> toMap() {
            Map<ColumnDef<?>, Value> map2 = Collections.unmodifiableMap((Map)this.map);
            Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(this.map)");
            return map2;
        }

        @Override
        @Nullable
        public Value get(@NotNull ColumnDef<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Map map2 = (Map)this.map;
            boolean bl = false;
            Map map3 = map2;
            boolean bl2 = false;
            boolean bl3 = map3.containsKey(column);
            bl = false;
            boolean bl4 = false;
            if (!bl3) {
                boolean bl5 = false;
                String string = "The specified column " + column.getName() + "  (type=" + column.getType().getName() + ") is not contained in this record.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return (Value)this.map.get(column);
        }

        @Override
        public void set(@NotNull ColumnDef<?> column, @Nullable Value value) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Map map2 = (Map)this.map;
            boolean bl = false;
            Map map3 = map2;
            boolean bl2 = false;
            boolean bl3 = map3.containsKey(column);
            bl = false;
            boolean bl4 = false;
            if (!bl3) {
                boolean bl5 = false;
                String string = "The specified column " + column.getName() + "  (type=" + column.getType().getName() + ") is not contained in this record.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (!column.validate(value)) {
                throw (Throwable)new IllegalArgumentException("Provided value " + value + " is incompatible with column " + column + '.');
            }
            ((Map)this.map).put(column, value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.recordset.Recordset.RecordsetRecord");
            }
            RecordsetRecord cfr_ignored_0 = (RecordsetRecord)object2;
            if (this.getTupleId() != ((RecordsetRecord)other).getTupleId()) {
                return false;
            }
            return !(Intrinsics.areEqual(this.map, ((RecordsetRecord)other).map) ^ true);
        }

        public int hashCode() {
            int result = Long.hashCode(this.getTupleId());
            result = 31 * result + this.getColumns().hashCode();
            result = 31 * result + this.map.hashCode();
            return result;
        }

        @Override
        public long getTupleId() {
            return this.tupleId;
        }

        @Override
        public void setTupleId(long l) {
            this.tupleId = l;
        }

        /*
         * WARNING - void declaration
         */
        public RecordsetRecord(Recordset this$0, @NotNull long tupleId, Value[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            this.this$0 = this$0;
            this.tupleId = tupleId;
            boolean bl = values.length == this.getColumns().length;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "The number of values must be equal to the number of columns held by the StandaloneRecord (v = " + values.length + ", c = " + this.getColumns().length + ')';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ColumnDef<?>[] $this$forEachIndexed$iv = this.getColumns();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (ColumnDef<?> item$iv : $this$forEachIndexed$iv) {
                void columnDef;
                int n = index$iv++;
                ColumnDef<?> columnDef2 = item$iv;
                int index = n;
                boolean bl5 = false;
                if (columnDef.validate(values[index])) continue;
                throw (Throwable)new IllegalArgumentException("Provided value " + values[index] + " is incompatible with column " + columnDef + '.');
            }
            this.map = new Object2ObjectOpenHashMap((Object[])this.getColumns(), (Object[])values);
        }

        public /* synthetic */ RecordsetRecord(Recordset recordset, long l, Value[] valueArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                int n2 = recordset.getColumns().length;
                Value[] valueArray2 = new Value[n2];
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = n3;
                    int n5 = n3++;
                    Value[] valueArray3 = valueArray2;
                    boolean bl = false;
                    Object var14_13 = null;
                    valueArray3[n5] = var14_13;
                }
                valueArray = valueArray2;
            }
            this(recordset, l, valueArray);
        }

        @Override
        public int getSize() {
            return Record.DefaultImpls.getSize(this);
        }
    }
}

