/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.queries.OperatorNode;
import org.vitrivr.cottontail.database.queries.QueryContext;
import org.vitrivr.cottontail.database.queries.binding.GrpcQueryBinder;
import org.vitrivr.cottontail.database.queries.planning.CottontailQueryPlanner;
import org.vitrivr.cottontail.database.queries.planning.rules.RewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.DeferFetchOnFetchRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.DeferFetchOnScanRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.LeftConjunctionOnSubselectRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.LeftConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.RightConjunctionOnSubselectRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.RightConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.BooleanIndexScanRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.KnnIndexScanRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.merge.LimitingSortMergeRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.pushdown.CountPushdownRule;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.operators.sinks.SpoolerSinkOperator;
import org.vitrivr.cottontail.execution.operators.system.ExplainQueryOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DQLGrpc;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.ExecutionException;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TransactionException;
import org.vitrivr.cottontail.server.grpc.services.TransactionService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0016J\u001e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DQLService;", "Lorg/vitrivr/cottontail/grpc/DQLGrpc$DQLImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionService;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/database/catalogue/Catalogue;Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "binder", "Lorg/vitrivr/cottontail/database/queries/binding/GrpcQueryBinder;", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "planner", "Lorg/vitrivr/cottontail/database/queries/planning/CottontailQueryPlanner;", "explain", "", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "ping", "Lcom/google/protobuf/Empty;", "query", "cottontaildb"})
@ExperimentalTime
public final class DQLService
extends DQLGrpc.DQLImplBase
implements TransactionService {
    private final GrpcQueryBinder binder;
    private final CottontailQueryPlanner planner;
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final TransactionManager manager;

    public void query(@NotNull CottontailGrpc.QueryMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        this.withTransactionContext(transactionId, responseObserver, (Function2<? super TransactionManager.Transaction, ? super String, Status>)((Function2)new Function2<TransactionManager.Transaction, String, Status>(this, request, responseObserver){
            final /* synthetic */ DQLService this$0;
            final /* synthetic */ CottontailGrpc.QueryMessage $request;
            final /* synthetic */ StreamObserver $responseObserver;

            @NotNull
            public final Status invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Status status;
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                try {
                    QueryContext ctx = new QueryContext(tx);
                    boolean $i$f$measureTime = false;
                    boolean bl = false;
                    TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                    boolean $i$f$measureTime2 = false;
                    boolean bl2 = false;
                    TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
                    boolean bl3 = false;
                    GrpcQueryBinder grpcQueryBinder = DQLService.access$getBinder$p(this.this$0);
                    CottontailGrpc.Query query2 = this.$request.getQuery();
                    Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"request.query");
                    grpcQueryBinder.bind(query2, ctx);
                    CottontailQueryPlanner.planAndSelect$default(DQLService.access$getPlanner$p(this.this$0), ctx, false, false, 6, null);
                    tx.execute(new SpoolerSinkOperator(ctx.toOperatorTree(tx), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver));
                    double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
                    Status status2 = Status.OK.withDescription(this.this$0.formatMessage(tx, q, "Executing query took " + Duration.toString-impl((double)totalDuration) + '.'));
                    Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"Status.OK.withDescriptio\u2026took ${totalDuration}.\"))");
                    status = status2;
                }
                catch (QueryException.QuerySyntaxException e) {
                    Status status3 = Status.INVALID_ARGUMENT.withDescription(this.this$0.formatMessage(tx, q, "Could not execute query due to syntax error: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status3, (String)"Status.INVALID_ARGUMENT.\u2026ax error: ${e.message}\"))");
                    status = status3;
                }
                catch (QueryException.QueryBindException e) {
                    Status status4 = Status.INVALID_ARGUMENT.withDescription(this.this$0.formatMessage(tx, q, "Could not execute query because DBO could not be found: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status4, (String)"Status.INVALID_ARGUMENT.\u2026be found: ${e.message}\"))");
                    status = status4;
                }
                catch (TransactionException.DeadlockException e) {
                    Status status5 = Status.ABORTED.withDescription(this.this$0.formatMessage(tx, q, "Could not execute query due to deadlock with other transaction: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status5, (String)"Status.ABORTED.withDescr\u2026nsaction: ${e.message}\"))");
                    status = status5;
                }
                catch (QueryException.QueryPlannerException e) {
                    Status status6 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Could not execute query because of an error during query planning: " + e.getMessage())).withCause((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)status6, (String)"Status.INTERNAL.withDesc\u2026.message}\")).withCause(e)");
                    status = status6;
                }
                catch (DatabaseException e) {
                    Status status7 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Could not execute query due to database error: " + e.getMessage())).withCause((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)status7, (String)"Status.INTERNAL.withDesc\u2026.message}\")).withCause(e)");
                    status = status7;
                }
                catch (ExecutionException e) {
                    Status status8 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Could not execute query due to an unhandled execution error: " + e.getMessage())).withCause((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)status8, (String)"Status.INTERNAL.withDesc\u2026.message}\")).withCause(e)");
                    status = status8;
                }
                catch (Throwable e) {
                    Status status9 = Status.UNKNOWN.withDescription(this.this$0.formatMessage(tx, q, "Could not execute query due to an unhandled error: " + e.getMessage())).withCause(e);
                    Intrinsics.checkNotNullExpressionValue((Object)status9, (String)"Status.UNKNOWN.withDescr\u2026.message}\")).withCause(e)");
                    status = status9;
                }
                return status;
            }
            {
                this.this$0 = dQLService;
                this.$request = queryMessage;
                this.$responseObserver = streamObserver;
                super(2);
            }
        }));
    }

    public void explain(@NotNull CottontailGrpc.QueryMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        CottontailGrpc.TransactionId transactionId = request.getTxId();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
        this.withTransactionContext(transactionId, responseObserver, (Function2<? super TransactionManager.Transaction, ? super String, Status>)((Function2)new Function2<TransactionManager.Transaction, String, Status>(this, request, responseObserver){
            final /* synthetic */ DQLService this$0;
            final /* synthetic */ CottontailGrpc.QueryMessage $request;
            final /* synthetic */ StreamObserver $responseObserver;

            @NotNull
            public final Status invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Status status;
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                try {
                    QueryContext ctx = new QueryContext(tx);
                    boolean $i$f$measureTime = false;
                    boolean bl = false;
                    TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                    boolean $i$f$measureTime2 = false;
                    boolean bl2 = false;
                    TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
                    boolean bl3 = false;
                    GrpcQueryBinder grpcQueryBinder = DQLService.access$getBinder$p(this.this$0);
                    CottontailGrpc.Query query2 = this.$request.getQuery();
                    Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"request.query");
                    grpcQueryBinder.bind(query2, ctx);
                    Collection<OperatorNode.Physical> candidates = DQLService.access$getPlanner$p(this.this$0).plan(ctx);
                    tx.execute(new SpoolerSinkOperator(new ExplainQueryOperator(candidates), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver));
                    double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
                    Status status2 = Status.OK.withDescription(this.this$0.formatMessage(tx, q, "Explaining query took " + Duration.toString-impl((double)totalDuration) + '.'));
                    Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"Status.OK.withDescriptio\u2026took ${totalDuration}.\"))");
                    status = status2;
                }
                catch (QueryException.QuerySyntaxException e) {
                    Status status3 = Status.INVALID_ARGUMENT.withDescription(this.this$0.formatMessage(tx, q, "Could not explain query due to syntax error: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status3, (String)"Status.INVALID_ARGUMENT.\u2026ax error: ${e.message}\"))");
                    status = status3;
                }
                catch (QueryException.QueryBindException e) {
                    Status status4 = Status.INVALID_ARGUMENT.withDescription(this.this$0.formatMessage(tx, q, "Could not explain query because DBO could not be found: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status4, (String)"Status.INVALID_ARGUMENT.\u2026be found: ${e.message}\"))");
                    status = status4;
                }
                catch (TransactionException.DeadlockException e) {
                    Status status5 = Status.ABORTED.withDescription(this.this$0.formatMessage(tx, q, "Could not explain query due to deadlock with other transaction: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status5, (String)"Status.ABORTED.withDescr\u2026nsaction: ${e.message}\"))");
                    status = status5;
                }
                catch (QueryException.QueryPlannerException e) {
                    Status status6 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Could not execute query because of an error during query planning: " + e.getMessage())).withCause((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)status6, (String)"Status.INTERNAL.withDesc\u2026.message}\")).withCause(e)");
                    status = status6;
                }
                catch (DatabaseException e) {
                    Status status7 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Could not explain query due to database error: " + e.getMessage())).withCause((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)status7, (String)"Status.INTERNAL.withDesc\u2026.message}\")).withCause(e)");
                    status = status7;
                }
                catch (ExecutionException e) {
                    Status status8 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Could not explain query due to an unhandled execution error: " + e.getMessage())).withCause((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)status8, (String)"Status.INTERNAL.withDesc\u2026.message}\")).withCause(e)");
                    status = status8;
                }
                catch (Throwable e) {
                    Status status9 = Status.UNKNOWN.withDescription(this.this$0.formatMessage(tx, q, "Could not explain query due to an unhandled error: " + e.getMessage())).withCause(e);
                    Intrinsics.checkNotNullExpressionValue((Object)status9, (String)"Status.UNKNOWN.withDescr\u2026.message}\")).withCause(e)");
                    status = status9;
                }
                return status;
            }
            {
                this.this$0 = dQLService;
                this.$request = queryMessage;
                this.$responseObserver = streamObserver;
                super(2);
            }
        }));
    }

    public void ping(@NotNull Empty request, @NotNull StreamObserver<Empty> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        responseObserver.onNext((Object)Empty.getDefaultInstance());
        responseObserver.onCompleted();
    }

    @NotNull
    public final Catalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    public DQLService(@NotNull Catalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.catalogue = catalogue;
        this.manager = manager;
        this.binder = new GrpcQueryBinder(this.catalogue);
        this.planner = new CottontailQueryPlanner(CollectionsKt.listOf((Object[])new RewriteRule[]{LeftConjunctionRewriteRule.INSTANCE, RightConjunctionRewriteRule.INSTANCE, LeftConjunctionOnSubselectRewriteRule.INSTANCE, RightConjunctionOnSubselectRewriteRule.INSTANCE, DeferFetchOnScanRewriteRule.INSTANCE, DeferFetchOnFetchRewriteRule.INSTANCE}), CollectionsKt.listOf((Object[])new RewriteRule[]{BooleanIndexScanRule.INSTANCE, KnnIndexScanRule.INSTANCE, CountPushdownRule.INSTANCE, LimitingSortMergeRule.INSTANCE}), this.catalogue.getConfig().getCache().getPlanCacheSize());
    }

    @Override
    public void withTransactionContext(@NotNull CottontailGrpc.TransactionId txId, @NotNull StreamObserver<?> responseObserver, @NotNull Function2<? super TransactionManager.Transaction, ? super String, Status> action) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        TransactionService.DefaultImpls.withTransactionContext(this, txId, responseObserver, action);
    }

    @Override
    @NotNull
    public String formatMessage(@NotNull TransactionManager.Transaction tx, @NotNull String queryId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return TransactionService.DefaultImpls.formatMessage(this, tx, queryId, message);
    }

    public static final /* synthetic */ GrpcQueryBinder access$getBinder$p(DQLService $this) {
        return $this.binder;
    }

    public static final /* synthetic */ CottontailQueryPlanner access$getPlanner$p(DQLService $this) {
        return $this.planner;
    }
}

