package org.vitrivr.cottontail.database.queries.planning.nodes.logical.projection

import org.vitrivr.cottontail.database.column.ColumnDef
import org.vitrivr.cottontail.database.queries.OperatorNode
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.UnaryLogicalOperatorNode
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.projection.CountProjectionPhysicalOperatorNode
import org.vitrivr.cottontail.database.queries.projection.Projection
import org.vitrivr.cottontail.model.basics.Name
import org.vitrivr.cottontail.model.basics.Type

/**
 * A [UnaryLogicalOperatorNode] that represents a projection operation involving aggregate functions such as [Projection.COUNT].
 *
 * @author Ralph Gasser
 * @version 2.1.0
 */
class CountProjectionLogicalOperatorNode(input: OperatorNode.Logical? = null, fields: List<Pair<Name.ColumnName, Name.ColumnName?>>) : AbstractProjectionLogicalOperatorOperator(input, Projection.COUNT, fields) {

    /** The [ColumnDef] generated by this [CountProjectionLogicalOperatorNode]. */
    override val columns: Array<ColumnDef<*>>
        get() {
            val alias = this.fields.first().second
            val name = alias ?: (this.input?.columns?.first()?.name?.entity()?.column(Projection.COUNT.label()) ?: Name.ColumnName(Projection.COUNT.label()))
            return arrayOf(ColumnDef(name, Type.Long, false))
        }

    /** The [ColumnDef] required by this [CountProjectionLogicalOperatorNode]. */
    override val requires: Array<ColumnDef<*>> = emptyArray()

    /**
     * Creates and returns a copy of this [CountProjectionLogicalOperatorNode] without any children or parents.
     *
     * @return Copy of this [CountProjectionLogicalOperatorNode].
     */
    override fun copy() = CountProjectionLogicalOperatorNode(fields = this.fields)

    /**
     * Returns a [CountProjectionPhysicalOperatorNode] representation of this [CountProjectionLogicalOperatorNode]
     *
     * @return [CountProjectionPhysicalOperatorNode]
     */
    override fun implement(): Physical = CountProjectionPhysicalOperatorNode(this.input?.implement(), this.fields)
}