/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.gg;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SplittableRandom;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.gg.GGIndex;
import org.vitrivr.cottontail.database.index.gg.GGIndexConfig;
import org.vitrivr.cottontail.database.index.pq.PQIndex;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.knn.KnnPredicate;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.math.knn.basics.DistanceKernel;
import org.vitrivr.cottontail.math.knn.kernels.Distances;
import org.vitrivr.cottontail.math.knn.selection.ComparablePair;
import org.vitrivr.cottontail.math.knn.selection.MinHeapSelection;
import org.vitrivr.cottontail.math.knn.selection.MinSingleSelection;
import org.vitrivr.cottontail.math.knn.selection.Selection;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;
import org.vitrivr.cottontail.storage.serializers.ValueSerializerFactory;
import org.vitrivr.cottontail.utilities.math.KnnUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006*"}, d2={"Lorg/vitrivr/cottontail/database/index/gg/GGIndex;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/database/index/gg/GGIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/database/index/gg/GGIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/database/index/gg/GGIndexConfig;", "groupsStore", "Lorg/mapdb/HTreeMap;", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "", "produces", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class GGIndex
extends AbstractIndex {
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final IndexType type;
    @NotNull
    private final GGIndexConfig config;
    private final HTreeMap<VectorValue<?>, long[]> groupsStore;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    public static final String GG_INDEX_NAME = "cdb_gg_means";
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public GGIndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof KnnPredicate && Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) && ((KnnPredicate)predicate).getDistance() == this.getConfig().getDistance();
    }

    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return Cost.Companion.getZERO();
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    public GGIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable GGIndexConfig config) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        this.produces = new ColumnDef[]{KnnUtilities.INSTANCE.distanceColumnDef(this.getParent().getName())};
        this.type = IndexType.GG;
        DB dB = this.getStore();
        ValueSerializerFactory<?> valueSerializerFactory = this.getColumns()[0].getType().serializerFactory();
        if (valueSerializerFactory == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.mapdb.Serializer<org.vitrivr.cottontail.model.values.types.VectorValue<*>>");
        }
        Serializer serializer2 = (Serializer)valueSerializerFactory;
        GroupSerializer groupSerializer = Serializer.LONG_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.LONG_ARRAY");
        this.groupsStore = dB.hashMap(GG_INDEX_NAME, serializer2, (Serializer)groupSerializer).counterEnable().createOrOpen();
        boolean bl = this.getColumns().length == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "GGIndex only supports indexing a single column.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar(GG_INDEX_NAME, (Serializer)GGIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            this.config = config != null ? config : new GGIndexConfig(50, System.currentTimeMillis(), Distances.L2);
            configOnDisk.set((Object)this.getConfig());
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (GGIndexConfig)object;
        }
        this.getStore().commit();
    }

    public /* synthetic */ GGIndex(Path path, DefaultEntity defaultEntity, GGIndexConfig gGIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            gGIndexConfig = null;
        }
        this(path, defaultEntity, gGIndexConfig);
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(GGIndex.class);
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/database/index/gg/GGIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/gg/GGIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "clear", "", "count", "", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        @Override
        public long count() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return GGIndex.this.groupsStore.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            PQIndex.Companion.getLOGGER().debug("Rebuilding GG index {}", (Object)GGIndex.this.getName());
            org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
            if (tx == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
            }
            EntityTx txn = (EntityTx)tx;
            boolean bl2 = false;
            Set remainingTids = new LinkedHashSet();
            Iterator<Record> $this$forEach$iv = txn.scan(new ColumnDef[0]);
            boolean $i$f$forEach = false;
            Iterator<Record> iterator2 = $this$forEach$iv;
            boolean bl3 = false;
            Iterator<Record> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Record element$iv;
                Record it = element$iv = iterator3.next();
                boolean bl4 = false;
                remainingTids.add(it.getTupleId());
            }
            int groupSize = (remainingTids.size() + GGIndex.this.getConfig().getNumGroups() - 1) / GGIndex.this.getConfig().getNumGroups();
            boolean bl5 = false;
            Set finishedTIds = new LinkedHashSet();
            SplittableRandom random2 = new SplittableRandom(GGIndex.this.getConfig().getSeed());
            GGIndex.this.groupsStore.clear();
            while (true) {
                Collection collection = remainingTids;
                boolean bl6 = false;
                if (!(!collection.isEmpty())) break;
                long groupSeedTid = ((Number)CollectionsKt.elementAt((Iterable)remainingTids, (int)random2.nextInt(remainingTids.size()))).longValue();
                Value groupSeedValue = txn.read(groupSeedTid, GGIndex.this.getColumns()).get(GGIndex.this.getColumns()[0]);
                if (!(groupSeedValue instanceof VectorValue)) continue;
                if (GGIndex.this.getConfig().getDistance().kernelForQuery((VectorValue)groupSeedValue) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.math.knn.basics.DistanceKernel<org.vitrivr.cottontail.model.values.types.VectorValue<*>>");
                }
                MinHeapSelection<Comparable> knn = new MinHeapSelection<Comparable>(groupSize);
                Iterable $this$forEach$iv2 = remainingTids;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    DistanceKernel<?> kernel;
                    long tid = ((Number)element$iv).longValue();
                    boolean bl7 = false;
                    Record r = txn.read(tid, GGIndex.this.getColumns());
                    Value vec = r.get(GGIndex.this.getColumns()[0]);
                    if (!(vec instanceof VectorValue)) continue;
                    double distance = kernel.invoke-He8yXgM((VectorValue)vec);
                    if (knn.getSize() >= groupSize) {
                        Object t = knn.peek();
                        Intrinsics.checkNotNull(t);
                        if (DoubleValue.compareTo-impl(((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), DoubleValue.box-impl(distance)) <= 0) continue;
                    }
                    knn.offer(new ComparablePair<Pair, DoubleValue>(new Pair((Object)tid, (Object)vec), DoubleValue.box-impl(distance)));
                }
                VectorValue groupMean = ((VectorValue)groupSeedValue).new();
                int n = 0;
                List groupTids = new ArrayList();
                n = 0;
                int n2 = knn.getSize();
                while (n < n2) {
                    void i;
                    Pair element = (Pair)((ComparablePair)knn.get((int)i)).getFirst();
                    groupMean = groupMean.plus((VectorValue)element.getSecond());
                    groupTids.add(element.getFirst());
                    boolean bl8 = remainingTids.remove(element.getFirst());
                    boolean bl9 = false;
                    boolean bl10 = false;
                    if (!bl8) {
                        boolean bl11 = false;
                        String string = GGIndex.this.getName().getSimple() + " processed an element that should have been removed by now.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    bl8 = finishedTIds.add(element.getFirst());
                    bl9 = false;
                    bl10 = false;
                    if (!bl8) {
                        boolean bl12 = false;
                        String string = GGIndex.this.getName().getSimple() + " processed an element that was already processed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    ++i;
                }
                groupMean = groupMean.div(DoubleValue.box-impl(DoubleValue.constructor-impl((Number)knn.getSize())));
                ((Map)GGIndex.this.groupsStore).put(groupMean, CollectionsKt.toLongArray((Collection)groupTids));
            }
            GGIndex.this.getDirtyField().compareAndSet(true, false);
            PQIndex.Companion.getLOGGER().debug("Rebuilding GGIndex {} complete.", (Object)GGIndex.this.getName());
        }

        @Override
        public void update(@NotNull DataChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            GGIndex.this.getDirtyField().compareAndSet(false, true);
        }

        @Override
        public void clear() {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            GGIndex.this.getDirtyField().compareAndSet(false, true);
            GGIndex.this.groupsStore.clear();
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(this, predicate){
                private final KnnPredicate predicate;
                private final VectorValue<?> vector;
                private final Lazy resultsQueue$delegate;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                private final ArrayDeque<StandaloneRecord> getResultsQueue() {
                    Lazy lazy = this.resultsQueue$delegate;
                    filter.1 var2_2 = this;
                    Object var3_3 = null;
                    boolean bl = false;
                    return (ArrayDeque)lazy.getValue();
                }

                public boolean hasNext() {
                    Collection collection = (Collection)this.getResultsQueue();
                    boolean bl = false;
                    return !collection.isEmpty();
                }

                @NotNull
                public Record next() {
                    return (Record)this.getResultsQueue().removeFirst();
                }

                /*
                 * WARNING - void declaration
                 */
                private final ArrayDeque<StandaloneRecord> prepareResults() {
                    int considerNumGroups = (this.this$0.GGIndex.this.getConfig().getNumGroups() + 9) / 10;
                    org.vitrivr.cottontail.database.general.Tx tx = this.this$0.getContext().getTx(this.this$0.GGIndex.this.getParent());
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
                    }
                    EntityTx txn = (EntityTx)tx;
                    DistanceKernel<?> distanceKernel = this.this$0.GGIndex.this.getConfig().getDistance().kernelForQuery(this.vector);
                    if (distanceKernel == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.math.knn.basics.DistanceKernel<org.vitrivr.cottontail.model.values.types.VectorValue<*>>");
                    }
                    DistanceKernel<?> kernel = distanceKernel;
                    boolean bl = (long)this.predicate.getK() < txn.maxTupleId() / (long)this.this$0.GGIndex.this.getConfig().getNumGroups() * (long)considerNumGroups;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean $i$a$-require-GGIndex$Tx$filter$1$prepareResults$22 = false;
                        String string = "Value of k is too large for this index considering " + considerNumGroups + " groups.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    MinHeapSelection<Comparable> groupKnn = new MinHeapSelection<Comparable>(considerNumGroups);
                    GGIndex.Companion.getLOGGER().debug("Scanning group mean signals.");
                    Map $this$forEach$iv = (Map)GGIndex.access$getGroupsStore$p(this.this$0.GGIndex.this);
                    int $i$f$forEach = 0;
                    Map $i$a$-require-GGIndex$Tx$filter$1$prepareResults$22 = $this$forEach$iv;
                    int n = 0;
                    Iterator<Map.Entry<K, V>> iterator2 = $i$a$-require-GGIndex$Tx$filter$1$prepareResults$22.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> it = element$iv = iterator2.next();
                        boolean bl4 = false;
                        V v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                        K k = it.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                        groupKnn.offer(new ComparablePair<V, DoubleValue>(v, DoubleValue.box-impl(kernel.invoke-He8yXgM((VectorValue)k))));
                    }
                    Selection knn = this.predicate.getK() == 1 ? (Selection)new MinSingleSelection<T>() : (Selection)new MinHeapSelection<T>(this.predicate.getK());
                    GGIndex.Companion.getLOGGER().debug("Scanning group members.");
                    $i$f$forEach = 0;
                    int $i$a$-require-GGIndex$Tx$filter$1$prepareResults$22 = groupKnn.getSize();
                    while ($i$f$forEach < $i$a$-require-GGIndex$Tx$filter$1$prepareResults$22) {
                        void k;
                        for (long tupleId : (long[])((ComparablePair)groupKnn.get((int)k)).getFirst()) {
                            Value value = txn.read(tupleId, this.this$0.GGIndex.this.getColumns()).get(this.this$0.GGIndex.this.getColumns()[0]);
                            if (!(value instanceof VectorValue)) continue;
                            double distance = kernel.invoke-He8yXgM((VectorValue)value);
                            if (knn.getSize() >= knn.getK()) {
                                T t = knn.peek();
                                Intrinsics.checkNotNull(t);
                                if (DoubleValue.compareTo-impl(((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), DoubleValue.box-impl(distance)) <= 0) continue;
                            }
                            knn.offer((Comparable)new ComparablePair<Long, DoubleValue>(tupleId, DoubleValue.box-impl(distance)));
                        }
                        ++k;
                    }
                    ArrayDeque queue = new ArrayDeque(this.predicate.getK());
                    $i$a$-require-GGIndex$Tx$filter$1$prepareResults$22 = 0;
                    n = knn.getSize();
                    while ($i$a$-require-GGIndex$Tx$filter$1$prepareResults$22 < n) {
                        void i;
                        queue.add((Object)new StandaloneRecord(((Number)((ComparablePair)knn.get((int)i)).getFirst()).longValue(), this.this$0.GGIndex.this.getProduces(), new Value[]{(Value)((ComparablePair)knn.get((int)i)).getSecond()}));
                        ++i;
                    }
                    return queue;
                }
                {
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    if (!($captured_local_variable$1 instanceof KnnPredicate) || ((KnnPredicate)$captured_local_variable$1).getDistance() != this$0.GGIndex.this.getConfig().getDistance()) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.GGIndex.this.getName() + "' (GGIndex) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (KnnPredicate)$captured_local_variable$1;
                    this.resultsQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayDeque<StandaloneRecord>>(this){
                        final /* synthetic */ filter.1 this$0;

                        @NotNull
                        public final ArrayDeque<StandaloneRecord> invoke() {
                            return filter.1.access$prepareResults(this.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    AbstractTx this_$iv = this$0;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                        this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    }
                    boolean bl = false;
                    Value value = this.predicate.getQuery().getValue();
                    boolean bl2 = value instanceof VectorValue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = "Bound value for query vector has wrong type (found = " + value.getType() + ").";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    this.vector = (VectorValue)value;
                }

                public static final /* synthetic */ ArrayDeque access$prepareResults(filter.1 $this) {
                    return $this.prepareResults();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw (Throwable)new UnsupportedOperationException("The UniqueHashIndex does not support ranged filtering!");
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
        }

        public static final /* synthetic */ Object access$withReadLock(Tx $this, Function0 block) {
            return $this.withReadLock(block);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/database/index/gg/GGIndex$Companion;", "", "()V", "GG_INDEX_NAME", "", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "cottontaildb"})
    public static final class Companion {
        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

