/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.predicates.knn;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.database.queries.binding.BindingContext;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.knn.KnnPredicateHint;
import org.vitrivr.cottontail.math.knn.basics.DistanceKernel;
import org.vitrivr.cottontail.math.knn.kernels.Distances;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.values.types.RealVectorValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;
import org.vitrivr.cottontail.utilities.math.KnnUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BM\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010$\u001a\u00020\u00002\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\b\u0010-\u001a\u00020\u0005H\u0016J\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"\u00a8\u00060"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/knn/KnnPredicate;", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "column", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "k", "", "distance", "Lorg/vitrivr/cottontail/math/knn/kernels/Distances;", "hint", "Lorg/vitrivr/cottontail/database/queries/predicates/knn/KnnPredicateHint;", "query", "Lorg/vitrivr/cottontail/database/queries/binding/Binding;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "weight", "(Lorg/vitrivr/cottontail/database/column/ColumnDef;ILorg/vitrivr/cottontail/math/knn/kernels/Distances;Lorg/vitrivr/cottontail/database/queries/predicates/knn/KnnPredicateHint;Lorg/vitrivr/cottontail/database/queries/binding/Binding;Lorg/vitrivr/cottontail/database/queries/binding/Binding;)V", "atomicCpuCost", "", "getAtomicCpuCost", "()F", "getColumn", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "columns", "", "getColumns", "()Ljava/util/Set;", "getDistance", "()Lorg/vitrivr/cottontail/math/knn/kernels/Distances;", "getHint", "()Lorg/vitrivr/cottontail/database/queries/predicates/knn/KnnPredicateHint;", "getK", "()I", "produces", "getProduces", "getQuery", "()Lorg/vitrivr/cottontail/database/queries/binding/Binding;", "getWeight", "bindValues", "ctx", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "digest", "", "equals", "", "other", "", "hashCode", "toKernel", "Lorg/vitrivr/cottontail/math/knn/basics/DistanceKernel;", "cottontaildb"})
public final class KnnPredicate
implements Predicate {
    @NotNull
    private final ColumnDef<?> column;
    private final int k;
    @NotNull
    private final Distances distance;
    @Nullable
    private final KnnPredicateHint hint;
    @NotNull
    private final Binding<Value> query;
    @Nullable
    private final Binding<Value> weight;

    @Override
    @NotNull
    public Set<ColumnDef<?>> getColumns() {
        return SetsKt.setOf(this.column);
    }

    @NotNull
    public final ColumnDef<?> getProduces() {
        return KnnUtilities.INSTANCE.distanceColumnDef(this.column.getName().entity());
    }

    @Override
    public float getAtomicCpuCost() {
        return this.weight == null ? this.distance.cost(this.column.getType().getLogicalSize(), true) : (float)2 * this.distance.cost(this.column.getType().getLogicalSize(), false);
    }

    @Override
    @NotNull
    public KnnPredicate bindValues(@NotNull BindingContext<Value> ctx) {
        block0: {
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            this.query.setContext$cottontaildb(ctx);
            Binding<Value> binding = this.weight;
            if (binding == null) break block0;
            binding.setContext$cottontaildb(ctx);
        }
        return this;
    }

    @NotNull
    public final DistanceKernel<?> toKernel() {
        DistanceKernel distanceKernel;
        if (this.weight != null) {
            Value value = this.query.getValue();
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.types.RealVectorValue<*>");
            }
            Value value2 = this.weight.getValue();
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.types.RealVectorValue<*>");
            }
            distanceKernel = this.distance.kernelForQueryAndWeight((RealVectorValue)value, (RealVectorValue)value2);
        } else {
            Value value = this.query.getValue();
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.types.VectorValue<*>");
            }
            distanceKernel = this.distance.kernelForQuery((VectorValue)value);
        }
        return distanceKernel;
    }

    @Override
    public long digest() {
        long result = this.getClass().hashCode();
        result = 31L * result + (long)this.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.queries.predicates.knn.KnnPredicate");
        }
        KnnPredicate cfr_ignored_0 = (KnnPredicate)object2;
        if (Intrinsics.areEqual(this.column, ((KnnPredicate)other).column) ^ true) {
            return false;
        }
        if (this.k != ((KnnPredicate)other).k) {
            return false;
        }
        if (Intrinsics.areEqual(this.query, ((KnnPredicate)other).query) ^ true) {
            return false;
        }
        if (this.distance != ((KnnPredicate)other).distance) {
            return false;
        }
        if (Intrinsics.areEqual(this.weight, ((KnnPredicate)other).weight) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.hint, (Object)((KnnPredicate)other).hint) ^ true);
    }

    public int hashCode() {
        int result = this.column.hashCode();
        result = 31 * result + this.k;
        result = 31 * result + this.query.hashCode();
        result = 31 * result + this.distance.hashCode();
        Object object = this.weight;
        boolean bl = false;
        Binding<Value> binding = object;
        result = 31 * result + (binding != null ? ((Object)binding).hashCode() : 0);
        object = this.hint;
        bl = false;
        Object object2 = object;
        result = 31 * result + (object2 != null ? object2.hashCode() : 0);
        return result;
    }

    @NotNull
    public final ColumnDef<?> getColumn() {
        return this.column;
    }

    public final int getK() {
        return this.k;
    }

    @NotNull
    public final Distances getDistance() {
        return this.distance;
    }

    @Nullable
    public final KnnPredicateHint getHint() {
        return this.hint;
    }

    @NotNull
    public final Binding<Value> getQuery() {
        return this.query;
    }

    @Nullable
    public final Binding<Value> getWeight() {
        return this.weight;
    }

    public KnnPredicate(@NotNull ColumnDef<?> column, int k, @NotNull Distances distance, @Nullable KnnPredicateHint hint, @NotNull Binding<Value> query2, @Nullable Binding<Value> weight) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)((Object)distance), (String)"distance");
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        this.column = column;
        this.k = k;
        this.distance = distance;
        this.hint = hint;
        this.query = query2;
        this.weight = weight;
        boolean bl = this.k >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            Unit unit = Unit.INSTANCE;
            throw (Throwable)new IllegalStateException(unit.toString());
        }
        if (this.k <= 0) {
            throw (Throwable)new QueryException.QuerySyntaxException("The value of k for a kNN query cannot be smaller than one (is " + this.k + ")s!");
        }
    }

    public /* synthetic */ KnnPredicate(ColumnDef columnDef, int n, Distances distances, KnnPredicateHint knnPredicateHint, Binding binding, Binding binding2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            knnPredicateHint = null;
        }
        if ((n2 & 0x20) != 0) {
            binding2 = null;
        }
        this(columnDef, n, distances, knnPredicateHint, binding, binding2);
    }
}

