/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.execution.operators.sinks.SpoolerSinkOperator;
import org.vitrivr.cottontail.execution.operators.system.ListLocksOperator;
import org.vitrivr.cottontail.execution.operators.system.ListTransactionsOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.TXNGrpc;
import org.vitrivr.cottontail.server.grpc.services.TransactionService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016J\u001e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/TXNService;", "Lorg/vitrivr/cottontail/grpc/TXNGrpc$TXNImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionService;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "begin", "", "request", "Lcom/google/protobuf/Empty;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TransactionId;", "commit", "listLocks", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "listTransactions", "rollback", "cottontaildb"})
public final class TXNService
extends TXNGrpc.TXNImplBase
implements TransactionService {
    @NotNull
    private final TransactionManager manager;

    public void begin(@NotNull Empty request, @NotNull StreamObserver<CottontailGrpc.TransactionId> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        TransactionManager.Transaction txn = new TransactionManager.Transaction(this.getManager(), TransactionType.USER);
        CottontailGrpc.TransactionId txId = CottontailGrpc.TransactionId.newBuilder().setValue(txn.getTxId()).build();
        responseObserver.onNext((Object)txId);
        responseObserver.onCompleted();
    }

    public void commit(@NotNull CottontailGrpc.TransactionId request, @NotNull StreamObserver<Empty> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        this.withTransactionContext(request, responseObserver, (Function2<? super TransactionManager.Transaction, ? super String, Status>)((Function2)new Function2<TransactionManager.Transaction, String, Status>(this, responseObserver){
            final /* synthetic */ TXNService this$0;
            final /* synthetic */ StreamObserver $responseObserver;

            @NotNull
            public final Status invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Status status;
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                try {
                    tx.commit();
                    this.$responseObserver.onNext((Object)Empty.getDefaultInstance());
                    Status status2 = Status.OK;
                    Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"Status.OK");
                    status = status2;
                }
                catch (Throwable e) {
                    Status status3 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Failed to execute COMMIT due to unexpected error: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status3, (String)"Status.INTERNAL.withDesc\u2026ed error: ${e.message}\"))");
                    status = status3;
                }
                return status;
            }
            {
                this.this$0 = tXNService;
                this.$responseObserver = streamObserver;
                super(2);
            }
        }));
    }

    public void rollback(@NotNull CottontailGrpc.TransactionId request, @NotNull StreamObserver<Empty> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        this.withTransactionContext(request, responseObserver, (Function2<? super TransactionManager.Transaction, ? super String, Status>)((Function2)new Function2<TransactionManager.Transaction, String, Status>(this, responseObserver){
            final /* synthetic */ TXNService this$0;
            final /* synthetic */ StreamObserver $responseObserver;

            @NotNull
            public final Status invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Status status;
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                try {
                    tx.rollback();
                    this.$responseObserver.onNext((Object)Empty.getDefaultInstance());
                    Status status2 = Status.OK;
                    Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"Status.OK");
                    status = status2;
                }
                catch (Throwable e) {
                    Status status3 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Failed to execute ROLLBACK due to unexpected error: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status3, (String)"Status.INTERNAL.withDesc\u2026ed error: ${e.message}\"))");
                    status = status3;
                }
                return status;
            }
            {
                this.this$0 = tXNService;
                this.$responseObserver = streamObserver;
                super(2);
            }
        }));
    }

    public void listTransactions(@NotNull Empty request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        TransactionService.DefaultImpls.withTransactionContext$default(this, null, responseObserver, (Function2)new Function2<TransactionManager.Transaction, String, Status>(this, responseObserver){
            final /* synthetic */ TXNService this$0;
            final /* synthetic */ StreamObserver $responseObserver;

            @NotNull
            public final Status invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Status status;
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                try {
                    SpoolerSinkOperator operator = new SpoolerSinkOperator(new ListTransactionsOperator(this.this$0.getManager()), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                    tx.execute(operator);
                    Status status2 = Status.OK;
                    Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"Status.OK");
                    status = status2;
                }
                catch (Throwable e) {
                    Status status3 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Failed to list locks due to unexpected error: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status3, (String)"Status.INTERNAL.withDesc\u2026ed error: ${e.message}\"))");
                    status = status3;
                }
                return status;
            }
            {
                this.this$0 = tXNService;
                this.$responseObserver = streamObserver;
                super(2);
            }
        }, 1, null);
    }

    public void listLocks(@NotNull Empty request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        TransactionService.DefaultImpls.withTransactionContext$default(this, null, responseObserver, (Function2)new Function2<TransactionManager.Transaction, String, Status>(this, responseObserver){
            final /* synthetic */ TXNService this$0;
            final /* synthetic */ StreamObserver $responseObserver;

            @NotNull
            public final Status invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Status status;
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                try {
                    SpoolerSinkOperator operator = new SpoolerSinkOperator(new ListLocksOperator(this.this$0.getManager().getLockManager()), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                    tx.execute(operator);
                    Status status2 = Status.OK;
                    Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"Status.OK");
                    status = status2;
                }
                catch (Throwable e) {
                    Status status3 = Status.INTERNAL.withDescription(this.this$0.formatMessage(tx, q, "Failed to list locks due to unexpected error: " + e.getMessage()));
                    Intrinsics.checkNotNullExpressionValue((Object)status3, (String)"Status.INTERNAL.withDesc\u2026ed error: ${e.message}\"))");
                    status = status3;
                }
                return status;
            }
            {
                this.this$0 = tXNService;
                this.$responseObserver = streamObserver;
                super(2);
            }
        }, 1, null);
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    public TXNService(@NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
    }

    @Override
    public void withTransactionContext(@NotNull CottontailGrpc.TransactionId txId, @NotNull StreamObserver<?> responseObserver, @NotNull Function2<? super TransactionManager.Transaction, ? super String, Status> action) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        TransactionService.DefaultImpls.withTransactionContext(this, txId, responseObserver, action);
    }

    @Override
    @NotNull
    public String formatMessage(@NotNull TransactionManager.Transaction tx, @NotNull String queryId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return TransactionService.DefaultImpls.formatMessage(this, tx, queryId, message);
    }
}

