/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.statistics.columns;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.database.queries.predicates.bool.BooleanPredicate;
import org.vitrivr.cottontail.database.statistics.columns.BooleanValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.BooleanVectorValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.ByteValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.DateValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.DoubleValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.DoubleVectorValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.FloatValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.FloatVectorValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.IntValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.IntVectorValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.LongValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.LongVectorValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.ShortValueStatistics;
import org.vitrivr.cottontail.database.statistics.columns.StringValueStatistics;
import org.vitrivr.cottontail.database.statistics.selectivity.Selectivity;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.types.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00015B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u0017\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010'J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010.\u001a\u00020%2\b\u0010/\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010'J\b\u00100\u001a\u00020%H\u0016J!\u00101\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u00018\u00002\b\u00103\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00104R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0017@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0017@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0019\"\u0004\b \u0010\u001dR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00066"}, d2={"Lorg/vitrivr/cottontail/database/statistics/columns/ValueStatistics;", "T", "Lorg/vitrivr/cottontail/model/values/types/Value;", "", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "(Lorg/vitrivr/cottontail/model/basics/Type;)V", "avgWidth", "", "getAvgWidth", "()I", "<set-?>", "", "fresh", "getFresh", "()Z", "setFresh", "(Z)V", "maxWidth", "getMaxWidth", "minWidth", "getMinWidth", "numberOfEntries", "", "getNumberOfEntries", "()J", "numberOfNonNullEntries", "getNumberOfNonNullEntries", "setNumberOfNonNullEntries", "(J)V", "numberOfNullEntries", "getNumberOfNullEntries", "setNumberOfNullEntries", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type;", "copy", "delete", "", "deleted", "(Lorg/vitrivr/cottontail/model/values/types/Value;)V", "estimateSelectivity", "Lorg/vitrivr/cottontail/database/statistics/selectivity/Selectivity;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "estimateSelectivity-GCnvam8", "(Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;)F", "insert", "inserted", "reset", "update", "old", "new", "(Lorg/vitrivr/cottontail/model/values/types/Value;Lorg/vitrivr/cottontail/model/values/types/Value;)V", "Companion", "cottontaildb"})
public class ValueStatistics<T extends Value> {
    private boolean fresh;
    private long numberOfNullEntries;
    private long numberOfNonNullEntries;
    @NotNull
    private final Type<T> type;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean getFresh() {
        return this.fresh;
    }

    protected final void setFresh(boolean bl) {
        this.fresh = bl;
    }

    public final long getNumberOfNullEntries() {
        return this.numberOfNullEntries;
    }

    protected final void setNumberOfNullEntries(long l) {
        this.numberOfNullEntries = l;
    }

    public final long getNumberOfNonNullEntries() {
        return this.numberOfNonNullEntries;
    }

    protected final void setNumberOfNonNullEntries(long l) {
        this.numberOfNonNullEntries = l;
    }

    public final long getNumberOfEntries() {
        return this.numberOfNullEntries + this.numberOfNonNullEntries;
    }

    public int getMinWidth() {
        return this.type.getLogicalSize();
    }

    public int getMaxWidth() {
        return this.type.getLogicalSize();
    }

    public final int getAvgWidth() {
        return Math.floorDiv(this.getMinWidth() + this.getMaxWidth(), 2);
    }

    public void insert(@Nullable T inserted) {
        if (inserted == null) {
            ++this.numberOfNullEntries;
        } else {
            ++this.numberOfNonNullEntries;
        }
    }

    public void delete(@Nullable T deleted) {
        if (deleted == null) {
            --this.numberOfNullEntries;
        } else {
            --this.numberOfNonNullEntries;
        }
    }

    public void update(@Nullable T old, @Nullable T t) {
        this.delete(old);
        this.insert(t);
    }

    public void reset() {
        this.fresh = true;
        this.numberOfNullEntries = 0L;
        this.numberOfNonNullEntries = 0L;
    }

    @NotNull
    public ValueStatistics<T> copy() {
        ValueStatistics<T> copy = new ValueStatistics<T>(this.type);
        copy.fresh = this.fresh;
        copy.numberOfNullEntries = this.numberOfNullEntries;
        copy.numberOfNonNullEntries = this.numberOfNonNullEntries;
        return copy;
    }

    public float estimateSelectivity-GCnvam8(@NotNull BooleanPredicate.Atomic predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return Selectivity.Companion.getDEFAULT_SELECTIVITY-MVuwP_M();
    }

    @NotNull
    public final Type<T> getType() {
        return this.type;
    }

    public ValueStatistics(@NotNull Type<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.type = type;
        this.fresh = true;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/statistics/columns/ValueStatistics$Companion;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/statistics/columns/ValueStatistics;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
    public static final class Companion
    implements Serializer<ValueStatistics<?>> {
        public void serialize(@NotNull DataOutput2 out, @NotNull ValueStatistics<?> value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            out.packInt(value.getType().getOrdinal());
            out.packInt(value.getType().getLogicalSize());
            ValueStatistics<?> valueStatistics = value;
            if (valueStatistics instanceof BooleanValueStatistics) {
                BooleanValueStatistics.Serializer.serialize(out, (BooleanValueStatistics)value);
            } else if (valueStatistics instanceof ByteValueStatistics) {
                ByteValueStatistics.Serializer.serialize(out, (ByteValueStatistics)value);
            } else if (valueStatistics instanceof ShortValueStatistics) {
                ShortValueStatistics.Serializer.serialize(out, (ShortValueStatistics)value);
            } else if (valueStatistics instanceof IntValueStatistics) {
                IntValueStatistics.Serializer.serialize(out, (IntValueStatistics)value);
            } else if (valueStatistics instanceof LongValueStatistics) {
                LongValueStatistics.Serializer.serialize(out, (LongValueStatistics)value);
            } else if (valueStatistics instanceof FloatValueStatistics) {
                FloatValueStatistics.Serializer.serialize(out, (FloatValueStatistics)value);
            } else if (valueStatistics instanceof DoubleValueStatistics) {
                DoubleValueStatistics.Serializer.serialize(out, (DoubleValueStatistics)value);
            } else if (valueStatistics instanceof DateValueStatistics) {
                DateValueStatistics.Serializer.serialize(out, (DateValueStatistics)value);
            } else if (valueStatistics instanceof StringValueStatistics) {
                StringValueStatistics.Serializer.serialize(out, (StringValueStatistics)value);
            } else if (valueStatistics instanceof BooleanVectorValueStatistics) {
                new BooleanVectorValueStatistics.Serializer(((BooleanVectorValueStatistics)value).getType()).serialize(out, (BooleanVectorValueStatistics)value);
            } else if (valueStatistics instanceof DoubleVectorValueStatistics) {
                new DoubleVectorValueStatistics.Serializer(((DoubleVectorValueStatistics)value).getType()).serialize(out, (DoubleVectorValueStatistics)value);
            } else if (valueStatistics instanceof FloatVectorValueStatistics) {
                new FloatVectorValueStatistics.Serializer(((FloatVectorValueStatistics)value).getType()).serialize(out, (FloatVectorValueStatistics)value);
            } else if (valueStatistics instanceof LongVectorValueStatistics) {
                new LongVectorValueStatistics.Serializer(((LongVectorValueStatistics)value).getType()).serialize(out, (LongVectorValueStatistics)value);
            } else if (valueStatistics instanceof IntVectorValueStatistics) {
                new IntVectorValueStatistics.Serializer(((IntVectorValueStatistics)value).getType()).serialize(out, (IntVectorValueStatistics)value);
            }
            out.writeBoolean(value.getFresh());
            out.packLong(value.getNumberOfNullEntries());
            out.packLong(value.getNumberOfNonNullEntries());
        }

        @NotNull
        public ValueStatistics<?> deserialize(@NotNull DataInput2 input, int available) {
            ValueStatistics valueStatistics;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Type<? extends Value> type = Type.Companion.forOrdinal(input.unpackInt(), input.unpackInt());
            if (Intrinsics.areEqual(type, (Object)Type.Complex32.INSTANCE) || Intrinsics.areEqual(type, (Object)Type.Complex64.INSTANCE) || type instanceof Type.Complex32Vector || type instanceof Type.Complex64Vector) {
                valueStatistics = new ValueStatistics(type);
            } else if (Intrinsics.areEqual(type, (Object)Type.Boolean.INSTANCE)) {
                valueStatistics = BooleanValueStatistics.Serializer.deserialize(input, available);
            } else if (Intrinsics.areEqual(type, (Object)Type.Byte.INSTANCE)) {
                valueStatistics = ByteValueStatistics.Serializer.deserialize(input, available);
            } else if (Intrinsics.areEqual(type, (Object)Type.Double.INSTANCE)) {
                valueStatistics = DoubleValueStatistics.Serializer.deserialize(input, available);
            } else if (Intrinsics.areEqual(type, (Object)Type.Float.INSTANCE)) {
                valueStatistics = FloatValueStatistics.Serializer.deserialize(input, available);
            } else if (Intrinsics.areEqual(type, (Object)Type.Int.INSTANCE)) {
                valueStatistics = IntValueStatistics.Serializer.deserialize(input, available);
            } else if (Intrinsics.areEqual(type, (Object)Type.Long.INSTANCE)) {
                valueStatistics = LongValueStatistics.Serializer.deserialize(input, available);
            } else if (Intrinsics.areEqual(type, (Object)Type.Short.INSTANCE)) {
                valueStatistics = ShortValueStatistics.Serializer.deserialize(input, available);
            } else if (Intrinsics.areEqual(type, (Object)Type.String.INSTANCE)) {
                valueStatistics = StringValueStatistics.Serializer.deserialize(input, available);
            } else if (Intrinsics.areEqual(type, (Object)Type.Date.INSTANCE)) {
                valueStatistics = DateValueStatistics.Serializer.deserialize(input, available);
            } else if (type instanceof Type.BooleanVector) {
                valueStatistics = new BooleanVectorValueStatistics.Serializer(type).deserialize(input, available);
            } else if (type instanceof Type.DoubleVector) {
                valueStatistics = new DoubleVectorValueStatistics.Serializer(type).deserialize(input, available);
            } else if (type instanceof Type.FloatVector) {
                valueStatistics = new FloatVectorValueStatistics.Serializer(type).deserialize(input, available);
            } else if (type instanceof Type.IntVector) {
                valueStatistics = new IntVectorValueStatistics.Serializer(type).deserialize(input, available);
            } else if (type instanceof Type.LongVector) {
                valueStatistics = new LongVectorValueStatistics.Serializer(type).deserialize(input, available);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ValueStatistics stat = valueStatistics;
            stat.setFresh(input.readBoolean());
            stat.setNumberOfNullEntries(input.unpackLong());
            stat.setNumberOfNonNullEntries(input.unpackLong());
            return stat;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

