/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.math.knn.kernels;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.math.knn.basics.DistanceKernel;
import org.vitrivr.cottontail.math.knn.basics.WeightedKernel;
import org.vitrivr.cottontail.math.knn.kernels.Distances$WhenMappings;
import org.vitrivr.cottontail.math.knn.kernels.binary.plain.EuclideanKernel;
import org.vitrivr.cottontail.math.knn.kernels.binary.plain.HaversineKernel;
import org.vitrivr.cottontail.math.knn.kernels.binary.plain.InnerProductKernel;
import org.vitrivr.cottontail.math.knn.kernels.binary.plain.ManhattanKernel;
import org.vitrivr.cottontail.math.knn.kernels.binary.plain.SquaredEuclideanKernel;
import org.vitrivr.cottontail.math.knn.kernels.binary.weighted.ChisquaredKernel;
import org.vitrivr.cottontail.math.knn.kernels.binary.weighted.CosineKernel;
import org.vitrivr.cottontail.math.knn.kernels.binary.weighted.HammingKernel;
import org.vitrivr.cottontail.model.values.types.RealVectorValue;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\"\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000fj\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/math/knn/kernels/Distances;", "", "(Ljava/lang/String;I)V", "cost", "", "d", "", "weighted", "", "kernelForQuery", "Lorg/vitrivr/cottontail/math/knn/basics/DistanceKernel;", "query", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "kernelForQueryAndWeight", "Lorg/vitrivr/cottontail/math/knn/basics/WeightedKernel;", "Lorg/vitrivr/cottontail/model/values/types/RealVectorValue;", "weight", "L1", "L2", "L2SQUARED", "HAMMING", "COSINE", "CHISQUARED", "INNERPRODUCT", "HAVERSINE", "cottontaildb"})
public final class Distances
extends Enum<Distances> {
    public static final /* enum */ Distances L1;
    public static final /* enum */ Distances L2;
    public static final /* enum */ Distances L2SQUARED;
    public static final /* enum */ Distances HAMMING;
    public static final /* enum */ Distances COSINE;
    public static final /* enum */ Distances CHISQUARED;
    public static final /* enum */ Distances INNERPRODUCT;
    public static final /* enum */ Distances HAVERSINE;
    private static final /* synthetic */ Distances[] $VALUES;

    static {
        Distances[] distancesArray = new Distances[8];
        Distances[] distancesArray2 = distancesArray;
        distancesArray[0] = L1 = new Distances();
        distancesArray[1] = L2 = new Distances();
        distancesArray[2] = L2SQUARED = new Distances();
        distancesArray[3] = HAMMING = new Distances();
        distancesArray[4] = COSINE = new Distances();
        distancesArray[5] = CHISQUARED = new Distances();
        distancesArray[6] = INNERPRODUCT = new Distances();
        distancesArray[7] = HAVERSINE = new Distances();
        $VALUES = distancesArray;
    }

    public final float cost(int d, boolean weighted) {
        float f;
        block19: {
            block18: {
                if (!weighted) break block18;
                switch (Distances$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                    case 1: {
                        f = org.vitrivr.cottontail.math.knn.kernels.binary.weighted.ManhattanKernel.Companion.cost(d);
                        break block19;
                    }
                    case 2: {
                        f = org.vitrivr.cottontail.math.knn.kernels.binary.weighted.EuclideanKernel.Companion.cost(d);
                        break block19;
                    }
                    case 3: {
                        f = org.vitrivr.cottontail.math.knn.kernels.binary.weighted.SquaredEuclideanKernel.Companion.cost(d);
                        break block19;
                    }
                    case 4: {
                        f = HammingKernel.Companion.cost(d);
                        break block19;
                    }
                    case 5: {
                        f = CosineKernel.Companion.cost(d);
                        break block19;
                    }
                    case 6: {
                        f = ChisquaredKernel.Companion.cost(d);
                        break block19;
                    }
                    default: {
                        boolean bl = false;
                        throw (Throwable)new NotImplementedError(null, 1, null);
                    }
                }
            }
            switch (Distances$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
                case 1: {
                    f = ManhattanKernel.Companion.cost(d);
                    break;
                }
                case 2: {
                    f = EuclideanKernel.Companion.cost(d);
                    break;
                }
                case 3: {
                    f = SquaredEuclideanKernel.Companion.cost(d);
                    break;
                }
                case 4: {
                    f = org.vitrivr.cottontail.math.knn.kernels.binary.plain.HammingKernel.Companion.cost(d);
                    break;
                }
                case 5: {
                    f = org.vitrivr.cottontail.math.knn.kernels.binary.plain.CosineKernel.Companion.cost(d);
                    break;
                }
                case 6: {
                    f = org.vitrivr.cottontail.math.knn.kernels.binary.plain.ChisquaredKernel.Companion.cost(d);
                    break;
                }
                case 7: {
                    f = InnerProductKernel.Companion.cost(d);
                    break;
                }
                case 8: {
                    f = HaversineKernel.Companion.cost(d);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return f;
    }

    public static /* synthetic */ float cost$default(Distances distances, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return distances.cost(n, bl);
    }

    @NotNull
    public final DistanceKernel<?> kernelForQuery(@NotNull VectorValue<?> query2) {
        DistanceKernel distanceKernel;
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        switch (Distances$WhenMappings.$EnumSwitchMapping$2[this.ordinal()]) {
            case 1: {
                distanceKernel = ManhattanKernel.Companion.kernel(query2);
                break;
            }
            case 2: {
                distanceKernel = EuclideanKernel.Companion.kernel(query2);
                break;
            }
            case 3: {
                distanceKernel = SquaredEuclideanKernel.Companion.kernel(query2);
                break;
            }
            case 4: {
                distanceKernel = org.vitrivr.cottontail.math.knn.kernels.binary.plain.HammingKernel.Companion.kernel(query2);
                break;
            }
            case 5: {
                distanceKernel = org.vitrivr.cottontail.math.knn.kernels.binary.plain.CosineKernel.Companion.kernel(query2);
                break;
            }
            case 6: {
                distanceKernel = org.vitrivr.cottontail.math.knn.kernels.binary.plain.ChisquaredKernel.Companion.kernel(query2);
                break;
            }
            case 7: {
                distanceKernel = InnerProductKernel.Companion.kernel(query2);
                break;
            }
            case 8: {
                distanceKernel = HaversineKernel.Companion.kernel(query2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return distanceKernel;
    }

    @NotNull
    public final WeightedKernel<?> kernelForQueryAndWeight(@NotNull RealVectorValue<?> query2, @NotNull RealVectorValue<?> weight) {
        WeightedKernel weightedKernel;
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        Intrinsics.checkNotNullParameter(weight, (String)"weight");
        switch (Distances$WhenMappings.$EnumSwitchMapping$3[this.ordinal()]) {
            case 1: {
                weightedKernel = org.vitrivr.cottontail.math.knn.kernels.binary.weighted.ManhattanKernel.Companion.kernel(query2, weight);
                break;
            }
            case 2: {
                weightedKernel = org.vitrivr.cottontail.math.knn.kernels.binary.weighted.EuclideanKernel.Companion.kernel(query2, weight);
                break;
            }
            case 3: {
                weightedKernel = org.vitrivr.cottontail.math.knn.kernels.binary.weighted.SquaredEuclideanKernel.Companion.kernel(query2, weight);
                break;
            }
            case 4: {
                weightedKernel = HammingKernel.Companion.kernel(query2, weight);
                break;
            }
            case 5: {
                weightedKernel = CosineKernel.Companion.kernel(query2, weight);
                break;
            }
            case 6: {
                weightedKernel = ChisquaredKernel.Companion.kernel(query2, weight);
                break;
            }
            default: {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
        }
        return weightedKernel;
    }

    public static Distances[] values() {
        return (Distances[])$VALUES.clone();
    }

    public static Distances valueOf(String string) {
        return Enum.valueOf(Distances.class, string);
    }
}

