/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.database.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.server.grpc.services.DDLService;
import org.vitrivr.cottontail.server.grpc.services.DMLService;
import org.vitrivr.cottontail.server.grpc.services.DQLService;
import org.vitrivr.cottontail.server.grpc.services.TXNService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer;", "", "config", "Lorg/vitrivr/cottontail/config/Config;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "(Lorg/vitrivr/cottontail/config/Config;Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "isRunning", "", "()Z", "server", "Lio/grpc/Server;", "kotlin.jvm.PlatformType", "transactionManager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "start", "", "stop", "cottontaildb"})
@ExperimentalTime
public final class CottontailGrpcServer {
    private final ThreadPoolExecutor executor;
    private final TransactionManager transactionManager;
    private final Server server;
    @NotNull
    private final Config config;
    @NotNull
    private final DefaultCatalogue catalogue;

    public final boolean isRunning() {
        Server server = this.server;
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"this.server");
        return !server.isShutdown();
    }

    public final void start() {
        this.server.start();
    }

    public final void stop() {
        this.server.shutdown();
        this.executor.shutdown();
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    /*
     * WARNING - void declaration
     */
    public CottontailGrpcServer(@NotNull Config config, @NotNull DefaultCatalogue catalogue) {
        ServerBuilder serverBuilder;
        void it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        this.config = config;
        this.catalogue = catalogue;
        this.executor = this.config.getExecution().newExecutor();
        this.transactionManager = new TransactionManager(this.config.getExecution().getTransactionTableSize(), this.config.getExecution().getTransactionHistorySize());
        ServerBuilder serverBuilder2 = ServerBuilder.forPort((int)this.config.getServer().getPort()).executor((Executor)this.executor).addService((BindableService)new DDLService(this.catalogue, this.transactionManager)).addService((BindableService)new DMLService(this.catalogue, this.transactionManager)).addService((BindableService)new DQLService(this.catalogue, this.transactionManager)).addService((BindableService)new TXNService(this.transactionManager));
        boolean bl = false;
        boolean bl2 = false;
        ServerBuilder serverBuilder3 = serverBuilder2;
        CottontailGrpcServer cottontailGrpcServer = this;
        boolean bl3 = false;
        if (this.config.getServer().getUseTls()) {
            Path path = this.config.getServer().getCertFile();
            Intrinsics.checkNotNull((Object)path);
            File certFile = path.toFile();
            Path path2 = this.config.getServer().getPrivateKey();
            Intrinsics.checkNotNull((Object)path2);
            File privateKeyFile = path2.toFile();
            serverBuilder = it.useTransportSecurity(certFile, privateKeyFile);
        } else {
            serverBuilder = it;
        }
        void var11_11 = serverBuilder;
        cottontailGrpcServer.server = var11_11.build();
    }
}

