/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.execution.operators.system.ListLocksOperator;
import org.vitrivr.cottontail.execution.operators.system.ListTransactionsOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.TXNGrpcKt;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.server.grpc.services.gRPCTransactionService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0019\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/TXNService;", "Lorg/vitrivr/cottontail/grpc/TXNGrpcKt$TXNCoroutineImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/gRPCTransactionService;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "begin", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TransactionId;", "request", "Lcom/google/protobuf/Empty;", "(Lcom/google/protobuf/Empty;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "commit", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TransactionId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listLocks", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "listTransactions", "rollback", "cottontaildb"})
@ExperimentalTime
public final class TXNService
extends TXNGrpcKt.TXNCoroutineImplBase
implements gRPCTransactionService {
    @NotNull
    private final TransactionManager manager;

    @Nullable
    public Object begin(@NotNull Empty request, @NotNull Continuation<? super CottontailGrpc.TransactionId> $completion) {
        TransactionManager.Transaction txn = new TransactionManager.Transaction(this.getManager(), TransactionType.USER);
        CottontailGrpc.TransactionId transactionId = CottontailGrpc.TransactionId.newBuilder().setValue(txn.getTxId()).build();
        Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"CottontailGrpc.Transacti\u2026etValue(txn.txId).build()");
        return transactionId;
    }

    @Nullable
    public Object commit(@NotNull CottontailGrpc.TransactionId request, @NotNull Continuation<? super Empty> $completion) {
        CharSequence charSequence;
        TransactionManager.Transaction txn = this.getManager().get(request.getValue());
        if (txn == null || txn.getType() != TransactionType.USER) {
            String message = "COMMIT failed because USER transaction " + request.getValue() + " could not be obtained.";
            StatusException statusException = Status.FAILED_PRECONDITION.withDescription(message).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.FAILED_PRECONDITI\u2026on(message).asException()");
            throw (Throwable)statusException;
        }
        CharSequence charSequence2 = request.getQueryId();
        boolean bl = false;
        CharSequence charSequence3 = charSequence2;
        boolean bl2 = false;
        if (charSequence3.length() == 0) {
            boolean bl3 = false;
            charSequence = UUID.randomUUID().toString();
        } else {
            charSequence = charSequence2;
        }
        String queryId = (String)charSequence;
        try {
            txn.commit();
            Empty empty = Empty.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)empty, (String)"Empty.getDefaultInstance()");
            return empty;
        }
        catch (Throwable e) {
            String string = queryId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"queryId");
            StatusException statusException = Status.INTERNAL.withDescription(this.formatMessage(txn, string, "Failed to execute COMMIT due to unexpected error: " + e.getMessage())).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.INTERNAL.withDesc\u2026message}\")).asException()");
            throw (Throwable)statusException;
        }
    }

    @Nullable
    public Object rollback(@NotNull CottontailGrpc.TransactionId request, @NotNull Continuation<? super Empty> $completion) {
        CharSequence charSequence;
        TransactionManager.Transaction txn = this.getManager().get(request.getValue());
        if (txn == null || txn.getType() != TransactionType.USER) {
            String message = "ROLLBACK failed because USER transaction " + request.getValue() + " could not be obtained.";
            StatusException statusException = Status.FAILED_PRECONDITION.withDescription(message).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.FAILED_PRECONDITI\u2026on(message).asException()");
            throw (Throwable)statusException;
        }
        CharSequence charSequence2 = request.getQueryId();
        boolean bl = false;
        CharSequence charSequence3 = charSequence2;
        boolean bl2 = false;
        if (charSequence3.length() == 0) {
            boolean bl3 = false;
            charSequence = UUID.randomUUID().toString();
        } else {
            charSequence = charSequence2;
        }
        String queryId = (String)charSequence;
        try {
            txn.rollback();
            Empty empty = Empty.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)empty, (String)"Empty.getDefaultInstance()");
            return empty;
        }
        catch (Throwable e) {
            String string = queryId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"queryId");
            StatusException statusException = Status.INTERNAL.withDescription(this.formatMessage(txn, string, "Failed to execute COMMIT due to unexpected error: " + e.getMessage())).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"Status.INTERNAL.withDesc\u2026message}\")).asException()");
            throw (Throwable)statusException;
        }
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listTransactions(@NotNull Empty request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return gRPCTransactionService.DefaultImpls.withTransactionContext$default(this, null, "LIST TRANSACTIONS", (Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this){
            final /* synthetic */ TXNService this$0;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                return this.this$0.executeAndMaterialize(tx, new ListTransactionsOperator(this.this$0.getManager()), q, 0);
            }
            {
                this.this$0 = tXNService;
                super(2);
            }
        }, 1, null);
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listLocks(@NotNull Empty request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return gRPCTransactionService.DefaultImpls.withTransactionContext$default(this, null, "LIST LOCKS", (Function2)new Function2<TransactionManager.Transaction, String, Flow<? extends CottontailGrpc.QueryResponseMessage>>(this){
            final /* synthetic */ TXNService this$0;

            @NotNull
            public final Flow<CottontailGrpc.QueryResponseMessage> invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                return this.this$0.executeAndMaterialize(tx, new ListLocksOperator(this.this$0.getManager().getLockManager()), q, 0);
            }
            {
                this.this$0 = tXNService;
                super(2);
            }
        }, 1, null);
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    public TXNService(@NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(null, 1, null);
        this.manager = manager;
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> withTransactionContext(@NotNull CottontailGrpc.TransactionId txId, @NotNull String description, @NotNull Function2<? super TransactionManager.Transaction, ? super String, ? extends Flow<CottontailGrpc.QueryResponseMessage>> action) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return gRPCTransactionService.DefaultImpls.withTransactionContext(this, txId, description, action);
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> executeAndMaterialize(@NotNull TransactionManager.Transaction tx, @NotNull Operator operator, @NotNull String queryId, int queryIndex) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        return gRPCTransactionService.DefaultImpls.executeAndMaterialize(this, tx, operator, queryId, queryIndex);
    }

    @Override
    @NotNull
    public CottontailGrpc.QueryResponseMessage.Tuple toTuple(@NotNull Record $this$toTuple) {
        Intrinsics.checkNotNullParameter((Object)$this$toTuple, (String)"$this$toTuple");
        return gRPCTransactionService.DefaultImpls.toTuple(this, $this$toTuple);
    }

    @Override
    @NotNull
    public String formatMessage(@NotNull TransactionManager.Transaction tx, @NotNull String queryId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return gRPCTransactionService.DefaultImpls.formatMessage(this, tx, queryId, message);
    }
}

