/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.io;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/vitrivr/cottontail/utilities/io/TxFileUtilities;", "", "()V", "TX_CREATED", "", "TX_DELETED", "TX_SEPARATOR", "logger", "Lorg/slf4j/Logger;", "createPath", "Ljava/nio/file/Path;", "path", "delete", "", "plainPath", "cottontaildb"})
public final class TxFileUtilities {
    @NotNull
    public static final String TX_SEPARATOR = "~";
    @NotNull
    public static final String TX_CREATED = "~created";
    @NotNull
    public static final String TX_DELETED = "~deleted";
    private static final Logger logger;
    @NotNull
    public static final TxFileUtilities INSTANCE;

    @NotNull
    public final Path plainPath(@NotNull Path path) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.contains$default((CharSequence)((Object)path.getFileName()).toString(), (CharSequence)TX_SEPARATOR, (boolean)false, (int)2, null)) {
            Path normalizedPath;
            String normalizedName = (String)StringsKt.split$default((CharSequence)((Object)path.getFileName()).toString(), (String[])new String[]{TX_SEPARATOR}, (boolean)false, (int)0, (int)6, null).get(0);
            Path path3 = normalizedPath = path.getParent().resolve(normalizedName);
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"normalizedPath");
        } else {
            path2 = path;
        }
        return path2;
    }

    @NotNull
    public final Path createPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path.getParent().resolve(path.getFileName() + TX_CREATED + UUID.randomUUID());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.parent.resolve(\"${p\u2026ED}${UUID.randomUUID()}\")");
        return path2;
    }

    public final void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Files.exists(path, new LinkOption[0])) {
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(new Consumer<Path>(path){
                final /* synthetic */ Path $path;

                public final void accept(Path it) {
                    try {
                        Files.delete(it);
                    }
                    catch (IOException e) {
                        Logger logger = TxFileUtilities.access$getLogger$p(TxFileUtilities.INSTANCE);
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to delete ").append(this.$path).append(" (content: ");
                        Stream<Path> stream = Files.list(this.$path);
                        Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.list(path)");
                        logger.warn(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)StreamsKt.toList(stream), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append(").").toString());
                    }
                }
                {
                    this.$path = path;
                }
            });
        } else {
            logger.warn("Noting to delete at " + path + '.');
        }
    }

    private TxFileUtilities() {
    }

    static {
        TxFileUtilities txFileUtilities;
        INSTANCE = txFileUtilities = new TxFileUtilities();
        Logger logger = LoggerFactory.getLogger(TxFileUtilities.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026ileUtilities::class.java)");
        TxFileUtilities.logger = logger;
    }

    public static final /* synthetic */ Logger access$getLogger$p(TxFileUtilities $this) {
        TxFileUtilities txFileUtilities = $this;
        return logger;
    }
}

