/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lsh.superbit;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.lsh.LSHIndex;
import org.vitrivr.cottontail.database.index.lsh.superbit.SamplingMethod;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBitLSH;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBitLSHIndexConfig;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.knn.KnnPredicate;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.math.knn.kernels.Distances;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.ComplexVectorValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002%&B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndex;", "T", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "Lorg/vitrivr/cottontail/database/index/lsh/LSHIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndexConfig;", "maps", "", "Lorg/mapdb/HTreeMap;", "", "", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class SuperBitLSHIndex<T extends VectorValue<?>>
extends LSHIndex<T> {
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private final IndexType type;
    @NotNull
    private final SuperBitLSHIndexConfig config;
    private final List<HTreeMap<Integer, long[]>> maps;
    private static final Logger LOGGER;
    private static final Distances[] SUPPORTED_DISTANCES;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public SuperBitLSHIndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof KnnPredicate && Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) && ArraysKt.contains((Object[])SUPPORTED_DISTANCES, (Object)((Object)((KnnPredicate)predicate).getDistance())) && (!this.getConfig().getConsiderImaginary() || ((KnnPredicate)predicate).getQuery() instanceof ComplexVectorValue);
    }

    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return this.canProcess(predicate) ? Cost.Companion.getZERO() : Cost.Companion.getINVALID();
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - void declaration
     */
    public SuperBitLSHIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable SuperBitLSHIndexConfig config) {
        ArrayList<HTreeMap> arrayList;
        boolean bl;
        int n;
        block7: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(path, parent);
            this.type = IndexType.LSH_SB;
            ColumnDef<?>[] $this$all$iv = this.getColumns();
            boolean $i$f$all = false;
            ColumnDef<?>[] columnDefArray = $this$all$iv;
            n = columnDefArray.length;
            for (int i = 0; i < n; ++i) {
                ColumnDef<?> element$iv;
                ColumnDef<?> it = element$iv = columnDefArray[i];
                boolean bl2 = false;
                if (it.getType().getVector()) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        if (!bl) {
            throw (Throwable)new DatabaseException.IndexNotSupportedException(this.getName(), "Because only vector columns are supported for SuperBitLSHIndex.");
        }
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar("cdb_index_config", (Serializer)SuperBitLSHIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            if (config != null) {
                this.config = config;
                configOnDisk.set((Object)config);
            } else {
                LOGGER.warn("No config supplied and the config from disk was also empty. Resorting to dummy config. Delete this index ASAP!");
                this.config = new SuperBitLSHIndexConfig(1, 1, 123L, true, SamplingMethod.GAUSSIAN);
            }
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (SuperBitLSHIndexConfig)object;
        }
        int n2 = this.getConfig().getStages();
        SuperBitLSHIndex superBitLSHIndex = this;
        boolean bl3 = false;
        n = 0;
        ArrayList<HTreeMap> arrayList2 = new ArrayList<HTreeMap>(n2);
        boolean bl4 = false;
        int n3 = 0;
        n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            void it;
            int n5 = n3++;
            boolean bl5 = false;
            int n6 = n5;
            arrayList = arrayList2;
            boolean bl6 = false;
            DB dB = this.getStore();
            String string = "cdb_lsh_map" + "_stage" + (int)it;
            GroupSerializer groupSerializer = Serializer.INTEGER;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.INTEGER");
            Serializer serializer2 = (Serializer)groupSerializer;
            GroupSerializer groupSerializer2 = Serializer.LONG_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer2, (String)"Serializer.LONG_ARRAY");
            HTreeMap hTreeMap = dB.hashMap(string, serializer2, (Serializer)groupSerializer2).counterEnable().createOrOpen();
            arrayList.add(hTreeMap);
        }
        superBitLSHIndex.maps = arrayList = (ArrayList<HTreeMap>)arrayList2;
        this.getStore().commit();
    }

    public /* synthetic */ SuperBitLSHIndex(Path path, DefaultEntity defaultEntity, SuperBitLSHIndexConfig superBitLSHIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            superBitLSHIndexConfig = null;
        }
        this(path, defaultEntity, superBitLSHIndexConfig);
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(SuperBitLSHIndex.class);
        SUPPORTED_DISTANCES = new Distances[]{Distances.COSINE, Distances.INNERPRODUCT};
    }

    public static final /* synthetic */ Distances[] access$getSUPPORTED_DISTANCES$cp() {
        return SUPPORTED_DISTANCES;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "acquireSpecimen", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "tx", "Lorg/vitrivr/cottontail/database/entity/EntityTx;", "clear", "", "count", "", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public long count() {
            long l;
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                void $this$mapTo$iv$iv;
                boolean bl3 = false;
                boolean bl4 = false;
                Iterable $this$map$iv = SuperBitLSHIndex.this.maps;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    HTreeMap hTreeMap = (HTreeMap)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    Map map2 = (Map)it;
                    boolean bl6 = false;
                    Long l2 = map2.size();
                    collection.add(l2);
                }
                l = CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            int n;
            int n2;
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                int bucket;
                int n6;
                boolean bl4 = false;
                boolean bl5 = false;
                LOGGER.debug("Rebuilding SB-LSH index {}", (Object)SuperBitLSHIndex.this.getName());
                org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
                if (tx == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
                }
                EntityTx tx2 = (EntityTx)tx;
                VectorValue<?> vectorValue = this.acquireSpecimen(tx2);
                if (vectorValue == null) {
                    throw (Throwable)new DatabaseException("Could not gather specimen to create index.", null, 2, null);
                }
                VectorValue<?> specimen = vectorValue;
                SuperBitLSH lsh = new SuperBitLSH(SuperBitLSHIndex.this.getConfig().getStages(), SuperBitLSHIndex.this.getConfig().getBuckets(), SuperBitLSHIndex.this.getConfig().getSeed(), specimen, SuperBitLSHIndex.this.getConfig().getConsiderImaginary(), SuperBitLSHIndex.this.getConfig().getSamplingMethod());
                int n7 = SuperBitLSHIndex.this.getConfig().getStages();
                boolean bl6 = false;
                boolean bl7 = false;
                ArrayList<List> arrayList = new ArrayList<List>(n7);
                boolean bl8 = false;
                int n8 = 0;
                int n9 = n7;
                for (n8 = 0; n8 < n9; ++n8) {
                    int n10 = n8;
                    boolean bl9 = false;
                    int n11 = n10;
                    ArrayList<List> arrayList2 = arrayList;
                    boolean bl10 = false;
                    int n12 = SuperBitLSHIndex.this.getConfig().getBuckets();
                    boolean bl11 = false;
                    ArrayList<List> arrayList3 = new ArrayList<List>(n12);
                    boolean bl12 = false;
                    int n13 = 0;
                    n13 = 0;
                    n6 = n12;
                    while (n13 < n6) {
                        int n14 = n13++;
                        boolean bl13 = false;
                        int n15 = n14;
                        ArrayList<List> arrayList4 = arrayList3;
                        boolean bl14 = false;
                        boolean bl15 = false;
                        List list = new ArrayList();
                        arrayList4.add(list);
                    }
                    List list = arrayList3;
                    arrayList2.add(list);
                }
                List local = arrayList;
                Object $this$forEach$iv = tx2.scan(SuperBitLSHIndex.this.getColumns());
                boolean $i$f$forEach = false;
                Iterator<Record> iterator2 = $this$forEach$iv;
                boolean bl16 = false;
                Iterator<Record> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Value value;
                    Record element$iv;
                    Record it = element$iv = iterator3.next();
                    boolean bl17 = false;
                    if (it.get(this.getDbo().getColumns()[0]) == null) {
                        throw (Throwable)new DatabaseException("Could not find column for entry in index " + this, null, 2, null);
                    }
                    if (value instanceof VectorValue) {
                        int[] buckets = lsh.hash((VectorValue)value);
                        Iterable $this$forEach$iv2 = ArraysKt.zip((int[])buckets, (Iterable)local);
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            Pair $dstr$bucket$map = (Pair)element$iv2;
                            boolean bl18 = false;
                            n6 = ((Number)$dstr$bucket$map.component1()).intValue();
                            List map2 = (List)$dstr$bucket$map.component2();
                            ((List)map2.get(bucket)).add(it.getTupleId());
                        }
                        continue;
                    }
                    throw (Throwable)new DatabaseException(value + " is no vector column!", null, 2, null);
                }
                $this$forEach$iv = CollectionsKt.zip((Iterable)SuperBitLSHIndex.this.maps, (Iterable)local);
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    void map3;
                    Record element$iv = iterator2.next();
                    Pair $dstr$map$localdata = (Pair)element$iv;
                    boolean bl19 = false;
                    HTreeMap it = (HTreeMap)$dstr$map$localdata.component1();
                    List localdata = (List)$dstr$map$localdata.component2();
                    map3.clear();
                    Iterable $this$forEachIndexed$iv = localdata;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void tIds;
                        int n16 = index$iv++;
                        boolean bl20 = false;
                        if (n16 < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        List bl18 = (List)item$iv;
                        bucket = n16;
                        boolean bl21 = false;
                        ((Map)map3).put(bucket, CollectionsKt.toLongArray((Collection)((Collection)tIds)));
                    }
                }
                SuperBitLSHIndex.this.getDirtyField().compareAndSet(true, false);
                LOGGER.debug("Rebuilding SB-LSH index completed.");
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n17 = n2++;
                    boolean bl22 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NotNull DataChangeEvent event) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                SuperBitLSHIndex.this.getDirtyField().compareAndSet(false, true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            int n;
            int n2;
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                SuperBitLSHIndex.this.getDirtyField().compareAndSet(false, true);
                Iterable $this$forEach$iv = SuperBitLSHIndex.this.maps;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HTreeMap map2 = (HTreeMap)element$iv;
                    boolean bl6 = false;
                    map2.clear();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl7 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(this, predicate){
                private final KnnPredicate predicate;
                private final LinkedList<Long> tupleIds;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                public boolean hasNext() {
                    Collection collection = this.tupleIds;
                    boolean bl = false;
                    return !collection.isEmpty();
                }

                @NotNull
                public Record next() {
                    Long l = this.tupleIds.removeFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"this.tupleIds.removeFirst()");
                    return new StandaloneRecord(((Number)l).longValue(), this.this$0.SuperBitLSHIndex.this.getProduces(), new Value[0]);
                }
                {
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    if (!($captured_local_variable$1 instanceof KnnPredicate)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.SuperBitLSHIndex.this.getName() + "' (LSH Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (KnnPredicate)$captured_local_variable$1;
                    if (Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)this.predicate.getColumns())), this$0.SuperBitLSHIndex.this.getColumns()[0]) ^ true || !ArraysKt.contains((Object[])SuperBitLSHIndex.access$getSUPPORTED_DISTANCES$cp(), (Object)((Object)this.predicate.getDistance()))) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.SuperBitLSHIndex.this.getName() + "' (lsh-index) does not support the provided predicate.");
                    }
                    Value value = this.predicate.getQuery().getValue();
                    boolean bl = value instanceof VectorValue;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Bound value for query vector has wrong type (found = " + value.getType() + ").";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    AbstractTx this_$iv = this$0;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
                    int n = 0;
                    boolean bl5 = false;
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    readLock.lock();
                    try {
                        boolean bl6 = false;
                        boolean bl7 = false;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    SuperBitLSH lsh = new SuperBitLSH(this$0.SuperBitLSHIndex.this.getConfig().getStages(), this$0.SuperBitLSHIndex.this.getConfig().getBuckets(), this$0.SuperBitLSHIndex.this.getConfig().getSeed(), (VectorValue)value, this$0.SuperBitLSHIndex.this.getConfig().getConsiderImaginary(), this$0.SuperBitLSHIndex.this.getConfig().getSamplingMethod());
                    this.tupleIds = new LinkedList<E>();
                    int[] signature = lsh.hash((VectorValue)value);
                    int n2 = 0;
                    n = signature.length;
                    while (n2 < n) {
                        void stage;
                        for (long tupleId : (long[])MapsKt.getValue((Map)((Map)SuperBitLSHIndex.access$getMaps$p(this$0.SuperBitLSHIndex.this).get((int)stage)), (Object)signature[stage])) {
                            this.tupleIds.offer(tupleId);
                        }
                        ++stage;
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw (Throwable)new UnsupportedOperationException("The SuperBitLSHIndex does not support ranged filtering!");
        }

        /*
         * WARNING - void declaration
         */
        private final VectorValue<?> acquireSpecimen(EntityTx tx) {
            long l = 0L;
            long l2 = tx.maxTupleId();
            while (l < l2) {
                void index;
                Value read = tx.read((long)index, SuperBitLSHIndex.this.getColumns()).get(this.getDbo().getColumns()[0]);
                if (read instanceof VectorValue) {
                    return (VectorValue)read;
                }
                l = index + 1L;
            }
            return null;
        }

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(SuperBitLSHIndex.this, context2);
        }

        public static final /* synthetic */ Object access$withReadLock(Tx $this, Function0 block) {
            return $this.withReadLock(block);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SUPPORTED_DISTANCES", "", "Lorg/vitrivr/cottontail/math/knn/kernels/Distances;", "[Lorg/vitrivr/cottontail/math/knn/kernels/Distances;", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

