/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.planning.nodes.physical.sources;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.queries.OperatorNode;
import org.vitrivr.cottontail.database.queries.QueryContext;
import org.vitrivr.cottontail.database.queries.binding.BindingContext;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.NullaryPhysicalOperatorNode;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.statistics.entity.RecordStatistics;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.execution.operators.sources.IndexScanOperator;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 C2\u00020\u0001:\u0001CB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0016\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0016J\b\u00104\u001a\u00020\u0000H\u0016J\u0013\u00105\u001a\u00020\f2\b\u00106\u001a\u0004\u0018\u000107H\u0096\u0002J\b\u00108\u001a\u00020\u0003H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020\u0003H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u00101\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020 H\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001cR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006D"}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/sources/RangedIndexScanPhysicalOperatorNode;", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/NullaryPhysicalOperatorNode;", "groupId", "", "index", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "partitionIndex", "partitions", "(ILorg/vitrivr/cottontail/database/index/IndexTx;Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;II)V", "canBePartitioned", "", "getCanBePartitioned", "()Z", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "getCost", "()Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "executable", "getExecutable", "getGroupId", "()I", "getIndex", "()Lorg/vitrivr/cottontail/database/index/IndexTx;", "name", "", "getName", "()Ljava/lang/String;", "outputSize", "", "getOutputSize", "()J", "getPartitionIndex", "getPartitions", "getPredicate", "()Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "statistics", "Lorg/vitrivr/cottontail/database/statistics/entity/RecordStatistics;", "getStatistics", "()Lorg/vitrivr/cottontail/database/statistics/entity/RecordStatistics;", "bindValues", "Lorg/vitrivr/cottontail/database/queries/OperatorNode;", "ctx", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "copy", "equals", "other", "", "hashCode", "partition", "", "Lorg/vitrivr/cottontail/database/queries/OperatorNode$Physical;", "p", "toOperator", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "tx", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Lorg/vitrivr/cottontail/database/queries/QueryContext;", "toString", "Companion", "cottontaildb"})
public final class RangedIndexScanPhysicalOperatorNode
extends NullaryPhysicalOperatorNode {
    private final long outputSize;
    @NotNull
    private final RecordStatistics statistics;
    @NotNull
    private final ColumnDef<?>[] columns;
    private final boolean executable;
    private final boolean canBePartitioned;
    @NotNull
    private final Cost cost;
    private final int groupId;
    @NotNull
    private final IndexTx index;
    @NotNull
    private final Predicate predicate;
    private final int partitionIndex;
    private final int partitions;
    private static final String NODE_NAME = "ScanIndex";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        return NODE_NAME;
    }

    @Override
    public long getOutputSize() {
        return this.outputSize;
    }

    @Override
    @NotNull
    public RecordStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @Override
    public boolean getExecutable() {
        return this.executable;
    }

    @Override
    public boolean getCanBePartitioned() {
        return this.canBePartitioned;
    }

    @Override
    @NotNull
    public Cost getCost() {
        return this.cost;
    }

    @Override
    @NotNull
    public RangedIndexScanPhysicalOperatorNode copy() {
        return new RangedIndexScanPhysicalOperatorNode(this.getGroupId(), this.index, this.predicate, this.partitionIndex, this.partitions);
    }

    @Override
    @NotNull
    public Operator toOperator(@NotNull TransactionContext tx, @NotNull QueryContext ctx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return new IndexScanOperator(this.getGroupId(), this.index, this.predicate.bindValues(ctx.getValues()), this.partitionIndex, this.partitions);
    }

    @Override
    @NotNull
    public List<OperatorNode.Physical> partition(int p) {
        throw (Throwable)new UnsupportedOperationException("RangedIndexScanPhysicalOperatorNode cannot be further partitioned.");
    }

    @Override
    @NotNull
    public OperatorNode bindValues(@NotNull BindingContext<Value> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.predicate.bindValues(ctx);
        return super.bindValues((BindingContext)ctx);
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + '[' + (Object)((Object)this.index.getType()) + ',' + this.predicate + ',' + this.partitionIndex + '/' + this.partitions + "/]";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RangedIndexScanPhysicalOperatorNode)) {
            return false;
        }
        if (this.getDepth() != ((RangedIndexScanPhysicalOperatorNode)other).getDepth()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.predicate, (Object)((RangedIndexScanPhysicalOperatorNode)other).predicate) ^ true) {
            return false;
        }
        if (this.partitionIndex != ((RangedIndexScanPhysicalOperatorNode)other).partitionIndex) {
            return false;
        }
        return this.partitions == ((RangedIndexScanPhysicalOperatorNode)other).partitions;
    }

    public int hashCode() {
        int result = Integer.hashCode(this.getDepth());
        result = 31 * result + this.predicate.hashCode();
        result = 31 * result + Integer.hashCode(this.partitionIndex);
        result = 31 * result + Integer.hashCode(this.partitions);
        return result;
    }

    @Override
    public int getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final IndexTx getIndex() {
        return this.index;
    }

    @NotNull
    public final Predicate getPredicate() {
        return this.predicate;
    }

    public final int getPartitionIndex() {
        return this.partitionIndex;
    }

    public final int getPartitions() {
        return this.partitions;
    }

    public RangedIndexScanPhysicalOperatorNode(int groupId, @NotNull IndexTx index, @NotNull Predicate predicate, int partitionIndex, int partitions) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        this.groupId = groupId;
        this.index = index;
        this.predicate = predicate;
        this.partitionIndex = partitionIndex;
        this.partitions = partitions;
        this.outputSize = Math.floorDiv(this.index.getDbo().getParent().getStatistics().getCount(), this.partitions);
        this.statistics = this.index.getDbo().getParent().getStatistics();
        this.columns = this.index.getDbo().getProduces();
        this.executable = true;
        this.cost = this.index.getDbo().cost(this.predicate);
        boolean bl = this.partitionIndex >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The partitionIndex of a ranged index scan must be greater than zero.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.partitions > 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "The number of partitions for a ranged index scan must be greater than zero.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/sources/RangedIndexScanPhysicalOperatorNode$Companion;", "", "()V", "NODE_NAME", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

