/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.schema;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxAction;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.schema.DefaultSchema;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.database.schema.SchemaHeader;
import org.vitrivr.cottontail.database.schema.SchemaTx;
import org.vitrivr.cottontail.database.schema.SchemaTxSnapshot;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.utilities.io.TxFileUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\"\u001a\u00020#H\u0016J\u0014\u0010$\u001a\u00060%R\u00020\u00002\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lorg/vitrivr/cottontail/database/schema/DefaultSchema;", "Lorg/vitrivr/cottontail/database/schema/Schema;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/catalogue/Catalogue;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/schema/SchemaHeader;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "getParent", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "store", "Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/schema/DefaultSchema$Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class DefaultSchema
implements Schema {
    private final DB store;
    private final Atomic.Var<SchemaHeader> headerField;
    private final StampedLock closeLock;
    private final Map<Name.EntityName, Entity> registry;
    @NotNull
    private final Name.SchemaName name;
    @NotNull
    private final Path path;
    @NotNull
    private final Catalogue parent;
    private static final String SCHEMA_HEADER_FIELD = "cdb_entity_header";
    private static final String FILE_CATALOGUE = "index.db";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Name.SchemaName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-DefaultSchema$close$22 = false;
            if (!this.getClosed()) {
                this.store.close();
                this.registry.entrySet().removeIf(close.1.1.INSTANCE);
            }
            Unit $i$a$-write-DefaultSchema$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Catalogue getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultSchema(@NotNull Path path, @NotNull Catalogue parent) {
        void $this$mapTo$iv$iv;
        DB dB;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        Object object = this;
        try {
            DefaultSchema defaultSchema = object;
            MapDBConfig mapDBConfig = this.getParent().getConfig().getMapdb();
            Path path2 = this.getPath().resolve(FILE_CATALOGUE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.path.resolve(FILE_CATALOGUE)");
            dB = mapDBConfig.db(path2);
        }
        catch (DBException dBException) {
            void e;
            DefaultSchema defaultSchema = object;
            throw (Throwable)new DatabaseException("Failed to open schema at '" + this.getPath() + "': " + e.getMessage() + '\'', null, 2, null);
        }
        defaultSchema.store = dB;
        this.headerField = (Atomic.Var)this.store.atomicVar(SCHEMA_HEADER_FIELD, (Serializer)SchemaHeader.Serializer).createOrOpen();
        this.closeLock = new StampedLock();
        Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.synchronized\u2026ject2ObjectOpenHashMap())");
        this.registry = map2;
        this.name = new Name.SchemaName(((SchemaHeader)this.headerField.get()).getName());
        Iterable $this$map$iv = ((SchemaHeader)this.headerField.get()).getEntities();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SchemaHeader.EntityRef entityRef = (SchemaHeader.EntityRef)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Path path3 = this.getPath().resolve("entity_" + it.getName());
            Name.EntityName entityName = this.getName().entity(it.getName());
            Path path4 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path");
            this.registry.put(entityName, new DefaultEntity(path4, this));
            Unit unit = Unit.INSTANCE;
            object.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    public static final /* synthetic */ Atomic.Var access$getHeaderField$p(DefaultSchema $this) {
        return $this.headerField;
    }

    public static final /* synthetic */ DB access$getStore$p(DefaultSchema $this) {
        return $this.store;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\"#B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014JI\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001722\u0010\u0018\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0019\"\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/database/schema/DefaultSchema$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/schema/DefaultSchema;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/general/DBO;", "getDbo", "()Lorg/vitrivr/cottontail/database/general/DBO;", "snapshot", "Lorg/vitrivr/cottontail/database/schema/SchemaTxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/schema/SchemaTxSnapshot;", "snapshot$delegate", "Lkotlin/Lazy;", "cleanup", "", "createEntity", "Lorg/vitrivr/cottontail/database/entity/Entity;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "columns", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "(Lorg/vitrivr/cottontail/model/basics/Name$EntityName;[Lkotlin/Pair;)Lorg/vitrivr/cottontail/database/entity/Entity;", "dropEntity", "entityForName", "listEntities", "", "CreateEntityTxAction", "DropEntityTxAction", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements SchemaTx {
        private final long closeStamp;
        @NotNull
        private final Lazy snapshot$delegate;

        @Override
        @NotNull
        public DBO getDbo() {
            return DefaultSchema.this;
        }

        @Override
        @NotNull
        public SchemaTxSnapshot getSnapshot() {
            Lazy lazy = this.snapshot$delegate;
            Tx tx = this;
            Object var3_3 = null;
            boolean bl = false;
            return (SchemaTxSnapshot)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Entity> listEntities() {
            List list;
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                list = CollectionsKt.toList((Iterable)this.getSnapshot().getEntities().values());
            }
            finally {
                readLock.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Entity entityForName(@NotNull Name.EntityName name) {
            Entity entity;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                Entity entity2 = this.getSnapshot().getEntities().get(name);
                if (entity2 == null) {
                    throw (Throwable)new DatabaseException.EntityDoesNotExistException(name);
                }
                entity = entity2;
            }
            finally {
                readLock.unlock();
            }
            return entity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Entity createEntity(@NotNull Name.EntityName name, Pair<? extends ColumnDef<?>, ? extends ColumnEngine> ... columns) {
            int n;
            int n2;
            int n3;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n5 = 0;
            n5 = 0;
            int n6 = n4;
            while (n5 < n6) {
                n3 = n5++;
                n2 = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Name.ColumnName columnName;
                Object object;
                int n7;
                void $this$mapTo$iv$iv;
                n = 0;
                boolean bl4 = false;
                Pair<? extends ColumnDef<?>, ? extends ColumnEngine>[] pairArray = this.getSnapshot().getEntities();
                Name.EntityName entityName = name;
                boolean bl5 = false;
                Pair<? extends ColumnDef<?>, ? extends ColumnEngine>[] pairArray2 = pairArray;
                boolean bl6 = false;
                if (pairArray2.containsKey(entityName)) {
                    throw (Throwable)new DatabaseException.EntityAlreadyExistsException(name);
                }
                Pair<? extends ColumnDef<?>, ? extends ColumnEngine>[] $this$map$iv = columns;
                boolean $i$f$map = false;
                pairArray2 = $this$map$iv;
                Pair<? extends ColumnDef<?>, ? extends ColumnEngine>[] destination$iv$iv = (Pair<? extends ColumnDef<?>, ? extends ColumnEngine>[])new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var22_32 = $this$mapTo$iv$iv;
                int n8 = ((void)var22_32).length;
                for (n7 = 0; n7 < n8; ++n7) {
                    void it;
                    void item$iv$iv;
                    void var26_39 = item$iv$iv = var22_32[n7];
                    object = destination$iv$iv;
                    boolean bl7 = false;
                    columnName = ((ColumnDef)it.getFirst()).getName();
                    object.add(columnName);
                }
                int distinctSize = CollectionsKt.distinct((Iterable)((List)destination$iv$iv)).size();
                if (distinctSize != columns.length) {
                    void $this$mapTo$iv$iv2;
                    Pair<? extends ColumnDef<?>, ? extends ColumnEngine>[] $this$map$iv2 = columns;
                    boolean $i$f$map2 = false;
                    destination$iv$iv = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
                    boolean $i$f$mapTo2 = false;
                    void var23_35 = $this$mapTo$iv$iv2;
                    n7 = ((void)var23_35).length;
                    for (int i = 0; i < n7; ++i) {
                        void it;
                        void item$iv$iv;
                        void bl7 = item$iv$iv = var23_35[i];
                        object = destination$iv$iv2;
                        boolean bl8 = false;
                        columnName = ((ColumnDef)it.getFirst()).getName();
                        object.add(columnName);
                    }
                    List cols = (List)destination$iv$iv2;
                    throw (Throwable)new DatabaseException.DuplicateColumnException(name, cols);
                }
                try {
                    Path data = DefaultEntity.Companion.initialize(name, DefaultSchema.this.getPath(), DefaultSchema.this.getParent().getConfig(), ArraysKt.toList((Object[])columns));
                    DefaultEntity entity = new DefaultEntity(data, DefaultSchema.this);
                    this.getSnapshot().record(new CreateEntityTxAction(entity));
                    this.getSnapshot().getEntities().put(name, entity);
                    Entity entity2 = entity;
                    return entity2;
                }
                catch (DatabaseException e) {
                    this.setStatus(TxStatus.ERROR);
                    throw (Throwable)e;
                }
            }
            finally {
                n6 = 0;
                n3 = 0;
                n3 = 0;
                n2 = n4;
                while (n3 < n2) {
                    n = n3++;
                    boolean bl9 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropEntity(@NotNull Name.EntityName name) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                Entity entity = this.getSnapshot().getEntities().get(name);
                if (entity == null) {
                    throw (Throwable)new DatabaseException.EntityDoesNotExistException(name);
                }
                Entity entity2 = entity;
                this.getContext().requestLock(entity2, LockMode.EXCLUSIVE);
                this.getSnapshot().record(new DropEntityTxAction(name));
                this.getSnapshot().getEntities().remove(name);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        protected void cleanup() {
            DefaultSchema.this.closeLock.unlockRead(this.closeStamp);
        }

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = DefaultSchema.this.closeLock.readLock();
            this.snapshot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<snapshot.1>(this){
                final /* synthetic */ Tx this$0;

                @NotNull
                public final snapshot.1 invoke() {
                    return new SchemaTxSnapshot(this){
                        @NotNull
                        private final Object2ObjectOpenHashMap<Name.EntityName, Entity> entities;
                        @NotNull
                        private final LinkedList<TxAction> actions;
                        final /* synthetic */ snapshot.2 this$0;

                        @NotNull
                        public Object2ObjectOpenHashMap<Name.EntityName, Entity> getEntities() {
                            return this.entities;
                        }

                        @NotNull
                        public LinkedList<TxAction> getActions() {
                            return this.actions;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void commit() {
                            try {
                                Collection<SchemaHeader.EntityRef> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                T element$iv2;
                                Iterable $this$forEach$iv = this.getActions();
                                boolean $i$f$forEach22 = false;
                                for (T element$iv2 : $this$forEach$iv) {
                                    TxAction it = (TxAction)element$iv2;
                                    boolean bl = false;
                                    it.commit();
                                }
                                Map $i$f$forEach22 = (Map)this.getEntities();
                                long l = System.currentTimeMillis();
                                long l2 = 0L;
                                String string = null;
                                SchemaHeader schemaHeader = (SchemaHeader)DefaultSchema.access$getHeaderField$p(this.this$0.this$0.DefaultSchema.this).get();
                                boolean $i$f$map = false;
                                element$iv2 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                                boolean $i$f$mapTo = false;
                                void var7_14 = $this$mapTo$iv$iv;
                                boolean bl = false;
                                Iterator<Map.Entry<K, V>> iterator2 = var7_14.entrySet().iterator();
                                while (iterator2.hasNext()) {
                                    void it;
                                    Map.Entry<K, V> item$iv$iv;
                                    Map.Entry<K, V> entry = item$iv$iv = iterator2.next();
                                    collection = destination$iv$iv;
                                    boolean bl2 = false;
                                    SchemaHeader.EntityRef entityRef = new SchemaHeader.EntityRef(((Entity)it.getValue()).getName().getSimple());
                                    collection.add(entityRef);
                                }
                                collection = (List)destination$iv$iv;
                                SchemaHeader newHeader = SchemaHeader.copy$default(schemaHeader, string, l2, l, (List)collection, 3, null);
                                DefaultSchema.access$getHeaderField$p(this.this$0.this$0.DefaultSchema.this).set((Object)newHeader);
                                DefaultSchema.access$getStore$p(this.this$0.this$0.DefaultSchema.this).commit();
                            }
                            catch (Throwable e) {
                                Tx.access$setStatus$p(this.this$0.this$0, TxStatus.ERROR);
                                DefaultSchema.access$getStore$p(this.this$0.this$0.DefaultSchema.this).rollback();
                                throw (Throwable)new DatabaseException("Failed to commit schema " + this.this$0.this$0.DefaultSchema.this.getName() + " due to an exception: " + e.getMessage(), e);
                            }
                        }

                        public void rollback() {
                            Iterable $this$forEach$iv = this.getActions();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                TxAction it = (TxAction)element$iv;
                                boolean bl = false;
                                it.rollback();
                            }
                            DefaultSchema.access$getStore$p(this.this$0.this$0.DefaultSchema.this).rollback();
                        }

                        public boolean record(@NotNull TxAction action) {
                            boolean bl;
                            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                            TxAction txAction = action;
                            if (txAction instanceof CreateEntityTxAction || txAction instanceof DropEntityTxAction) {
                                ((LinkedList)this.getActions()).add(action);
                                bl = true;
                            } else {
                                bl = false;
                            }
                            return bl;
                        }
                        {
                            this.this$0 = this$0;
                            this.entities = new Object2ObjectOpenHashMap(DefaultSchema.access$getRegistry$p(this$0.this$0.DefaultSchema.this));
                            this.actions = new LinkedList<E>();
                        }
                    };
                }
                {
                    this.this$0 = tx;
                    super(0);
                }
            }));
            if (DefaultSchema.this.getClosed()) {
                DefaultSchema.this.closeLock.unlockRead(this.closeStamp);
                throw (Throwable)new TxException.TxDBOClosedException(this.getContext().getTxId(), DefaultSchema.this);
            }
        }

        public static final /* synthetic */ TxStatus access$getStatus$p(Tx $this) {
            return $this.getStatus();
        }

        public static final /* synthetic */ void access$setStatus$p(Tx $this, TxStatus txStatus) {
            $this.setStatus(txStatus);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/database/schema/DefaultSchema$Tx$CreateEntityTxAction;", "Lorg/vitrivr/cottontail/database/general/TxAction;", "entity", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Lorg/vitrivr/cottontail/database/schema/DefaultSchema$Tx;Lorg/vitrivr/cottontail/database/entity/Entity;)V", "commit", "", "rollback", "cottontaildb"})
        public final class CreateEntityTxAction
        implements TxAction {
            private final Entity entity;

            @Override
            public void commit() {
                this.entity.close();
                Path move = Files.move(this.entity.getPath(), TxFileUtilities.INSTANCE.plainPath(this.entity.getPath()), StandardCopyOption.ATOMIC_MOVE);
                Map map2 = DefaultSchema.this.registry;
                Name.EntityName entityName = this.entity.getName();
                Path path = move;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"move");
                map2.put(entityName, new DefaultEntity(path, this.entity.getParent()));
            }

            @Override
            public void rollback() {
                this.entity.close();
                TxFileUtilities.INSTANCE.delete(this.entity.getPath());
            }

            public CreateEntityTxAction(Entity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                this.entity = entity;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/database/schema/DefaultSchema$Tx$DropEntityTxAction;", "Lorg/vitrivr/cottontail/database/general/TxAction;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "(Lorg/vitrivr/cottontail/database/schema/DefaultSchema$Tx;Lorg/vitrivr/cottontail/model/basics/Name$EntityName;)V", "commit", "", "rollback", "cottontaildb"})
        public final class DropEntityTxAction
        implements TxAction {
            private final Name.EntityName entity;

            @Override
            public void commit() {
                Entity entity = (Entity)DefaultSchema.this.registry.remove(this.entity);
                if (entity == null) {
                    throw (Throwable)new IllegalStateException("Failed to drop schema " + this.entity + " because it is unknown to the schema. This is a programmer's error!");
                }
                Entity entity2 = entity;
                entity2.close();
                if (Files.exists(entity2.getPath(), new LinkOption[0])) {
                    TxFileUtilities.INSTANCE.delete(entity2.getPath());
                }
            }

            @Override
            public void rollback() {
            }

            public DropEntityTxAction(Name.EntityName entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                this.entity = entity;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/database/schema/DefaultSchema$Companion;", "", "()V", "FILE_CATALOGUE", "", "SCHEMA_HEADER_FIELD", "initialize", "Ljava/nio/file/Path;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "path", "config", "Lorg/vitrivr/cottontail/config/Config;", "cottontaildb"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Path initialize(@NotNull Name.SchemaName name, @NotNull Path path, @NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Path path2 = path.resolve("schema_" + name.getSimple());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(\"schema_${name.simple}\")");
            Path dataPath = TxFileUtilities.INSTANCE.createPath(path2);
            if (Files.exists(dataPath, new LinkOption[0])) {
                throw (Throwable)new DatabaseException.InvalidFileException("Failed to create schema '" + name + "'. Data directory '" + dataPath + "' seems to be occupied.");
            }
            Files.createDirectories(dataPath, new FileAttribute[0]);
            try {
                MapDBConfig mapDBConfig = config.getMapdb();
                Path path3 = dataPath.resolve(DefaultSchema.FILE_CATALOGUE);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"dataPath.resolve(FILE_CATALOGUE)");
                Closeable closeable = (Closeable)mapDBConfig.db(path3);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    DB store = (DB)closeable;
                    boolean bl3 = false;
                    Atomic.Var schemaHeader = (Atomic.Var)store.atomicVar(DefaultSchema.SCHEMA_HEADER_FIELD, (Serializer)SchemaHeader.Serializer).create();
                    schemaHeader.set((Object)new SchemaHeader(name.getSimple(), 0L, 0L, null, 14, null));
                    store.commit();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return dataPath;
            }
            catch (DBException e) {
                TxFileUtilities.INSTANCE.delete(dataPath);
                throw (Throwable)new DatabaseException("Failed to create schema '" + name + "' due to error in the underlying data store: {" + e.getMessage(), null, 2, null);
            }
            catch (IOException e) {
                TxFileUtilities.INSTANCE.delete(dataPath);
                throw (Throwable)new DatabaseException("Failed to create schema '" + name + "' due to an IO exception: {" + e.getMessage(), null, 2, null);
            }
            catch (Throwable e) {
                TxFileUtilities.INSTANCE.delete(dataPath);
                throw (Throwable)new DatabaseException("Failed to create schema '" + name + "' due to an unexpected error: {" + e.getMessage(), null, 2, null);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

