package org.vitrivr.cottontail.database.queries.planning.nodes.logical.projection

import org.vitrivr.cottontail.database.column.ColumnDef
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.UnaryLogicalOperatorNode
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.projection.ExistsProjectionPhysicalOperatorNode
import org.vitrivr.cottontail.database.queries.projection.Projection
import org.vitrivr.cottontail.model.basics.Name
import org.vitrivr.cottontail.model.basics.Type

/**
 * A [UnaryLogicalOperatorNode] that represents a projection operation involving aggregate functions such as [Projection.EXISTS].
 *
 * @author Ralph Gasser
 * @version 2.3.0
 */
class ExistsProjectionLogicalOperatorNode(input: Logical? = null, val alias: Name.ColumnName? = null) : AbstractProjectionLogicalOperatorOperator(input, Projection.EXISTS) {

    /** The [ColumnDef] generated by this [ExistsProjectionLogicalOperatorNode]. */
    override val columns: List<ColumnDef<*>>
        get() {
            val name = this.alias ?: (this.input?.columns?.first()?.name?.entity()?.column(Projection.EXISTS.label()) ?: Name.ColumnName(Projection.EXISTS.label()))
            return listOf(ColumnDef(name, Type.Boolean, false))
        }

    /**
     * Creates and returns a copy of this [ExistsProjectionLogicalOperatorNode] without any children or parents.
     *
     * @return Copy of this [ExistsProjectionLogicalOperatorNode].
     */
    override fun copy() = ExistsProjectionLogicalOperatorNode(alias = this.alias)

    /**
     * Returns a [ExistsProjectionPhysicalOperatorNode] representation of this [ExistsProjectionLogicalOperatorNode]
     *
     * @return [ExistsProjectionPhysicalOperatorNode]
     */
    override fun implement(): Physical = ExistsProjectionPhysicalOperatorNode(this.input?.implement(), this.alias)

    /**
     * Compares this [ExistsProjectionPhysicalOperatorNode] to another object.
     *
     * @param other The other [Any] to compare this [ExistsProjectionPhysicalOperatorNode] to.
     * @return True if other equals this, false otherwise.
     */
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is ExistsProjectionLogicalOperatorNode) return false
        if (this.type != other.type) return false
        if (this.alias != other.alias) return false
        return true
    }

    /**
     * Generates and returns a hash code for this [ExistsProjectionPhysicalOperatorNode].
     */
    override fun hashCode(): Int {
        var result = this.type.hashCode()
        result = 31 * result + this.alias.hashCode()
        return result
    }
}